/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandler;
import io.netty.channel.embedded.EmbeddedChannel;
import io.netty.handler.codec.DecoderResult;
import io.netty.handler.codec.http.DefaultHttpContent;
import io.netty.handler.codec.http.DefaultHttpHeaders;
import io.netty.handler.codec.http.DefaultHttpRequest;
import io.netty.handler.codec.http.DefaultLastHttpContent;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpRequestEncoder;
import io.netty.handler.codec.http.HttpUtil;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.LastHttpContent;
import io.netty.util.CharsetUtil;
import io.netty.util.IllegalReferenceCountException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.Charset;
import java.util.concurrent.ExecutionException;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.function.Executable;

public class HttpRequestEncoderTest {
    private static ByteBuf[] getBuffers() {
        return new ByteBuf[]{Unpooled.buffer((int)128).order(ByteOrder.BIG_ENDIAN), Unpooled.buffer((int)128).order(ByteOrder.LITTLE_ENDIAN), Unpooled.wrappedBuffer((ByteBuffer)ByteBuffer.allocate(128).order(ByteOrder.BIG_ENDIAN)).resetWriterIndex(), Unpooled.wrappedBuffer((ByteBuffer)ByteBuffer.allocate(128).order(ByteOrder.LITTLE_ENDIAN)).resetWriterIndex()};
    }

    @Test
    public void testUriWithoutPath() throws Exception {
        for (ByteBuf buffer : HttpRequestEncoderTest.getBuffers()) {
            HttpRequestEncoder encoder = new HttpRequestEncoder();
            encoder.encodeInitialLine(buffer, (HttpRequest)new DefaultHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.GET, "http://localhost"));
            String req = buffer.toString(Charset.forName("US-ASCII"));
            Assertions.assertEquals((Object)"GET http://localhost/ HTTP/1.1\r\n", (Object)req);
            buffer.release();
        }
    }

    @Test
    public void testUriWithoutPath2() throws Exception {
        for (ByteBuf buffer : HttpRequestEncoderTest.getBuffers()) {
            HttpRequestEncoder encoder = new HttpRequestEncoder();
            encoder.encodeInitialLine(buffer, (HttpRequest)new DefaultHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.GET, "http://localhost:9999?p1=v1"));
            String req = buffer.toString(Charset.forName("US-ASCII"));
            Assertions.assertEquals((Object)"GET http://localhost:9999/?p1=v1 HTTP/1.1\r\n", (Object)req);
            buffer.release();
        }
    }

    @Test
    public void testUriWithEmptyPath() throws Exception {
        for (ByteBuf buffer : HttpRequestEncoderTest.getBuffers()) {
            HttpRequestEncoder encoder = new HttpRequestEncoder();
            encoder.encodeInitialLine(buffer, (HttpRequest)new DefaultHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.GET, "http://localhost:9999/?p1=v1"));
            String req = buffer.toString(Charset.forName("US-ASCII"));
            Assertions.assertEquals((Object)"GET http://localhost:9999/?p1=v1 HTTP/1.1\r\n", (Object)req);
            buffer.release();
        }
    }

    @Test
    public void testUriWithPath() throws Exception {
        for (ByteBuf buffer : HttpRequestEncoderTest.getBuffers()) {
            HttpRequestEncoder encoder = new HttpRequestEncoder();
            encoder.encodeInitialLine(buffer, (HttpRequest)new DefaultHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.GET, "http://localhost/"));
            String req = buffer.toString(Charset.forName("US-ASCII"));
            Assertions.assertEquals((Object)"GET http://localhost/ HTTP/1.1\r\n", (Object)req);
            buffer.release();
        }
    }

    @Test
    public void testAbsPath() throws Exception {
        for (ByteBuf buffer : HttpRequestEncoderTest.getBuffers()) {
            HttpRequestEncoder encoder = new HttpRequestEncoder();
            encoder.encodeInitialLine(buffer, (HttpRequest)new DefaultHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.GET, "/"));
            String req = buffer.toString(Charset.forName("US-ASCII"));
            Assertions.assertEquals((Object)"GET / HTTP/1.1\r\n", (Object)req);
            buffer.release();
        }
    }

    @Test
    public void testEmptyAbsPath() throws Exception {
        for (ByteBuf buffer : HttpRequestEncoderTest.getBuffers()) {
            HttpRequestEncoder encoder = new HttpRequestEncoder();
            encoder.encodeInitialLine(buffer, (HttpRequest)new DefaultHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.GET, ""));
            String req = buffer.toString(Charset.forName("US-ASCII"));
            Assertions.assertEquals((Object)"GET / HTTP/1.1\r\n", (Object)req);
            buffer.release();
        }
    }

    @Test
    public void testQueryStringPath() throws Exception {
        for (ByteBuf buffer : HttpRequestEncoderTest.getBuffers()) {
            HttpRequestEncoder encoder = new HttpRequestEncoder();
            encoder.encodeInitialLine(buffer, (HttpRequest)new DefaultHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.GET, "/?url=http://example.com"));
            String req = buffer.toString(Charset.forName("US-ASCII"));
            Assertions.assertEquals((Object)"GET /?url=http://example.com HTTP/1.1\r\n", (Object)req);
            buffer.release();
        }
    }

    @Test
    public void testEmptyReleasedBufferShouldNotWriteEmptyBufferToChannel() throws Exception {
        HttpRequestEncoder encoder = new HttpRequestEncoder();
        final EmbeddedChannel channel = new EmbeddedChannel(new ChannelHandler[]{encoder});
        final ByteBuf buf = Unpooled.buffer();
        buf.release();
        ExecutionException e = (ExecutionException)Assertions.assertThrows(ExecutionException.class, (Executable)new Executable(){

            public void execute() throws Throwable {
                channel.writeAndFlush((Object)buf).get();
            }
        });
        MatcherAssert.assertThat((Object)e.getCause().getCause(), (Matcher)Matchers.is((Matcher)Matchers.instanceOf(IllegalReferenceCountException.class)));
        channel.finishAndReleaseAll();
    }

    @Test
    public void testEmptyBufferShouldPassThrough() throws Exception {
        HttpRequestEncoder encoder = new HttpRequestEncoder();
        EmbeddedChannel channel = new EmbeddedChannel(new ChannelHandler[]{encoder});
        ByteBuf buffer = Unpooled.buffer();
        channel.writeAndFlush((Object)buffer).get();
        channel.finishAndReleaseAll();
        Assertions.assertEquals((int)0, (int)buffer.refCnt());
    }

    @Test
    public void testEmptyContentsChunked() throws Exception {
        this.testEmptyContents(true, false);
    }

    @Test
    public void testEmptyContentsChunkedWithTrailers() throws Exception {
        this.testEmptyContents(true, true);
    }

    @Test
    public void testEmptyContentsNotChunked() throws Exception {
        this.testEmptyContents(false, false);
    }

    @Test
    public void testEmptyContentNotsChunkedWithTrailers() throws Exception {
        this.testEmptyContents(false, true);
    }

    private void testEmptyContents(boolean chunked, boolean trailers) throws Exception {
        HttpRequestEncoder encoder = new HttpRequestEncoder();
        EmbeddedChannel channel = new EmbeddedChannel(new ChannelHandler[]{encoder});
        DefaultHttpRequest request = new DefaultHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.POST, "/");
        if (chunked) {
            HttpUtil.setTransferEncodingChunked((HttpMessage)request, (boolean)true);
        }
        Assertions.assertTrue((boolean)channel.writeOutbound(new Object[]{request}));
        ByteBuf contentBuffer = Unpooled.buffer();
        Assertions.assertTrue((boolean)channel.writeOutbound(new Object[]{new DefaultHttpContent(contentBuffer)}));
        ByteBuf lastContentBuffer = Unpooled.buffer();
        DefaultLastHttpContent last = new DefaultLastHttpContent(lastContentBuffer);
        if (trailers) {
            last.trailingHeaders().set("X-Netty-Test", (Object)"true");
        }
        Assertions.assertTrue((boolean)channel.writeOutbound(new Object[]{last}));
        ByteBuf head = (ByteBuf)channel.readOutbound();
        Assertions.assertTrue((boolean)head.release());
        ByteBuf content = (ByteBuf)channel.readOutbound();
        content.release();
        ByteBuf lastContent = (ByteBuf)channel.readOutbound();
        lastContent.release();
        Assertions.assertFalse((boolean)channel.finish());
    }

    @Test
    public void testForChunkedRequestNpe() throws Exception {
        EmbeddedChannel channel = new EmbeddedChannel(new ChannelHandler[]{new HttpRequestEncoder()});
        Assertions.assertTrue((boolean)channel.writeOutbound(new Object[]{new CustomHttpRequest()}));
        Assertions.assertTrue((boolean)channel.writeOutbound(new Object[]{new DefaultHttpContent(Unpooled.copiedBuffer((CharSequence)"test", (Charset)CharsetUtil.US_ASCII))}));
        Assertions.assertTrue((boolean)channel.writeOutbound(new Object[]{LastHttpContent.EMPTY_LAST_CONTENT}));
        Assertions.assertTrue((boolean)channel.finishAndReleaseAll());
    }

    private static final class CustomHttpRequest
    implements HttpRequest {
        private CustomHttpRequest() {
        }

        public DecoderResult decoderResult() {
            return DecoderResult.SUCCESS;
        }

        public void setDecoderResult(DecoderResult result) {
        }

        public DecoderResult getDecoderResult() {
            return this.decoderResult();
        }

        public HttpVersion getProtocolVersion() {
            return HttpVersion.HTTP_1_1;
        }

        public HttpVersion protocolVersion() {
            return this.getProtocolVersion();
        }

        public HttpHeaders headers() {
            DefaultHttpHeaders headers = new DefaultHttpHeaders();
            headers.add("Transfer-Encoding", (Object)"chunked");
            return headers;
        }

        public HttpMethod getMethod() {
            return HttpMethod.POST;
        }

        public HttpMethod method() {
            return this.getMethod();
        }

        public HttpRequest setMethod(HttpMethod method) {
            return this;
        }

        public String getUri() {
            return "/";
        }

        public String uri() {
            return "/";
        }

        public HttpRequest setUri(String uri) {
            return this;
        }

        public HttpRequest setProtocolVersion(HttpVersion version) {
            return this;
        }
    }
}

