/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http.multipart;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.handler.codec.http.DefaultFullHttpRequest;
import io.netty.handler.codec.http.DefaultHttpContent;
import io.netty.handler.codec.http.DefaultHttpRequest;
import io.netty.handler.codec.http.DefaultLastHttpContent;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.multipart.DefaultHttpDataFactory;
import io.netty.handler.codec.http.multipart.FileUpload;
import io.netty.handler.codec.http.multipart.HttpData;
import io.netty.handler.codec.http.multipart.HttpDataFactory;
import io.netty.handler.codec.http.multipart.HttpPostMultipartRequestDecoder;
import io.netty.handler.codec.http.multipart.HttpPostRequestDecoder;
import io.netty.handler.codec.http.multipart.InterfaceHttpData;
import io.netty.util.CharsetUtil;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Arrays;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class HttpPostMultiPartRequestDecoderTest {
    @Test
    public void testDecodeFullHttpRequestWithNoContentTypeHeader() {
        DefaultFullHttpRequest req = new DefaultFullHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.POST, "/");
        try {
            new HttpPostMultipartRequestDecoder((HttpRequest)req);
            Assertions.fail((String)"Was expecting an ErrorDataDecoderException");
        }
        catch (HttpPostRequestDecoder.ErrorDataDecoderException errorDataDecoderException) {
        }
        finally {
            Assertions.assertTrue((boolean)req.release());
        }
    }

    @Test
    public void testDecodeFullHttpRequestWithInvalidCharset() {
        DefaultFullHttpRequest req = new DefaultFullHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.POST, "/");
        req.headers().set((CharSequence)HttpHeaderNames.CONTENT_TYPE, (Object)"multipart/form-data; boundary=--89421926422648 [; charset=UTF-8]");
        try {
            new HttpPostMultipartRequestDecoder((HttpRequest)req);
            Assertions.fail((String)"Was expecting an ErrorDataDecoderException");
        }
        catch (HttpPostRequestDecoder.ErrorDataDecoderException errorDataDecoderException) {
        }
        finally {
            Assertions.assertTrue((boolean)req.release());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDecodeFullHttpRequestWithInvalidPayloadReleaseBuffer() {
        String content = "\n--861fbeab-cd20-470c-9609-d40a0f704466\nContent-Disposition: form-data; name=\"image1\"; filename*=\"'some.jpeg\"\nContent-Type: image/jpeg\nContent-Length: 1\nx\n--861fbeab-cd20-470c-9609-d40a0f704466--\n";
        DefaultFullHttpRequest req = new DefaultFullHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.POST, "/upload", Unpooled.copiedBuffer((CharSequence)content, (Charset)CharsetUtil.US_ASCII));
        req.headers().set("content-type", (Object)"multipart/form-data; boundary=861fbeab-cd20-470c-9609-d40a0f704466");
        req.headers().set("content-length", (Object)content.length());
        try {
            new HttpPostMultipartRequestDecoder((HttpRequest)req);
            Assertions.fail((String)"Was expecting an ErrorDataDecoderException");
        }
        catch (HttpPostRequestDecoder.ErrorDataDecoderException errorDataDecoderException) {
        }
        finally {
            Assertions.assertTrue((boolean)req.release());
        }
    }

    @Test
    public void testDelimiterExceedLeftSpaceInCurrentBuffer() {
        InterfaceHttpData[] httpDatas;
        String delimiter = "--861fbeab-cd20-470c-9609-d40a0f704466";
        String suffix = '\n' + delimiter + "--\n";
        byte[] bsuffix = suffix.getBytes(CharsetUtil.UTF_8);
        int partOfDelimiter = bsuffix.length / 2;
        int bytesLastChunk = 355 - partOfDelimiter;
        byte[] bsuffix1 = Arrays.copyOf(bsuffix, partOfDelimiter);
        byte[] bsuffix2 = Arrays.copyOfRange(bsuffix, partOfDelimiter, bsuffix.length);
        String prefix = delimiter + "\nContent-Disposition: form-data; name=\"image\"; filename=\"guangzhou.jpeg\"\nContent-Type: image/jpeg\nContent-Length: " + bytesLastChunk + "\n\n";
        DefaultHttpRequest request = new DefaultHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.POST, "/upload");
        request.headers().set("content-type", (Object)"multipart/form-data; boundary=861fbeab-cd20-470c-9609-d40a0f704466");
        request.headers().set("content-length", (Object)(prefix.length() + bytesLastChunk + suffix.length()));
        DefaultHttpDataFactory factory = new DefaultHttpDataFactory(false);
        HttpPostMultipartRequestDecoder decoder = new HttpPostMultipartRequestDecoder((HttpDataFactory)factory, (HttpRequest)request);
        ByteBuf buf = Unpooled.wrappedBuffer((byte[])prefix.getBytes(CharsetUtil.UTF_8));
        DefaultHttpContent httpContent = new DefaultHttpContent(buf);
        decoder.offer((HttpContent)httpContent);
        Assertions.assertNotNull((Object)((HttpData)decoder.currentPartialHttpData()));
        httpContent.release();
        byte[] body = new byte[bytesLastChunk + bsuffix1.length];
        Arrays.fill(body, (byte)2);
        for (int i = 0; i < bsuffix1.length; ++i) {
            body[bytesLastChunk + i] = bsuffix1[i];
        }
        ByteBuf content = Unpooled.wrappedBuffer((byte[])body);
        httpContent = new DefaultHttpContent(content);
        decoder.offer((HttpContent)httpContent);
        Assertions.assertNotNull((Object)((HttpData)decoder.currentPartialHttpData()).content());
        httpContent.release();
        content = Unpooled.wrappedBuffer((byte[])bsuffix2);
        httpContent = new DefaultHttpContent(content);
        decoder.offer((HttpContent)httpContent);
        Assertions.assertNull((Object)((HttpData)decoder.currentPartialHttpData()));
        httpContent.release();
        decoder.offer((HttpContent)new DefaultLastHttpContent());
        FileUpload data = (FileUpload)decoder.getBodyHttpDatas().get(0);
        Assertions.assertEquals((long)data.length(), (long)bytesLastChunk);
        Assertions.assertEquals((Object)true, (Object)data.isInMemory());
        for (InterfaceHttpData httpData : httpDatas = decoder.getBodyHttpDatas().toArray(new InterfaceHttpData[0])) {
            Assertions.assertEquals((int)1, (int)httpData.refCnt(), (String)"Before cleanAllHttpData should be 1");
        }
        factory.cleanAllHttpData();
        for (InterfaceHttpData httpData : httpDatas) {
            Assertions.assertEquals((int)1, (int)httpData.refCnt(), (String)"After cleanAllHttpData should be 1 if in Memory");
        }
        decoder.destroy();
        for (InterfaceHttpData httpData : httpDatas) {
            Assertions.assertEquals((int)0, (int)httpData.refCnt(), (String)"RefCnt should be 0");
        }
    }

    private void commonTestBigFileDelimiterInMiddleChunk(HttpDataFactory factory, boolean inMemory) throws IOException {
        InterfaceHttpData[] httpDatas;
        int i;
        int nbChunks = 100;
        int bytesPerChunk = 100000;
        int bytesLastChunk = 10000;
        int fileSize = bytesPerChunk * nbChunks + bytesLastChunk;
        String delimiter = "--861fbeab-cd20-470c-9609-d40a0f704466";
        String prefix = delimiter + "\nContent-Disposition: form-data; name=\"image\"; filename=\"guangzhou.jpeg\"\nContent-Type: image/jpeg\nContent-Length: " + fileSize + "\n\n";
        String suffix1 = "\n--861fbeab-";
        String suffix2 = "cd20-470c-9609-d40a0f704466--\n";
        String suffix = suffix1 + suffix2;
        DefaultHttpRequest request = new DefaultHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.POST, "/upload");
        request.headers().set("content-type", (Object)"multipart/form-data; boundary=861fbeab-cd20-470c-9609-d40a0f704466");
        request.headers().set("content-length", (Object)(prefix.length() + fileSize + suffix.length()));
        HttpPostMultipartRequestDecoder decoder = new HttpPostMultipartRequestDecoder(factory, (HttpRequest)request);
        ByteBuf buf = Unpooled.wrappedBuffer((byte[])prefix.getBytes(CharsetUtil.UTF_8));
        DefaultHttpContent httpContent = new DefaultHttpContent(buf);
        decoder.offer((HttpContent)httpContent);
        Assertions.assertNotNull((Object)((HttpData)decoder.currentPartialHttpData()).content());
        httpContent.release();
        byte[] body = new byte[bytesPerChunk];
        Arrays.fill(body, (byte)1);
        body[0] = 13;
        body[1] = 10;
        for (int i2 = 0; i2 < nbChunks; ++i2) {
            ByteBuf content = Unpooled.wrappedBuffer((byte[])body, (int)0, (int)bytesPerChunk);
            httpContent = new DefaultHttpContent(content);
            decoder.offer((HttpContent)httpContent);
            Assertions.assertNotNull((Object)((HttpData)decoder.currentPartialHttpData()).content());
            httpContent.release();
        }
        byte[] bsuffix1 = suffix1.getBytes(CharsetUtil.UTF_8);
        byte[] previousLastbody = new byte[bytesLastChunk - bsuffix1.length];
        byte[] bdelimiter = delimiter.getBytes(CharsetUtil.UTF_8);
        byte[] lastbody = new byte[2 * bsuffix1.length];
        Arrays.fill(previousLastbody, (byte)1);
        previousLastbody[0] = 13;
        previousLastbody[1] = 10;
        Arrays.fill(lastbody, (byte)1);
        for (i = 0; i < bdelimiter.length; ++i) {
            previousLastbody[i + 10] = bdelimiter[i];
        }
        lastbody[0] = 13;
        lastbody[1] = 10;
        for (i = 0; i < bsuffix1.length; ++i) {
            lastbody[bsuffix1.length + i] = bsuffix1[i];
        }
        ByteBuf content2 = Unpooled.wrappedBuffer((byte[])previousLastbody, (int)0, (int)previousLastbody.length);
        httpContent = new DefaultHttpContent(content2);
        decoder.offer((HttpContent)httpContent);
        Assertions.assertNotNull((Object)((HttpData)decoder.currentPartialHttpData()).content());
        httpContent.release();
        content2 = Unpooled.wrappedBuffer((byte[])lastbody, (int)0, (int)lastbody.length);
        httpContent = new DefaultHttpContent(content2);
        decoder.offer((HttpContent)httpContent);
        Assertions.assertNotNull((Object)((HttpData)decoder.currentPartialHttpData()).content());
        httpContent.release();
        content2 = Unpooled.wrappedBuffer((byte[])suffix2.getBytes(CharsetUtil.UTF_8));
        httpContent = new DefaultHttpContent(content2);
        decoder.offer((HttpContent)httpContent);
        Assertions.assertNull((Object)decoder.currentPartialHttpData());
        httpContent.release();
        decoder.offer((HttpContent)new DefaultLastHttpContent());
        FileUpload data = (FileUpload)decoder.getBodyHttpDatas().get(0);
        Assertions.assertEquals((long)data.length(), (long)fileSize);
        Assertions.assertEquals((Object)inMemory, (Object)data.isInMemory());
        if (data.isInMemory()) {
            Assertions.assertFalse((data.getByteBuf().capacity() < 0x100000 ? 1 : 0) != 0, (String)"Capacity should be higher than 1M");
        }
        Assertions.assertTrue((decoder.getCurrentAllocatedCapacity() < 0x100000 ? 1 : 0) != 0, (String)"Capacity should be less than 1M");
        for (InterfaceHttpData httpData : httpDatas = decoder.getBodyHttpDatas().toArray(new InterfaceHttpData[0])) {
            Assertions.assertEquals((int)1, (int)httpData.refCnt(), (String)"Before cleanAllHttpData should be 1");
        }
        factory.cleanAllHttpData();
        for (InterfaceHttpData httpData : httpDatas) {
            Assertions.assertEquals((int)(inMemory ? 1 : 0), (int)httpData.refCnt(), (String)"After cleanAllHttpData should be 1 if in Memory");
        }
        decoder.destroy();
        for (InterfaceHttpData httpData : httpDatas) {
            Assertions.assertEquals((int)0, (int)httpData.refCnt(), (String)"RefCnt should be 0");
        }
    }

    @Test
    public void testBIgFileUploadDelimiterInMiddleChunkDecoderDiskFactory() throws IOException {
        DefaultHttpDataFactory factory = new DefaultHttpDataFactory(true);
        this.commonTestBigFileDelimiterInMiddleChunk((HttpDataFactory)factory, false);
    }

    @Test
    public void testBIgFileUploadDelimiterInMiddleChunkDecoderMemoryFactory() throws IOException {
        DefaultHttpDataFactory factory = new DefaultHttpDataFactory(false);
        this.commonTestBigFileDelimiterInMiddleChunk((HttpDataFactory)factory, true);
    }

    @Test
    public void testBIgFileUploadDelimiterInMiddleChunkDecoderMixedFactory() throws IOException {
        DefaultHttpDataFactory factory = new DefaultHttpDataFactory(10000L);
        this.commonTestBigFileDelimiterInMiddleChunk((HttpDataFactory)factory, false);
    }

    @Test
    public void testNotBadReleaseBuffersDuringDecodingDiskFactory() throws IOException {
        DefaultHttpDataFactory factory = new DefaultHttpDataFactory(true);
        HttpPostMultiPartRequestDecoderTest.commonNotBadReleaseBuffersDuringDecoding((HttpDataFactory)factory, false);
    }

    @Test
    public void testNotBadReleaseBuffersDuringDecodingMemoryFactory() throws IOException {
        DefaultHttpDataFactory factory = new DefaultHttpDataFactory(false);
        HttpPostMultiPartRequestDecoderTest.commonNotBadReleaseBuffersDuringDecoding((HttpDataFactory)factory, true);
    }

    @Test
    public void testNotBadReleaseBuffersDuringDecodingMixedFactory() throws IOException {
        DefaultHttpDataFactory factory = new DefaultHttpDataFactory(100L);
        HttpPostMultiPartRequestDecoderTest.commonNotBadReleaseBuffersDuringDecoding((HttpDataFactory)factory, false);
    }

    private static void commonNotBadReleaseBuffersDuringDecoding(HttpDataFactory factory, boolean inMemory) throws IOException {
        int nbItems = 20;
        int bytesPerItem = 1000;
        int maxMemory = 500;
        String prefix1 = "\n--861fbeab-cd20-470c-9609-d40a0f704466\nContent-Disposition: form-data; name=\"image";
        String prefix2 = "\"; filename=\"guangzhou.jpeg\"\nContent-Type: image/jpeg\nContent-Length: " + bytesPerItem + "\n\n";
        String suffix = "\n--861fbeab-cd20-470c-9609-d40a0f704466--\n";
        DefaultHttpRequest request = new DefaultHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.POST, "/upload");
        request.headers().set("content-type", (Object)"multipart/form-data; boundary=861fbeab-cd20-470c-9609-d40a0f704466");
        request.headers().set("content-length", (Object)(nbItems * (prefix1.length() + prefix2.length() + 2 + bytesPerItem) + suffix.length()));
        HttpPostMultipartRequestDecoder decoder = new HttpPostMultipartRequestDecoder(factory, (HttpRequest)request);
        decoder.setDiscardThreshold(maxMemory);
        for (int rank = 0; rank < nbItems; ++rank) {
            byte[] bp1 = prefix1.getBytes(CharsetUtil.UTF_8);
            byte[] bp2 = prefix2.getBytes(CharsetUtil.UTF_8);
            byte[] prefix = new byte[bp1.length + 2 + bp2.length];
            for (int i = 0; i < bp1.length; ++i) {
                prefix[i] = bp1[i];
            }
            byte[] brank = Integer.toString(10 + rank).getBytes(CharsetUtil.UTF_8);
            prefix[bp1.length] = brank[0];
            prefix[bp1.length + 1] = brank[1];
            for (int i = 0; i < bp2.length; ++i) {
                prefix[bp1.length + 2 + i] = bp2[i];
            }
            ByteBuf buf = Unpooled.wrappedBuffer((byte[])prefix);
            DefaultHttpContent httpContent = new DefaultHttpContent(buf);
            decoder.offer((HttpContent)httpContent);
            httpContent.release();
            byte[] body = new byte[bytesPerItem];
            Arrays.fill(body, (byte)rank);
            ByteBuf content = Unpooled.wrappedBuffer((byte[])body, (int)0, (int)bytesPerItem);
            httpContent = new DefaultHttpContent(content);
            decoder.offer((HttpContent)httpContent);
            httpContent.release();
        }
        byte[] lastbody = suffix.getBytes(CharsetUtil.UTF_8);
        ByteBuf content2 = Unpooled.wrappedBuffer((byte[])lastbody, (int)0, (int)lastbody.length);
        DefaultHttpContent httpContent = new DefaultHttpContent(content2);
        decoder.offer((HttpContent)httpContent);
        httpContent.release();
        decoder.offer((HttpContent)new DefaultLastHttpContent());
        for (int rank = 0; rank < nbItems; ++rank) {
            FileUpload data = (FileUpload)decoder.getBodyHttpData("image" + (10 + rank));
            Assertions.assertEquals((long)bytesPerItem, (long)data.length());
            Assertions.assertEquals((Object)inMemory, (Object)data.isInMemory());
            byte[] body = new byte[bytesPerItem];
            Arrays.fill(body, (byte)rank);
            Assertions.assertTrue((boolean)Arrays.equals(body, data.get()));
        }
        for (InterfaceHttpData httpData : decoder.getBodyHttpDatas()) {
            httpData.release();
            factory.removeHttpDataFromClean((HttpRequest)request, httpData);
        }
        factory.cleanAllHttpData();
        decoder.destroy();
    }

    private static void commonTestFileDelimiterLFLastChunk(HttpDataFactory factory, boolean inMemory) throws IOException {
        InterfaceHttpData[] httpDatas;
        int nbChunks = 2;
        int bytesPerChunk = 100000;
        int bytesLastChunk = 10000;
        int fileSize = bytesPerChunk * nbChunks + bytesLastChunk;
        String delimiter = "--861fbeab-cd20-470c-9609-d40a0f704466";
        String prefix = delimiter + "\nContent-Disposition: form-data; name=\"image\"; filename=\"guangzhou.jpeg\"\nContent-Type: image/jpeg\nContent-Length: " + fileSize + "\n\n";
        String suffix = "--861fbeab-cd20-470c-9609-d40a0f704466--";
        byte[] bsuffix = suffix.getBytes(CharsetUtil.UTF_8);
        byte[] bsuffixReal = new byte[bsuffix.length + 2];
        for (int i = 0; i < bsuffix.length; ++i) {
            bsuffixReal[1 + i] = bsuffix[i];
        }
        bsuffixReal[0] = 10;
        bsuffixReal[bsuffixReal.length - 1] = 13;
        byte[] lastbody = new byte[]{10};
        DefaultHttpRequest request = new DefaultHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.POST, "/upload");
        request.headers().set("content-type", (Object)"multipart/form-data; boundary=861fbeab-cd20-470c-9609-d40a0f704466");
        request.headers().set("content-length", (Object)(prefix.length() + fileSize + suffix.length() + 4));
        HttpPostMultipartRequestDecoder decoder = new HttpPostMultipartRequestDecoder(factory, (HttpRequest)request);
        ByteBuf buf = Unpooled.wrappedBuffer((byte[])prefix.getBytes(CharsetUtil.UTF_8));
        DefaultHttpContent httpContent = new DefaultHttpContent(buf);
        decoder.offer((HttpContent)httpContent);
        Assertions.assertNotNull((Object)((HttpData)decoder.currentPartialHttpData()).content());
        httpContent.release();
        byte[] body = new byte[bytesPerChunk];
        Arrays.fill(body, (byte)1);
        body[0] = 13;
        body[1] = 10;
        for (int i = 0; i < nbChunks; ++i) {
            ByteBuf content = Unpooled.wrappedBuffer((byte[])body, (int)0, (int)bytesPerChunk);
            httpContent = new DefaultHttpContent(content);
            decoder.offer((HttpContent)httpContent);
            Assertions.assertNotNull((Object)((HttpData)decoder.currentPartialHttpData()).content());
            httpContent.release();
        }
        byte[] previousLastbody = new byte[bytesLastChunk + 1];
        Arrays.fill(previousLastbody, (byte)1);
        previousLastbody[bytesLastChunk] = 13;
        ByteBuf content2 = Unpooled.wrappedBuffer((byte[])previousLastbody, (int)0, (int)previousLastbody.length);
        httpContent = new DefaultHttpContent(content2);
        decoder.offer((HttpContent)httpContent);
        Assertions.assertNotNull((Object)decoder.currentPartialHttpData());
        httpContent.release();
        content2 = Unpooled.wrappedBuffer((byte[])bsuffixReal, (int)0, (int)bsuffixReal.length);
        httpContent = new DefaultHttpContent(content2);
        decoder.offer((HttpContent)httpContent);
        Assertions.assertNull((Object)decoder.currentPartialHttpData());
        httpContent.release();
        content2 = Unpooled.wrappedBuffer((byte[])lastbody, (int)0, (int)lastbody.length);
        httpContent = new DefaultHttpContent(content2);
        decoder.offer((HttpContent)httpContent);
        Assertions.assertNull((Object)decoder.currentPartialHttpData());
        httpContent.release();
        decoder.offer((HttpContent)new DefaultLastHttpContent());
        FileUpload data = (FileUpload)decoder.getBodyHttpDatas().get(0);
        Assertions.assertEquals((long)data.length(), (long)fileSize);
        Assertions.assertEquals((Object)inMemory, (Object)data.isInMemory());
        if (data.isInMemory()) {
            Assertions.assertFalse((data.getByteBuf().capacity() < fileSize ? 1 : 0) != 0, (String)"Capacity should be at least file size");
        }
        Assertions.assertTrue((decoder.getCurrentAllocatedCapacity() < fileSize ? 1 : 0) != 0, (String)"Capacity should be less than 1M");
        for (InterfaceHttpData httpData : httpDatas = decoder.getBodyHttpDatas().toArray(new InterfaceHttpData[0])) {
            Assertions.assertEquals((int)1, (int)httpData.refCnt(), (String)"Before cleanAllHttpData should be 1");
        }
        factory.cleanAllHttpData();
        for (InterfaceHttpData httpData : httpDatas) {
            Assertions.assertEquals((int)(inMemory ? 1 : 0), (int)httpData.refCnt(), (String)"After cleanAllHttpData should be 1 if in Memory");
        }
        decoder.destroy();
        for (InterfaceHttpData httpData : httpDatas) {
            Assertions.assertEquals((int)0, (int)httpData.refCnt(), (String)"RefCnt should be 0");
        }
    }

    @Test
    public void testFileDelimiterLFLastChunkDecoderDiskFactory() throws IOException {
        DefaultHttpDataFactory factory = new DefaultHttpDataFactory(true);
        HttpPostMultiPartRequestDecoderTest.commonTestFileDelimiterLFLastChunk((HttpDataFactory)factory, false);
    }

    @Test
    public void testFileDelimiterLFLastChunkDecoderMemoryFactory() throws IOException {
        DefaultHttpDataFactory factory = new DefaultHttpDataFactory(false);
        HttpPostMultiPartRequestDecoderTest.commonTestFileDelimiterLFLastChunk((HttpDataFactory)factory, true);
    }

    @Test
    public void testFileDelimiterLFLastChunkDecoderMixedFactory() throws IOException {
        DefaultHttpDataFactory factory = new DefaultHttpDataFactory(10000L);
        HttpPostMultiPartRequestDecoderTest.commonTestFileDelimiterLFLastChunk((HttpDataFactory)factory, false);
    }
}

