/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http.websocketx;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.embedded.EmbeddedChannel;
import io.netty.handler.codec.http.websocketx.CloseWebSocketFrame;
import io.netty.handler.codec.http.websocketx.WebSocket08FrameDecoder;
import io.netty.handler.codec.http.websocketx.WebSocket08FrameEncoder;
import java.util.HashSet;
import java.util.Iterator;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

public class WebSocket08FrameDecoderTest {
    @Test
    public void channelInactive() throws Exception {
        WebSocket08FrameDecoder decoder = new WebSocket08FrameDecoder(true, true, 65535, false);
        ChannelHandlerContext ctx = (ChannelHandlerContext)Mockito.mock(ChannelHandlerContext.class);
        decoder.channelInactive(ctx);
        ((ChannelHandlerContext)Mockito.verify((Object)ctx)).fireChannelInactive();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void supportIanaStatusCodes() throws Exception {
        HashSet<Integer> forbiddenIanaCodes = new HashSet<Integer>();
        forbiddenIanaCodes.add(1004);
        forbiddenIanaCodes.add(1005);
        forbiddenIanaCodes.add(1006);
        HashSet<Integer> validIanaCodes = new HashSet<Integer>();
        for (int i = 1000; i < 1015; ++i) {
            validIanaCodes.add(i);
        }
        validIanaCodes.removeAll(forbiddenIanaCodes);
        Iterator iterator = validIanaCodes.iterator();
        while (iterator.hasNext()) {
            int statusCode = (Integer)iterator.next();
            EmbeddedChannel encoderChannel = new EmbeddedChannel(new ChannelHandler[]{new WebSocket08FrameEncoder(true)});
            EmbeddedChannel decoderChannel = new EmbeddedChannel(new ChannelHandler[]{new WebSocket08FrameDecoder(true, true, 65535, false)});
            Assertions.assertTrue((boolean)encoderChannel.writeOutbound(new Object[]{new CloseWebSocketFrame(statusCode, "Bye")}));
            Assertions.assertTrue((boolean)encoderChannel.finish());
            ByteBuf serializedCloseFrame = (ByteBuf)encoderChannel.readOutbound();
            Assertions.assertNull((Object)encoderChannel.readOutbound());
            Assertions.assertTrue((boolean)decoderChannel.writeInbound(new Object[]{serializedCloseFrame}));
            Assertions.assertTrue((boolean)decoderChannel.finish());
            CloseWebSocketFrame outputFrame = (CloseWebSocketFrame)decoderChannel.readInbound();
            Assertions.assertNull((Object)decoderChannel.readOutbound());
            try {
                Assertions.assertEquals((int)statusCode, (int)outputFrame.statusCode());
            }
            finally {
                outputFrame.release();
            }
        }
    }
}

