/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http;

import io.netty.handler.codec.http.DefaultFullHttpRequest;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.DefaultHttpHeaders;
import io.netty.handler.codec.http.DefaultHttpRequest;
import io.netty.handler.codec.http.DefaultHttpResponse;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http.HttpHeadersTestUtils;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpUtil;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.util.CharsetUtil;
import io.netty.util.ReferenceCountUtil;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.function.Executable;

public class HttpUtilTest {
    @Test
    public void testRecognizesOriginForm() {
        Assertions.assertTrue((boolean)HttpUtil.isOriginForm((URI)URI.create("/where?q=now")));
        Assertions.assertFalse((boolean)HttpUtil.isOriginForm((URI)URI.create("http://www.example.org/pub/WWW/TheProject.html")));
        Assertions.assertFalse((boolean)HttpUtil.isOriginForm((URI)URI.create("www.example.com:80")));
        Assertions.assertFalse((boolean)HttpUtil.isOriginForm((URI)URI.create("*")));
    }

    @Test
    public void testRecognizesAsteriskForm() {
        Assertions.assertTrue((boolean)HttpUtil.isAsteriskForm((URI)URI.create("*")));
        Assertions.assertFalse((boolean)HttpUtil.isAsteriskForm((URI)URI.create("/where?q=now")));
        Assertions.assertFalse((boolean)HttpUtil.isAsteriskForm((URI)URI.create("http://www.example.org/pub/WWW/TheProject.html")));
        Assertions.assertFalse((boolean)HttpUtil.isAsteriskForm((URI)URI.create("www.example.com:80")));
    }

    @Test
    public void testRemoveTransferEncodingIgnoreCase() {
        DefaultHttpResponse message = new DefaultHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK);
        message.headers().set((CharSequence)HttpHeaderNames.TRANSFER_ENCODING, (Object)"Chunked");
        Assertions.assertFalse((boolean)message.headers().isEmpty());
        HttpUtil.setTransferEncodingChunked((HttpMessage)message, (boolean)false);
        Assertions.assertTrue((boolean)message.headers().isEmpty());
    }

    @Test
    public void testGetOperations() {
        DefaultHttpHeaders headers = new DefaultHttpHeaders();
        headers.add(HttpHeadersTestUtils.of("Foo"), (Object)HttpHeadersTestUtils.of("1"));
        headers.add(HttpHeadersTestUtils.of("Foo"), (Object)HttpHeadersTestUtils.of("2"));
        Assertions.assertEquals((Object)"1", (Object)headers.get(HttpHeadersTestUtils.of("Foo")));
        List values = headers.getAll(HttpHeadersTestUtils.of("Foo"));
        Assertions.assertEquals((int)2, (int)values.size());
        Assertions.assertEquals((Object)"1", values.get(0));
        Assertions.assertEquals((Object)"2", values.get(1));
    }

    @Test
    public void testGetCharsetAsRawCharSequence() {
        String QUOTES_CHARSET_CONTENT_TYPE = "text/html; charset=\"utf8\"";
        String SIMPLE_CONTENT_TYPE = "text/html";
        DefaultHttpResponse message = new DefaultHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK);
        message.headers().set((CharSequence)HttpHeaderNames.CONTENT_TYPE, (Object)QUOTES_CHARSET_CONTENT_TYPE);
        Assertions.assertEquals((Object)"\"utf8\"", (Object)HttpUtil.getCharsetAsSequence((HttpMessage)message));
        Assertions.assertEquals((Object)"\"utf8\"", (Object)HttpUtil.getCharsetAsSequence((CharSequence)QUOTES_CHARSET_CONTENT_TYPE));
        message.headers().set((CharSequence)HttpHeaderNames.CONTENT_TYPE, (Object)"text/html");
        Assertions.assertNull((Object)HttpUtil.getCharsetAsSequence((HttpMessage)message));
        Assertions.assertNull((Object)HttpUtil.getCharsetAsSequence((CharSequence)SIMPLE_CONTENT_TYPE));
    }

    @Test
    public void testGetCharset() {
        this.testGetCharsetUtf8("text/html; charset=utf-8");
    }

    @Test
    public void testGetCharsetNoSpace() {
        this.testGetCharsetUtf8("text/html;charset=utf-8");
    }

    @Test
    public void testGetCharsetQuoted() {
        this.testGetCharsetUtf8("text/html; charset=\"utf-8\"");
    }

    @Test
    public void testGetCharsetNoSpaceQuoted() {
        this.testGetCharsetUtf8("text/html;charset=\"utf-8\"");
    }

    private void testGetCharsetUtf8(String contentType) {
        String UPPER_CASE_NORMAL_CONTENT_TYPE = contentType.toUpperCase();
        DefaultHttpResponse message = new DefaultHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK);
        message.headers().set((CharSequence)HttpHeaderNames.CONTENT_TYPE, (Object)contentType);
        Assertions.assertEquals((Object)CharsetUtil.UTF_8, (Object)HttpUtil.getCharset((HttpMessage)message));
        Assertions.assertEquals((Object)CharsetUtil.UTF_8, (Object)HttpUtil.getCharset((CharSequence)contentType));
        message.headers().set((CharSequence)HttpHeaderNames.CONTENT_TYPE, (Object)UPPER_CASE_NORMAL_CONTENT_TYPE);
        Assertions.assertEquals((Object)CharsetUtil.UTF_8, (Object)HttpUtil.getCharset((HttpMessage)message));
        Assertions.assertEquals((Object)CharsetUtil.UTF_8, (Object)HttpUtil.getCharset((CharSequence)UPPER_CASE_NORMAL_CONTENT_TYPE));
    }

    @Test
    public void testGetCharsetNoLeadingQuotes() {
        HttpUtilTest.testGetCharsetInvalidQuotes("text/html;charset=utf-8\"");
    }

    @Test
    public void testGetCharsetNoTrailingQuotes() {
        HttpUtilTest.testGetCharsetInvalidQuotes("text/html;charset=\"utf-8");
    }

    @Test
    public void testGetCharsetOnlyQuotes() {
        HttpUtilTest.testGetCharsetInvalidQuotes("text/html;charset=\"\"");
    }

    private static void testGetCharsetInvalidQuotes(String contentType) {
        String UPPER_CASE_NORMAL_CONTENT_TYPE = contentType.toUpperCase();
        DefaultHttpResponse message = new DefaultHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK);
        message.headers().set((CharSequence)HttpHeaderNames.CONTENT_TYPE, (Object)contentType);
        Assertions.assertEquals((Object)CharsetUtil.ISO_8859_1, (Object)HttpUtil.getCharset((HttpMessage)message, (Charset)CharsetUtil.ISO_8859_1));
        Assertions.assertEquals((Object)CharsetUtil.ISO_8859_1, (Object)HttpUtil.getCharset((CharSequence)contentType, (Charset)CharsetUtil.ISO_8859_1));
        message.headers().set((CharSequence)HttpHeaderNames.CONTENT_TYPE, (Object)UPPER_CASE_NORMAL_CONTENT_TYPE);
        Assertions.assertEquals((Object)CharsetUtil.ISO_8859_1, (Object)HttpUtil.getCharset((HttpMessage)message, (Charset)CharsetUtil.ISO_8859_1));
        Assertions.assertEquals((Object)CharsetUtil.ISO_8859_1, (Object)HttpUtil.getCharset((CharSequence)UPPER_CASE_NORMAL_CONTENT_TYPE, (Charset)CharsetUtil.ISO_8859_1));
    }

    @Test
    public void testGetCharsetIfNotLastParameter() {
        String NORMAL_CONTENT_TYPE_WITH_PARAMETERS = "application/soap-xml; charset=utf-8; action=\"http://www.soap-service.by/foo/add\"";
        DefaultHttpRequest message = new DefaultHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.POST, "http://localhost:7788/foo");
        message.headers().set((CharSequence)HttpHeaderNames.CONTENT_TYPE, (Object)NORMAL_CONTENT_TYPE_WITH_PARAMETERS);
        Assertions.assertEquals((Object)CharsetUtil.UTF_8, (Object)HttpUtil.getCharset((HttpMessage)message));
        Assertions.assertEquals((Object)CharsetUtil.UTF_8, (Object)HttpUtil.getCharset((CharSequence)NORMAL_CONTENT_TYPE_WITH_PARAMETERS));
        Assertions.assertEquals((Object)"utf-8", (Object)HttpUtil.getCharsetAsSequence((HttpMessage)message));
        Assertions.assertEquals((Object)"utf-8", (Object)HttpUtil.getCharsetAsSequence((CharSequence)NORMAL_CONTENT_TYPE_WITH_PARAMETERS));
    }

    @Test
    public void testGetCharset_defaultValue() {
        String SIMPLE_CONTENT_TYPE = "text/html";
        String CONTENT_TYPE_WITH_INCORRECT_CHARSET = "text/html; charset=UTFFF";
        String CONTENT_TYPE_WITH_ILLEGAL_CHARSET_NAME = "text/html; charset=!illegal!";
        DefaultHttpResponse message = new DefaultHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK);
        message.headers().set((CharSequence)HttpHeaderNames.CONTENT_TYPE, (Object)"text/html");
        Assertions.assertEquals((Object)CharsetUtil.ISO_8859_1, (Object)HttpUtil.getCharset((HttpMessage)message));
        Assertions.assertEquals((Object)CharsetUtil.ISO_8859_1, (Object)HttpUtil.getCharset((CharSequence)"text/html"));
        message.headers().set((CharSequence)HttpHeaderNames.CONTENT_TYPE, (Object)"text/html");
        Assertions.assertEquals((Object)CharsetUtil.UTF_8, (Object)HttpUtil.getCharset((HttpMessage)message, (Charset)StandardCharsets.UTF_8));
        Assertions.assertEquals((Object)CharsetUtil.UTF_8, (Object)HttpUtil.getCharset((CharSequence)"text/html", (Charset)StandardCharsets.UTF_8));
        message.headers().set((CharSequence)HttpHeaderNames.CONTENT_TYPE, (Object)"text/html; charset=UTFFF");
        Assertions.assertEquals((Object)CharsetUtil.ISO_8859_1, (Object)HttpUtil.getCharset((HttpMessage)message));
        Assertions.assertEquals((Object)CharsetUtil.ISO_8859_1, (Object)HttpUtil.getCharset((CharSequence)"text/html; charset=UTFFF"));
        message.headers().set((CharSequence)HttpHeaderNames.CONTENT_TYPE, (Object)"text/html; charset=UTFFF");
        Assertions.assertEquals((Object)CharsetUtil.UTF_8, (Object)HttpUtil.getCharset((HttpMessage)message, (Charset)StandardCharsets.UTF_8));
        Assertions.assertEquals((Object)CharsetUtil.UTF_8, (Object)HttpUtil.getCharset((CharSequence)"text/html; charset=UTFFF", (Charset)StandardCharsets.UTF_8));
        message.headers().set((CharSequence)HttpHeaderNames.CONTENT_TYPE, (Object)"text/html; charset=!illegal!");
        Assertions.assertEquals((Object)CharsetUtil.ISO_8859_1, (Object)HttpUtil.getCharset((HttpMessage)message));
        Assertions.assertEquals((Object)CharsetUtil.ISO_8859_1, (Object)HttpUtil.getCharset((CharSequence)"text/html; charset=!illegal!"));
        message.headers().set((CharSequence)HttpHeaderNames.CONTENT_TYPE, (Object)"text/html; charset=!illegal!");
        Assertions.assertEquals((Object)CharsetUtil.UTF_8, (Object)HttpUtil.getCharset((HttpMessage)message, (Charset)StandardCharsets.UTF_8));
        Assertions.assertEquals((Object)CharsetUtil.UTF_8, (Object)HttpUtil.getCharset((CharSequence)"text/html; charset=!illegal!", (Charset)StandardCharsets.UTF_8));
    }

    @Test
    public void testGetMimeType() {
        String SIMPLE_CONTENT_TYPE = "text/html";
        String NORMAL_CONTENT_TYPE = "text/html; charset=utf-8";
        DefaultHttpResponse message = new DefaultHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK);
        Assertions.assertNull((Object)HttpUtil.getMimeType((HttpMessage)message));
        message.headers().set((CharSequence)HttpHeaderNames.CONTENT_TYPE, (Object)"");
        Assertions.assertNull((Object)HttpUtil.getMimeType((HttpMessage)message));
        Assertions.assertNull((Object)HttpUtil.getMimeType((CharSequence)""));
        message.headers().set((CharSequence)HttpHeaderNames.CONTENT_TYPE, (Object)"text/html");
        Assertions.assertEquals((Object)"text/html", (Object)HttpUtil.getMimeType((HttpMessage)message));
        Assertions.assertEquals((Object)"text/html", (Object)HttpUtil.getMimeType((CharSequence)"text/html"));
        message.headers().set((CharSequence)HttpHeaderNames.CONTENT_TYPE, (Object)"text/html; charset=utf-8");
        Assertions.assertEquals((Object)"text/html", (Object)HttpUtil.getMimeType((HttpMessage)message));
        Assertions.assertEquals((Object)"text/html", (Object)HttpUtil.getMimeType((CharSequence)"text/html; charset=utf-8"));
    }

    @Test
    public void testGetContentLengthThrowsNumberFormatException() {
        DefaultHttpResponse message = new DefaultHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK);
        message.headers().set((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (Object)"bar");
        try {
            HttpUtil.getContentLength((HttpMessage)message);
            Assertions.fail();
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    @Test
    public void testGetContentLengthIntDefaultValueThrowsNumberFormatException() {
        DefaultHttpResponse message = new DefaultHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK);
        message.headers().set((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (Object)"bar");
        try {
            HttpUtil.getContentLength((HttpMessage)message, (int)1);
            Assertions.fail();
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    @Test
    public void testGetContentLengthLongDefaultValueThrowsNumberFormatException() {
        DefaultHttpResponse message = new DefaultHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK);
        message.headers().set((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (Object)"bar");
        try {
            HttpUtil.getContentLength((HttpMessage)message, (long)1L);
            Assertions.fail();
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    @Test
    public void testDoubleChunkedHeader() {
        DefaultHttpResponse message = new DefaultHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK);
        message.headers().add((CharSequence)HttpHeaderNames.TRANSFER_ENCODING, (Object)"chunked");
        HttpUtil.setTransferEncodingChunked((HttpMessage)message, (boolean)true);
        List<String> expected = Collections.singletonList("chunked");
        Assertions.assertEquals(expected, (Object)message.headers().getAll((CharSequence)HttpHeaderNames.TRANSFER_ENCODING));
    }

    private static List<String> allPossibleCasesOfContinue() {
        ArrayList<String> cases = new ArrayList<String>();
        String c = "continue";
        int i = 0;
        while ((double)i < Math.pow(2.0, "continue".length())) {
            StringBuilder sb = new StringBuilder("continue".length());
            int k = 0;
            for (int j = i; j > 0; j >>= 1) {
                if ((j & 1) == 1) {
                    sb.append(Character.toUpperCase("continue".charAt(k++)));
                    continue;
                }
                sb.append("continue".charAt(k++));
            }
            while (k < "continue".length()) {
                sb.append("continue".charAt(k));
                ++k;
            }
            cases.add(sb.toString());
            ++i;
        }
        return cases;
    }

    @Test
    public void testIs100Continue() {
        for (String continueCase : HttpUtilTest.allPossibleCasesOfContinue()) {
            HttpUtilTest.run100ContinueTest(HttpVersion.HTTP_1_1, "100-" + continueCase, true);
        }
        HttpUtilTest.run100ContinueTest(HttpVersion.HTTP_1_1, null, false);
        HttpUtilTest.run100ContinueTest(HttpVersion.HTTP_1_1, "chocolate=yummy", false);
        HttpUtilTest.run100ContinueTest(HttpVersion.HTTP_1_0, "100-continue", false);
        DefaultFullHttpResponse message = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK);
        message.headers().set((CharSequence)HttpHeaderNames.EXPECT, (Object)"100-continue");
        HttpUtilTest.run100ContinueTest((HttpMessage)message, false);
    }

    private static void run100ContinueTest(HttpVersion version, String expectations, boolean expect) {
        DefaultFullHttpRequest message = new DefaultFullHttpRequest(version, HttpMethod.GET, "/");
        if (expectations != null) {
            message.headers().set((CharSequence)HttpHeaderNames.EXPECT, (Object)expectations);
        }
        HttpUtilTest.run100ContinueTest((HttpMessage)message, expect);
    }

    private static void run100ContinueTest(HttpMessage message, boolean expected) {
        Assertions.assertEquals((Object)expected, (Object)HttpUtil.is100ContinueExpected((HttpMessage)message));
        ReferenceCountUtil.release((Object)message);
    }

    @Test
    public void testContainsUnsupportedExpectation() {
        for (String continueCase : HttpUtilTest.allPossibleCasesOfContinue()) {
            HttpUtilTest.runUnsupportedExpectationTest(HttpVersion.HTTP_1_1, "100-" + continueCase, false);
        }
        HttpUtilTest.runUnsupportedExpectationTest(HttpVersion.HTTP_1_1, null, false);
        HttpUtilTest.runUnsupportedExpectationTest(HttpVersion.HTTP_1_1, "chocolate=yummy", true);
        HttpUtilTest.runUnsupportedExpectationTest(HttpVersion.HTTP_1_0, "100-continue", false);
        DefaultFullHttpResponse message = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK);
        message.headers().set("Expect", (Object)"100-continue");
        HttpUtilTest.runUnsupportedExpectationTest((HttpMessage)message, false);
    }

    private static void runUnsupportedExpectationTest(HttpVersion version, String expectations, boolean expect) {
        DefaultFullHttpRequest message = new DefaultFullHttpRequest(version, HttpMethod.GET, "/");
        if (expectations != null) {
            message.headers().set("Expect", (Object)expectations);
        }
        HttpUtilTest.runUnsupportedExpectationTest((HttpMessage)message, expect);
    }

    private static void runUnsupportedExpectationTest(HttpMessage message, boolean expected) {
        Assertions.assertEquals((Object)expected, (Object)HttpUtil.isUnsupportedExpectation((HttpMessage)message));
        ReferenceCountUtil.release((Object)message);
    }

    @Test
    public void testFormatHostnameForHttpFromResolvedAddressWithHostname() throws Exception {
        InetSocketAddress socketAddress = new InetSocketAddress(InetAddress.getByName("localhost"), 8080);
        Assertions.assertEquals((Object)"localhost", (Object)HttpUtil.formatHostnameForHttp((InetSocketAddress)socketAddress));
    }

    @Test
    public void testFormatHostnameForHttpFromUnesolvedAddressWithHostname() {
        InetSocketAddress socketAddress = InetSocketAddress.createUnresolved("localhost", 80);
        Assertions.assertEquals((Object)"localhost", (Object)HttpUtil.formatHostnameForHttp((InetSocketAddress)socketAddress));
    }

    @Test
    public void testIpv6() throws Exception {
        InetSocketAddress socketAddress = new InetSocketAddress(InetAddress.getByName("::1"), 8080);
        Assertions.assertEquals((Object)"[::1]", (Object)HttpUtil.formatHostnameForHttp((InetSocketAddress)socketAddress));
    }

    @Test
    public void testIpv6Unresolved() {
        InetSocketAddress socketAddress = InetSocketAddress.createUnresolved("::1", 8080);
        Assertions.assertEquals((Object)"[::1]", (Object)HttpUtil.formatHostnameForHttp((InetSocketAddress)socketAddress));
    }

    @Test
    public void testIpv4() throws Exception {
        InetSocketAddress socketAddress = new InetSocketAddress(InetAddress.getByName("10.0.0.1"), 8080);
        Assertions.assertEquals((Object)"10.0.0.1", (Object)HttpUtil.formatHostnameForHttp((InetSocketAddress)socketAddress));
    }

    @Test
    public void testIpv4Unresolved() {
        InetSocketAddress socketAddress = InetSocketAddress.createUnresolved("10.0.0.1", 8080);
        Assertions.assertEquals((Object)"10.0.0.1", (Object)HttpUtil.formatHostnameForHttp((InetSocketAddress)socketAddress));
    }

    @Test
    public void testKeepAliveIfConnectionHeaderAbsent() {
        DefaultHttpRequest http11Message = new DefaultHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.GET, "http:localhost/http_1_1");
        Assertions.assertTrue((boolean)HttpUtil.isKeepAlive((HttpMessage)http11Message));
        DefaultHttpRequest http10Message = new DefaultHttpRequest(HttpVersion.HTTP_1_0, HttpMethod.GET, "http:localhost/http_1_0");
        Assertions.assertFalse((boolean)HttpUtil.isKeepAlive((HttpMessage)http10Message));
    }

    @Test
    public void testKeepAliveIfConnectionHeaderMultipleValues() {
        DefaultHttpRequest http11Message = new DefaultHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.GET, "http:localhost/http_1_1");
        http11Message.headers().set((CharSequence)HttpHeaderNames.CONNECTION, (Object)(HttpHeaderValues.UPGRADE + ", " + HttpHeaderValues.CLOSE));
        Assertions.assertFalse((boolean)HttpUtil.isKeepAlive((HttpMessage)http11Message));
        http11Message.headers().set((CharSequence)HttpHeaderNames.CONNECTION, (Object)(HttpHeaderValues.UPGRADE + ", Close"));
        Assertions.assertFalse((boolean)HttpUtil.isKeepAlive((HttpMessage)http11Message));
        http11Message.headers().set((CharSequence)HttpHeaderNames.CONNECTION, (Object)(HttpHeaderValues.CLOSE + ", " + HttpHeaderValues.UPGRADE));
        Assertions.assertFalse((boolean)HttpUtil.isKeepAlive((HttpMessage)http11Message));
        http11Message.headers().set((CharSequence)HttpHeaderNames.CONNECTION, (Object)(HttpHeaderValues.UPGRADE + ", " + HttpHeaderValues.KEEP_ALIVE));
        Assertions.assertTrue((boolean)HttpUtil.isKeepAlive((HttpMessage)http11Message));
    }

    @Test
    public void normalizeAndGetContentLengthEmpty() {
        HttpUtilTest.testNormalizeAndGetContentLengthInvalidContentLength("");
    }

    @Test
    public void normalizeAndGetContentLengthNotANumber() {
        HttpUtilTest.testNormalizeAndGetContentLengthInvalidContentLength("foo");
    }

    @Test
    public void normalizeAndGetContentLengthNegative() {
        HttpUtilTest.testNormalizeAndGetContentLengthInvalidContentLength("-1");
    }

    private static void testNormalizeAndGetContentLengthInvalidContentLength(final String contentLengthField) {
        Assertions.assertThrows(IllegalArgumentException.class, (Executable)new Executable(){

            public void execute() {
                HttpUtil.normalizeAndGetContentLength(Collections.singletonList(contentLengthField), (boolean)false, (boolean)false);
            }
        });
    }
}

