/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http.websocketx.extensions.compression;

import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandler;
import io.netty.channel.embedded.EmbeddedChannel;
import io.netty.handler.codec.compression.ZlibCodecFactory;
import io.netty.handler.codec.http.websocketx.TextWebSocketFrame;
import io.netty.handler.codec.http.websocketx.extensions.WebSocketClientExtension;
import io.netty.handler.codec.http.websocketx.extensions.WebSocketExtensionData;
import io.netty.handler.codec.http.websocketx.extensions.compression.PerMessageDeflateClientExtensionHandshaker;
import io.netty.handler.codec.http.websocketx.extensions.compression.PerMessageDeflateDecoder;
import io.netty.handler.codec.http.websocketx.extensions.compression.PerMessageDeflateEncoder;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class PerMessageDeflateClientExtensionHandshakerTest {
    @Test
    public void testNormalData() {
        PerMessageDeflateClientExtensionHandshaker handshaker = new PerMessageDeflateClientExtensionHandshaker();
        WebSocketExtensionData data = handshaker.newRequestData();
        Assertions.assertEquals((Object)"permessage-deflate", (Object)data.name());
        Assertions.assertEquals((int)(ZlibCodecFactory.isSupportingWindowSizeAndMemLevel() ? 1 : 0), (int)data.parameters().size());
    }

    @Test
    public void testCustomData() {
        PerMessageDeflateClientExtensionHandshaker handshaker = new PerMessageDeflateClientExtensionHandshaker(6, true, 10, true, true);
        WebSocketExtensionData data = handshaker.newRequestData();
        Assertions.assertEquals((Object)"permessage-deflate", (Object)data.name());
        Assertions.assertTrue((boolean)data.parameters().containsKey("client_max_window_bits"));
        Assertions.assertTrue((boolean)data.parameters().containsKey("server_max_window_bits"));
        Assertions.assertEquals((Object)"10", data.parameters().get("server_max_window_bits"));
        Assertions.assertTrue((boolean)data.parameters().containsKey("client_max_window_bits"));
        Assertions.assertTrue((boolean)data.parameters().containsKey("server_max_window_bits"));
    }

    @Test
    public void testNormalHandshake() {
        PerMessageDeflateClientExtensionHandshaker handshaker = new PerMessageDeflateClientExtensionHandshaker();
        WebSocketClientExtension extension = handshaker.handshakeExtension(new WebSocketExtensionData("permessage-deflate", Collections.emptyMap()));
        Assertions.assertNotNull((Object)extension);
        Assertions.assertEquals((int)4, (int)extension.rsv());
        Assertions.assertTrue((boolean)(extension.newExtensionDecoder() instanceof PerMessageDeflateDecoder));
        Assertions.assertTrue((boolean)(extension.newExtensionEncoder() instanceof PerMessageDeflateEncoder));
    }

    @Test
    public void testCustomHandshake() {
        PerMessageDeflateClientExtensionHandshaker handshaker = new PerMessageDeflateClientExtensionHandshaker(6, true, 10, true, true);
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("client_max_window_bits", "12");
        parameters.put("server_max_window_bits", "8");
        parameters.put("client_no_context_takeover", null);
        parameters.put("server_no_context_takeover", null);
        WebSocketClientExtension extension = handshaker.handshakeExtension(new WebSocketExtensionData("permessage-deflate", parameters));
        Assertions.assertNotNull((Object)extension);
        Assertions.assertEquals((int)4, (int)extension.rsv());
        Assertions.assertTrue((boolean)(extension.newExtensionDecoder() instanceof PerMessageDeflateDecoder));
        Assertions.assertTrue((boolean)(extension.newExtensionEncoder() instanceof PerMessageDeflateEncoder));
        parameters = new HashMap();
        parameters.put("server_max_window_bits", "10");
        parameters.put("server_no_context_takeover", null);
        extension = handshaker.handshakeExtension(new WebSocketExtensionData("permessage-deflate", parameters));
        Assertions.assertNotNull((Object)extension);
        Assertions.assertEquals((int)4, (int)extension.rsv());
        Assertions.assertTrue((boolean)(extension.newExtensionDecoder() instanceof PerMessageDeflateDecoder));
        Assertions.assertTrue((boolean)(extension.newExtensionEncoder() instanceof PerMessageDeflateEncoder));
        parameters = new HashMap();
        extension = handshaker.handshakeExtension(new WebSocketExtensionData("permessage-deflate", parameters));
        Assertions.assertNull((Object)extension);
    }

    @Test
    public void testParameterValidation() {
        PerMessageDeflateClientExtensionHandshaker handshaker = new PerMessageDeflateClientExtensionHandshaker(6, true, 15, true, false);
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("client_max_window_bits", "15");
        parameters.put("server_max_window_bits", "8");
        WebSocketClientExtension extension = handshaker.handshakeExtension(new WebSocketExtensionData("permessage-deflate", parameters));
        Assertions.assertNotNull((Object)extension);
        Assertions.assertEquals((int)4, (int)extension.rsv());
        Assertions.assertTrue((boolean)(extension.newExtensionDecoder() instanceof PerMessageDeflateDecoder));
        Assertions.assertTrue((boolean)(extension.newExtensionEncoder() instanceof PerMessageDeflateEncoder));
        parameters = new HashMap();
        parameters.put("client_max_window_bits", "15");
        parameters.put("server_max_window_bits", "7");
        extension = handshaker.handshakeExtension(new WebSocketExtensionData("permessage-deflate", parameters));
        Assertions.assertNull((Object)extension);
    }

    @Test
    public void testServerNoContextTakeover() {
        PerMessageDeflateClientExtensionHandshaker handshaker = new PerMessageDeflateClientExtensionHandshaker(6, true, 15, true, false);
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("server_no_context_takeover", null);
        WebSocketClientExtension extension = handshaker.handshakeExtension(new WebSocketExtensionData("permessage-deflate", parameters));
        Assertions.assertNotNull((Object)extension);
        Assertions.assertEquals((int)4, (int)extension.rsv());
        Assertions.assertTrue((boolean)(extension.newExtensionDecoder() instanceof PerMessageDeflateDecoder));
        Assertions.assertTrue((boolean)(extension.newExtensionEncoder() instanceof PerMessageDeflateEncoder));
        handshaker = new PerMessageDeflateClientExtensionHandshaker(6, true, 15, true, true);
        parameters = new HashMap();
        extension = handshaker.handshakeExtension(new WebSocketExtensionData("permessage-deflate", parameters));
        Assertions.assertNull((Object)extension);
    }

    @Test
    public void testDecoderNoClientContext() {
        PerMessageDeflateClientExtensionHandshaker handshaker = new PerMessageDeflateClientExtensionHandshaker(6, true, 15, true, false);
        byte[] firstPayload = new byte[]{76, -50, -53, 10, -62, 48, 20, 4, -48, 95, 41, 89, -37, 36, 77, 90, 31, -39, 41, -72, 112, 33, -120, 20, 20, 119, -79, 70, 123, -95, 121, -48, 92, -116, 80, -6, -17, -58, -99, -37, -31, 12, 51, 19, 1, -9, -12, 68, -111, -117, 25, 58, 111, 77, -127, -66, -64, -34, 20, 59, -64, -29, -2, 90, -100, -115, 30, 16, 114, -68, 61, 29, 40, 89, -112, -73, 25, 35, 120, -105, -67, -32, -43, -70, -84, 120, -55, 69, 43, -124, 106, -92, 18, -110, 114, -50, 111, 25, -3, 10, 17, -75, 13, 127, -84, 106, 90, -66, 84, -75, 84, 53, -89, -75, 92, -3, -40, -61, 119, 49, -117, 30, 49, 68, -59, 88, 74, -119, -34, 1, -83, -7, -48, 124, -124, -23, 16, 88, -118, 121, 54, -53, 1, 44, 32, 81, 19, 25, -115, -43, -32, -64, -67, -120, -110, -101, 121, -2, 2};
        byte[] secondPayload = new byte[]{-86, 86, 42, 46, 77, 78, 78, 45, 6, 26, 83, 82, 84, -102, -86, 3, -28, 38, 21, 39, 23, 101, 38, -91, 2, -51, -51, 47, 74, 73, 45, 114, -54, -49, -49, -10, 49, -78, -118, 112, 10, 9, 13, 118, 1, -102, 84, -108, 90, 88, 10, 116, 27, -56, -84, 124, -112, -13, 16, 26, 116, -108, 18, -117, -46, -127, 6, 69, 99, -45, 24, 91, 91, 11, 0};
        Map<String, Object> parameters = Collections.singletonMap("client_no_context_takeover", null);
        WebSocketClientExtension extension = handshaker.handshakeExtension(new WebSocketExtensionData("permessage-deflate", parameters));
        Assertions.assertNotNull((Object)extension);
        EmbeddedChannel decoderChannel = new EmbeddedChannel(new ChannelHandler[]{extension.newExtensionDecoder()});
        Assertions.assertTrue((boolean)decoderChannel.writeInbound(new Object[]{new TextWebSocketFrame(true, 4, Unpooled.copiedBuffer((byte[])firstPayload))}));
        TextWebSocketFrame firstFrameDecompressed = (TextWebSocketFrame)decoderChannel.readInbound();
        Assertions.assertTrue((boolean)decoderChannel.writeInbound(new Object[]{new TextWebSocketFrame(true, 4, Unpooled.copiedBuffer((byte[])secondPayload))}));
        TextWebSocketFrame secondFrameDecompressed = (TextWebSocketFrame)decoderChannel.readInbound();
        Assertions.assertNotNull((Object)firstFrameDecompressed);
        Assertions.assertNotNull((Object)firstFrameDecompressed.content());
        Assertions.assertTrue((boolean)(firstFrameDecompressed instanceof TextWebSocketFrame));
        Assertions.assertEquals((Object)firstFrameDecompressed.text(), (Object)"{\"info\":\"Welcome to the BitMEX Realtime API.\",\"version\":\"2018-10-02T22:53:23.000Z\",\"timestamp\":\"2018-10-15T06:43:40.437Z\",\"docs\":\"https://www.bitmex.com/app/wsAPI\",\"limit\":{\"remaining\":39}}");
        Assertions.assertTrue((boolean)firstFrameDecompressed.release());
        Assertions.assertNotNull((Object)secondFrameDecompressed);
        Assertions.assertNotNull((Object)secondFrameDecompressed.content());
        Assertions.assertTrue((boolean)(secondFrameDecompressed instanceof TextWebSocketFrame));
        Assertions.assertEquals((Object)secondFrameDecompressed.text(), (Object)"{\"success\":true,\"subscribe\":\"orderBookL2:XBTUSD\",\"request\":{\"op\":\"subscribe\",\"args\":[\"orderBookL2:XBTUSD\"]}}");
        Assertions.assertTrue((boolean)secondFrameDecompressed.release());
        Assertions.assertFalse((boolean)decoderChannel.finish());
    }
}

