/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http;

import io.netty.handler.codec.http.DefaultHttpHeaders;
import io.netty.handler.codec.http.DefaultHttpResponse;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpHeadersTestUtils;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpUtil;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.util.AsciiString;
import io.netty.util.internal.EmptyArrays;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.function.Executable;

public class DefaultHttpHeadersTest {
    private static final CharSequence HEADER_NAME = "testHeader";
    private static final CharSequence ILLEGAL_VALUE = "testHeader\r\nContent-Length:45\r\n\r\n";

    @Test
    public void nullHeaderNameNotAllowed() {
        Assertions.assertThrows(IllegalArgumentException.class, (Executable)new Executable(){

            public void execute() {
                new DefaultHttpHeaders().add(null, (Object)"foo");
            }
        });
    }

    @Test
    public void emptyHeaderNameNotAllowed() {
        Assertions.assertThrows(IllegalArgumentException.class, (Executable)new Executable(){

            public void execute() {
                new DefaultHttpHeaders().add("", (Object)"foo");
            }
        });
    }

    @Test
    public void keysShouldBeCaseInsensitive() {
        DefaultHttpHeaders headers = new DefaultHttpHeaders();
        headers.add(HttpHeadersTestUtils.of("Name"), (Object)HttpHeadersTestUtils.of("value1"));
        headers.add(HttpHeadersTestUtils.of("name"), (Object)HttpHeadersTestUtils.of("value2"));
        headers.add(HttpHeadersTestUtils.of("NAME"), (Object)HttpHeadersTestUtils.of("value3"));
        Assertions.assertEquals((int)3, (int)headers.size());
        List<String> values = Arrays.asList("value1", "value2", "value3");
        Assertions.assertEquals(values, (Object)headers.getAll(HttpHeadersTestUtils.of("NAME")));
        Assertions.assertEquals(values, (Object)headers.getAll(HttpHeadersTestUtils.of("name")));
        Assertions.assertEquals(values, (Object)headers.getAll(HttpHeadersTestUtils.of("Name")));
        Assertions.assertEquals(values, (Object)headers.getAll(HttpHeadersTestUtils.of("nAmE")));
    }

    @Test
    public void keysShouldBeCaseInsensitiveInHeadersEquals() {
        DefaultHttpHeaders headers1 = new DefaultHttpHeaders();
        headers1.add(HttpHeadersTestUtils.of("name1"), Arrays.asList("value1", "value2", "value3"));
        headers1.add(HttpHeadersTestUtils.of("nAmE2"), (Object)HttpHeadersTestUtils.of("value4"));
        DefaultHttpHeaders headers2 = new DefaultHttpHeaders();
        headers2.add(HttpHeadersTestUtils.of("naMe1"), Arrays.asList("value1", "value2", "value3"));
        headers2.add(HttpHeadersTestUtils.of("NAME2"), (Object)HttpHeadersTestUtils.of("value4"));
        Assertions.assertEquals((Object)headers1, (Object)headers1);
        Assertions.assertEquals((Object)headers2, (Object)headers2);
        Assertions.assertEquals((Object)headers1, (Object)headers2);
        Assertions.assertEquals((Object)headers2, (Object)headers1);
        Assertions.assertEquals((int)headers1.hashCode(), (int)headers2.hashCode());
    }

    @Test
    public void testStringKeyRetrievedAsAsciiString() {
        DefaultHttpHeaders headers = new DefaultHttpHeaders(false);
        String connection = "keep-alive";
        headers.add(HttpHeadersTestUtils.of("Connection"), (Object)"keep-alive");
        String value = headers.getAsString((CharSequence)HttpHeaderNames.CONNECTION.toString());
        Assertions.assertNotNull((Object)value);
        Assertions.assertEquals((Object)"keep-alive", (Object)value);
        String value2 = headers.getAsString((CharSequence)HttpHeaderNames.CONNECTION);
        Assertions.assertNotNull((Object)value2);
        Assertions.assertEquals((Object)"keep-alive", (Object)value2);
    }

    @Test
    public void testAsciiStringKeyRetrievedAsString() {
        DefaultHttpHeaders headers = new DefaultHttpHeaders(false);
        String cacheControl = "no-cache";
        headers.add((CharSequence)HttpHeaderNames.CACHE_CONTROL, (Object)"no-cache");
        String value = headers.getAsString((CharSequence)HttpHeaderNames.CACHE_CONTROL);
        Assertions.assertNotNull((Object)value);
        Assertions.assertEquals((Object)"no-cache", (Object)value);
        String value2 = headers.getAsString((CharSequence)HttpHeaderNames.CACHE_CONTROL.toString());
        Assertions.assertNotNull((Object)value2);
        Assertions.assertEquals((Object)"no-cache", (Object)value2);
    }

    @Test
    public void testRemoveTransferEncodingIgnoreCase() {
        DefaultHttpResponse message = new DefaultHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK);
        message.headers().set((CharSequence)HttpHeaderNames.TRANSFER_ENCODING, (Object)"Chunked");
        Assertions.assertFalse((boolean)message.headers().isEmpty());
        HttpUtil.setTransferEncodingChunked((HttpMessage)message, (boolean)false);
        Assertions.assertTrue((boolean)message.headers().isEmpty());
    }

    @Test
    public void testGetOperations() {
        DefaultHttpHeaders headers = new DefaultHttpHeaders();
        headers.add(HttpHeadersTestUtils.of("Foo"), (Object)HttpHeadersTestUtils.of("1"));
        headers.add(HttpHeadersTestUtils.of("Foo"), (Object)HttpHeadersTestUtils.of("2"));
        Assertions.assertEquals((Object)"1", (Object)headers.get(HttpHeadersTestUtils.of("Foo")));
        List values = headers.getAll(HttpHeadersTestUtils.of("Foo"));
        Assertions.assertEquals((int)2, (int)values.size());
        Assertions.assertEquals((Object)"1", values.get(0));
        Assertions.assertEquals((Object)"2", values.get(1));
    }

    @Test
    public void testEqualsIgnoreCase() {
        MatcherAssert.assertThat((Object)AsciiString.contentEqualsIgnoreCase(null, null), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)AsciiString.contentEqualsIgnoreCase(null, (CharSequence)"foo"), (Matcher)CoreMatchers.is((Object)false));
        MatcherAssert.assertThat((Object)AsciiString.contentEqualsIgnoreCase((CharSequence)"bar", null), (Matcher)CoreMatchers.is((Object)false));
        MatcherAssert.assertThat((Object)AsciiString.contentEqualsIgnoreCase((CharSequence)"FoO", (CharSequence)"fOo"), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    public void testSetNullHeaderValueValidate() {
        DefaultHttpHeaders headers = new DefaultHttpHeaders(true);
        Assertions.assertThrows(NullPointerException.class, (Executable)new Executable((HttpHeaders)headers){
            final /* synthetic */ HttpHeaders val$headers;
            {
                this.val$headers = httpHeaders;
            }

            public void execute() {
                this.val$headers.set(HttpHeadersTestUtils.of("test"), (Object)null);
            }
        });
    }

    @Test
    public void testSetNullHeaderValueNotValidate() {
        DefaultHttpHeaders headers = new DefaultHttpHeaders(false);
        Assertions.assertThrows(NullPointerException.class, (Executable)new Executable((HttpHeaders)headers){
            final /* synthetic */ HttpHeaders val$headers;
            {
                this.val$headers = httpHeaders;
            }

            public void execute() {
                this.val$headers.set(HttpHeadersTestUtils.of("test"), (Object)null);
            }
        });
    }

    @Test
    public void addCharSequences() {
        DefaultHttpHeaders headers = DefaultHttpHeadersTest.newDefaultDefaultHttpHeaders();
        headers.add(HEADER_NAME, HttpHeadersTestUtils.HeaderValue.THREE.asList());
        DefaultHttpHeadersTest.assertDefaultValues(headers, HttpHeadersTestUtils.HeaderValue.THREE);
    }

    @Test
    public void addIterable() {
        DefaultHttpHeaders headers = DefaultHttpHeadersTest.newDefaultDefaultHttpHeaders();
        headers.add(HEADER_NAME, HttpHeadersTestUtils.HeaderValue.THREE.asList());
        DefaultHttpHeadersTest.assertDefaultValues(headers, HttpHeadersTestUtils.HeaderValue.THREE);
    }

    @Test
    public void addObjects() {
        DefaultHttpHeaders headers = DefaultHttpHeadersTest.newDefaultDefaultHttpHeaders();
        headers.add(HEADER_NAME, HttpHeadersTestUtils.HeaderValue.THREE.asList());
        DefaultHttpHeadersTest.assertDefaultValues(headers, HttpHeadersTestUtils.HeaderValue.THREE);
    }

    @Test
    public void setCharSequences() {
        DefaultHttpHeaders headers = DefaultHttpHeadersTest.newDefaultDefaultHttpHeaders();
        headers.set(HEADER_NAME, HttpHeadersTestUtils.HeaderValue.THREE.asList());
        DefaultHttpHeadersTest.assertDefaultValues(headers, HttpHeadersTestUtils.HeaderValue.THREE);
    }

    @Test
    public void setIterable() {
        DefaultHttpHeaders headers = DefaultHttpHeadersTest.newDefaultDefaultHttpHeaders();
        headers.set(HEADER_NAME, HttpHeadersTestUtils.HeaderValue.THREE.asList());
        DefaultHttpHeadersTest.assertDefaultValues(headers, HttpHeadersTestUtils.HeaderValue.THREE);
    }

    @Test
    public void setObjectObjects() {
        DefaultHttpHeaders headers = DefaultHttpHeadersTest.newDefaultDefaultHttpHeaders();
        headers.set(HEADER_NAME, HttpHeadersTestUtils.HeaderValue.THREE.asList());
        DefaultHttpHeadersTest.assertDefaultValues(headers, HttpHeadersTestUtils.HeaderValue.THREE);
    }

    @Test
    public void setObjectIterable() {
        DefaultHttpHeaders headers = DefaultHttpHeadersTest.newDefaultDefaultHttpHeaders();
        headers.set(HEADER_NAME, HttpHeadersTestUtils.HeaderValue.THREE.asList());
        DefaultHttpHeadersTest.assertDefaultValues(headers, HttpHeadersTestUtils.HeaderValue.THREE);
    }

    @Test
    public void setCharSequenceValidatesValue() {
        final DefaultHttpHeaders headers = DefaultHttpHeadersTest.newDefaultDefaultHttpHeaders();
        Assertions.assertThrows(IllegalArgumentException.class, (Executable)new Executable(){

            public void execute() throws Throwable {
                headers.set(HEADER_NAME, (Object)ILLEGAL_VALUE);
            }
        });
    }

    @Test
    public void setIterableValidatesValue() {
        final DefaultHttpHeaders headers = DefaultHttpHeadersTest.newDefaultDefaultHttpHeaders();
        Assertions.assertThrows(IllegalArgumentException.class, (Executable)new Executable(){

            public void execute() throws Throwable {
                headers.set(HEADER_NAME, Collections.singleton(ILLEGAL_VALUE));
            }
        });
    }

    @Test
    public void toStringOnEmptyHeaders() {
        Assertions.assertEquals((Object)"DefaultHttpHeaders[]", (Object)DefaultHttpHeadersTest.newDefaultDefaultHttpHeaders().toString());
    }

    @Test
    public void toStringOnSingleHeader() {
        Assertions.assertEquals((Object)"DefaultHttpHeaders[foo: bar]", (Object)DefaultHttpHeadersTest.newDefaultDefaultHttpHeaders().add("foo", (Object)"bar").toString());
    }

    @Test
    public void toStringOnMultipleHeaders() {
        Assertions.assertEquals((Object)"DefaultHttpHeaders[foo: bar, baz: qix]", (Object)DefaultHttpHeadersTest.newDefaultDefaultHttpHeaders().add("foo", (Object)"bar").add("baz", (Object)"qix").toString());
    }

    @Test
    public void providesHeaderNamesAsArray() throws Exception {
        Set nettyHeaders = new DefaultHttpHeaders().add((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (Object)10).names();
        Object[] namesArray = nettyHeaders.toArray(EmptyArrays.EMPTY_STRINGS);
        Assertions.assertArrayEquals((Object[])namesArray, (Object[])new String[]{HttpHeaderNames.CONTENT_LENGTH.toString()});
    }

    private static void assertDefaultValues(DefaultHttpHeaders headers, HttpHeadersTestUtils.HeaderValue headerValue) {
        Assertions.assertTrue((boolean)AsciiString.contentEquals((CharSequence)headerValue.asList().get(0), (CharSequence)headers.get(HEADER_NAME)));
        List<CharSequence> expected = headerValue.asList();
        List actual = headers.getAll(HEADER_NAME);
        Assertions.assertEquals((int)expected.size(), (int)actual.size());
        Iterator<CharSequence> eItr = expected.iterator();
        Iterator aItr = actual.iterator();
        while (eItr.hasNext()) {
            Assertions.assertTrue((boolean)AsciiString.contentEquals((CharSequence)eItr.next(), (CharSequence)((CharSequence)aItr.next())));
        }
    }

    private static DefaultHttpHeaders newDefaultDefaultHttpHeaders() {
        return new DefaultHttpHeaders(true);
    }
}

