/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http;

import io.netty.channel.ChannelHandler;
import io.netty.channel.embedded.EmbeddedChannel;
import io.netty.handler.codec.compression.Brotli;
import io.netty.handler.codec.compression.CompressionOptions;
import io.netty.handler.codec.compression.StandardCompressionOptions;
import io.netty.handler.codec.http.DefaultFullHttpRequest;
import io.netty.handler.codec.http.DefaultHttpResponse;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.HttpContentCompressor;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpVersion;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.condition.EnabledIf;

@EnabledIf(value="isBrotiAvailable")
class HttpContentCompressorOptionsTest {
    HttpContentCompressorOptionsTest() {
    }

    static boolean isBrotiAvailable() {
        return Brotli.isAvailable();
    }

    @Test
    void testGetBrTargetContentEncoding() {
        HttpContentCompressor compressor = new HttpContentCompressor(new CompressionOptions[]{StandardCompressionOptions.gzip(), StandardCompressionOptions.deflate(), StandardCompressionOptions.brotli(), StandardCompressionOptions.zstd()});
        String[] tests = new String[]{"", null, "*", "br", "*;q=0.0", null, "br", "br", "compress, br;q=0.5", "br", "br; q=0.5, identity", "br", "br; q=0, deflate", "br"};
        for (int i = 0; i < tests.length; i += 2) {
            String acceptEncoding = tests[i];
            String contentEncoding = tests[i + 1];
            String targetEncoding = compressor.determineEncoding(acceptEncoding);
            Assertions.assertEquals((Object)contentEncoding, (Object)targetEncoding);
        }
    }

    @Test
    void testGetZstdTargetContentEncoding() {
        HttpContentCompressor compressor = new HttpContentCompressor(new CompressionOptions[]{StandardCompressionOptions.gzip(), StandardCompressionOptions.deflate(), StandardCompressionOptions.brotli(), StandardCompressionOptions.zstd()});
        String[] tests = new String[]{"", null, "*;q=0.0", null, "zstd", "zstd", "compress, zstd;q=0.5", "zstd", "zstd; q=0.5, identity", "zstd", "zstd; q=0, deflate", "zstd"};
        for (int i = 0; i < tests.length; i += 2) {
            String acceptEncoding = tests[i];
            String contentEncoding = tests[i + 1];
            String targetEncoding = compressor.determineEncoding(acceptEncoding);
            Assertions.assertEquals((Object)contentEncoding, (Object)targetEncoding);
        }
    }

    @Test
    void testAcceptEncodingHttpRequest() {
        EmbeddedChannel ch = new EmbeddedChannel(new ChannelHandler[]{new HttpContentCompressor(null)});
        ch.writeInbound(new Object[]{HttpContentCompressorOptionsTest.newRequest()});
        FullHttpRequest fullHttpRequest = (FullHttpRequest)ch.readInbound();
        fullHttpRequest.release();
        DefaultHttpResponse res = new DefaultHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK);
        res.headers().set((CharSequence)HttpHeaderNames.TRANSFER_ENCODING, (Object)HttpHeaderValues.CHUNKED);
        ch.writeOutbound(new Object[]{res});
        HttpContentCompressorOptionsTest.assertEncodedResponse(ch);
        Assertions.assertTrue((boolean)ch.close().isSuccess());
    }

    private static void assertEncodedResponse(EmbeddedChannel ch) {
        Object o = ch.readOutbound();
        MatcherAssert.assertThat((Object)o, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(HttpResponse.class)));
        HttpContentCompressorOptionsTest.assertEncodedResponse((HttpResponse)o);
    }

    private static void assertEncodedResponse(HttpResponse res) {
        MatcherAssert.assertThat((Object)res, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.not((Matcher)CoreMatchers.instanceOf(HttpContent.class))));
        MatcherAssert.assertThat((Object)res.headers().get((CharSequence)HttpHeaderNames.TRANSFER_ENCODING), (Matcher)CoreMatchers.is((Object)"chunked"));
        MatcherAssert.assertThat((Object)res.headers().get((CharSequence)HttpHeaderNames.CONTENT_LENGTH), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
        MatcherAssert.assertThat((Object)res.headers().get((CharSequence)HttpHeaderNames.CONTENT_ENCODING), (Matcher)CoreMatchers.is((Object)"br"));
    }

    private static FullHttpRequest newRequest() {
        DefaultFullHttpRequest req = new DefaultFullHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.GET, "/");
        req.headers().set((CharSequence)HttpHeaderNames.ACCEPT_ENCODING, (Object)"br, zstd, gzip, deflate");
        return req;
    }
}

