/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http;

import io.netty.channel.ChannelHandler;
import io.netty.channel.embedded.EmbeddedChannel;
import io.netty.handler.codec.http.DefaultFullHttpRequest;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpServerKeepAliveHandler;
import io.netty.handler.codec.http.HttpUtil;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.util.AsciiString;
import io.netty.util.ReferenceCountUtil;
import java.util.Arrays;
import java.util.Collection;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;

public class HttpServerKeepAliveHandlerTest {
    private static final String REQUEST_KEEP_ALIVE = "REQUEST_KEEP_ALIVE";
    private static final int NOT_SELF_DEFINED_MSG_LENGTH = 0;
    private static final int SET_RESPONSE_LENGTH = 1;
    private static final int SET_MULTIPART = 2;
    private static final int SET_CHUNKED = 4;
    private EmbeddedChannel channel;

    @BeforeEach
    public void setUp() {
        this.channel = new EmbeddedChannel(new ChannelHandler[]{new HttpServerKeepAliveHandler()});
    }

    static Collection<Object[]> keepAliveProvider() {
        return Arrays.asList({true, HttpVersion.HTTP_1_0, HttpResponseStatus.OK, REQUEST_KEEP_ALIVE, 1, HttpHeaderValues.KEEP_ALIVE}, {true, HttpVersion.HTTP_1_0, HttpResponseStatus.OK, REQUEST_KEEP_ALIVE, 2, HttpHeaderValues.KEEP_ALIVE}, {false, HttpVersion.HTTP_1_0, HttpResponseStatus.OK, null, 1, null}, {true, HttpVersion.HTTP_1_1, HttpResponseStatus.OK, REQUEST_KEEP_ALIVE, 1, null}, {false, HttpVersion.HTTP_1_1, HttpResponseStatus.OK, REQUEST_KEEP_ALIVE, 1, HttpHeaderValues.CLOSE}, {true, HttpVersion.HTTP_1_1, HttpResponseStatus.OK, REQUEST_KEEP_ALIVE, 2, null}, {true, HttpVersion.HTTP_1_1, HttpResponseStatus.OK, REQUEST_KEEP_ALIVE, 4, null}, {false, HttpVersion.HTTP_1_1, HttpResponseStatus.OK, null, 1, null}, {false, HttpVersion.HTTP_1_0, HttpResponseStatus.OK, REQUEST_KEEP_ALIVE, 0, null}, {false, HttpVersion.HTTP_1_0, HttpResponseStatus.OK, null, 0, null}, {false, HttpVersion.HTTP_1_1, HttpResponseStatus.OK, REQUEST_KEEP_ALIVE, 0, null}, {false, HttpVersion.HTTP_1_1, HttpResponseStatus.OK, null, 0, null}, {false, HttpVersion.HTTP_1_0, HttpResponseStatus.OK, REQUEST_KEEP_ALIVE, 1, null}, {true, HttpVersion.HTTP_1_1, HttpResponseStatus.NO_CONTENT, REQUEST_KEEP_ALIVE, 0, null}, {false, HttpVersion.HTTP_1_0, HttpResponseStatus.NO_CONTENT, null, 0, null});
    }

    @ParameterizedTest
    @MethodSource(value={"keepAliveProvider"})
    public void test_KeepAlive(boolean isKeepAliveResponseExpected, HttpVersion httpVersion, HttpResponseStatus responseStatus, String sendKeepAlive, int setSelfDefinedMessageLength, AsciiString setResponseConnection) throws Exception {
        DefaultFullHttpRequest request = new DefaultFullHttpRequest(httpVersion, HttpMethod.GET, "/v1/foo/bar");
        HttpUtil.setKeepAlive((HttpMessage)request, (boolean)REQUEST_KEEP_ALIVE.equals(sendKeepAlive));
        DefaultFullHttpResponse response = new DefaultFullHttpResponse(httpVersion, responseStatus);
        if (setResponseConnection != null) {
            response.headers().set((CharSequence)HttpHeaderNames.CONNECTION, (Object)setResponseConnection);
        }
        HttpServerKeepAliveHandlerTest.setupMessageLength((HttpResponse)response, setSelfDefinedMessageLength);
        Assertions.assertTrue((boolean)this.channel.writeInbound(new Object[]{request}));
        Object requestForwarded = this.channel.readInbound();
        Assertions.assertEquals((Object)request, (Object)requestForwarded);
        ReferenceCountUtil.release((Object)requestForwarded);
        this.channel.writeAndFlush((Object)response);
        HttpResponse writtenResponse = (HttpResponse)this.channel.readOutbound();
        Assertions.assertEquals((Object)isKeepAliveResponseExpected, (Object)this.channel.isOpen(), (String)"channel.isOpen");
        Assertions.assertEquals((Object)isKeepAliveResponseExpected, (Object)HttpUtil.isKeepAlive((HttpMessage)writtenResponse), (String)"response keep-alive");
        ReferenceCountUtil.release((Object)writtenResponse);
        Assertions.assertFalse((boolean)this.channel.finishAndReleaseAll());
    }

    static Collection<Object[]> connectionCloseProvider() {
        return Arrays.asList({HttpVersion.HTTP_1_0, HttpResponseStatus.OK, 1}, {HttpVersion.HTTP_1_0, HttpResponseStatus.OK, 2}, {HttpVersion.HTTP_1_0, HttpResponseStatus.OK, 0}, {HttpVersion.HTTP_1_0, HttpResponseStatus.NO_CONTENT, 0}, {HttpVersion.HTTP_1_1, HttpResponseStatus.OK, 1}, {HttpVersion.HTTP_1_1, HttpResponseStatus.OK, 2}, {HttpVersion.HTTP_1_1, HttpResponseStatus.OK, 0}, {HttpVersion.HTTP_1_1, HttpResponseStatus.OK, 4}, {HttpVersion.HTTP_1_1, HttpResponseStatus.NO_CONTENT, 0});
    }

    @ParameterizedTest
    @MethodSource(value={"connectionCloseProvider"})
    public void testConnectionCloseHeaderHandledCorrectly(HttpVersion httpVersion, HttpResponseStatus responseStatus, int setSelfDefinedMessageLength) {
        DefaultFullHttpResponse response = new DefaultFullHttpResponse(httpVersion, responseStatus);
        response.headers().set((CharSequence)HttpHeaderNames.CONNECTION, (Object)HttpHeaderValues.CLOSE);
        HttpServerKeepAliveHandlerTest.setupMessageLength((HttpResponse)response, setSelfDefinedMessageLength);
        this.channel.writeAndFlush((Object)response);
        HttpResponse writtenResponse = (HttpResponse)this.channel.readOutbound();
        Assertions.assertFalse((boolean)this.channel.isOpen());
        ReferenceCountUtil.release((Object)writtenResponse);
        Assertions.assertFalse((boolean)this.channel.finishAndReleaseAll());
    }

    @ParameterizedTest
    @MethodSource(value={"connectionCloseProvider"})
    public void testConnectionCloseHeaderHandledCorrectlyForVoidPromise(HttpVersion httpVersion, HttpResponseStatus responseStatus, int setSelfDefinedMessageLength) {
        DefaultFullHttpResponse response = new DefaultFullHttpResponse(httpVersion, responseStatus);
        response.headers().set((CharSequence)HttpHeaderNames.CONNECTION, (Object)HttpHeaderValues.CLOSE);
        HttpServerKeepAliveHandlerTest.setupMessageLength((HttpResponse)response, setSelfDefinedMessageLength);
        this.channel.writeAndFlush((Object)response, this.channel.voidPromise());
        HttpResponse writtenResponse = (HttpResponse)this.channel.readOutbound();
        Assertions.assertFalse((boolean)this.channel.isOpen());
        ReferenceCountUtil.release((Object)writtenResponse);
        Assertions.assertFalse((boolean)this.channel.finishAndReleaseAll());
    }

    @ParameterizedTest
    @MethodSource(value={"keepAliveProvider"})
    public void testPipelineKeepAlive(boolean isKeepAliveResponseExpected, HttpVersion httpVersion, HttpResponseStatus responseStatus, String sendKeepAlive, int setSelfDefinedMessageLength, AsciiString setResponseConnection) {
        DefaultFullHttpRequest firstRequest = new DefaultFullHttpRequest(httpVersion, HttpMethod.GET, "/v1/foo/bar");
        HttpUtil.setKeepAlive((HttpMessage)firstRequest, (boolean)true);
        DefaultFullHttpRequest secondRequest = new DefaultFullHttpRequest(httpVersion, HttpMethod.GET, "/v1/foo/bar");
        HttpUtil.setKeepAlive((HttpMessage)secondRequest, (boolean)REQUEST_KEEP_ALIVE.equals(sendKeepAlive));
        DefaultFullHttpRequest finalRequest = new DefaultFullHttpRequest(httpVersion, HttpMethod.GET, "/v1/foo/bar");
        HttpUtil.setKeepAlive((HttpMessage)finalRequest, (boolean)false);
        DefaultFullHttpResponse response = new DefaultFullHttpResponse(httpVersion, responseStatus);
        DefaultFullHttpResponse informationalResp = new DefaultFullHttpResponse(httpVersion, HttpResponseStatus.PROCESSING);
        HttpUtil.setKeepAlive((HttpMessage)response, (boolean)true);
        HttpUtil.setContentLength((HttpMessage)response, (long)0L);
        HttpUtil.setKeepAlive((HttpMessage)informationalResp, (boolean)true);
        Assertions.assertTrue((boolean)this.channel.writeInbound(new Object[]{firstRequest, secondRequest, finalRequest}));
        Object requestForwarded = this.channel.readInbound();
        Assertions.assertEquals((Object)firstRequest, (Object)requestForwarded);
        ReferenceCountUtil.release((Object)requestForwarded);
        this.channel.writeAndFlush((Object)response.retainedDuplicate());
        HttpResponse firstResponse = (HttpResponse)this.channel.readOutbound();
        Assertions.assertTrue((boolean)this.channel.isOpen(), (String)"channel.isOpen");
        Assertions.assertTrue((boolean)HttpUtil.isKeepAlive((HttpMessage)firstResponse), (String)"response keep-alive");
        ReferenceCountUtil.release((Object)firstResponse);
        requestForwarded = this.channel.readInbound();
        Assertions.assertEquals((Object)secondRequest, (Object)requestForwarded);
        ReferenceCountUtil.release((Object)requestForwarded);
        this.channel.writeAndFlush((Object)informationalResp);
        HttpResponse writtenInfoResp = (HttpResponse)this.channel.readOutbound();
        Assertions.assertTrue((boolean)this.channel.isOpen(), (String)"channel.isOpen");
        Assertions.assertTrue((boolean)HttpUtil.isKeepAlive((HttpMessage)writtenInfoResp), (String)"response keep-alive");
        ReferenceCountUtil.release((Object)writtenInfoResp);
        if (setResponseConnection != null) {
            response.headers().set((CharSequence)HttpHeaderNames.CONNECTION, (Object)setResponseConnection);
        } else {
            response.headers().remove((CharSequence)HttpHeaderNames.CONNECTION);
        }
        HttpServerKeepAliveHandlerTest.setupMessageLength((HttpResponse)response, setSelfDefinedMessageLength);
        this.channel.writeAndFlush((Object)response.retainedDuplicate());
        HttpResponse secondResponse = (HttpResponse)this.channel.readOutbound();
        Assertions.assertEquals((Object)isKeepAliveResponseExpected, (Object)this.channel.isOpen(), (String)"channel.isOpen");
        Assertions.assertEquals((Object)isKeepAliveResponseExpected, (Object)HttpUtil.isKeepAlive((HttpMessage)secondResponse), (String)"response keep-alive");
        ReferenceCountUtil.release((Object)secondResponse);
        requestForwarded = this.channel.readInbound();
        Assertions.assertEquals((Object)finalRequest, (Object)requestForwarded);
        ReferenceCountUtil.release((Object)requestForwarded);
        if (isKeepAliveResponseExpected) {
            this.channel.writeAndFlush((Object)response);
            HttpResponse finalResponse = (HttpResponse)this.channel.readOutbound();
            Assertions.assertFalse((boolean)this.channel.isOpen(), (String)"channel.isOpen");
            Assertions.assertFalse((boolean)HttpUtil.isKeepAlive((HttpMessage)finalResponse), (String)"response keep-alive");
        }
        ReferenceCountUtil.release((Object)response);
        Assertions.assertFalse((boolean)this.channel.finishAndReleaseAll());
    }

    private static void setupMessageLength(HttpResponse response, int setSelfDefinedMessageLength) {
        switch (setSelfDefinedMessageLength) {
            case 0: {
                if (!HttpUtil.isContentLengthSet((HttpMessage)response)) break;
                response.headers().remove((CharSequence)HttpHeaderNames.CONTENT_LENGTH);
                break;
            }
            case 1: {
                HttpUtil.setContentLength((HttpMessage)response, (long)0L);
                break;
            }
            case 4: {
                HttpUtil.setTransferEncodingChunked((HttpMessage)response, (boolean)true);
                break;
            }
            case 2: {
                response.headers().set((CharSequence)HttpHeaderNames.CONTENT_TYPE, (Object)HttpHeaderValues.MULTIPART_MIXED.toUpperCase());
                break;
            }
            default: {
                throw new IllegalArgumentException("selfDefinedMessageLength: " + setSelfDefinedMessageLength);
            }
        }
    }
}

