/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http.websocketx;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandler;
import io.netty.channel.embedded.EmbeddedChannel;
import io.netty.handler.codec.http.websocketx.BinaryWebSocketFrame;
import io.netty.handler.codec.http.websocketx.CloseWebSocketFrame;
import io.netty.handler.codec.http.websocketx.CorruptedWebSocketFrameException;
import io.netty.handler.codec.http.websocketx.TextWebSocketFrame;
import io.netty.handler.codec.http.websocketx.WebSocket08FrameDecoder;
import io.netty.handler.codec.http.websocketx.WebSocket08FrameEncoder;
import io.netty.handler.codec.http.websocketx.WebSocketCloseStatus;
import io.netty.handler.codec.http.websocketx.WebSocketDecoderConfig;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class WebSocket08EncoderDecoderTest {
    private ByteBuf binTestData;
    private String strTestData;
    private static final int MAX_TESTDATA_LENGTH = 102400;

    private void initTestData() {
        this.binTestData = Unpooled.buffer((int)102400);
        byte j = 0;
        for (int i = 0; i < 102400; ++i) {
            this.binTestData.array()[i] = j;
            j = (byte)(j + 1);
        }
        StringBuilder s = new StringBuilder();
        int c = 65;
        for (int i = 0; i < 102400; ++i) {
            s.append((char)c);
            c = (char)(c + '\u0001');
            if (c != 90) continue;
            c = 65;
        }
        this.strTestData = s.toString();
    }

    @Test
    public void testWebSocketProtocolViolation() {
        this.initTestData();
        int maxPayloadLength = 255;
        String errorMessage = "Max frame length of " + maxPayloadLength + " has been exceeded.";
        WebSocketCloseStatus expectedStatus = WebSocketCloseStatus.MESSAGE_TOO_BIG;
        WebSocketDecoderConfig config = WebSocketDecoderConfig.newBuilder().maxFramePayloadLength(maxPayloadLength).closeOnProtocolViolation(true).build();
        EmbeddedChannel inChannel = new EmbeddedChannel(new ChannelHandler[]{new WebSocket08FrameDecoder(config)});
        EmbeddedChannel outChannel = new EmbeddedChannel(new ChannelHandler[]{new WebSocket08FrameEncoder(true)});
        this.executeProtocolViolationTest(outChannel, inChannel, maxPayloadLength + 1, expectedStatus, errorMessage);
        CloseWebSocketFrame response = (CloseWebSocketFrame)inChannel.readOutbound();
        Assertions.assertNotNull((Object)response);
        Assertions.assertEquals((int)expectedStatus.code(), (int)response.statusCode());
        Assertions.assertEquals((Object)errorMessage, (Object)response.reasonText());
        response.release();
        Assertions.assertFalse((boolean)inChannel.finish());
        Assertions.assertFalse((boolean)outChannel.finish());
        config = WebSocketDecoderConfig.newBuilder().maxFramePayloadLength(maxPayloadLength).closeOnProtocolViolation(false).build();
        inChannel = new EmbeddedChannel(new ChannelHandler[]{new WebSocket08FrameDecoder(config)});
        outChannel = new EmbeddedChannel(new ChannelHandler[]{new WebSocket08FrameEncoder(true)});
        this.executeProtocolViolationTest(outChannel, inChannel, maxPayloadLength + 1, expectedStatus, errorMessage);
        response = (CloseWebSocketFrame)inChannel.readOutbound();
        Assertions.assertNull((Object)response);
        Assertions.assertFalse((boolean)inChannel.finish());
        Assertions.assertFalse((boolean)outChannel.finish());
        this.binTestData.release();
    }

    private void executeProtocolViolationTest(EmbeddedChannel outChannel, EmbeddedChannel inChannel, int testDataLength, WebSocketCloseStatus expectedStatus, String errorMessage) {
        CorruptedWebSocketFrameException corrupted = null;
        try {
            this.testBinaryWithLen(outChannel, inChannel, testDataLength);
        }
        catch (CorruptedWebSocketFrameException e) {
            corrupted = e;
        }
        BinaryWebSocketFrame exceedingFrame = (BinaryWebSocketFrame)inChannel.readInbound();
        Assertions.assertNull((Object)exceedingFrame);
        Assertions.assertNotNull((Object)((Object)corrupted));
        Assertions.assertEquals((Object)expectedStatus, (Object)corrupted.closeStatus());
        Assertions.assertEquals((Object)errorMessage, (Object)corrupted.getMessage());
    }

    @Test
    public void testWebSocketEncodingAndDecoding() {
        this.initTestData();
        EmbeddedChannel outChannel = new EmbeddedChannel(new ChannelHandler[]{new WebSocket08FrameEncoder(false)});
        EmbeddedChannel inChannel = new EmbeddedChannel(new ChannelHandler[]{new WebSocket08FrameDecoder(false, false, 0x100000, false)});
        this.executeTests(outChannel, inChannel);
        outChannel = new EmbeddedChannel(new ChannelHandler[]{new WebSocket08FrameEncoder(true)});
        inChannel = new EmbeddedChannel(new ChannelHandler[]{new WebSocket08FrameDecoder(true, false, 0x100000, false)});
        this.executeTests(outChannel, inChannel);
        outChannel = new EmbeddedChannel(new ChannelHandler[]{new WebSocket08FrameEncoder(true)});
        inChannel = new EmbeddedChannel(new ChannelHandler[]{new WebSocket08FrameDecoder(false, false, 0x100000, true)});
        this.executeTests(outChannel, inChannel);
        this.binTestData.release();
    }

    private void executeTests(EmbeddedChannel outChannel, EmbeddedChannel inChannel) {
        this.executeTests(outChannel, inChannel, 0);
        this.executeTests(outChannel, inChannel, 1);
        this.executeTests(outChannel, inChannel, 2);
        this.executeTests(outChannel, inChannel, 3);
        this.executeTests(outChannel, inChannel, 4);
        this.executeTests(outChannel, inChannel, 5);
        this.executeTests(outChannel, inChannel, 125);
        this.executeTests(outChannel, inChannel, 126);
        this.executeTests(outChannel, inChannel, 127);
        this.executeTests(outChannel, inChannel, 128);
        this.executeTests(outChannel, inChannel, 129);
        this.executeTests(outChannel, inChannel, 65535);
        this.executeTests(outChannel, inChannel, 65536);
        this.executeTests(outChannel, inChannel, 65537);
        this.executeTests(outChannel, inChannel, 65538);
        this.executeTests(outChannel, inChannel, 65539);
    }

    private void executeTests(EmbeddedChannel outChannel, EmbeddedChannel inChannel, int testDataLength) {
        this.testTextWithLen(outChannel, inChannel, testDataLength);
        this.testBinaryWithLen(outChannel, inChannel, testDataLength);
    }

    private void testTextWithLen(EmbeddedChannel outChannel, EmbeddedChannel inChannel, int testDataLength) {
        String testStr = this.strTestData.substring(0, testDataLength);
        outChannel.writeOutbound(new Object[]{new TextWebSocketFrame(testStr)});
        this.transfer(outChannel, inChannel);
        Object decoded = inChannel.readInbound();
        Assertions.assertNotNull((Object)decoded);
        Assertions.assertTrue((boolean)(decoded instanceof TextWebSocketFrame));
        TextWebSocketFrame txt = (TextWebSocketFrame)decoded;
        Assertions.assertEquals((Object)txt.text(), (Object)testStr);
        txt.release();
    }

    private void testBinaryWithLen(EmbeddedChannel outChannel, EmbeddedChannel inChannel, int testDataLength) {
        this.binTestData.retain();
        this.binTestData.setIndex(0, testDataLength);
        outChannel.writeOutbound(new Object[]{new BinaryWebSocketFrame(this.binTestData)});
        this.transfer(outChannel, inChannel);
        Object decoded = inChannel.readInbound();
        Assertions.assertNotNull((Object)decoded);
        Assertions.assertTrue((boolean)(decoded instanceof BinaryWebSocketFrame));
        BinaryWebSocketFrame binFrame = (BinaryWebSocketFrame)decoded;
        int readable = binFrame.content().readableBytes();
        Assertions.assertEquals((int)readable, (int)testDataLength);
        for (int i = 0; i < testDataLength; ++i) {
            Assertions.assertEquals((byte)this.binTestData.getByte(i), (byte)binFrame.content().getByte(i));
        }
        binFrame.release();
    }

    private void transfer(EmbeddedChannel outChannel, EmbeddedChannel inChannel) {
        ByteBuf encoded;
        while ((encoded = (ByteBuf)outChannel.readOutbound()) != null) {
            inChannel.writeInbound(new Object[]{encoded});
        }
        return;
    }
}

