/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http.websocketx;

import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.embedded.EmbeddedChannel;
import io.netty.handler.codec.http.DefaultFullHttpRequest;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpObjectAggregator;
import io.netty.handler.codec.http.HttpRequestDecoder;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.HttpResponseDecoder;
import io.netty.handler.codec.http.HttpResponseEncoder;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.LastHttpContent;
import io.netty.handler.codec.http.websocketx.WebSocketDecoderConfig;
import io.netty.handler.codec.http.websocketx.WebSocketHandshakeException;
import io.netty.handler.codec.http.websocketx.WebSocketServerHandshaker;
import io.netty.handler.codec.http.websocketx.WebSocketServerHandshaker00;
import io.netty.handler.codec.http.websocketx.WebSocketServerHandshakerTest;
import io.netty.handler.codec.http.websocketx.WebSocketVersion;
import io.netty.util.CharsetUtil;
import java.nio.charset.Charset;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class WebSocketServerHandshaker00Test
extends WebSocketServerHandshakerTest {
    @Override
    protected WebSocketServerHandshaker newHandshaker(String webSocketURL, String subprotocols, WebSocketDecoderConfig decoderConfig) {
        return new WebSocketServerHandshaker00(webSocketURL, subprotocols, decoderConfig);
    }

    @Override
    protected WebSocketVersion webSocketVersion() {
        return WebSocketVersion.V00;
    }

    @Test
    public void testPerformOpeningHandshake() {
        WebSocketServerHandshaker00Test.testPerformOpeningHandshake0(true);
    }

    @Test
    public void testPerformOpeningHandshakeSubProtocolNotSupported() {
        WebSocketServerHandshaker00Test.testPerformOpeningHandshake0(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testPerformHandshakeWithoutOriginHeader() {
        EmbeddedChannel ch = new EmbeddedChannel(new ChannelHandler[]{new HttpObjectAggregator(42), new HttpRequestDecoder(), new HttpResponseEncoder()});
        DefaultFullHttpRequest req = new DefaultFullHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.GET, "/chat", Unpooled.copiedBuffer((CharSequence)"^n:ds[4U", (Charset)CharsetUtil.US_ASCII));
        req.headers().set((CharSequence)HttpHeaderNames.HOST, (Object)"server.example.com");
        req.headers().set((CharSequence)HttpHeaderNames.UPGRADE, (Object)HttpHeaderValues.WEBSOCKET);
        req.headers().set((CharSequence)HttpHeaderNames.CONNECTION, (Object)"Upgrade");
        req.headers().set((CharSequence)HttpHeaderNames.SEC_WEBSOCKET_KEY1, (Object)"4 @1  46546xW%0l 1 5");
        req.headers().set((CharSequence)HttpHeaderNames.SEC_WEBSOCKET_PROTOCOL, (Object)"chat, superchat");
        WebSocketServerHandshaker00 handshaker00 = new WebSocketServerHandshaker00("ws://example.com/chat", "chat", Integer.MAX_VALUE);
        try {
            handshaker00.handshake((Channel)ch, (FullHttpRequest)req);
            Assertions.fail((String)"Expecting WebSocketHandshakeException");
        }
        catch (WebSocketHandshakeException e) {
            Assertions.assertEquals((Object)"Missing origin header, got only [host, upgrade, connection, sec-websocket-key1, sec-websocket-protocol]", (Object)e.getMessage());
        }
        finally {
            req.release();
        }
    }

    private static void testPerformOpeningHandshake0(boolean subProtocol) {
        EmbeddedChannel ch = new EmbeddedChannel(new ChannelHandler[]{new HttpObjectAggregator(42), new HttpRequestDecoder(), new HttpResponseEncoder()});
        DefaultFullHttpRequest req = new DefaultFullHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.GET, "/chat", Unpooled.copiedBuffer((CharSequence)"^n:ds[4U", (Charset)CharsetUtil.US_ASCII));
        req.headers().set((CharSequence)HttpHeaderNames.HOST, (Object)"server.example.com");
        req.headers().set((CharSequence)HttpHeaderNames.UPGRADE, (Object)HttpHeaderValues.WEBSOCKET);
        req.headers().set((CharSequence)HttpHeaderNames.CONNECTION, (Object)"Upgrade");
        req.headers().set((CharSequence)HttpHeaderNames.ORIGIN, (Object)"http://example.com");
        req.headers().set((CharSequence)HttpHeaderNames.SEC_WEBSOCKET_KEY1, (Object)"4 @1  46546xW%0l 1 5");
        req.headers().set((CharSequence)HttpHeaderNames.SEC_WEBSOCKET_KEY2, (Object)"12998 5 Y3 1  .P00");
        req.headers().set((CharSequence)HttpHeaderNames.SEC_WEBSOCKET_PROTOCOL, (Object)"chat, superchat");
        if (subProtocol) {
            new WebSocketServerHandshaker00("ws://example.com/chat", "chat", Integer.MAX_VALUE).handshake((Channel)ch, (FullHttpRequest)req);
        } else {
            new WebSocketServerHandshaker00("ws://example.com/chat", null, Integer.MAX_VALUE).handshake((Channel)ch, (FullHttpRequest)req);
        }
        EmbeddedChannel ch2 = new EmbeddedChannel(new ChannelHandler[]{new HttpResponseDecoder()});
        ch2.writeInbound(new Object[]{ch.readOutbound()});
        HttpResponse res = (HttpResponse)ch2.readInbound();
        Assertions.assertEquals((Object)"ws://example.com/chat", (Object)res.headers().get((CharSequence)HttpHeaderNames.SEC_WEBSOCKET_LOCATION));
        if (subProtocol) {
            Assertions.assertEquals((Object)"chat", (Object)res.headers().get((CharSequence)HttpHeaderNames.SEC_WEBSOCKET_PROTOCOL));
        } else {
            Assertions.assertNull((Object)res.headers().get((CharSequence)HttpHeaderNames.SEC_WEBSOCKET_PROTOCOL));
        }
        LastHttpContent content = (LastHttpContent)ch2.readInbound();
        Assertions.assertEquals((Object)"8jKS'y:G*Co,Wxa-", (Object)content.content().toString(CharsetUtil.US_ASCII));
        content.release();
        req.release();
    }
}

