/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http;

import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandler;
import io.netty.channel.embedded.EmbeddedChannel;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpRequestDecoder;
import io.netty.handler.codec.http.LastHttpContent;
import io.netty.util.CharsetUtil;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.hamcrest.core.IsInstanceOf;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;

public class MultipleContentLengthHeadersTest {
    static Collection<Object[]> parameters() {
        return Arrays.asList({false, false, false}, {false, false, true}, {false, true, false}, {false, true, true}, {true, false, false}, {true, false, true}, {true, true, false}, {true, true, true});
    }

    private static EmbeddedChannel newChannel(boolean allowDuplicateContentLengths) {
        HttpRequestDecoder decoder = new HttpRequestDecoder(4096, 8192, 8192, true, 128, allowDuplicateContentLengths);
        return new EmbeddedChannel(new ChannelHandler[]{decoder});
    }

    @ParameterizedTest
    @MethodSource(value={"parameters"})
    public void testMultipleContentLengthHeadersBehavior(boolean allowDuplicateContentLengths, boolean sameValue, boolean singleField) {
        EmbeddedChannel channel = MultipleContentLengthHeadersTest.newChannel(allowDuplicateContentLengths);
        String requestStr = MultipleContentLengthHeadersTest.setupRequestString(sameValue, singleField);
        MatcherAssert.assertThat((Object)channel.writeInbound(new Object[]{Unpooled.copiedBuffer((CharSequence)requestStr, (Charset)CharsetUtil.US_ASCII)}), (Matcher)Matchers.is((Object)true));
        HttpRequest request = (HttpRequest)channel.readInbound();
        if (allowDuplicateContentLengths) {
            if (sameValue) {
                MultipleContentLengthHeadersTest.assertValid(request);
                List contentLengths = request.headers().getAll((CharSequence)HttpHeaderNames.CONTENT_LENGTH);
                MatcherAssert.assertThat((Object)contentLengths, (Matcher)Matchers.contains((Object[])new String[]{"1"}));
                LastHttpContent body = (LastHttpContent)channel.readInbound();
                MatcherAssert.assertThat((Object)body.content().readableBytes(), (Matcher)Matchers.is((Object)1));
                MatcherAssert.assertThat((Object)body.content().readCharSequence(1, CharsetUtil.US_ASCII).toString(), (Matcher)Matchers.is((Object)"a"));
            } else {
                MultipleContentLengthHeadersTest.assertInvalid(request);
            }
        } else {
            MultipleContentLengthHeadersTest.assertInvalid(request);
        }
        MatcherAssert.assertThat((Object)channel.finish(), (Matcher)Matchers.is((Object)false));
    }

    private static String setupRequestString(boolean sameValue, boolean singleField) {
        String firstValue = "1";
        String secondValue = sameValue ? firstValue : "2";
        String contentLength = singleField ? "Content-Length: " + firstValue + ", " + secondValue + "\r\n\r\n" : "Content-Length: " + firstValue + "\r\nContent-Length: " + secondValue + "\r\n\r\n";
        return "PUT /some/path HTTP/1.1\r\n" + contentLength + "ab";
    }

    @Test
    public void testDanglingComma() {
        EmbeddedChannel channel = MultipleContentLengthHeadersTest.newChannel(false);
        String requestStr = "GET /some/path HTTP/1.1\r\nContent-Length: 1,\r\nConnection: close\n\nab";
        MatcherAssert.assertThat((Object)channel.writeInbound(new Object[]{Unpooled.copiedBuffer((CharSequence)requestStr, (Charset)CharsetUtil.US_ASCII)}), (Matcher)Matchers.is((Object)true));
        HttpRequest request = (HttpRequest)channel.readInbound();
        MultipleContentLengthHeadersTest.assertInvalid(request);
        MatcherAssert.assertThat((Object)channel.finish(), (Matcher)Matchers.is((Object)false));
    }

    private static void assertValid(HttpRequest request) {
        MatcherAssert.assertThat((Object)request.decoderResult().isFailure(), (Matcher)Matchers.is((Object)false));
    }

    private static void assertInvalid(HttpRequest request) {
        MatcherAssert.assertThat((Object)request.decoderResult().isFailure(), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)request.decoderResult().cause(), (Matcher)IsInstanceOf.instanceOf(IllegalArgumentException.class));
        MatcherAssert.assertThat((Object)request.decoderResult().cause().getMessage(), (Matcher)Matchers.containsString((String)"Multiple Content-Length values found"));
    }
}

