/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http.multipart;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.handler.codec.http.DefaultHttpRequest;
import io.netty.handler.codec.http.DefaultLastHttpContent;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.multipart.DefaultHttpDataFactory;
import io.netty.handler.codec.http.multipart.HttpDataFactory;
import io.netty.handler.codec.http.multipart.HttpPostStandardRequestDecoder;
import io.netty.handler.codec.http.multipart.InterfaceHttpData;
import io.netty.handler.codec.http.multipart.MemoryAttribute;
import io.netty.util.CharsetUtil;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class HttpPostStandardRequestDecoderTest {
    HttpPostStandardRequestDecoderTest() {
    }

    @Test
    void testDecodeAttributes() {
        String requestBody = "key1=value1&key2=value2";
        DefaultHttpRequest request = new DefaultHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.POST, "/upload");
        HttpPostStandardRequestDecoder decoder = new HttpPostStandardRequestDecoder((HttpDataFactory)HttpPostStandardRequestDecoderTest.httpDiskDataFactory(), (HttpRequest)request);
        ByteBuf buf = Unpooled.wrappedBuffer((byte[])requestBody.getBytes(CharsetUtil.UTF_8));
        DefaultLastHttpContent httpContent = new DefaultLastHttpContent(buf);
        decoder.offer((HttpContent)httpContent);
        Assertions.assertEquals((int)2, (int)decoder.getBodyHttpDatas().size());
        HttpPostStandardRequestDecoderTest.assertMemoryAttribute(decoder.getBodyHttpData("key1"), "value1");
        HttpPostStandardRequestDecoderTest.assertMemoryAttribute(decoder.getBodyHttpData("key2"), "value2");
        decoder.destroy();
    }

    @Test
    void testDecodeAttributesWithAmpersandPrefixSkipsNullAttribute() {
        String requestBody = "&key1=value1";
        DefaultHttpRequest request = new DefaultHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.POST, "/upload");
        HttpPostStandardRequestDecoder decoder = new HttpPostStandardRequestDecoder((HttpDataFactory)HttpPostStandardRequestDecoderTest.httpDiskDataFactory(), (HttpRequest)request);
        ByteBuf buf = Unpooled.wrappedBuffer((byte[])requestBody.getBytes(CharsetUtil.UTF_8));
        DefaultLastHttpContent httpContent = new DefaultLastHttpContent(buf);
        decoder.offer((HttpContent)httpContent);
        Assertions.assertEquals((int)1, (int)decoder.getBodyHttpDatas().size());
        HttpPostStandardRequestDecoderTest.assertMemoryAttribute(decoder.getBodyHttpData("key1"), "value1");
        decoder.destroy();
    }

    @Test
    void testDecodeZeroAttributesWithAmpersandPrefix() {
        String requestBody = "&";
        DefaultHttpRequest request = new DefaultHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.POST, "/upload");
        HttpPostStandardRequestDecoder decoder = new HttpPostStandardRequestDecoder((HttpDataFactory)HttpPostStandardRequestDecoderTest.httpDiskDataFactory(), (HttpRequest)request);
        ByteBuf buf = Unpooled.wrappedBuffer((byte[])requestBody.getBytes(CharsetUtil.UTF_8));
        DefaultLastHttpContent httpContent = new DefaultLastHttpContent(buf);
        decoder.offer((HttpContent)httpContent);
        Assertions.assertEquals((int)0, (int)decoder.getBodyHttpDatas().size());
        decoder.destroy();
    }

    private static DefaultHttpDataFactory httpDiskDataFactory() {
        return new DefaultHttpDataFactory(false);
    }

    private static void assertMemoryAttribute(InterfaceHttpData data, String expectedValue) {
        Assertions.assertEquals((Object)InterfaceHttpData.HttpDataType.Attribute, (Object)data.getHttpDataType());
        Assertions.assertEquals((Object)((MemoryAttribute)data).getValue(), (Object)expectedValue);
    }
}

