/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http.websocketx.extensions;

import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelPromise;
import io.netty.channel.embedded.EmbeddedChannel;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.LastHttpContent;
import io.netty.handler.codec.http.websocketx.extensions.WebSocketExtensionData;
import io.netty.handler.codec.http.websocketx.extensions.WebSocketExtensionTestUtil;
import io.netty.handler.codec.http.websocketx.extensions.WebSocketExtensionUtil;
import io.netty.handler.codec.http.websocketx.extensions.WebSocketServerExtension;
import io.netty.handler.codec.http.websocketx.extensions.WebSocketServerExtensionHandler;
import io.netty.handler.codec.http.websocketx.extensions.WebSocketServerExtensionHandshaker;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class WebSocketServerExtensionHandlerTest {
    WebSocketServerExtensionHandshaker mainHandshakerMock = (WebSocketServerExtensionHandshaker)Mockito.mock(WebSocketServerExtensionHandshaker.class, (String)"mainHandshaker");
    WebSocketServerExtensionHandshaker fallbackHandshakerMock = (WebSocketServerExtensionHandshaker)Mockito.mock(WebSocketServerExtensionHandshaker.class, (String)"fallbackHandshaker");
    WebSocketServerExtensionHandshaker main2HandshakerMock = (WebSocketServerExtensionHandshaker)Mockito.mock(WebSocketServerExtensionHandshaker.class, (String)"main2Handshaker");
    WebSocketServerExtension mainExtensionMock = (WebSocketServerExtension)Mockito.mock(WebSocketServerExtension.class, (String)"mainExtension");
    WebSocketServerExtension fallbackExtensionMock = (WebSocketServerExtension)Mockito.mock(WebSocketServerExtension.class, (String)"fallbackExtension");
    WebSocketServerExtension main2ExtensionMock = (WebSocketServerExtension)Mockito.mock(WebSocketServerExtension.class, (String)"main2Extension");

    @Test
    public void testMainSuccess() {
        Mockito.when((Object)this.mainHandshakerMock.handshakeExtension(WebSocketExtensionTestUtil.webSocketExtensionDataMatcher("main"))).thenReturn((Object)this.mainExtensionMock);
        Mockito.when((Object)this.mainHandshakerMock.handshakeExtension(WebSocketExtensionTestUtil.webSocketExtensionDataMatcher("fallback"))).thenReturn(null);
        Mockito.when((Object)this.fallbackHandshakerMock.handshakeExtension(WebSocketExtensionTestUtil.webSocketExtensionDataMatcher("fallback"))).thenReturn((Object)this.fallbackExtensionMock);
        Mockito.when((Object)this.fallbackHandshakerMock.handshakeExtension(WebSocketExtensionTestUtil.webSocketExtensionDataMatcher("main"))).thenReturn(null);
        Mockito.when((Object)this.mainExtensionMock.rsv()).thenReturn((Object)4);
        Mockito.when((Object)this.mainExtensionMock.newReponseData()).thenReturn((Object)new WebSocketExtensionData("main", Collections.emptyMap()));
        Mockito.when((Object)this.mainExtensionMock.newExtensionEncoder()).thenReturn((Object)new WebSocketExtensionTestUtil.DummyEncoder());
        Mockito.when((Object)this.mainExtensionMock.newExtensionDecoder()).thenReturn((Object)new WebSocketExtensionTestUtil.DummyDecoder());
        Mockito.when((Object)this.fallbackExtensionMock.rsv()).thenReturn((Object)4);
        WebSocketServerExtensionHandler extensionHandler = new WebSocketServerExtensionHandler(new WebSocketServerExtensionHandshaker[]{this.mainHandshakerMock, this.fallbackHandshakerMock});
        EmbeddedChannel ch = new EmbeddedChannel(new ChannelHandler[]{extensionHandler});
        HttpRequest req = WebSocketExtensionTestUtil.newUpgradeRequest("main, fallback");
        ch.writeInbound(new Object[]{req});
        HttpResponse res = WebSocketExtensionTestUtil.newUpgradeResponse(null);
        ch.writeOutbound(new Object[]{res});
        HttpResponse res2 = (HttpResponse)ch.readOutbound();
        List resExts = WebSocketExtensionUtil.extractExtensions((String)res2.headers().get((CharSequence)HttpHeaderNames.SEC_WEBSOCKET_EXTENSIONS));
        Assertions.assertNull((Object)ch.pipeline().context((ChannelHandler)extensionHandler));
        Assertions.assertEquals((int)1, (int)resExts.size());
        Assertions.assertEquals((Object)"main", (Object)((WebSocketExtensionData)resExts.get(0)).name());
        Assertions.assertTrue((boolean)((WebSocketExtensionData)resExts.get(0)).parameters().isEmpty());
        Assertions.assertNotNull((Object)ch.pipeline().get(WebSocketExtensionTestUtil.DummyDecoder.class));
        Assertions.assertNotNull((Object)ch.pipeline().get(WebSocketExtensionTestUtil.DummyEncoder.class));
        ((WebSocketServerExtensionHandshaker)Mockito.verify((Object)this.mainHandshakerMock, (VerificationMode)Mockito.atLeastOnce())).handshakeExtension(WebSocketExtensionTestUtil.webSocketExtensionDataMatcher("main"));
        ((WebSocketServerExtensionHandshaker)Mockito.verify((Object)this.mainHandshakerMock, (VerificationMode)Mockito.atLeastOnce())).handshakeExtension(WebSocketExtensionTestUtil.webSocketExtensionDataMatcher("fallback"));
        ((WebSocketServerExtensionHandshaker)Mockito.verify((Object)this.fallbackHandshakerMock, (VerificationMode)Mockito.atLeastOnce())).handshakeExtension(WebSocketExtensionTestUtil.webSocketExtensionDataMatcher("fallback"));
        ((WebSocketServerExtension)Mockito.verify((Object)this.mainExtensionMock, (VerificationMode)Mockito.atLeastOnce())).rsv();
        ((WebSocketServerExtension)Mockito.verify((Object)this.mainExtensionMock)).newReponseData();
        ((WebSocketServerExtension)Mockito.verify((Object)this.mainExtensionMock)).newExtensionEncoder();
        ((WebSocketServerExtension)Mockito.verify((Object)this.mainExtensionMock)).newExtensionDecoder();
        ((WebSocketServerExtension)Mockito.verify((Object)this.fallbackExtensionMock, (VerificationMode)Mockito.atLeastOnce())).rsv();
    }

    @Test
    public void testCompatibleExtensionTogetherSuccess() {
        Mockito.when((Object)this.mainHandshakerMock.handshakeExtension(WebSocketExtensionTestUtil.webSocketExtensionDataMatcher("main"))).thenReturn((Object)this.mainExtensionMock);
        Mockito.when((Object)this.mainHandshakerMock.handshakeExtension(WebSocketExtensionTestUtil.webSocketExtensionDataMatcher("fallback"))).thenReturn(null);
        Mockito.when((Object)this.fallbackHandshakerMock.handshakeExtension(WebSocketExtensionTestUtil.webSocketExtensionDataMatcher("fallback"))).thenReturn((Object)this.fallbackExtensionMock);
        Mockito.when((Object)this.fallbackHandshakerMock.handshakeExtension(WebSocketExtensionTestUtil.webSocketExtensionDataMatcher("main"))).thenReturn(null);
        Mockito.when((Object)this.mainExtensionMock.rsv()).thenReturn((Object)4);
        Mockito.when((Object)this.mainExtensionMock.newReponseData()).thenReturn((Object)new WebSocketExtensionData("main", Collections.emptyMap()));
        Mockito.when((Object)this.mainExtensionMock.newExtensionEncoder()).thenReturn((Object)new WebSocketExtensionTestUtil.DummyEncoder());
        Mockito.when((Object)this.mainExtensionMock.newExtensionDecoder()).thenReturn((Object)new WebSocketExtensionTestUtil.DummyDecoder());
        Mockito.when((Object)this.fallbackExtensionMock.rsv()).thenReturn((Object)2);
        Mockito.when((Object)this.fallbackExtensionMock.newReponseData()).thenReturn((Object)new WebSocketExtensionData("fallback", Collections.emptyMap()));
        Mockito.when((Object)this.fallbackExtensionMock.newExtensionEncoder()).thenReturn((Object)new WebSocketExtensionTestUtil.Dummy2Encoder());
        Mockito.when((Object)this.fallbackExtensionMock.newExtensionDecoder()).thenReturn((Object)new WebSocketExtensionTestUtil.Dummy2Decoder());
        WebSocketServerExtensionHandler extensionHandler = new WebSocketServerExtensionHandler(new WebSocketServerExtensionHandshaker[]{this.mainHandshakerMock, this.fallbackHandshakerMock});
        EmbeddedChannel ch = new EmbeddedChannel(new ChannelHandler[]{extensionHandler});
        HttpRequest req = WebSocketExtensionTestUtil.newUpgradeRequest("main, fallback");
        ch.writeInbound(new Object[]{req});
        HttpResponse res = WebSocketExtensionTestUtil.newUpgradeResponse(null);
        ch.writeOutbound(new Object[]{res});
        HttpResponse res2 = (HttpResponse)ch.readOutbound();
        List resExts = WebSocketExtensionUtil.extractExtensions((String)res2.headers().get((CharSequence)HttpHeaderNames.SEC_WEBSOCKET_EXTENSIONS));
        Assertions.assertNull((Object)ch.pipeline().context((ChannelHandler)extensionHandler));
        Assertions.assertEquals((int)2, (int)resExts.size());
        Assertions.assertEquals((Object)"main", (Object)((WebSocketExtensionData)resExts.get(0)).name());
        Assertions.assertEquals((Object)"fallback", (Object)((WebSocketExtensionData)resExts.get(1)).name());
        Assertions.assertNotNull((Object)ch.pipeline().get(WebSocketExtensionTestUtil.DummyDecoder.class));
        Assertions.assertNotNull((Object)ch.pipeline().get(WebSocketExtensionTestUtil.DummyEncoder.class));
        Assertions.assertNotNull((Object)ch.pipeline().get(WebSocketExtensionTestUtil.Dummy2Decoder.class));
        Assertions.assertNotNull((Object)ch.pipeline().get(WebSocketExtensionTestUtil.Dummy2Encoder.class));
        ((WebSocketServerExtensionHandshaker)Mockito.verify((Object)this.mainHandshakerMock)).handshakeExtension(WebSocketExtensionTestUtil.webSocketExtensionDataMatcher("main"));
        ((WebSocketServerExtensionHandshaker)Mockito.verify((Object)this.mainHandshakerMock)).handshakeExtension(WebSocketExtensionTestUtil.webSocketExtensionDataMatcher("fallback"));
        ((WebSocketServerExtensionHandshaker)Mockito.verify((Object)this.fallbackHandshakerMock)).handshakeExtension(WebSocketExtensionTestUtil.webSocketExtensionDataMatcher("fallback"));
        ((WebSocketServerExtension)Mockito.verify((Object)this.mainExtensionMock, (VerificationMode)Mockito.times((int)2))).rsv();
        ((WebSocketServerExtension)Mockito.verify((Object)this.mainExtensionMock)).newReponseData();
        ((WebSocketServerExtension)Mockito.verify((Object)this.mainExtensionMock)).newExtensionEncoder();
        ((WebSocketServerExtension)Mockito.verify((Object)this.mainExtensionMock)).newExtensionDecoder();
        ((WebSocketServerExtension)Mockito.verify((Object)this.fallbackExtensionMock, (VerificationMode)Mockito.times((int)2))).rsv();
        ((WebSocketServerExtension)Mockito.verify((Object)this.fallbackExtensionMock)).newReponseData();
        ((WebSocketServerExtension)Mockito.verify((Object)this.fallbackExtensionMock)).newExtensionEncoder();
        ((WebSocketServerExtension)Mockito.verify((Object)this.fallbackExtensionMock)).newExtensionDecoder();
    }

    @Test
    public void testNoneExtensionMatchingSuccess() {
        Mockito.when((Object)this.mainHandshakerMock.handshakeExtension(WebSocketExtensionTestUtil.webSocketExtensionDataMatcher("unknown"))).thenReturn(null);
        Mockito.when((Object)this.mainHandshakerMock.handshakeExtension(WebSocketExtensionTestUtil.webSocketExtensionDataMatcher("unknown2"))).thenReturn(null);
        Mockito.when((Object)this.fallbackHandshakerMock.handshakeExtension(WebSocketExtensionTestUtil.webSocketExtensionDataMatcher("unknown"))).thenReturn(null);
        Mockito.when((Object)this.fallbackHandshakerMock.handshakeExtension(WebSocketExtensionTestUtil.webSocketExtensionDataMatcher("unknown2"))).thenReturn(null);
        WebSocketServerExtensionHandler extensionHandler = new WebSocketServerExtensionHandler(new WebSocketServerExtensionHandshaker[]{this.mainHandshakerMock, this.fallbackHandshakerMock});
        EmbeddedChannel ch = new EmbeddedChannel(new ChannelHandler[]{extensionHandler});
        HttpRequest req = WebSocketExtensionTestUtil.newUpgradeRequest("unknown, unknown2");
        ch.writeInbound(new Object[]{req});
        HttpResponse res = WebSocketExtensionTestUtil.newUpgradeResponse(null);
        ch.writeOutbound(new Object[]{res});
        HttpResponse res2 = (HttpResponse)ch.readOutbound();
        Assertions.assertNull((Object)ch.pipeline().context((ChannelHandler)extensionHandler));
        Assertions.assertFalse((boolean)res2.headers().contains((CharSequence)HttpHeaderNames.SEC_WEBSOCKET_EXTENSIONS));
        ((WebSocketServerExtensionHandshaker)Mockito.verify((Object)this.mainHandshakerMock)).handshakeExtension(WebSocketExtensionTestUtil.webSocketExtensionDataMatcher("unknown"));
        ((WebSocketServerExtensionHandshaker)Mockito.verify((Object)this.mainHandshakerMock)).handshakeExtension(WebSocketExtensionTestUtil.webSocketExtensionDataMatcher("unknown2"));
        ((WebSocketServerExtensionHandshaker)Mockito.verify((Object)this.fallbackHandshakerMock)).handshakeExtension(WebSocketExtensionTestUtil.webSocketExtensionDataMatcher("unknown"));
        ((WebSocketServerExtensionHandshaker)Mockito.verify((Object)this.fallbackHandshakerMock)).handshakeExtension(WebSocketExtensionTestUtil.webSocketExtensionDataMatcher("unknown2"));
    }

    @Test
    public void testExtensionHandlerNotRemovedByFailureWritePromise() {
        Mockito.when((Object)this.mainHandshakerMock.handshakeExtension(WebSocketExtensionTestUtil.webSocketExtensionDataMatcher("main"))).thenReturn((Object)this.mainExtensionMock);
        Mockito.when((Object)this.mainExtensionMock.newReponseData()).thenReturn((Object)new WebSocketExtensionData("main", Collections.emptyMap()));
        WebSocketServerExtensionHandler extensionHandler = new WebSocketServerExtensionHandler(new WebSocketServerExtensionHandshaker[]{this.mainHandshakerMock});
        EmbeddedChannel ch = new EmbeddedChannel(new ChannelHandler[]{extensionHandler});
        HttpRequest req = WebSocketExtensionTestUtil.newUpgradeRequest("main");
        ch.writeInbound(new Object[]{req});
        HttpResponse res = WebSocketExtensionTestUtil.newUpgradeResponse(null);
        ChannelPromise failurePromise = ch.newPromise();
        ch.writeOneOutbound((Object)res, failurePromise);
        failurePromise.setFailure((Throwable)new IOException("Cannot write response"));
        Assertions.assertNull((Object)ch.readOutbound());
        Assertions.assertNotNull((Object)ch.pipeline().context((ChannelHandler)extensionHandler));
        Assertions.assertTrue((boolean)ch.finish());
    }

    @Test
    public void testExtensionMultipleRequests() {
        Mockito.when((Object)this.mainHandshakerMock.handshakeExtension(WebSocketExtensionTestUtil.webSocketExtensionDataMatcher("main"))).thenReturn((Object)this.mainExtensionMock);
        Mockito.when((Object)this.mainExtensionMock.rsv()).thenReturn((Object)4);
        Mockito.when((Object)this.mainExtensionMock.newReponseData()).thenReturn((Object)new WebSocketExtensionData("main", Collections.emptyMap()));
        Mockito.when((Object)this.mainExtensionMock.newExtensionEncoder()).thenReturn((Object)new WebSocketExtensionTestUtil.DummyEncoder());
        Mockito.when((Object)this.mainExtensionMock.newExtensionDecoder()).thenReturn((Object)new WebSocketExtensionTestUtil.DummyDecoder());
        Mockito.when((Object)this.main2HandshakerMock.handshakeExtension(WebSocketExtensionTestUtil.webSocketExtensionDataMatcher("main2"))).thenReturn((Object)this.main2ExtensionMock);
        Mockito.when((Object)this.main2ExtensionMock.rsv()).thenReturn((Object)4);
        Mockito.when((Object)this.main2ExtensionMock.newReponseData()).thenReturn((Object)new WebSocketExtensionData("main2", Collections.emptyMap()));
        Mockito.when((Object)this.main2ExtensionMock.newExtensionEncoder()).thenReturn((Object)new WebSocketExtensionTestUtil.DummyEncoder());
        Mockito.when((Object)this.main2ExtensionMock.newExtensionDecoder()).thenReturn((Object)new WebSocketExtensionTestUtil.DummyDecoder());
        WebSocketServerExtensionHandler extensionHandler = new WebSocketServerExtensionHandler(new WebSocketServerExtensionHandshaker[]{this.mainHandshakerMock, this.main2HandshakerMock});
        EmbeddedChannel ch = new EmbeddedChannel(new ChannelHandler[]{extensionHandler});
        HttpRequest req = WebSocketExtensionTestUtil.newUpgradeRequest("main");
        Assertions.assertTrue((boolean)ch.writeInbound(new Object[]{req}));
        Assertions.assertTrue((boolean)ch.writeInbound(new Object[]{LastHttpContent.EMPTY_LAST_CONTENT}));
        HttpRequest req2 = WebSocketExtensionTestUtil.newUpgradeRequest("main2");
        Assertions.assertTrue((boolean)ch.writeInbound(new Object[]{req2}));
        Assertions.assertTrue((boolean)ch.writeInbound(new Object[]{LastHttpContent.EMPTY_LAST_CONTENT}));
        HttpResponse res = WebSocketExtensionTestUtil.newUpgradeResponse(null);
        Assertions.assertTrue((boolean)ch.writeOutbound(new Object[]{res}));
        Assertions.assertTrue((boolean)ch.writeOutbound(new Object[]{LastHttpContent.EMPTY_LAST_CONTENT}));
        res = (HttpResponse)ch.readOutbound();
        Assertions.assertEquals((Object)"main", (Object)res.headers().get((CharSequence)HttpHeaderNames.SEC_WEBSOCKET_EXTENSIONS));
        LastHttpContent content = (LastHttpContent)ch.readOutbound();
        content.release();
        Assertions.assertNull((Object)ch.pipeline().context((ChannelHandler)extensionHandler));
        Assertions.assertTrue((boolean)ch.finishAndReleaseAll());
    }
}

