/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http;

import com.aayushatharva.brotli4j.decoder.DecoderJNI;
import com.aayushatharva.brotli4j.decoder.DirectDecompress;
import io.netty.bootstrap.Bootstrap;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.netty.buffer.CompositeByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOutboundHandlerAdapter;
import io.netty.channel.ChannelPromise;
import io.netty.channel.DefaultEventLoopGroup;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.embedded.EmbeddedChannel;
import io.netty.channel.local.LocalAddress;
import io.netty.channel.local.LocalChannel;
import io.netty.channel.local.LocalServerChannel;
import io.netty.handler.codec.DecoderResult;
import io.netty.handler.codec.EncoderException;
import io.netty.handler.codec.compression.Brotli;
import io.netty.handler.codec.compression.CompressionOptions;
import io.netty.handler.codec.compression.ZlibWrapper;
import io.netty.handler.codec.http.DefaultFullHttpRequest;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.DefaultHttpContent;
import io.netty.handler.codec.http.DefaultHttpResponse;
import io.netty.handler.codec.http.DefaultLastHttpContent;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpClientCodec;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.HttpContentCompressor;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http.HttpHeadersTestUtils;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpObject;
import io.netty.handler.codec.http.HttpObjectAggregator;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpServerCodec;
import io.netty.handler.codec.http.HttpUtil;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.LastHttpContent;
import io.netty.util.CharsetUtil;
import io.netty.util.ReferenceCountUtil;
import io.netty.util.concurrent.EventExecutorGroup;
import java.net.SocketAddress;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.UUID;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.condition.EnabledIf;

public class HttpContentCompressorTest {
    @Test
    public void testGetTargetContentEncoding() throws Exception {
        HttpContentCompressor compressor = new HttpContentCompressor();
        String[] tests = new String[]{"", null, "*", "gzip", "*;q=0.0", null, "gzip", "gzip", "compress, gzip;q=0.5", "gzip", "gzip; q=0.5, identity", "gzip", "gzip ; q=0.1", "gzip", "gzip; q=0, deflate", "deflate", " deflate ; q=0 , *;q=0.5", "gzip"};
        for (int i = 0; i < tests.length; i += 2) {
            String acceptEncoding = tests[i];
            String contentEncoding = tests[i + 1];
            ZlibWrapper targetWrapper = compressor.determineWrapper(acceptEncoding);
            String targetEncoding = null;
            if (targetWrapper != null) {
                switch (targetWrapper) {
                    case GZIP: {
                        targetEncoding = "gzip";
                        break;
                    }
                    case ZLIB: {
                        targetEncoding = "deflate";
                        break;
                    }
                    default: {
                        Assertions.fail();
                    }
                }
            }
            Assertions.assertEquals((Object)contentEncoding, targetEncoding);
        }
    }

    @Test
    public void testDetermineEncoding() throws Exception {
        HttpContentCompressor compressor = new HttpContentCompressor((CompressionOptions[])null);
        String[] tests = new String[]{"", null, ",", null, "identity", null, "unknown", null, "*", "br", "br", "br", "br ; q=0.1", "br", "unknown, br", "br", "br, gzip", "br", "gzip, br", "br", "identity, br", "br", "gzip", "gzip", "gzip ; q=0.1", "gzip"};
        for (int i = 0; i < tests.length; i += 2) {
            String acceptEncoding = tests[i];
            String expectedEncoding = tests[i + 1];
            String targetEncoding = compressor.determineEncoding(acceptEncoding);
            Assertions.assertEquals((Object)expectedEncoding, (Object)targetEncoding);
        }
    }

    @Test
    public void testSplitContent() throws Exception {
        EmbeddedChannel ch = new EmbeddedChannel(new ChannelHandler[]{new HttpContentCompressor()});
        ch.writeInbound(new Object[]{HttpContentCompressorTest.newRequest()});
        ch.writeOutbound(new Object[]{new DefaultHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK)});
        ch.writeOutbound(new Object[]{new DefaultHttpContent(Unpooled.copiedBuffer((CharSequence)"Hell", (Charset)CharsetUtil.US_ASCII))});
        ch.writeOutbound(new Object[]{new DefaultHttpContent(Unpooled.copiedBuffer((CharSequence)"o, w", (Charset)CharsetUtil.US_ASCII))});
        ch.writeOutbound(new Object[]{new DefaultLastHttpContent(Unpooled.copiedBuffer((CharSequence)"orld", (Charset)CharsetUtil.US_ASCII))});
        HttpContentCompressorTest.assertEncodedResponse(ch);
        HttpContent chunk = (HttpContent)ch.readOutbound();
        MatcherAssert.assertThat((Object)ByteBufUtil.hexDump((ByteBuf)chunk.content()), (Matcher)CoreMatchers.is((Object)"1f8b0800000000000000f248cdc901000000ffff"));
        chunk.release();
        chunk = (HttpContent)ch.readOutbound();
        MatcherAssert.assertThat((Object)ByteBufUtil.hexDump((ByteBuf)chunk.content()), (Matcher)CoreMatchers.is((Object)"cad7512807000000ffff"));
        chunk.release();
        chunk = (HttpContent)ch.readOutbound();
        MatcherAssert.assertThat((Object)ByteBufUtil.hexDump((ByteBuf)chunk.content()), (Matcher)CoreMatchers.is((Object)"ca2fca4901000000ffff"));
        chunk.release();
        chunk = (HttpContent)ch.readOutbound();
        MatcherAssert.assertThat((Object)ByteBufUtil.hexDump((ByteBuf)chunk.content()), (Matcher)CoreMatchers.is((Object)"0300c2a99ae70c000000"));
        MatcherAssert.assertThat((Object)chunk, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(HttpContent.class)));
        chunk.release();
        chunk = (HttpContent)ch.readOutbound();
        MatcherAssert.assertThat((Object)chunk.content().isReadable(), (Matcher)CoreMatchers.is((Object)false));
        MatcherAssert.assertThat((Object)chunk, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(LastHttpContent.class)));
        chunk.release();
        MatcherAssert.assertThat((Object)ch.readOutbound(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
    }

    @Test
    public void testChunkedContent() throws Exception {
        EmbeddedChannel ch = new EmbeddedChannel(new ChannelHandler[]{new HttpContentCompressor()});
        ch.writeInbound(new Object[]{HttpContentCompressorTest.newRequest()});
        DefaultHttpResponse res = new DefaultHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK);
        res.headers().set((CharSequence)HttpHeaderNames.TRANSFER_ENCODING, (Object)HttpHeaderValues.CHUNKED);
        ch.writeOutbound(new Object[]{res});
        HttpContentCompressorTest.assertEncodedResponse(ch);
        ch.writeOutbound(new Object[]{new DefaultHttpContent(Unpooled.copiedBuffer((CharSequence)"Hell", (Charset)CharsetUtil.US_ASCII))});
        ch.writeOutbound(new Object[]{new DefaultHttpContent(Unpooled.copiedBuffer((CharSequence)"o, w", (Charset)CharsetUtil.US_ASCII))});
        ch.writeOutbound(new Object[]{new DefaultLastHttpContent(Unpooled.copiedBuffer((CharSequence)"orld", (Charset)CharsetUtil.US_ASCII))});
        HttpContent chunk = (HttpContent)ch.readOutbound();
        MatcherAssert.assertThat((Object)ByteBufUtil.hexDump((ByteBuf)chunk.content()), (Matcher)CoreMatchers.is((Object)"1f8b0800000000000000f248cdc901000000ffff"));
        chunk.release();
        chunk = (HttpContent)ch.readOutbound();
        MatcherAssert.assertThat((Object)ByteBufUtil.hexDump((ByteBuf)chunk.content()), (Matcher)CoreMatchers.is((Object)"cad7512807000000ffff"));
        chunk.release();
        chunk = (HttpContent)ch.readOutbound();
        MatcherAssert.assertThat((Object)ByteBufUtil.hexDump((ByteBuf)chunk.content()), (Matcher)CoreMatchers.is((Object)"ca2fca4901000000ffff"));
        chunk.release();
        chunk = (HttpContent)ch.readOutbound();
        MatcherAssert.assertThat((Object)ByteBufUtil.hexDump((ByteBuf)chunk.content()), (Matcher)CoreMatchers.is((Object)"0300c2a99ae70c000000"));
        MatcherAssert.assertThat((Object)chunk, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(HttpContent.class)));
        chunk.release();
        chunk = (HttpContent)ch.readOutbound();
        MatcherAssert.assertThat((Object)chunk.content().isReadable(), (Matcher)CoreMatchers.is((Object)false));
        MatcherAssert.assertThat((Object)chunk, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(LastHttpContent.class)));
        chunk.release();
        MatcherAssert.assertThat((Object)ch.readOutbound(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
    }

    @Test
    public void testChunkedContentWithAssembledResponse() throws Exception {
        EmbeddedChannel ch = new EmbeddedChannel(new ChannelHandler[]{new HttpContentCompressor()});
        ch.writeInbound(new Object[]{HttpContentCompressorTest.newRequest()});
        AssembledHttpResponse res = new AssembledHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK, Unpooled.copiedBuffer((CharSequence)"Hell", (Charset)CharsetUtil.US_ASCII));
        res.headers().set((CharSequence)HttpHeaderNames.TRANSFER_ENCODING, (Object)HttpHeaderValues.CHUNKED);
        ch.writeOutbound(new Object[]{res});
        HttpContentCompressorTest.assertAssembledEncodedResponse(ch);
        ch.writeOutbound(new Object[]{new DefaultHttpContent(Unpooled.copiedBuffer((CharSequence)"o, w", (Charset)CharsetUtil.US_ASCII))});
        ch.writeOutbound(new Object[]{new DefaultLastHttpContent(Unpooled.copiedBuffer((CharSequence)"orld", (Charset)CharsetUtil.US_ASCII))});
        HttpContent chunk = (HttpContent)ch.readOutbound();
        MatcherAssert.assertThat((Object)ByteBufUtil.hexDump((ByteBuf)chunk.content()), (Matcher)CoreMatchers.is((Object)"1f8b0800000000000000f248cdc901000000ffff"));
        chunk.release();
        chunk = (HttpContent)ch.readOutbound();
        MatcherAssert.assertThat((Object)ByteBufUtil.hexDump((ByteBuf)chunk.content()), (Matcher)CoreMatchers.is((Object)"cad7512807000000ffff"));
        chunk.release();
        chunk = (HttpContent)ch.readOutbound();
        MatcherAssert.assertThat((Object)ByteBufUtil.hexDump((ByteBuf)chunk.content()), (Matcher)CoreMatchers.is((Object)"ca2fca4901000000ffff"));
        chunk.release();
        chunk = (HttpContent)ch.readOutbound();
        MatcherAssert.assertThat((Object)ByteBufUtil.hexDump((ByteBuf)chunk.content()), (Matcher)CoreMatchers.is((Object)"0300c2a99ae70c000000"));
        MatcherAssert.assertThat((Object)chunk, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(HttpContent.class)));
        chunk.release();
        chunk = (HttpContent)ch.readOutbound();
        MatcherAssert.assertThat((Object)chunk.content().isReadable(), (Matcher)CoreMatchers.is((Object)false));
        MatcherAssert.assertThat((Object)chunk, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(LastHttpContent.class)));
        chunk.release();
        MatcherAssert.assertThat((Object)ch.readOutbound(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
    }

    @Test
    public void testChunkedContentWithAssembledResponseIdentityEncoding() throws Exception {
        EmbeddedChannel ch = new EmbeddedChannel(new ChannelHandler[]{new HttpContentCompressor()});
        ch.writeInbound(new Object[]{new DefaultFullHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.GET, "/")});
        AssembledHttpResponse res = new AssembledHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK, Unpooled.copiedBuffer((CharSequence)"Hell", (Charset)CharsetUtil.US_ASCII));
        res.headers().set((CharSequence)HttpHeaderNames.TRANSFER_ENCODING, (Object)HttpHeaderValues.CHUNKED);
        ch.writeOutbound(new Object[]{res});
        ch.writeOutbound(new Object[]{new DefaultHttpContent(Unpooled.copiedBuffer((CharSequence)"o, w", (Charset)CharsetUtil.US_ASCII))});
        ch.writeOutbound(new Object[]{new DefaultLastHttpContent(Unpooled.copiedBuffer((CharSequence)"orld", (Charset)CharsetUtil.US_ASCII))});
        HttpContent chunk = (HttpContent)ch.readOutbound();
        MatcherAssert.assertThat((Object)chunk.content().toString(StandardCharsets.UTF_8), (Matcher)CoreMatchers.is((Object)"Hell"));
        chunk.release();
        chunk = (HttpContent)ch.readOutbound();
        MatcherAssert.assertThat((Object)chunk.content().toString(StandardCharsets.UTF_8), (Matcher)CoreMatchers.is((Object)"o, w"));
        chunk.release();
        chunk = (HttpContent)ch.readOutbound();
        MatcherAssert.assertThat((Object)chunk.content().toString(StandardCharsets.UTF_8), (Matcher)CoreMatchers.is((Object)"orld"));
        MatcherAssert.assertThat((Object)chunk, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(LastHttpContent.class)));
        chunk.release();
        MatcherAssert.assertThat((Object)ch.readOutbound(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
    }

    @Test
    public void testContentWithAssembledResponseIdentityEncodingHttp10() throws Exception {
        EmbeddedChannel ch = new EmbeddedChannel(new ChannelHandler[]{new HttpContentCompressor()});
        ch.writeInbound(new Object[]{new DefaultFullHttpRequest(HttpVersion.HTTP_1_0, HttpMethod.GET, "/")});
        AssembledHttpResponse res = new AssembledHttpResponse(HttpVersion.HTTP_1_0, HttpResponseStatus.OK, Unpooled.copiedBuffer((CharSequence)"Hell", (Charset)CharsetUtil.US_ASCII));
        ch.writeOutbound(new Object[]{res});
        ch.writeOutbound(new Object[]{new DefaultHttpContent(Unpooled.copiedBuffer((CharSequence)"o, w", (Charset)CharsetUtil.US_ASCII))});
        ch.writeOutbound(new Object[]{new DefaultLastHttpContent(Unpooled.copiedBuffer((CharSequence)"orld", (Charset)CharsetUtil.US_ASCII))});
        HttpContent chunk = (HttpContent)ch.readOutbound();
        MatcherAssert.assertThat((Object)chunk.content().toString(StandardCharsets.UTF_8), (Matcher)CoreMatchers.is((Object)"Hell"));
        chunk.release();
        chunk = (HttpContent)ch.readOutbound();
        MatcherAssert.assertThat((Object)chunk.content().toString(StandardCharsets.UTF_8), (Matcher)CoreMatchers.is((Object)"o, w"));
        chunk.release();
        chunk = (HttpContent)ch.readOutbound();
        MatcherAssert.assertThat((Object)chunk.content().toString(StandardCharsets.UTF_8), (Matcher)CoreMatchers.is((Object)"orld"));
        MatcherAssert.assertThat((Object)chunk, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(LastHttpContent.class)));
        chunk.release();
        MatcherAssert.assertThat((Object)ch.readOutbound(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
    }

    @Test
    public void testChunkedContentWithTrailingHeader() throws Exception {
        EmbeddedChannel ch = new EmbeddedChannel(new ChannelHandler[]{new HttpContentCompressor()});
        ch.writeInbound(new Object[]{HttpContentCompressorTest.newRequest()});
        DefaultHttpResponse res = new DefaultHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK);
        res.headers().set((CharSequence)HttpHeaderNames.TRANSFER_ENCODING, (Object)HttpHeaderValues.CHUNKED);
        ch.writeOutbound(new Object[]{res});
        HttpContentCompressorTest.assertEncodedResponse(ch);
        ch.writeOutbound(new Object[]{new DefaultHttpContent(Unpooled.copiedBuffer((CharSequence)"Hell", (Charset)CharsetUtil.US_ASCII))});
        ch.writeOutbound(new Object[]{new DefaultHttpContent(Unpooled.copiedBuffer((CharSequence)"o, w", (Charset)CharsetUtil.US_ASCII))});
        DefaultLastHttpContent content = new DefaultLastHttpContent(Unpooled.copiedBuffer((CharSequence)"orld", (Charset)CharsetUtil.US_ASCII));
        content.trailingHeaders().set(HttpHeadersTestUtils.of("X-Test"), (Object)HttpHeadersTestUtils.of("Netty"));
        ch.writeOutbound(new Object[]{content});
        HttpContent chunk = (HttpContent)ch.readOutbound();
        MatcherAssert.assertThat((Object)ByteBufUtil.hexDump((ByteBuf)chunk.content()), (Matcher)CoreMatchers.is((Object)"1f8b0800000000000000f248cdc901000000ffff"));
        chunk.release();
        chunk = (HttpContent)ch.readOutbound();
        MatcherAssert.assertThat((Object)ByteBufUtil.hexDump((ByteBuf)chunk.content()), (Matcher)CoreMatchers.is((Object)"cad7512807000000ffff"));
        chunk.release();
        chunk = (HttpContent)ch.readOutbound();
        MatcherAssert.assertThat((Object)ByteBufUtil.hexDump((ByteBuf)chunk.content()), (Matcher)CoreMatchers.is((Object)"ca2fca4901000000ffff"));
        chunk.release();
        chunk = (HttpContent)ch.readOutbound();
        MatcherAssert.assertThat((Object)ByteBufUtil.hexDump((ByteBuf)chunk.content()), (Matcher)CoreMatchers.is((Object)"0300c2a99ae70c000000"));
        MatcherAssert.assertThat((Object)chunk, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(HttpContent.class)));
        chunk.release();
        chunk = (HttpContent)ch.readOutbound();
        MatcherAssert.assertThat((Object)chunk.content().isReadable(), (Matcher)CoreMatchers.is((Object)false));
        MatcherAssert.assertThat((Object)chunk, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(LastHttpContent.class)));
        Assertions.assertEquals((Object)"Netty", (Object)((LastHttpContent)chunk).trailingHeaders().get(HttpHeadersTestUtils.of("X-Test")));
        Assertions.assertEquals((Object)DecoderResult.SUCCESS, (Object)chunk.decoderResult());
        chunk.release();
        MatcherAssert.assertThat((Object)ch.readOutbound(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
    }

    @Test
    public void testFullContentWithContentLength() throws Exception {
        EmbeddedChannel ch = new EmbeddedChannel(new ChannelHandler[]{new HttpContentCompressor()});
        ch.writeInbound(new Object[]{HttpContentCompressorTest.newRequest()});
        DefaultFullHttpResponse fullRes = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK, Unpooled.copiedBuffer((CharSequence)"Hello, World", (Charset)CharsetUtil.US_ASCII));
        fullRes.headers().set((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (Object)fullRes.content().readableBytes());
        ch.writeOutbound(new Object[]{fullRes});
        HttpResponse res = (HttpResponse)ch.readOutbound();
        MatcherAssert.assertThat((Object)res, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.not((Matcher)CoreMatchers.instanceOf(HttpContent.class))));
        MatcherAssert.assertThat((Object)res.headers().get((CharSequence)HttpHeaderNames.TRANSFER_ENCODING), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
        MatcherAssert.assertThat((Object)res.headers().get((CharSequence)HttpHeaderNames.CONTENT_ENCODING), (Matcher)CoreMatchers.is((Object)"gzip"));
        long contentLengthHeaderValue = HttpUtil.getContentLength((HttpMessage)res);
        long observedLength = 0L;
        HttpContent c = (HttpContent)ch.readOutbound();
        observedLength += (long)c.content().readableBytes();
        MatcherAssert.assertThat((Object)ByteBufUtil.hexDump((ByteBuf)c.content()), (Matcher)CoreMatchers.is((Object)"1f8b0800000000000000f248cdc9c9d75108cf2fca4901000000ffff"));
        c.release();
        c = (HttpContent)ch.readOutbound();
        observedLength += (long)c.content().readableBytes();
        MatcherAssert.assertThat((Object)ByteBufUtil.hexDump((ByteBuf)c.content()), (Matcher)CoreMatchers.is((Object)"0300c6865b260c000000"));
        c.release();
        LastHttpContent last = (LastHttpContent)ch.readOutbound();
        MatcherAssert.assertThat((Object)last.content().readableBytes(), (Matcher)CoreMatchers.is((Object)0));
        last.release();
        MatcherAssert.assertThat((Object)ch.readOutbound(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
        Assertions.assertEquals((long)contentLengthHeaderValue, (long)observedLength);
    }

    @Test
    public void testFullContent() throws Exception {
        EmbeddedChannel ch = new EmbeddedChannel(new ChannelHandler[]{new HttpContentCompressor()});
        ch.writeInbound(new Object[]{HttpContentCompressorTest.newRequest()});
        DefaultFullHttpResponse res = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK, Unpooled.copiedBuffer((CharSequence)"Hello, World", (Charset)CharsetUtil.US_ASCII));
        ch.writeOutbound(new Object[]{res});
        HttpContentCompressorTest.assertEncodedResponse(ch);
        HttpContent c = (HttpContent)ch.readOutbound();
        MatcherAssert.assertThat((Object)ByteBufUtil.hexDump((ByteBuf)c.content()), (Matcher)CoreMatchers.is((Object)"1f8b0800000000000000f248cdc9c9d75108cf2fca4901000000ffff"));
        c.release();
        c = (HttpContent)ch.readOutbound();
        MatcherAssert.assertThat((Object)ByteBufUtil.hexDump((ByteBuf)c.content()), (Matcher)CoreMatchers.is((Object)"0300c6865b260c000000"));
        c.release();
        LastHttpContent last = (LastHttpContent)ch.readOutbound();
        MatcherAssert.assertThat((Object)last.content().readableBytes(), (Matcher)CoreMatchers.is((Object)0));
        last.release();
        MatcherAssert.assertThat((Object)ch.readOutbound(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testExecutorPreserveOrdering() throws Exception {
        DefaultEventLoopGroup compressorGroup = new DefaultEventLoopGroup(1);
        DefaultEventLoopGroup localGroup = new DefaultEventLoopGroup(1);
        Channel server = null;
        Channel client = null;
        try {
            ServerBootstrap bootstrap = ((ServerBootstrap)new ServerBootstrap().channel(LocalServerChannel.class)).group((EventLoopGroup)localGroup).childHandler((ChannelHandler)new ChannelInitializer<LocalChannel>((EventLoopGroup)compressorGroup){
                final /* synthetic */ EventLoopGroup val$compressorGroup;
                {
                    this.val$compressorGroup = eventLoopGroup;
                }

                protected void initChannel(LocalChannel ch) throws Exception {
                    ch.pipeline().addLast(new ChannelHandler[]{new HttpServerCodec()}).addLast(new ChannelHandler[]{new HttpObjectAggregator(1024)}).addLast((EventExecutorGroup)this.val$compressorGroup, new ChannelHandler[]{new HttpContentCompressor()}).addLast(new ChannelHandler[]{new ChannelOutboundHandlerAdapter(){

                        public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) throws Exception {
                            super.write(ctx, msg, promise);
                        }
                    }}).addLast(new ChannelHandler[]{new ChannelInboundHandlerAdapter(){

                        public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
                            if (msg instanceof FullHttpRequest) {
                                DefaultFullHttpResponse res = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK, Unpooled.copiedBuffer((CharSequence)"Hello, World", (Charset)CharsetUtil.US_ASCII));
                                ctx.writeAndFlush((Object)res);
                                ReferenceCountUtil.release((Object)msg);
                                return;
                            }
                            super.channelRead(ctx, msg);
                        }
                    }});
                }
            });
            LocalAddress address = new LocalAddress(UUID.randomUUID().toString());
            server = bootstrap.bind((SocketAddress)address).sync().channel();
            final LinkedBlockingQueue responses = new LinkedBlockingQueue();
            client = ((Bootstrap)((Bootstrap)((Bootstrap)new Bootstrap().channel(LocalChannel.class)).remoteAddress((SocketAddress)address).group((EventLoopGroup)localGroup)).handler((ChannelHandler)new ChannelInitializer<LocalChannel>(){

                protected void initChannel(LocalChannel ch) throws Exception {
                    ch.pipeline().addLast(new ChannelHandler[]{new HttpClientCodec()}).addLast(new ChannelHandler[]{new ChannelInboundHandlerAdapter(){

                        public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
                            if (msg instanceof HttpObject) {
                                responses.put((HttpObject)msg);
                                return;
                            }
                            super.channelRead(ctx, msg);
                        }
                    }});
                }
            })).connect().sync().channel();
            client.writeAndFlush((Object)HttpContentCompressorTest.newRequest()).sync();
            HttpContentCompressorTest.assertEncodedResponse((HttpResponse)responses.poll(1L, TimeUnit.SECONDS));
            HttpContent c = (HttpContent)responses.poll(1L, TimeUnit.SECONDS);
            Assertions.assertNotNull((Object)c);
            MatcherAssert.assertThat((Object)ByteBufUtil.hexDump((ByteBuf)c.content()), (Matcher)CoreMatchers.is((Object)"1f8b0800000000000000f248cdc9c9d75108cf2fca4901000000ffff"));
            c.release();
            c = (HttpContent)responses.poll(1L, TimeUnit.SECONDS);
            Assertions.assertNotNull((Object)c);
            MatcherAssert.assertThat((Object)ByteBufUtil.hexDump((ByteBuf)c.content()), (Matcher)CoreMatchers.is((Object)"0300c6865b260c000000"));
            c.release();
            LastHttpContent last = (LastHttpContent)responses.poll(1L, TimeUnit.SECONDS);
            Assertions.assertNotNull((Object)last);
            MatcherAssert.assertThat((Object)last.content().readableBytes(), (Matcher)CoreMatchers.is((Object)0));
            last.release();
            Assertions.assertNull(responses.poll(1L, TimeUnit.SECONDS));
        }
        finally {
            if (client != null) {
                client.close().sync();
            }
            if (server != null) {
                server.close().sync();
            }
            compressorGroup.shutdownGracefully();
            localGroup.shutdownGracefully();
        }
    }

    @Test
    public void testEmptySplitContent() throws Exception {
        EmbeddedChannel ch = new EmbeddedChannel(new ChannelHandler[]{new HttpContentCompressor()});
        ch.writeInbound(new Object[]{HttpContentCompressorTest.newRequest()});
        ch.writeOutbound(new Object[]{new DefaultHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK)});
        HttpContentCompressorTest.assertEncodedResponse(ch);
        ch.writeOutbound(new Object[]{LastHttpContent.EMPTY_LAST_CONTENT});
        HttpContent chunk = (HttpContent)ch.readOutbound();
        MatcherAssert.assertThat((Object)ByteBufUtil.hexDump((ByteBuf)chunk.content()), (Matcher)CoreMatchers.is((Object)"1f8b080000000000000003000000000000000000"));
        MatcherAssert.assertThat((Object)chunk, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(HttpContent.class)));
        chunk.release();
        chunk = (HttpContent)ch.readOutbound();
        MatcherAssert.assertThat((Object)chunk.content().isReadable(), (Matcher)CoreMatchers.is((Object)false));
        MatcherAssert.assertThat((Object)chunk, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(LastHttpContent.class)));
        chunk.release();
        MatcherAssert.assertThat((Object)ch.readOutbound(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
    }

    @Test
    public void testEmptyFullContent() throws Exception {
        EmbeddedChannel ch = new EmbeddedChannel(new ChannelHandler[]{new HttpContentCompressor()});
        ch.writeInbound(new Object[]{HttpContentCompressorTest.newRequest()});
        DefaultFullHttpResponse res = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK, Unpooled.EMPTY_BUFFER);
        ch.writeOutbound(new Object[]{res});
        Object o = ch.readOutbound();
        MatcherAssert.assertThat((Object)o, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(FullHttpResponse.class)));
        res = (FullHttpResponse)o;
        MatcherAssert.assertThat((Object)res.headers().get((CharSequence)HttpHeaderNames.TRANSFER_ENCODING), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
        MatcherAssert.assertThat((Object)res.headers().get((CharSequence)HttpHeaderNames.CONTENT_ENCODING), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
        MatcherAssert.assertThat((Object)res.content().readableBytes(), (Matcher)CoreMatchers.is((Object)0));
        MatcherAssert.assertThat((Object)res.content().toString(CharsetUtil.US_ASCII), (Matcher)CoreMatchers.is((Object)""));
        res.release();
        MatcherAssert.assertThat((Object)ch.readOutbound(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
    }

    @Test
    public void testEmptyFullContentWithTrailer() throws Exception {
        EmbeddedChannel ch = new EmbeddedChannel(new ChannelHandler[]{new HttpContentCompressor()});
        ch.writeInbound(new Object[]{HttpContentCompressorTest.newRequest()});
        DefaultFullHttpResponse res = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK, Unpooled.EMPTY_BUFFER);
        res.trailingHeaders().set(HttpHeadersTestUtils.of("X-Test"), (Object)HttpHeadersTestUtils.of("Netty"));
        ch.writeOutbound(new Object[]{res});
        Object o = ch.readOutbound();
        MatcherAssert.assertThat((Object)o, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(FullHttpResponse.class)));
        res = (FullHttpResponse)o;
        MatcherAssert.assertThat((Object)res.headers().get((CharSequence)HttpHeaderNames.TRANSFER_ENCODING), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
        MatcherAssert.assertThat((Object)res.headers().get((CharSequence)HttpHeaderNames.CONTENT_ENCODING), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
        MatcherAssert.assertThat((Object)res.content().readableBytes(), (Matcher)CoreMatchers.is((Object)0));
        MatcherAssert.assertThat((Object)res.content().toString(CharsetUtil.US_ASCII), (Matcher)CoreMatchers.is((Object)""));
        Assertions.assertEquals((Object)"Netty", (Object)res.trailingHeaders().get(HttpHeadersTestUtils.of("X-Test")));
        Assertions.assertEquals((Object)DecoderResult.SUCCESS, (Object)res.decoderResult());
        MatcherAssert.assertThat((Object)ch.readOutbound(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
    }

    @Test
    public void test100Continue() throws Exception {
        FullHttpRequest request = HttpContentCompressorTest.newRequest();
        HttpUtil.set100ContinueExpected((HttpMessage)request, (boolean)true);
        EmbeddedChannel ch = new EmbeddedChannel(new ChannelHandler[]{new HttpContentCompressor()});
        ch.writeInbound(new Object[]{request});
        DefaultFullHttpResponse continueResponse = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.CONTINUE, Unpooled.EMPTY_BUFFER);
        ch.writeOutbound(new Object[]{continueResponse});
        DefaultFullHttpResponse res = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK, Unpooled.EMPTY_BUFFER);
        res.trailingHeaders().set(HttpHeadersTestUtils.of("X-Test"), (Object)HttpHeadersTestUtils.of("Netty"));
        ch.writeOutbound(new Object[]{res});
        Object o = ch.readOutbound();
        MatcherAssert.assertThat((Object)o, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(FullHttpResponse.class)));
        res = (FullHttpResponse)o;
        Assertions.assertSame((Object)continueResponse, (Object)res);
        res.release();
        o = ch.readOutbound();
        MatcherAssert.assertThat((Object)o, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(FullHttpResponse.class)));
        res = (FullHttpResponse)o;
        MatcherAssert.assertThat((Object)res.headers().get((CharSequence)HttpHeaderNames.TRANSFER_ENCODING), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
        MatcherAssert.assertThat((Object)res.headers().get((CharSequence)HttpHeaderNames.CONTENT_ENCODING), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
        MatcherAssert.assertThat((Object)res.content().readableBytes(), (Matcher)CoreMatchers.is((Object)0));
        MatcherAssert.assertThat((Object)res.content().toString(CharsetUtil.US_ASCII), (Matcher)CoreMatchers.is((Object)""));
        Assertions.assertEquals((Object)"Netty", (Object)res.trailingHeaders().get(HttpHeadersTestUtils.of("X-Test")));
        Assertions.assertEquals((Object)DecoderResult.SUCCESS, (Object)res.decoderResult());
        MatcherAssert.assertThat((Object)ch.readOutbound(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
    }

    @Test
    public void testMultiple1xxInformationalResponse() throws Exception {
        FullHttpRequest request = HttpContentCompressorTest.newRequest();
        HttpUtil.set100ContinueExpected((HttpMessage)request, (boolean)true);
        EmbeddedChannel ch = new EmbeddedChannel(new ChannelHandler[]{new HttpContentCompressor()});
        ch.writeInbound(new Object[]{request});
        DefaultFullHttpResponse continueResponse = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.CONTINUE, Unpooled.EMPTY_BUFFER);
        ch.writeOutbound(new Object[]{continueResponse});
        DefaultFullHttpResponse earlyHintsResponse = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.EARLY_HINTS, Unpooled.EMPTY_BUFFER);
        earlyHintsResponse.trailingHeaders().set(HttpHeadersTestUtils.of("X-Test"), (Object)HttpHeadersTestUtils.of("Netty"));
        ch.writeOutbound(new Object[]{earlyHintsResponse});
        DefaultFullHttpResponse res = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK, Unpooled.EMPTY_BUFFER);
        res.trailingHeaders().set(HttpHeadersTestUtils.of("X-Test"), (Object)HttpHeadersTestUtils.of("Netty"));
        ch.writeOutbound(new Object[]{res});
        Object o = ch.readOutbound();
        MatcherAssert.assertThat((Object)o, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(FullHttpResponse.class)));
        res = (FullHttpResponse)o;
        Assertions.assertSame((Object)continueResponse, (Object)res);
        res.release();
        o = ch.readOutbound();
        MatcherAssert.assertThat((Object)o, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(FullHttpResponse.class)));
        res = (FullHttpResponse)o;
        Assertions.assertSame((Object)earlyHintsResponse, (Object)res);
        res.release();
        o = ch.readOutbound();
        MatcherAssert.assertThat((Object)o, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(FullHttpResponse.class)));
        res = (FullHttpResponse)o;
        MatcherAssert.assertThat((Object)res.headers().get((CharSequence)HttpHeaderNames.TRANSFER_ENCODING), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
        MatcherAssert.assertThat((Object)res.headers().get((CharSequence)HttpHeaderNames.CONTENT_ENCODING), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
        MatcherAssert.assertThat((Object)res.content().readableBytes(), (Matcher)CoreMatchers.is((Object)0));
        MatcherAssert.assertThat((Object)res.content().toString(CharsetUtil.US_ASCII), (Matcher)CoreMatchers.is((Object)""));
        Assertions.assertEquals((Object)"Netty", (Object)res.trailingHeaders().get(HttpHeadersTestUtils.of("X-Test")));
        Assertions.assertEquals((Object)DecoderResult.SUCCESS, (Object)res.decoderResult());
        MatcherAssert.assertThat((Object)ch.readOutbound(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
        Assertions.assertTrue((boolean)ch.finishAndReleaseAll());
    }

    @Test
    public void test103EarlyHintsResponse() throws Exception {
        FullHttpRequest request = HttpContentCompressorTest.newRequest();
        EmbeddedChannel ch = new EmbeddedChannel(new ChannelHandler[]{new HttpContentCompressor()});
        ch.writeInbound(new Object[]{request});
        DefaultFullHttpResponse earlyHintsResponse = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.EARLY_HINTS, Unpooled.EMPTY_BUFFER);
        earlyHintsResponse.trailingHeaders().set(HttpHeadersTestUtils.of("X-Test"), (Object)HttpHeadersTestUtils.of("Netty"));
        ch.writeOutbound(new Object[]{earlyHintsResponse});
        DefaultFullHttpResponse res = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK, Unpooled.EMPTY_BUFFER);
        res.trailingHeaders().set(HttpHeadersTestUtils.of("X-Test"), (Object)HttpHeadersTestUtils.of("Netty"));
        ch.writeOutbound(new Object[]{res});
        Object o = ch.readOutbound();
        MatcherAssert.assertThat((Object)o, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(FullHttpResponse.class)));
        res = (FullHttpResponse)o;
        Assertions.assertSame((Object)earlyHintsResponse, (Object)res);
        res.release();
        o = ch.readOutbound();
        MatcherAssert.assertThat((Object)o, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(FullHttpResponse.class)));
        res = (FullHttpResponse)o;
        MatcherAssert.assertThat((Object)res.headers().get((CharSequence)HttpHeaderNames.TRANSFER_ENCODING), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
        MatcherAssert.assertThat((Object)res.headers().get((CharSequence)HttpHeaderNames.CONTENT_ENCODING), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
        MatcherAssert.assertThat((Object)res.content().readableBytes(), (Matcher)CoreMatchers.is((Object)0));
        MatcherAssert.assertThat((Object)res.content().toString(CharsetUtil.US_ASCII), (Matcher)CoreMatchers.is((Object)""));
        Assertions.assertEquals((Object)"Netty", (Object)res.trailingHeaders().get(HttpHeadersTestUtils.of("X-Test")));
        Assertions.assertEquals((Object)DecoderResult.SUCCESS, (Object)res.decoderResult());
        MatcherAssert.assertThat((Object)ch.readOutbound(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
        Assertions.assertTrue((boolean)ch.finishAndReleaseAll());
    }

    @Test
    public void testTooManyResponses() throws Exception {
        Object message;
        FullHttpRequest request = HttpContentCompressorTest.newRequest();
        EmbeddedChannel ch = new EmbeddedChannel(new ChannelHandler[]{new HttpContentCompressor()});
        ch.writeInbound(new Object[]{request});
        ch.writeOutbound(new Object[]{new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK, Unpooled.EMPTY_BUFFER)});
        try {
            ch.writeOutbound(new Object[]{new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK, Unpooled.EMPTY_BUFFER)});
            Assertions.fail();
        }
        catch (EncoderException e) {
            Assertions.assertTrue((boolean)(e.getCause() instanceof IllegalStateException));
        }
        Assertions.assertTrue((boolean)ch.finish());
        while ((message = ch.readOutbound()) != null) {
            ReferenceCountUtil.release((Object)message);
        }
        while ((message = ch.readInbound()) != null) {
            ReferenceCountUtil.release((Object)message);
        }
    }

    @Test
    public void testIdentity() throws Exception {
        EmbeddedChannel ch = new EmbeddedChannel(new ChannelHandler[]{new HttpContentCompressor()});
        Assertions.assertTrue((boolean)ch.writeInbound(new Object[]{HttpContentCompressorTest.newRequest()}));
        DefaultFullHttpResponse res = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK, Unpooled.copiedBuffer((CharSequence)"Hello, World", (Charset)CharsetUtil.US_ASCII));
        int len = res.content().readableBytes();
        res.headers().set((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (Object)len);
        res.headers().set((CharSequence)HttpHeaderNames.CONTENT_ENCODING, (Object)HttpHeaderValues.IDENTITY);
        Assertions.assertTrue((boolean)ch.writeOutbound(new Object[]{res}));
        FullHttpResponse response = (FullHttpResponse)ch.readOutbound();
        Assertions.assertEquals((Object)String.valueOf(len), (Object)response.headers().get((CharSequence)HttpHeaderNames.CONTENT_LENGTH));
        Assertions.assertEquals((Object)HttpHeaderValues.IDENTITY.toString(), (Object)response.headers().get((CharSequence)HttpHeaderNames.CONTENT_ENCODING));
        Assertions.assertEquals((Object)"Hello, World", (Object)response.content().toString(CharsetUtil.US_ASCII));
        response.release();
        Assertions.assertTrue((boolean)ch.finishAndReleaseAll());
    }

    @Test
    public void testCustomEncoding() throws Exception {
        EmbeddedChannel ch = new EmbeddedChannel(new ChannelHandler[]{new HttpContentCompressor()});
        Assertions.assertTrue((boolean)ch.writeInbound(new Object[]{HttpContentCompressorTest.newRequest()}));
        DefaultFullHttpResponse res = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK, Unpooled.copiedBuffer((CharSequence)"Hello, World", (Charset)CharsetUtil.US_ASCII));
        int len = res.content().readableBytes();
        res.headers().set((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (Object)len);
        res.headers().set((CharSequence)HttpHeaderNames.CONTENT_ENCODING, (Object)"ascii");
        Assertions.assertTrue((boolean)ch.writeOutbound(new Object[]{res}));
        FullHttpResponse response = (FullHttpResponse)ch.readOutbound();
        Assertions.assertEquals((Object)String.valueOf(len), (Object)response.headers().get((CharSequence)HttpHeaderNames.CONTENT_LENGTH));
        Assertions.assertEquals((Object)"ascii", (Object)response.headers().get((CharSequence)HttpHeaderNames.CONTENT_ENCODING));
        Assertions.assertEquals((Object)"Hello, World", (Object)response.content().toString(CharsetUtil.US_ASCII));
        response.release();
        Assertions.assertTrue((boolean)ch.finishAndReleaseAll());
    }

    static boolean isBrotliAvailable() {
        return Brotli.isAvailable();
    }

    @Test
    @EnabledIf(value="isBrotliAvailable")
    public void testBrotliFullHttpResponse() throws Exception {
        HttpContent content;
        HttpContentCompressor compressor = new HttpContentCompressor((CompressionOptions[])null);
        EmbeddedChannel ch = new EmbeddedChannel(new ChannelHandler[]{compressor});
        Assertions.assertTrue((boolean)ch.writeInbound(new Object[]{HttpContentCompressorTest.newBrotliRequest()}));
        DefaultFullHttpResponse res = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK, Unpooled.copiedBuffer((CharSequence)"Hello Hello Hello Hello Hello", (Charset)CharsetUtil.US_ASCII));
        int len = res.content().readableBytes();
        res.headers().set((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (Object)len);
        res.headers().set((CharSequence)HttpHeaderNames.CONTENT_TYPE, (Object)"text/plain");
        Assertions.assertTrue((boolean)ch.writeOutbound(new Object[]{res}));
        DefaultHttpResponse response = (DefaultHttpResponse)ch.readOutbound();
        Assertions.assertEquals((Object)String.valueOf(19), (Object)response.headers().get((CharSequence)HttpHeaderNames.CONTENT_LENGTH));
        Assertions.assertEquals((Object)"text/plain", (Object)response.headers().get((CharSequence)HttpHeaderNames.CONTENT_TYPE));
        Assertions.assertEquals((Object)"br", (Object)response.headers().get((CharSequence)HttpHeaderNames.CONTENT_ENCODING));
        CompositeByteBuf contentBuf = Unpooled.compositeBuffer();
        while ((content = (HttpContent)ch.readOutbound()) != null) {
            if (content.content().isReadable()) {
                contentBuf.addComponent(true, content.content());
                continue;
            }
            content.content().release();
        }
        DirectDecompress decompressResult = DirectDecompress.decompress((byte[])ByteBufUtil.getBytes((ByteBuf)contentBuf));
        Assertions.assertEquals((Object)DecoderJNI.Status.DONE, (Object)decompressResult.getResultStatus());
        Assertions.assertEquals((Object)"Hello Hello Hello Hello Hello", (Object)new String(decompressResult.getDecompressedData(), CharsetUtil.US_ASCII));
        Assertions.assertTrue((boolean)ch.finishAndReleaseAll());
        contentBuf.release();
    }

    @Test
    @EnabledIf(value="isBrotliAvailable")
    public void testBrotliChunkedContent() throws Exception {
        HttpContent content;
        HttpContentCompressor compressor = new HttpContentCompressor((CompressionOptions[])null);
        EmbeddedChannel ch = new EmbeddedChannel(new ChannelHandler[]{compressor});
        Assertions.assertTrue((boolean)ch.writeInbound(new Object[]{HttpContentCompressorTest.newBrotliRequest()}));
        DefaultHttpResponse res = new DefaultHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK);
        res.headers().set((CharSequence)HttpHeaderNames.TRANSFER_ENCODING, (Object)HttpHeaderValues.CHUNKED);
        res.headers().set((CharSequence)HttpHeaderNames.CONTENT_TYPE, (Object)"text/plain");
        ch.writeOutbound(new Object[]{res});
        HttpResponse outboundRes = (HttpResponse)ch.readOutbound();
        MatcherAssert.assertThat((Object)outboundRes, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.not((Matcher)CoreMatchers.instanceOf(HttpContent.class))));
        MatcherAssert.assertThat((Object)outboundRes.headers().get((CharSequence)HttpHeaderNames.TRANSFER_ENCODING), (Matcher)CoreMatchers.is((Object)"chunked"));
        MatcherAssert.assertThat((Object)outboundRes.headers().get((CharSequence)HttpHeaderNames.CONTENT_LENGTH), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
        MatcherAssert.assertThat((Object)outboundRes.headers().get((CharSequence)HttpHeaderNames.CONTENT_ENCODING), (Matcher)CoreMatchers.is((Object)"br"));
        MatcherAssert.assertThat((Object)outboundRes.headers().get((CharSequence)HttpHeaderNames.CONTENT_TYPE), (Matcher)CoreMatchers.is((Object)"text/plain"));
        ch.writeOutbound(new Object[]{new DefaultHttpContent(Unpooled.copiedBuffer((CharSequence)"Hell", (Charset)CharsetUtil.US_ASCII))});
        ch.writeOutbound(new Object[]{new DefaultHttpContent(Unpooled.copiedBuffer((CharSequence)"o world. Hello w", (Charset)CharsetUtil.US_ASCII))});
        ch.writeOutbound(new Object[]{new DefaultLastHttpContent(Unpooled.copiedBuffer((CharSequence)"orld.", (Charset)CharsetUtil.US_ASCII))});
        CompositeByteBuf contentBuf = Unpooled.compositeBuffer();
        while ((content = (HttpContent)ch.readOutbound()) != null) {
            if (content.content().isReadable()) {
                contentBuf.addComponent(true, content.content());
                continue;
            }
            content.content().release();
        }
        DirectDecompress decompressResult = DirectDecompress.decompress((byte[])ByteBufUtil.getBytes((ByteBuf)contentBuf));
        Assertions.assertEquals((Object)DecoderJNI.Status.DONE, (Object)decompressResult.getResultStatus());
        Assertions.assertEquals((Object)"Hello world. Hello world.", (Object)new String(decompressResult.getDecompressedData(), CharsetUtil.US_ASCII));
        Assertions.assertTrue((boolean)ch.finishAndReleaseAll());
        contentBuf.release();
    }

    @Test
    public void testCompressThresholdAllCompress() throws Exception {
        EmbeddedChannel ch = new EmbeddedChannel(new ChannelHandler[]{new HttpContentCompressor()});
        Assertions.assertTrue((boolean)ch.writeInbound(new Object[]{HttpContentCompressorTest.newRequest()}));
        DefaultFullHttpResponse res1023 = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK, Unpooled.wrappedBuffer((byte[])new byte[1023]));
        Assertions.assertTrue((boolean)ch.writeOutbound(new Object[]{res1023}));
        DefaultHttpResponse response1023 = (DefaultHttpResponse)ch.readOutbound();
        MatcherAssert.assertThat((Object)response1023.headers().get((CharSequence)HttpHeaderNames.CONTENT_ENCODING), (Matcher)CoreMatchers.is((Object)"gzip"));
        ch.releaseOutbound();
        Assertions.assertTrue((boolean)ch.writeInbound(new Object[]{HttpContentCompressorTest.newRequest()}));
        DefaultFullHttpResponse res1024 = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK, Unpooled.wrappedBuffer((byte[])new byte[1024]));
        Assertions.assertTrue((boolean)ch.writeOutbound(new Object[]{res1024}));
        DefaultHttpResponse response1024 = (DefaultHttpResponse)ch.readOutbound();
        MatcherAssert.assertThat((Object)response1024.headers().get((CharSequence)HttpHeaderNames.CONTENT_ENCODING), (Matcher)CoreMatchers.is((Object)"gzip"));
        Assertions.assertTrue((boolean)ch.finishAndReleaseAll());
    }

    @Test
    public void testCompressThresholdNotCompress() throws Exception {
        EmbeddedChannel ch = new EmbeddedChannel(new ChannelHandler[]{new HttpContentCompressor(6, 15, 8, 1024)});
        Assertions.assertTrue((boolean)ch.writeInbound(new Object[]{HttpContentCompressorTest.newRequest()}));
        DefaultFullHttpResponse res1023 = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK, Unpooled.wrappedBuffer((byte[])new byte[1023]));
        Assertions.assertTrue((boolean)ch.writeOutbound(new Object[]{res1023}));
        DefaultHttpResponse response1023 = (DefaultHttpResponse)ch.readOutbound();
        Assertions.assertFalse((boolean)response1023.headers().contains((CharSequence)HttpHeaderNames.CONTENT_ENCODING));
        ch.releaseOutbound();
        Assertions.assertTrue((boolean)ch.writeInbound(new Object[]{HttpContentCompressorTest.newRequest()}));
        DefaultFullHttpResponse res1024 = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK, Unpooled.wrappedBuffer((byte[])new byte[1024]));
        Assertions.assertTrue((boolean)ch.writeOutbound(new Object[]{res1024}));
        DefaultHttpResponse response1024 = (DefaultHttpResponse)ch.readOutbound();
        MatcherAssert.assertThat((Object)response1024.headers().get((CharSequence)HttpHeaderNames.CONTENT_ENCODING), (Matcher)CoreMatchers.is((Object)"gzip"));
        Assertions.assertTrue((boolean)ch.finishAndReleaseAll());
    }

    @Test
    public void testMultipleAcceptEncodingHeaders() {
        FullHttpRequest request = HttpContentCompressorTest.newRequest();
        request.headers().set((CharSequence)HttpHeaderNames.ACCEPT_ENCODING, (Object)"unknown; q=1.0").add((CharSequence)HttpHeaderNames.ACCEPT_ENCODING, (Object)"gzip; q=0.5").add((CharSequence)HttpHeaderNames.ACCEPT_ENCODING, (Object)"deflate; q=0");
        EmbeddedChannel ch = new EmbeddedChannel(new ChannelHandler[]{new HttpContentCompressor()});
        Assertions.assertTrue((boolean)ch.writeInbound(new Object[]{request}));
        DefaultFullHttpResponse res = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK, Unpooled.copiedBuffer((CharSequence)"Gzip Win", (Charset)CharsetUtil.US_ASCII));
        Assertions.assertTrue((boolean)ch.writeOutbound(new Object[]{res}));
        HttpContentCompressorTest.assertEncodedResponse(ch);
        HttpContent c = (HttpContent)ch.readOutbound();
        MatcherAssert.assertThat((Object)ByteBufUtil.hexDump((ByteBuf)c.content()), (Matcher)CoreMatchers.is((Object)"1f8b080000000000000072afca2c5008cfcc03000000ffff"));
        c.release();
        c = (HttpContent)ch.readOutbound();
        MatcherAssert.assertThat((Object)ByteBufUtil.hexDump((ByteBuf)c.content()), (Matcher)CoreMatchers.is((Object)"03001f2ebf0f08000000"));
        c.release();
        LastHttpContent last = (LastHttpContent)ch.readOutbound();
        MatcherAssert.assertThat((Object)last.content().readableBytes(), (Matcher)CoreMatchers.is((Object)0));
        last.release();
        MatcherAssert.assertThat((Object)ch.readOutbound(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
        Assertions.assertTrue((boolean)ch.finishAndReleaseAll());
    }

    private static FullHttpRequest newRequest() {
        DefaultFullHttpRequest req = new DefaultFullHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.GET, "/");
        req.headers().set((CharSequence)HttpHeaderNames.ACCEPT_ENCODING, (Object)"gzip");
        return req;
    }

    private static FullHttpRequest newBrotliRequest() {
        DefaultFullHttpRequest req = new DefaultFullHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.GET, "/");
        req.headers().set((CharSequence)HttpHeaderNames.ACCEPT_ENCODING, (Object)"br");
        return req;
    }

    private static void assertEncodedResponse(EmbeddedChannel ch) {
        Object o = ch.readOutbound();
        MatcherAssert.assertThat((Object)o, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(HttpResponse.class)));
        HttpContentCompressorTest.assertEncodedResponse((HttpResponse)o);
    }

    private static void assertEncodedResponse(HttpResponse res) {
        MatcherAssert.assertThat((Object)res, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.not((Matcher)CoreMatchers.instanceOf(HttpContent.class))));
        MatcherAssert.assertThat((Object)res.headers().get((CharSequence)HttpHeaderNames.TRANSFER_ENCODING), (Matcher)CoreMatchers.is((Object)"chunked"));
        MatcherAssert.assertThat((Object)res.headers().get((CharSequence)HttpHeaderNames.CONTENT_LENGTH), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
        MatcherAssert.assertThat((Object)res.headers().get((CharSequence)HttpHeaderNames.CONTENT_ENCODING), (Matcher)CoreMatchers.is((Object)"gzip"));
    }

    private static void assertAssembledEncodedResponse(EmbeddedChannel ch) {
        Object o = ch.readOutbound();
        MatcherAssert.assertThat((Object)o, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(AssembledHttpResponse.class)));
        AssembledHttpResponse res = (AssembledHttpResponse)((Object)o);
        try {
            MatcherAssert.assertThat((Object)((Object)res), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(HttpContent.class)));
            MatcherAssert.assertThat((Object)res.headers().get((CharSequence)HttpHeaderNames.TRANSFER_ENCODING), (Matcher)CoreMatchers.is((Object)"chunked"));
            MatcherAssert.assertThat((Object)res.headers().get((CharSequence)HttpHeaderNames.CONTENT_LENGTH), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
            MatcherAssert.assertThat((Object)res.headers().get((CharSequence)HttpHeaderNames.CONTENT_ENCODING), (Matcher)CoreMatchers.is((Object)"gzip"));
        }
        finally {
            res.release();
        }
    }

    static class AssembledHttpResponse
    extends DefaultHttpResponse
    implements HttpContent {
        private final ByteBuf content;

        AssembledHttpResponse(HttpVersion version, HttpResponseStatus status, ByteBuf content) {
            super(version, status);
            this.content = content;
        }

        public HttpContent copy() {
            throw new UnsupportedOperationException();
        }

        public HttpContent duplicate() {
            throw new UnsupportedOperationException();
        }

        public HttpContent retainedDuplicate() {
            throw new UnsupportedOperationException();
        }

        public HttpContent replace(ByteBuf content) {
            throw new UnsupportedOperationException();
        }

        public AssembledHttpResponse retain() {
            this.content.retain();
            return this;
        }

        public AssembledHttpResponse retain(int increment) {
            this.content.retain(increment);
            return this;
        }

        public ByteBuf content() {
            return this.content;
        }

        public int refCnt() {
            return this.content.refCnt();
        }

        public boolean release() {
            return this.content.release();
        }

        public boolean release(int decrement) {
            return this.content.release(decrement);
        }

        public AssembledHttpResponse touch() {
            this.content.touch();
            return this;
        }

        public AssembledHttpResponse touch(Object hint) {
            this.content.touch(hint);
            return this;
        }
    }
}

