/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http.websocketx;

import io.netty.handler.codec.http.DefaultFullHttpRequest;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.websocketx.WebSocketVersion;

public class WebSocketRequestBuilder {
    private HttpVersion httpVersion;
    private HttpMethod method;
    private String uri;
    private String host;
    private String upgrade;
    private String connection;
    private String key;
    private String origin;
    private WebSocketVersion version;

    public WebSocketRequestBuilder httpVersion(HttpVersion httpVersion) {
        this.httpVersion = httpVersion;
        return this;
    }

    public WebSocketRequestBuilder method(HttpMethod method) {
        this.method = method;
        return this;
    }

    public WebSocketRequestBuilder uri(CharSequence uri) {
        this.uri = uri == null ? null : uri.toString();
        return this;
    }

    public WebSocketRequestBuilder host(CharSequence host) {
        this.host = host == null ? null : host.toString();
        return this;
    }

    public WebSocketRequestBuilder upgrade(CharSequence upgrade) {
        this.upgrade = upgrade == null ? null : upgrade.toString();
        return this;
    }

    public WebSocketRequestBuilder connection(CharSequence connection) {
        this.connection = connection == null ? null : connection.toString();
        return this;
    }

    public WebSocketRequestBuilder key(CharSequence key) {
        this.key = key == null ? null : key.toString();
        return this;
    }

    public WebSocketRequestBuilder origin(CharSequence origin) {
        this.origin = origin == null ? null : origin.toString();
        return this;
    }

    public WebSocketRequestBuilder version13() {
        this.version = WebSocketVersion.V13;
        return this;
    }

    public WebSocketRequestBuilder version8() {
        this.version = WebSocketVersion.V08;
        return this;
    }

    public WebSocketRequestBuilder version00() {
        this.version = null;
        return this;
    }

    public WebSocketRequestBuilder noVersion() {
        return this;
    }

    public FullHttpRequest build() {
        DefaultFullHttpRequest req = new DefaultFullHttpRequest(this.httpVersion, this.method, this.uri);
        HttpHeaders headers = req.headers();
        if (this.host != null) {
            headers.set((CharSequence)HttpHeaderNames.HOST, (Object)this.host);
        }
        if (this.upgrade != null) {
            headers.set((CharSequence)HttpHeaderNames.UPGRADE, (Object)this.upgrade);
        }
        if (this.connection != null) {
            headers.set((CharSequence)HttpHeaderNames.CONNECTION, (Object)this.connection);
        }
        if (this.key != null) {
            headers.set((CharSequence)HttpHeaderNames.SEC_WEBSOCKET_KEY, (Object)this.key);
        }
        if (this.origin != null) {
            if (this.version == WebSocketVersion.V13 || this.version == WebSocketVersion.V00) {
                headers.set((CharSequence)HttpHeaderNames.ORIGIN, (Object)this.origin);
            } else {
                headers.set((CharSequence)HttpHeaderNames.SEC_WEBSOCKET_ORIGIN, (Object)this.origin);
            }
        }
        if (this.version != null) {
            headers.set((CharSequence)HttpHeaderNames.SEC_WEBSOCKET_VERSION, (Object)this.version.toHttpHeaderValue());
        }
        return req;
    }

    public static HttpRequest successful() {
        return new WebSocketRequestBuilder().httpVersion(HttpVersion.HTTP_1_1).method(HttpMethod.GET).uri("/test").host("server.example.com").upgrade((CharSequence)HttpHeaderValues.WEBSOCKET).connection((CharSequence)HttpHeaderValues.UPGRADE).key("dGhlIHNhbXBsZSBub25jZQ==").origin("http://example.com").version13().build();
    }
}

