/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http.websocketx;

import io.netty.channel.Channel;
import io.netty.channel.embedded.EmbeddedChannel;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpUtil;
import io.netty.handler.codec.http.websocketx.WebSocketServerHandshakerFactory;
import io.netty.handler.codec.http.websocketx.WebSocketVersion;
import io.netty.util.ReferenceCountUtil;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class WebSocketServerHandshakerFactoryTest {
    @Test
    public void testUnsupportedVersion() throws Exception {
        EmbeddedChannel ch = new EmbeddedChannel();
        WebSocketServerHandshakerFactory.sendUnsupportedVersionResponse((Channel)ch);
        ch.runPendingTasks();
        Object msg = ch.readOutbound();
        if (!(msg instanceof FullHttpResponse)) {
            Assertions.fail((String)("Got wrong response " + msg));
        }
        FullHttpResponse response = (FullHttpResponse)msg;
        Assertions.assertEquals((Object)HttpResponseStatus.UPGRADE_REQUIRED, (Object)response.status());
        Assertions.assertEquals((Object)WebSocketVersion.V13.toHttpHeaderValue(), (Object)response.headers().get((CharSequence)HttpHeaderNames.SEC_WEBSOCKET_VERSION));
        Assertions.assertTrue((boolean)HttpUtil.isContentLengthSet((HttpMessage)response));
        Assertions.assertEquals((long)0L, (long)HttpUtil.getContentLength((HttpMessage)response));
        ReferenceCountUtil.release((Object)response);
        Assertions.assertFalse((boolean)ch.finish());
    }
}

