/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.handler.codec.http.DefaultHttpContent;
import io.netty.handler.codec.http.DefaultHttpHeaders;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.LastHttpContent;
import io.netty.util.internal.StringUtil;
import java.util.Iterator;
import java.util.Map;

public class DefaultLastHttpContent
extends DefaultHttpContent
implements LastHttpContent {
    private final HttpHeaders trailingHeaders;
    private final boolean validateHeaders;

    public DefaultLastHttpContent() {
        this(Unpooled.buffer((int)0));
    }

    public DefaultLastHttpContent(ByteBuf content) {
        this(content, true);
    }

    public DefaultLastHttpContent(ByteBuf content, boolean validateHeaders) {
        super(content);
        this.trailingHeaders = new TrailingHttpHeaders(validateHeaders);
        this.validateHeaders = validateHeaders;
    }

    @Override
    public LastHttpContent copy() {
        DefaultLastHttpContent copy = new DefaultLastHttpContent(this.content().copy(), this.validateHeaders);
        copy.trailingHeaders().set(this.trailingHeaders());
        return copy;
    }

    @Override
    public LastHttpContent duplicate() {
        DefaultLastHttpContent copy = new DefaultLastHttpContent(this.content().duplicate(), this.validateHeaders);
        copy.trailingHeaders().set(this.trailingHeaders());
        return copy;
    }

    @Override
    public LastHttpContent retain(int increment) {
        super.retain(increment);
        return this;
    }

    @Override
    public LastHttpContent retain() {
        super.retain();
        return this;
    }

    @Override
    public LastHttpContent touch() {
        super.touch();
        return this;
    }

    @Override
    public LastHttpContent touch(Object hint) {
        super.touch(hint);
        return this;
    }

    @Override
    public HttpHeaders trailingHeaders() {
        return this.trailingHeaders;
    }

    @Override
    public String toString() {
        StringBuilder buf = new StringBuilder(super.toString());
        buf.append(StringUtil.NEWLINE);
        this.appendHeaders(buf);
        buf.setLength(buf.length() - StringUtil.NEWLINE.length());
        return buf.toString();
    }

    private void appendHeaders(StringBuilder buf) {
        Iterator i$ = this.trailingHeaders().iterator();
        while (i$.hasNext()) {
            Map.Entry e = (Map.Entry)i$.next();
            buf.append((CharSequence)e.getKey());
            buf.append(": ");
            buf.append((CharSequence)e.getValue());
            buf.append(StringUtil.NEWLINE);
        }
    }

    private static final class TrailingHttpHeaders
    extends DefaultHttpHeaders {
        private static final TrailingHttpHeadersNameConverter VALIDATE_NAME_CONVERTER = new TrailingHttpHeadersNameConverter(true);
        private static final TrailingHttpHeadersNameConverter NO_VALIDATE_NAME_CONVERTER = new TrailingHttpHeadersNameConverter(false);

        TrailingHttpHeaders(boolean validate) {
            super(validate, validate ? VALIDATE_NAME_CONVERTER : NO_VALIDATE_NAME_CONVERTER, false);
        }

        private static final class TrailingHttpHeadersNameConverter
        extends DefaultHttpHeaders.HttpHeadersNameConverter {
            TrailingHttpHeadersNameConverter(boolean validate) {
                super(validate);
            }

            @Override
            public CharSequence convertName(CharSequence name) {
                name = super.convertName(name);
                if (this.validate && (HttpHeaderNames.CONTENT_LENGTH.equalsIgnoreCase(name) || HttpHeaderNames.TRANSFER_ENCODING.equalsIgnoreCase(name) || HttpHeaderNames.TRAILER.equalsIgnoreCase(name))) {
                    throw new IllegalArgumentException("prohibited trailing header: " + name);
                }
                return name;
            }
        }
    }
}

