/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http2;

import io.netty.handler.codec.BinaryHeaders;
import io.netty.util.ByteString;
import io.netty.util.CharsetUtil;
import java.util.HashSet;
import java.util.Set;

public interface Http2Headers
extends BinaryHeaders {
    public Http2Headers add(ByteString var1, ByteString var2);

    public Http2Headers add(ByteString var1, Iterable<? extends ByteString> var2);

    public Http2Headers add(ByteString var1, ByteString ... var2);

    public Http2Headers addObject(ByteString var1, Object var2);

    public Http2Headers addObject(ByteString var1, Iterable<?> var2);

    public Http2Headers addObject(ByteString var1, Object ... var2);

    public Http2Headers addBoolean(ByteString var1, boolean var2);

    public Http2Headers addByte(ByteString var1, byte var2);

    public Http2Headers addChar(ByteString var1, char var2);

    public Http2Headers addShort(ByteString var1, short var2);

    public Http2Headers addInt(ByteString var1, int var2);

    public Http2Headers addLong(ByteString var1, long var2);

    public Http2Headers addFloat(ByteString var1, float var2);

    public Http2Headers addDouble(ByteString var1, double var2);

    public Http2Headers addTimeMillis(ByteString var1, long var2);

    public Http2Headers add(BinaryHeaders var1);

    public Http2Headers set(ByteString var1, ByteString var2);

    public Http2Headers set(ByteString var1, Iterable<? extends ByteString> var2);

    public Http2Headers set(ByteString var1, ByteString ... var2);

    public Http2Headers setObject(ByteString var1, Object var2);

    public Http2Headers setObject(ByteString var1, Iterable<?> var2);

    public Http2Headers setObject(ByteString var1, Object ... var2);

    public Http2Headers setBoolean(ByteString var1, boolean var2);

    public Http2Headers setByte(ByteString var1, byte var2);

    public Http2Headers setChar(ByteString var1, char var2);

    public Http2Headers setShort(ByteString var1, short var2);

    public Http2Headers setInt(ByteString var1, int var2);

    public Http2Headers setLong(ByteString var1, long var2);

    public Http2Headers setFloat(ByteString var1, float var2);

    public Http2Headers setDouble(ByteString var1, double var2);

    public Http2Headers setTimeMillis(ByteString var1, long var2);

    public Http2Headers set(BinaryHeaders var1);

    public Http2Headers setAll(BinaryHeaders var1);

    public Http2Headers clear();

    public Http2Headers method(ByteString var1);

    public Http2Headers scheme(ByteString var1);

    public Http2Headers authority(ByteString var1);

    public Http2Headers path(ByteString var1);

    public Http2Headers status(ByteString var1);

    public ByteString method();

    public ByteString scheme();

    public ByteString authority();

    public ByteString path();

    public ByteString status();

    public static enum PseudoHeaderName {
        METHOD(":method"),
        SCHEME(":scheme"),
        AUTHORITY(":authority"),
        PATH(":path"),
        STATUS(":status");

        private final ByteString value;
        private static final Set<ByteString> PSEUDO_HEADERS;

        private PseudoHeaderName(String value) {
            this.value = new ByteString((CharSequence)value, CharsetUtil.UTF_8);
        }

        public ByteString value() {
            return this.value;
        }

        public static boolean isPseudoHeader(ByteString header) {
            return PSEUDO_HEADERS.contains(header);
        }

        static {
            PSEUDO_HEADERS = new HashSet<ByteString>();
            for (PseudoHeaderName pseudoHeader : PseudoHeaderName.values()) {
                PSEUDO_HEADERS.add(pseudoHeader.value());
            }
        }
    }
}

