/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http2;

import io.netty.handler.codec.http.DefaultFullHttpRequest;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.FullHttpMessage;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpScheme;
import io.netty.handler.codec.http.HttpUtil;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http2.DefaultHttp2Headers;
import io.netty.handler.codec.http2.EmptyHttp2Headers;
import io.netty.handler.codec.http2.Http2Error;
import io.netty.handler.codec.http2.Http2Exception;
import io.netty.handler.codec.http2.Http2Headers;
import io.netty.util.AsciiString;
import io.netty.util.ByteString;
import io.netty.util.internal.ObjectUtil;
import io.netty.util.internal.StringUtil;
import java.net.URI;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public final class HttpConversionUtil {
    private static final Set<CharSequence> HTTP_TO_HTTP2_HEADER_BLACKLIST = new HashSet<CharSequence>(){
        private static final long serialVersionUID = -5678614530214167043L;
        {
            this.add(HttpHeaderNames.CONNECTION);
            this.add(HttpHeaderNames.KEEP_ALIVE);
            this.add(HttpHeaderNames.PROXY_CONNECTION);
            this.add(HttpHeaderNames.TRANSFER_ENCODING);
            this.add(HttpHeaderNames.HOST);
            this.add(HttpHeaderNames.UPGRADE);
            this.add(ExtensionHeaderNames.STREAM_ID.text());
            this.add(ExtensionHeaderNames.AUTHORITY.text());
            this.add(ExtensionHeaderNames.SCHEME.text());
            this.add(ExtensionHeaderNames.PATH.text());
        }
    };
    public static final HttpMethod OUT_OF_MESSAGE_SEQUENCE_METHOD = HttpMethod.OPTIONS;
    public static final String OUT_OF_MESSAGE_SEQUENCE_PATH = "";
    public static final HttpResponseStatus OUT_OF_MESSAGE_SEQUENCE_RETURN_CODE = HttpResponseStatus.OK;
    private static final AsciiString EMPTY_REQUEST_PATH = new AsciiString((CharSequence)"/");

    private HttpConversionUtil() {
    }

    public static HttpResponseStatus parseStatus(ByteString status) throws Http2Exception {
        HttpResponseStatus result;
        try {
            result = HttpResponseStatus.parseLine((ByteString)status);
            if (result == HttpResponseStatus.SWITCHING_PROTOCOLS) {
                throw Http2Exception.connectionError(Http2Error.PROTOCOL_ERROR, "Invalid HTTP/2 status code '%d'", result.code());
            }
        }
        catch (Http2Exception e) {
            throw e;
        }
        catch (Throwable t) {
            throw Http2Exception.connectionError(Http2Error.PROTOCOL_ERROR, t, "Unrecognized HTTP status code '%s' encountered in translation to HTTP/1.x", status);
        }
        return result;
    }

    public static FullHttpResponse toHttpResponse(int streamId, Http2Headers http2Headers, boolean validateHttpHeaders) throws Http2Exception {
        HttpResponseStatus status = HttpConversionUtil.parseStatus(http2Headers.status());
        DefaultFullHttpResponse msg = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, status, validateHttpHeaders);
        HttpConversionUtil.addHttp2ToHttpHeaders(streamId, http2Headers, (FullHttpMessage)msg, false);
        return msg;
    }

    public static FullHttpRequest toHttpRequest(int streamId, Http2Headers http2Headers, boolean validateHttpHeaders) throws Http2Exception {
        ByteString method = (ByteString)ObjectUtil.checkNotNull((Object)http2Headers.method(), (String)"method header cannot be null in conversion to HTTP/1.x");
        ByteString path = (ByteString)ObjectUtil.checkNotNull((Object)http2Headers.path(), (String)"path header cannot be null in conversion to HTTP/1.x");
        DefaultFullHttpRequest msg = new DefaultFullHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.valueOf((String)method.toString()), path.toString(), validateHttpHeaders);
        HttpConversionUtil.addHttp2ToHttpHeaders(streamId, http2Headers, (FullHttpMessage)msg, false);
        return msg;
    }

    public static void addHttp2ToHttpHeaders(int streamId, Http2Headers sourceHeaders, FullHttpMessage destinationMessage, boolean addToTrailer) throws Http2Exception {
        HttpHeaders headers = addToTrailer ? destinationMessage.trailingHeaders() : destinationMessage.headers();
        boolean request = destinationMessage instanceof HttpRequest;
        Http2ToHttpHeaderTranslator translator = new Http2ToHttpHeaderTranslator(streamId, headers, request);
        try {
            Iterator<Map.Entry<ByteString, ByteString>> i$ = sourceHeaders.iterator();
            while (i$.hasNext()) {
                Map.Entry<ByteString, ByteString> entry = i$.next();
                translator.translate(entry);
            }
        }
        catch (Http2Exception ex) {
            throw ex;
        }
        catch (Throwable t) {
            throw Http2Exception.streamError(streamId, Http2Error.PROTOCOL_ERROR, t, "HTTP/2 to HTTP/1.x headers conversion error", new Object[0]);
        }
        headers.remove((CharSequence)HttpHeaderNames.TRANSFER_ENCODING);
        headers.remove((CharSequence)HttpHeaderNames.TRAILER);
        if (!addToTrailer) {
            headers.setInt((CharSequence)ExtensionHeaderNames.STREAM_ID.text(), streamId);
            HttpUtil.setKeepAlive((HttpMessage)destinationMessage, (boolean)true);
        }
    }

    public static Http2Headers toHttp2Headers(HttpMessage in) throws Exception {
        DefaultHttp2Headers out = new DefaultHttp2Headers();
        HttpHeaders inHeaders = in.headers();
        if (in instanceof HttpRequest) {
            HttpRequest request = (HttpRequest)in;
            URI requestTargetUri = URI.create(request.uri());
            out.path((ByteString)HttpConversionUtil.toHttp2Path(requestTargetUri));
            out.method((ByteString)request.method().asciiName());
            HttpConversionUtil.setHttp2Scheme(inHeaders, requestTargetUri, out);
            if (!HttpUtil.isOriginForm((URI)requestTargetUri) && !HttpUtil.isAsteriskForm((URI)requestTargetUri)) {
                String host = inHeaders.getAsString((CharSequence)HttpHeaderNames.HOST);
                if (host == null || host.isEmpty()) {
                    HttpConversionUtil.setHttp2Authority(inHeaders, requestTargetUri.getAuthority(), out);
                } else {
                    HttpConversionUtil.setHttp2Authority(inHeaders, host, out);
                }
            }
        } else if (in instanceof HttpResponse) {
            HttpResponse response = (HttpResponse)in;
            out.status((ByteString)new AsciiString((CharSequence)Integer.toString(response.status().code())));
        }
        return out.add(HttpConversionUtil.toHttp2Headers(inHeaders));
    }

    public static Http2Headers toHttp2Headers(HttpHeaders inHeaders) throws Exception {
        if (inHeaders.isEmpty()) {
            return EmptyHttp2Headers.INSTANCE;
        }
        DefaultHttp2Headers out = new DefaultHttp2Headers();
        Iterator iter = inHeaders.iteratorCharSequence();
        while (iter.hasNext()) {
            Map.Entry entry = (Map.Entry)iter.next();
            AsciiString aName = AsciiString.of((CharSequence)((CharSequence)entry.getKey())).toLowerCase();
            if (HTTP_TO_HTTP2_HEADER_BLACKLIST.contains(aName)) continue;
            AsciiString aValue = AsciiString.of((CharSequence)((CharSequence)entry.getValue()));
            if (aName.contentEqualsIgnoreCase((CharSequence)HttpHeaderNames.TE) && !aValue.contentEqualsIgnoreCase((CharSequence)HttpHeaderValues.TRAILERS)) continue;
            out.add((ByteString)aName, (ByteString)aValue);
        }
        return out;
    }

    private static AsciiString toHttp2Path(URI uri) {
        String path;
        StringBuilder pathBuilder = new StringBuilder(StringUtil.length((String)uri.getPath()) + StringUtil.length((String)uri.getQuery()) + StringUtil.length((String)uri.getFragment()) + 2);
        if (!StringUtil.isNullOrEmpty((String)uri.getPath())) {
            pathBuilder.append(uri.getPath());
        }
        if (!StringUtil.isNullOrEmpty((String)uri.getQuery())) {
            pathBuilder.append('?');
            pathBuilder.append(uri.getQuery());
        }
        if (!StringUtil.isNullOrEmpty((String)uri.getFragment())) {
            pathBuilder.append('#');
            pathBuilder.append(uri.getFragment());
        }
        return (path = pathBuilder.toString()).isEmpty() ? EMPTY_REQUEST_PATH : new AsciiString((CharSequence)path);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void setHttp2Authority(HttpHeaders in, String autority, Http2Headers out) {
        if (autority != null) {
            int endOfUserInfo = autority.indexOf(64);
            if (endOfUserInfo < 0) {
                out.authority((ByteString)new AsciiString((CharSequence)autority));
                return;
            } else {
                if (endOfUserInfo + 1 >= autority.length()) throw new IllegalArgumentException("autority: " + autority);
                out.authority((ByteString)new AsciiString((CharSequence)autority.substring(endOfUserInfo + 1)));
            }
            return;
        } else {
            String cValue = in.get((CharSequence)ExtensionHeaderNames.AUTHORITY.text());
            if (cValue == null) return;
            out.authority((ByteString)AsciiString.of((CharSequence)cValue));
        }
    }

    private static void setHttp2Scheme(HttpHeaders in, URI uri, Http2Headers out) {
        String value = uri.getScheme();
        if (value != null) {
            out.scheme((ByteString)new AsciiString((CharSequence)value));
            return;
        }
        String cValue = in.get((CharSequence)ExtensionHeaderNames.SCHEME.text());
        if (cValue != null) {
            out.scheme((ByteString)AsciiString.of((CharSequence)cValue));
            return;
        }
        if (uri.getPort() == HttpScheme.HTTPS.port()) {
            out.scheme((ByteString)HttpScheme.HTTPS.name());
        } else if (uri.getPort() == HttpScheme.HTTP.port()) {
            out.scheme((ByteString)HttpScheme.HTTP.name());
        } else {
            throw new IllegalArgumentException(":scheme must be specified. see https://tools.ietf.org/html/rfc7540#section-8.1.2.3");
        }
    }

    private static final class Http2ToHttpHeaderTranslator {
        private static final Map<ByteString, ByteString> REQUEST_HEADER_TRANSLATIONS = new HashMap<ByteString, ByteString>();
        private static final Map<ByteString, ByteString> RESPONSE_HEADER_TRANSLATIONS = new HashMap<ByteString, ByteString>();
        private final int streamId;
        private final HttpHeaders output;
        private final Map<ByteString, ByteString> translations;

        Http2ToHttpHeaderTranslator(int streamId, HttpHeaders output, boolean request) {
            this.streamId = streamId;
            this.output = output;
            this.translations = request ? REQUEST_HEADER_TRANSLATIONS : RESPONSE_HEADER_TRANSLATIONS;
        }

        public void translate(Map.Entry<ByteString, ByteString> entry) throws Http2Exception {
            ByteString name = entry.getKey();
            ByteString value = entry.getValue();
            ByteString translatedName = this.translations.get(name);
            if (translatedName != null || !Http2Headers.PseudoHeaderName.isPseudoHeader(name)) {
                if (translatedName == null) {
                    translatedName = name;
                }
                if (translatedName.isEmpty() || translatedName.byteAt(0) == 58) {
                    throw Http2Exception.streamError(this.streamId, Http2Error.PROTOCOL_ERROR, "Invalid HTTP/2 header '%s' encountered in translation to HTTP/1.x", translatedName);
                }
                this.output.add((CharSequence)new AsciiString(translatedName, false), (Object)new AsciiString(value, false));
            }
        }

        static {
            RESPONSE_HEADER_TRANSLATIONS.put(Http2Headers.PseudoHeaderName.AUTHORITY.value(), (ByteString)ExtensionHeaderNames.AUTHORITY.text());
            RESPONSE_HEADER_TRANSLATIONS.put(Http2Headers.PseudoHeaderName.SCHEME.value(), (ByteString)ExtensionHeaderNames.SCHEME.text());
            REQUEST_HEADER_TRANSLATIONS.putAll(RESPONSE_HEADER_TRANSLATIONS);
            RESPONSE_HEADER_TRANSLATIONS.put(Http2Headers.PseudoHeaderName.PATH.value(), (ByteString)ExtensionHeaderNames.PATH.text());
        }
    }

    public static enum ExtensionHeaderNames {
        STREAM_ID("x-http2-stream-id"),
        AUTHORITY("x-http2-authority"),
        SCHEME("x-http2-scheme"),
        PATH("x-http2-path"),
        STREAM_PROMISE_ID("x-http2-stream-promise-id"),
        STREAM_DEPENDENCY_ID("x-http2-stream-dependency-id"),
        STREAM_WEIGHT("x-http2-stream-weight");

        private final AsciiString text;

        private ExtensionHeaderNames(String text) {
            this.text = new AsciiString((CharSequence)text);
        }

        public AsciiString text() {
            return this.text;
        }
    }
}

