/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http2;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.handler.codec.http2.DefaultHttp2Headers;
import io.netty.handler.codec.http2.DefaultHttp2HeadersDecoder;
import io.netty.handler.codec.http2.HpackEncoder;
import io.netty.handler.codec.http2.Http2Error;
import io.netty.handler.codec.http2.Http2Exception;
import io.netty.handler.codec.http2.Http2Headers;
import io.netty.handler.codec.http2.Http2HeadersEncoder;
import io.netty.handler.codec.http2.Http2TestUtil;
import io.netty.util.AsciiString;
import io.netty.util.CharsetUtil;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.function.Executable;

public class DefaultHttp2HeadersDecoderTest {
    private DefaultHttp2HeadersDecoder decoder;

    @BeforeEach
    public void setup() {
        this.decoder = new DefaultHttp2HeadersDecoder(false);
    }

    @Test
    public void decodeShouldSucceed() throws Exception {
        ByteBuf buf = DefaultHttp2HeadersDecoderTest.encode(DefaultHttp2HeadersDecoderTest.b(":method"), DefaultHttp2HeadersDecoderTest.b("GET"), DefaultHttp2HeadersDecoderTest.b("akey"), DefaultHttp2HeadersDecoderTest.b("avalue"), Http2TestUtil.randomBytes(), Http2TestUtil.randomBytes());
        try {
            Http2Headers headers = this.decoder.decodeHeaders(0, buf);
            Assertions.assertEquals((int)3, (int)headers.size());
            Assertions.assertEquals((Object)"GET", (Object)headers.method().toString());
            Assertions.assertEquals((Object)"avalue", (Object)((CharSequence)headers.get((Object)new AsciiString((CharSequence)"akey"))).toString());
        }
        finally {
            buf.release();
        }
    }

    @Test
    public void testExceedHeaderSize() throws Exception {
        int maxListSize = 100;
        this.decoder.configuration().maxHeaderListSize(100L, 100L);
        final ByteBuf buf = DefaultHttp2HeadersDecoderTest.encode(Http2TestUtil.randomBytes(100), Http2TestUtil.randomBytes(1));
        try {
            Assertions.assertThrows(Http2Exception.class, (Executable)new Executable(){

                public void execute() throws Throwable {
                    DefaultHttp2HeadersDecoderTest.this.decoder.decodeHeaders(0, buf);
                }
            });
        }
        finally {
            buf.release();
        }
    }

    @Test
    public void decodeLargerThanHeaderListSizeButLessThanGoAway() throws Exception {
        this.decoder.maxHeaderListSize(0L, 0xFFFFFFFFL);
        final ByteBuf buf = DefaultHttp2HeadersDecoderTest.encode(DefaultHttp2HeadersDecoderTest.b(":method"), DefaultHttp2HeadersDecoderTest.b("GET"));
        boolean streamId = true;
        Http2Exception.HeaderListSizeException e = (Http2Exception.HeaderListSizeException)Assertions.assertThrows(Http2Exception.HeaderListSizeException.class, (Executable)new Executable(){

            public void execute() throws Throwable {
                DefaultHttp2HeadersDecoderTest.this.decoder.decodeHeaders(1, buf);
            }
        });
        Assertions.assertEquals((int)1, (int)e.streamId());
        buf.release();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void decodeLargerThanHeaderListSizeButLessThanGoAwayWithInitialDecoderSettings() throws Exception {
        final ByteBuf buf = DefaultHttp2HeadersDecoderTest.encode(DefaultHttp2HeadersDecoderTest.b(":method"), DefaultHttp2HeadersDecoderTest.b("GET"), DefaultHttp2HeadersDecoderTest.b("test_header"), DefaultHttp2HeadersDecoderTest.b(String.format("%09000d", 0).replace('0', 'A')));
        boolean streamId = true;
        try {
            Http2Exception.HeaderListSizeException e = (Http2Exception.HeaderListSizeException)Assertions.assertThrows(Http2Exception.HeaderListSizeException.class, (Executable)new Executable(){

                public void execute() throws Throwable {
                    DefaultHttp2HeadersDecoderTest.this.decoder.decodeHeaders(1, buf);
                }
            });
            Assertions.assertEquals((int)1, (int)e.streamId());
        }
        finally {
            buf.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void decodeLargerThanHeaderListSizeGoAway() throws Exception {
        this.decoder.maxHeaderListSize(0L, 0L);
        final ByteBuf buf = DefaultHttp2HeadersDecoderTest.encode(DefaultHttp2HeadersDecoderTest.b(":method"), DefaultHttp2HeadersDecoderTest.b("GET"));
        boolean streamId = true;
        try {
            Http2Exception e = (Http2Exception)Assertions.assertThrows(Http2Exception.class, (Executable)new Executable(){

                public void execute() throws Throwable {
                    DefaultHttp2HeadersDecoderTest.this.decoder.decodeHeaders(1, buf);
                }
            });
            Assertions.assertEquals((Object)Http2Error.PROTOCOL_ERROR, (Object)e.error());
        }
        finally {
            buf.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void duplicatePseudoHeadersMustFailValidation() throws Exception {
        final ByteBuf buf = DefaultHttp2HeadersDecoderTest.encode(DefaultHttp2HeadersDecoderTest.b(":authority"), DefaultHttp2HeadersDecoderTest.b("abc"), DefaultHttp2HeadersDecoderTest.b(":authority"), DefaultHttp2HeadersDecoderTest.b("def"));
        try {
            final DefaultHttp2HeadersDecoder decoder = new DefaultHttp2HeadersDecoder(true);
            Http2Exception e = (Http2Exception)Assertions.assertThrows(Http2Exception.class, (Executable)new Executable(){

                public void execute() throws Throwable {
                    decoder.decodeHeaders(1, buf);
                }
            });
            Assertions.assertEquals((Object)Http2Error.PROTOCOL_ERROR, (Object)e.error());
        }
        finally {
            buf.release();
        }
    }

    private static byte[] b(String string) {
        return string.getBytes(CharsetUtil.UTF_8);
    }

    private static ByteBuf encode(byte[] ... entries) throws Exception {
        HpackEncoder hpackEncoder = Http2TestUtil.newTestEncoder();
        ByteBuf out = Unpooled.buffer();
        DefaultHttp2Headers http2Headers = new DefaultHttp2Headers(false);
        int ix = 0;
        while (ix < entries.length) {
            http2Headers.add((Object)new AsciiString(entries[ix++], false), (Object)new AsciiString(entries[ix++], false));
        }
        hpackEncoder.encodeHeaders(3, out, (Http2Headers)http2Headers, Http2HeadersEncoder.NEVER_SENSITIVE);
        return out;
    }
}

