/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http2;

import io.netty.bootstrap.Bootstrap;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.handler.codec.http2.DefaultHttp2DataFrame;
import io.netty.handler.codec.http2.DefaultHttp2GoAwayFrame;
import io.netty.handler.codec.http2.DefaultHttp2Headers;
import io.netty.handler.codec.http2.DefaultHttp2HeadersFrame;
import io.netty.handler.codec.http2.DefaultHttp2PriorityFrame;
import io.netty.handler.codec.http2.DefaultHttp2PushPromiseFrame;
import io.netty.handler.codec.http2.Http2ChannelDuplexHandler;
import io.netty.handler.codec.http2.Http2DataFrame;
import io.netty.handler.codec.http2.Http2Error;
import io.netty.handler.codec.http2.Http2FrameCodec;
import io.netty.handler.codec.http2.Http2FrameCodecBuilder;
import io.netty.handler.codec.http2.Http2FrameStream;
import io.netty.handler.codec.http2.Http2Headers;
import io.netty.handler.codec.http2.Http2HeadersFrame;
import io.netty.handler.codec.http2.Http2PriorityFrame;
import io.netty.handler.codec.http2.Http2PushPromiseFrame;
import io.netty.handler.codec.http2.Http2Settings;
import io.netty.util.CharsetUtil;
import io.netty.util.ReferenceCountUtil;
import io.netty.util.concurrent.GenericFutureListener;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class DefaultHttp2PushPromiseFrameTest {
    private final EventLoopGroup eventLoopGroup = new NioEventLoopGroup(2);
    private final ClientHandler clientHandler = new ClientHandler();
    private final Map<Integer, String> contentMap = new ConcurrentHashMap<Integer, String>();
    private ChannelFuture connectionFuture;

    @BeforeEach
    public void setup() throws InterruptedException {
        ServerBootstrap serverBootstrap = ((ServerBootstrap)new ServerBootstrap().group(this.eventLoopGroup).channel(NioServerSocketChannel.class)).childHandler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

            protected void initChannel(SocketChannel ch) {
                ChannelPipeline pipeline = ch.pipeline();
                Http2FrameCodec frameCodec = Http2FrameCodecBuilder.forServer().autoAckSettingsFrame(true).autoAckPingFrame(true).build();
                pipeline.addLast(new ChannelHandler[]{frameCodec});
                pipeline.addLast(new ChannelHandler[]{new ServerHandler()});
            }
        });
        ChannelFuture channelFuture = serverBootstrap.bind(0).sync();
        Bootstrap bootstrap = (Bootstrap)((Bootstrap)((Bootstrap)new Bootstrap().group(this.eventLoopGroup)).channel(NioSocketChannel.class)).handler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

            protected void initChannel(SocketChannel ch) {
                ChannelPipeline pipeline = ch.pipeline();
                Http2FrameCodec frameCodec = Http2FrameCodecBuilder.forClient().autoAckSettingsFrame(true).autoAckPingFrame(true).initialSettings(Http2Settings.defaultSettings().pushEnabled(true)).build();
                pipeline.addLast(new ChannelHandler[]{frameCodec});
                pipeline.addLast(new ChannelHandler[]{DefaultHttp2PushPromiseFrameTest.this.clientHandler});
            }
        });
        this.connectionFuture = bootstrap.connect(channelFuture.channel().localAddress());
    }

    @Test
    public void send() {
        this.connectionFuture.addListener((GenericFutureListener)new ChannelFutureListener(){

            public void operationComplete(ChannelFuture future) {
                DefaultHttp2PushPromiseFrameTest.this.clientHandler.write();
            }
        });
    }

    @AfterEach
    public void shutdown() {
        this.eventLoopGroup.shutdownGracefully();
    }

    private static final class ClientHandler
    extends Http2ChannelDuplexHandler {
        private ChannelHandlerContext ctx;

        private ClientHandler() {
        }

        public void channelActive(ChannelHandlerContext ctx) throws InterruptedException {
            this.ctx = ctx;
        }

        void write() {
            DefaultHttp2Headers http2Headers = new DefaultHttp2Headers();
            http2Headers.path((CharSequence)"/").authority((CharSequence)"localhost").method((CharSequence)"GET").scheme((CharSequence)"https");
            DefaultHttp2HeadersFrame headersFrame = new DefaultHttp2HeadersFrame((Http2Headers)http2Headers, true);
            headersFrame.stream(this.newStream());
            this.ctx.writeAndFlush((Object)headersFrame);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void channelRead(ChannelHandlerContext ctx, Object msg) {
            if (msg instanceof Http2PushPromiseFrame) {
                Http2PushPromiseFrame pushPromiseFrame = (Http2PushPromiseFrame)msg;
                Assertions.assertEquals((Object)"/meow", (Object)pushPromiseFrame.http2Headers().path().toString());
                Assertions.assertEquals((Object)"GET", (Object)pushPromiseFrame.http2Headers().method().toString());
                Assertions.assertEquals((Object)"https", (Object)pushPromiseFrame.http2Headers().scheme().toString());
                Assertions.assertEquals((Object)"localhost:5555", (Object)pushPromiseFrame.http2Headers().authority().toString());
                DefaultHttp2PriorityFrame priorityFrame = new DefaultHttp2PriorityFrame(pushPromiseFrame.stream().id(), 16, true);
                priorityFrame.stream(pushPromiseFrame.pushStream());
                ctx.writeAndFlush((Object)priorityFrame);
            } else if (msg instanceof Http2HeadersFrame) {
                Http2HeadersFrame headersFrame = (Http2HeadersFrame)msg;
                if (headersFrame.stream().id() == 3) {
                    Assertions.assertEquals((Object)"200", (Object)headersFrame.headers().status().toString());
                    Assertions.assertEquals((Object)"false", (Object)((CharSequence)headersFrame.headers().get((Object)"push")).toString());
                } else if (headersFrame.stream().id() == 2) {
                    Assertions.assertEquals((Object)"200", (Object)headersFrame.headers().status().toString());
                    Assertions.assertEquals((Object)"true", (Object)((CharSequence)headersFrame.headers().get((Object)"push")).toString());
                } else {
                    ctx.writeAndFlush((Object)new DefaultHttp2GoAwayFrame(Http2Error.REFUSED_STREAM));
                }
            } else if (msg instanceof Http2DataFrame) {
                Http2DataFrame dataFrame = (Http2DataFrame)msg;
                try {
                    if (dataFrame.stream().id() == 3) {
                        Assertions.assertEquals((Object)"Meow", (Object)dataFrame.content().toString(CharsetUtil.UTF_8));
                    } else if (dataFrame.stream().id() == 2) {
                        Assertions.assertEquals((Object)"Meow, I am Pushed via HTTP/2", (Object)dataFrame.content().toString(CharsetUtil.UTF_8));
                    } else {
                        ctx.writeAndFlush((Object)new DefaultHttp2GoAwayFrame(Http2Error.REFUSED_STREAM));
                    }
                }
                finally {
                    ReferenceCountUtil.release((Object)dataFrame);
                }
            }
        }
    }

    private final class ServerHandler
    extends Http2ChannelDuplexHandler {
        private ServerHandler() {
        }

        public void channelRead(final ChannelHandlerContext ctx, Object msg) throws Exception {
            if (msg instanceof Http2HeadersFrame) {
                final Http2HeadersFrame receivedFrame = (Http2HeadersFrame)msg;
                DefaultHttp2Headers pushRequestHeaders = new DefaultHttp2Headers();
                pushRequestHeaders.path((CharSequence)"/meow").method((CharSequence)"GET").scheme((CharSequence)"https").authority((CharSequence)"localhost:5555");
                final Http2FrameStream newPushFrameStream = this.newStream();
                DefaultHttp2PushPromiseFrame pushPromiseFrame = new DefaultHttp2PushPromiseFrame((Http2Headers)pushRequestHeaders);
                pushPromiseFrame.stream(receivedFrame.stream());
                pushPromiseFrame.pushStream(newPushFrameStream);
                ctx.writeAndFlush((Object)pushPromiseFrame).addListener((GenericFutureListener)new ChannelFutureListener(){

                    public void operationComplete(ChannelFuture future) {
                        DefaultHttp2PushPromiseFrameTest.this.contentMap.put(newPushFrameStream.id(), "Meow, I am Pushed via HTTP/2");
                        DefaultHttp2Headers http2Headers = new DefaultHttp2Headers();
                        http2Headers.status((CharSequence)"200");
                        http2Headers.add((Object)"push", (Object)"false");
                        DefaultHttp2HeadersFrame headersFrame = new DefaultHttp2HeadersFrame((Http2Headers)http2Headers, false);
                        headersFrame.stream(receivedFrame.stream());
                        ChannelFuture channelFuture = ctx.writeAndFlush((Object)headersFrame);
                        channelFuture.addListener((GenericFutureListener)new ChannelFutureListener(){

                            public void operationComplete(ChannelFuture future) throws Exception {
                                DefaultHttp2DataFrame dataFrame = new DefaultHttp2DataFrame(Unpooled.wrappedBuffer((byte[])"Meow".getBytes()), true);
                                dataFrame.stream(receivedFrame.stream());
                                ctx.writeAndFlush((Object)dataFrame);
                            }
                        });
                    }
                });
            } else if (msg instanceof Http2PriorityFrame) {
                Http2PriorityFrame priorityFrame = (Http2PriorityFrame)msg;
                String content = (String)DefaultHttp2PushPromiseFrameTest.this.contentMap.get(priorityFrame.stream().id());
                if (content == null) {
                    ctx.writeAndFlush((Object)new DefaultHttp2GoAwayFrame(Http2Error.REFUSED_STREAM));
                    return;
                }
                DefaultHttp2Headers http2Headers = new DefaultHttp2Headers();
                http2Headers.status((CharSequence)"200");
                http2Headers.add((Object)"push", (Object)"true");
                DefaultHttp2HeadersFrame headersFrame = new DefaultHttp2HeadersFrame((Http2Headers)http2Headers, false);
                headersFrame.stream(priorityFrame.stream());
                ctx.writeAndFlush((Object)headersFrame);
                DefaultHttp2DataFrame dataFrame = new DefaultHttp2DataFrame(Unpooled.wrappedBuffer((byte[])content.getBytes()), true);
                dataFrame.stream(priorityFrame.stream());
                ctx.writeAndFlush((Object)dataFrame);
            }
        }
    }
}

