/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http2;

import io.netty.bootstrap.Bootstrap;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerAdapter;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOutboundHandlerAdapter;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.ChannelPromise;
import io.netty.channel.DefaultEventLoopGroup;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.local.LocalAddress;
import io.netty.channel.local.LocalChannel;
import io.netty.channel.local.LocalServerChannel;
import io.netty.handler.codec.http2.DefaultHttp2Headers;
import io.netty.handler.codec.http2.EmptyHttp2Headers;
import io.netty.handler.codec.http2.Http2ConnectionHandler;
import io.netty.handler.codec.http2.Http2ConnectionHandlerBuilder;
import io.netty.handler.codec.http2.Http2ConnectionPrefaceAndSettingsFrameWrittenEvent;
import io.netty.handler.codec.http2.Http2Error;
import io.netty.handler.codec.http2.Http2Exception;
import io.netty.handler.codec.http2.Http2FrameListener;
import io.netty.handler.codec.http2.Http2Headers;
import io.netty.handler.codec.http2.Http2Settings;
import io.netty.handler.codec.http2.Http2Stream;
import io.netty.handler.codec.http2.Http2TestUtil;
import io.netty.util.AsciiString;
import io.netty.util.IllegalReferenceCountException;
import io.netty.util.ReferenceCountUtil;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.net.SocketAddress;
import java.util.Random;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.function.Executable;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;

public class Http2ConnectionRoundtripTest {
    private static final long DEFAULT_AWAIT_TIMEOUT_SECONDS = 15L;
    @Mock
    private Http2FrameListener clientListener;
    @Mock
    private Http2FrameListener serverListener;
    private Http2ConnectionHandler http2Client;
    private Http2ConnectionHandler http2Server;
    private ServerBootstrap sb;
    private Bootstrap cb;
    private Channel serverChannel;
    private volatile Channel serverConnectedChannel;
    private Channel clientChannel;
    private Http2TestUtil.FrameCountDown serverFrameCountDown;
    private CountDownLatch requestLatch;
    private CountDownLatch serverSettingsAckLatch;
    private CountDownLatch dataLatch;
    private CountDownLatch trailersLatch;
    private CountDownLatch goAwayLatch;

    @BeforeEach
    public void setup() throws Exception {
        MockitoAnnotations.initMocks((Object)this);
        Http2ConnectionRoundtripTest.mockFlowControl(this.clientListener);
        Http2ConnectionRoundtripTest.mockFlowControl(this.serverListener);
    }

    @AfterEach
    public void teardown() throws Exception {
        Channel serverConnectedChannel;
        if (this.clientChannel != null) {
            this.clientChannel.close().syncUninterruptibly();
            this.clientChannel = null;
        }
        if (this.serverChannel != null) {
            this.serverChannel.close().syncUninterruptibly();
            this.serverChannel = null;
        }
        if ((serverConnectedChannel = this.serverConnectedChannel) != null) {
            serverConnectedChannel.close().syncUninterruptibly();
            this.serverConnectedChannel = null;
        }
        Future serverGroup = this.sb.config().group().shutdownGracefully(0L, 5L, TimeUnit.SECONDS);
        Future serverChildGroup = this.sb.config().childGroup().shutdownGracefully(0L, 5L, TimeUnit.SECONDS);
        Future clientGroup = this.cb.config().group().shutdownGracefully(0L, 5L, TimeUnit.SECONDS);
        serverGroup.syncUninterruptibly();
        serverChildGroup.syncUninterruptibly();
        clientGroup.syncUninterruptibly();
    }

    @Test
    public void inflightFrameAfterStreamResetShouldNotMakeConnectionUnusable() throws Exception {
        final CountDownLatch latch = new CountDownLatch(1);
        ((Http2FrameListener)Mockito.doAnswer((Answer)new Answer<Void>(){

            public Void answer(InvocationOnMock invocationOnMock) throws Throwable {
                ChannelHandlerContext ctx = (ChannelHandlerContext)invocationOnMock.getArgument(0);
                Http2ConnectionRoundtripTest.this.http2Server.encoder().writeHeaders(ctx, ((Integer)invocationOnMock.getArgument(1)).intValue(), (Http2Headers)invocationOnMock.getArgument(2), 0, false, ctx.newPromise());
                Http2ConnectionRoundtripTest.this.http2Server.flush(ctx);
                return null;
            }
        }).when((Object)this.serverListener)).onHeadersRead((ChannelHandlerContext)Mockito.any(ChannelHandlerContext.class), Mockito.anyInt(), (Http2Headers)Mockito.any(Http2Headers.class), Mockito.anyInt(), Mockito.anyShort(), Mockito.anyBoolean(), Mockito.anyInt(), Mockito.anyBoolean());
        ((Http2FrameListener)Mockito.doAnswer((Answer)new Answer<Void>(){

            public Void answer(InvocationOnMock invocationOnMock) throws Throwable {
                latch.countDown();
                return null;
            }
        }).when((Object)this.clientListener)).onHeadersRead((ChannelHandlerContext)Mockito.any(ChannelHandlerContext.class), Mockito.eq((int)5), (Http2Headers)Mockito.any(Http2Headers.class), Mockito.anyInt(), Mockito.anyShort(), Mockito.anyBoolean(), Mockito.anyInt(), Mockito.anyBoolean());
        this.bootstrapEnv(1, 1, 2, 1);
        int weight = 16;
        final Http2Headers headers = Http2ConnectionRoundtripTest.dummyHeaders();
        Http2TestUtil.runInChannel(this.clientChannel, new Http2TestUtil.Http2Runnable(){

            @Override
            public void run() throws Http2Exception {
                Http2ConnectionRoundtripTest.this.http2Client.encoder().writeHeaders(Http2ConnectionRoundtripTest.this.ctx(), 3, headers, 0, (short)16, false, 0, false, Http2ConnectionRoundtripTest.this.newPromise());
                Http2ConnectionRoundtripTest.this.http2Client.flush(Http2ConnectionRoundtripTest.this.ctx());
                Http2ConnectionRoundtripTest.this.http2Client.encoder().writeRstStream(Http2ConnectionRoundtripTest.this.ctx(), 3, Http2Error.INTERNAL_ERROR.code(), Http2ConnectionRoundtripTest.this.newPromise());
                Http2ConnectionRoundtripTest.this.http2Client.flush(Http2ConnectionRoundtripTest.this.ctx());
            }
        });
        Http2TestUtil.runInChannel(this.clientChannel, new Http2TestUtil.Http2Runnable(){

            @Override
            public void run() throws Http2Exception {
                Http2ConnectionRoundtripTest.this.http2Client.encoder().writeHeaders(Http2ConnectionRoundtripTest.this.ctx(), 5, headers, 0, (short)16, false, 0, false, Http2ConnectionRoundtripTest.this.newPromise());
                Http2ConnectionRoundtripTest.this.http2Client.flush(Http2ConnectionRoundtripTest.this.ctx());
            }
        });
        Assertions.assertTrue((boolean)latch.await(15L, TimeUnit.SECONDS));
    }

    @Test
    public void headersWithEndStreamShouldNotSendError() throws Exception {
        this.bootstrapEnv(1, 1, 2, 1);
        int weight = 16;
        final Http2Headers headers = Http2ConnectionRoundtripTest.dummyHeaders();
        Http2TestUtil.runInChannel(this.clientChannel, new Http2TestUtil.Http2Runnable(){

            @Override
            public void run() throws Http2Exception {
                Http2ConnectionRoundtripTest.this.http2Client.encoder().writeHeaders(Http2ConnectionRoundtripTest.this.ctx(), 3, headers, 0, (short)16, false, 0, true, Http2ConnectionRoundtripTest.this.newPromise());
                Http2ConnectionRoundtripTest.this.http2Client.flush(Http2ConnectionRoundtripTest.this.ctx());
            }
        });
        Assertions.assertTrue((boolean)this.requestLatch.await(15L, TimeUnit.SECONDS));
        ((Http2FrameListener)Mockito.verify((Object)this.serverListener)).onHeadersRead((ChannelHandlerContext)Mockito.any(ChannelHandlerContext.class), Mockito.eq((int)3), (Http2Headers)Mockito.eq((Object)headers), Mockito.eq((int)0), Mockito.eq((short)16), Mockito.eq((boolean)false), Mockito.eq((int)0), Mockito.eq((boolean)true));
        Thread.sleep(1000L);
        ((Http2FrameListener)Mockito.verify((Object)this.serverListener, (VerificationMode)Mockito.never())).onGoAwayRead((ChannelHandlerContext)Mockito.any(ChannelHandlerContext.class), Mockito.anyInt(), Mockito.anyLong(), (ByteBuf)Mockito.any(ByteBuf.class));
        ((Http2FrameListener)Mockito.verify((Object)this.serverListener, (VerificationMode)Mockito.never())).onRstStreamRead((ChannelHandlerContext)Mockito.any(ChannelHandlerContext.class), Mockito.anyInt(), Mockito.anyLong());
        this.setClientGracefulShutdownTime(0L);
    }

    @Test
    public void encodeViolatesMaxHeaderListSizeCanStillUseConnection() throws Exception {
        final CountDownLatch serverSettingsAckLatch1 = new CountDownLatch(2);
        final CountDownLatch serverSettingsAckLatch2 = new CountDownLatch(3);
        final CountDownLatch clientSettingsLatch1 = new CountDownLatch(3);
        final CountDownLatch serverRevHeadersLatch = new CountDownLatch(1);
        final CountDownLatch clientHeadersLatch = new CountDownLatch(1);
        final CountDownLatch clientDataWrite = new CountDownLatch(1);
        final AtomicReference clientHeadersWriteException = new AtomicReference();
        final AtomicReference clientHeadersWriteException2 = new AtomicReference();
        final AtomicReference clientDataWriteException = new AtomicReference();
        final Http2Headers headers = Http2ConnectionRoundtripTest.dummyHeaders();
        ((Http2FrameListener)Mockito.doAnswer((Answer)new Answer<Void>(){

            public Void answer(InvocationOnMock invocationOnMock) throws Throwable {
                serverSettingsAckLatch1.countDown();
                serverSettingsAckLatch2.countDown();
                return null;
            }
        }).when((Object)this.serverListener)).onSettingsAckRead((ChannelHandlerContext)Mockito.any(ChannelHandlerContext.class));
        ((Http2FrameListener)Mockito.doAnswer((Answer)new Answer<Void>(){

            public Void answer(InvocationOnMock invocationOnMock) throws Throwable {
                clientSettingsLatch1.countDown();
                return null;
            }
        }).when((Object)this.clientListener)).onSettingsRead((ChannelHandlerContext)Mockito.any(ChannelHandlerContext.class), (Http2Settings)Mockito.any(Http2Settings.class));
        ((Http2FrameListener)Mockito.doAnswer((Answer)new Answer<Void>(){

            public Void answer(InvocationOnMock invocationOnMock) throws Throwable {
                serverRevHeadersLatch.countDown();
                return null;
            }
        }).when((Object)this.serverListener)).onHeadersRead((ChannelHandlerContext)Mockito.any(ChannelHandlerContext.class), Mockito.eq((int)5), (Http2Headers)Mockito.eq((Object)headers), Mockito.anyInt(), Mockito.anyShort(), Mockito.anyBoolean(), Mockito.eq((int)0), Mockito.eq((boolean)true));
        this.bootstrapEnv(1, 2, 1, 0, 0);
        Http2TestUtil.runInChannel(this.serverConnectedChannel, new Http2TestUtil.Http2Runnable(){

            @Override
            public void run() throws Http2Exception {
                Http2ConnectionRoundtripTest.this.http2Server.encoder().writeSettings(Http2ConnectionRoundtripTest.this.serverCtx(), new Http2Settings().copyFrom(Http2ConnectionRoundtripTest.this.http2Server.decoder().localSettings()).maxHeaderListSize(100L), Http2ConnectionRoundtripTest.this.serverNewPromise());
                Http2ConnectionRoundtripTest.this.http2Server.flush(Http2ConnectionRoundtripTest.this.serverCtx());
            }
        });
        Assertions.assertTrue((boolean)serverSettingsAckLatch1.await(15L, TimeUnit.SECONDS));
        Http2TestUtil.runInChannel(this.clientChannel, new Http2TestUtil.Http2Runnable(){

            @Override
            public void run() throws Http2Exception {
                Http2ConnectionRoundtripTest.this.http2Client.encoder().writeHeaders(Http2ConnectionRoundtripTest.this.ctx(), 3, headers, 0, false, Http2ConnectionRoundtripTest.this.newPromise()).addListener((GenericFutureListener)new ChannelFutureListener(){

                    public void operationComplete(ChannelFuture future) throws Exception {
                        clientHeadersWriteException.set(future.cause());
                    }
                });
                Http2ConnectionRoundtripTest.this.http2Client.encoder().writeData(Http2ConnectionRoundtripTest.this.ctx(), 3, Unpooled.buffer(), 0, true, Http2ConnectionRoundtripTest.this.newPromise()).addListener((GenericFutureListener)new ChannelFutureListener(){

                    public void operationComplete(ChannelFuture future) throws Exception {
                        clientDataWriteException.set(future.cause());
                        clientDataWrite.countDown();
                    }
                });
                Http2ConnectionRoundtripTest.this.http2Client.flush(Http2ConnectionRoundtripTest.this.ctx());
            }
        });
        Assertions.assertTrue((boolean)clientDataWrite.await(15L, TimeUnit.SECONDS));
        Assertions.assertNotNull(clientHeadersWriteException.get(), (String)"Header encode should have exceeded maxHeaderListSize!");
        Assertions.assertNotNull(clientDataWriteException.get(), (String)"Data on closed stream should fail!");
        Http2TestUtil.runInChannel(this.serverConnectedChannel, new Http2TestUtil.Http2Runnable(){

            @Override
            public void run() throws Http2Exception {
                Http2ConnectionRoundtripTest.this.http2Server.encoder().writeSettings(Http2ConnectionRoundtripTest.this.serverCtx(), new Http2Settings().copyFrom(Http2ConnectionRoundtripTest.this.http2Server.decoder().localSettings()).maxHeaderListSize(0xFFFFFFFFL), Http2ConnectionRoundtripTest.this.serverNewPromise());
                Http2ConnectionRoundtripTest.this.http2Server.flush(Http2ConnectionRoundtripTest.this.serverCtx());
            }
        });
        Assertions.assertTrue((boolean)clientSettingsLatch1.await(15L, TimeUnit.SECONDS));
        Assertions.assertTrue((boolean)serverSettingsAckLatch2.await(15L, TimeUnit.SECONDS));
        Http2TestUtil.runInChannel(this.clientChannel, new Http2TestUtil.Http2Runnable(){

            @Override
            public void run() throws Http2Exception {
                Http2ConnectionRoundtripTest.this.http2Client.encoder().writeHeaders(Http2ConnectionRoundtripTest.this.ctx(), 5, headers, 0, true, Http2ConnectionRoundtripTest.this.newPromise()).addListener((GenericFutureListener)new ChannelFutureListener(){

                    public void operationComplete(ChannelFuture future) throws Exception {
                        clientHeadersWriteException2.set(future.cause());
                        clientHeadersLatch.countDown();
                    }
                });
                Http2ConnectionRoundtripTest.this.http2Client.flush(Http2ConnectionRoundtripTest.this.ctx());
            }
        });
        Assertions.assertTrue((boolean)clientHeadersLatch.await(15L, TimeUnit.SECONDS));
        Assertions.assertNull(clientHeadersWriteException2.get(), (String)"Client write of headers should succeed with increased header list size!");
        Assertions.assertTrue((boolean)serverRevHeadersLatch.await(15L, TimeUnit.SECONDS));
        ((Http2FrameListener)Mockito.verify((Object)this.serverListener, (VerificationMode)Mockito.never())).onDataRead((ChannelHandlerContext)Mockito.any(ChannelHandlerContext.class), Mockito.anyInt(), (ByteBuf)Mockito.any(ByteBuf.class), Mockito.anyInt(), Mockito.anyBoolean());
        ((Http2FrameListener)Mockito.verify((Object)this.serverListener, (VerificationMode)Mockito.never())).onGoAwayRead((ChannelHandlerContext)Mockito.any(ChannelHandlerContext.class), Mockito.anyInt(), Mockito.anyLong(), (ByteBuf)Mockito.any(ByteBuf.class));
        ((Http2FrameListener)Mockito.verify((Object)this.serverListener, (VerificationMode)Mockito.never())).onRstStreamRead((ChannelHandlerContext)Mockito.any(ChannelHandlerContext.class), Mockito.anyInt(), Mockito.anyLong());
        ((Http2FrameListener)Mockito.verify((Object)this.clientListener, (VerificationMode)Mockito.never())).onGoAwayRead((ChannelHandlerContext)Mockito.any(ChannelHandlerContext.class), Mockito.anyInt(), Mockito.anyLong(), (ByteBuf)Mockito.any(ByteBuf.class));
        ((Http2FrameListener)Mockito.verify((Object)this.clientListener, (VerificationMode)Mockito.never())).onRstStreamRead((ChannelHandlerContext)Mockito.any(ChannelHandlerContext.class), Mockito.anyInt(), Mockito.anyLong());
    }

    @Test
    public void testSettingsAckIsSentBeforeUsingFlowControl() throws Exception {
        final CountDownLatch serverSettingsAckLatch1 = new CountDownLatch(1);
        final CountDownLatch serverSettingsAckLatch2 = new CountDownLatch(2);
        final CountDownLatch serverDataLatch = new CountDownLatch(1);
        final CountDownLatch clientWriteDataLatch = new CountDownLatch(1);
        final byte[] data = new byte[]{1, 2, 3, 4, 5};
        final ByteArrayOutputStream out = new ByteArrayOutputStream(data.length);
        ((Http2FrameListener)Mockito.doAnswer((Answer)new Answer<Void>(){

            public Void answer(InvocationOnMock invocationOnMock) throws Throwable {
                serverSettingsAckLatch1.countDown();
                serverSettingsAckLatch2.countDown();
                return null;
            }
        }).when((Object)this.serverListener)).onSettingsAckRead((ChannelHandlerContext)Mockito.any(ChannelHandlerContext.class));
        ((Http2FrameListener)Mockito.doAnswer((Answer)new Answer<Integer>(){

            public Integer answer(InvocationOnMock in) throws Throwable {
                ByteBuf buf = (ByteBuf)in.getArguments()[2];
                int padding = (Integer)in.getArguments()[3];
                int processedBytes = buf.readableBytes() + padding;
                buf.readBytes((OutputStream)out, buf.readableBytes());
                serverDataLatch.countDown();
                return processedBytes;
            }
        }).when((Object)this.serverListener)).onDataRead((ChannelHandlerContext)Mockito.any(ChannelHandlerContext.class), Mockito.eq((int)3), (ByteBuf)Mockito.any(ByteBuf.class), Mockito.eq((int)0), Mockito.anyBoolean());
        this.bootstrapEnv(1, 1, 1, 1);
        final Http2Headers headers = Http2ConnectionRoundtripTest.dummyHeaders();
        Http2TestUtil.runInChannel(this.serverConnectedChannel, new Http2TestUtil.Http2Runnable(){

            @Override
            public void run() throws Http2Exception {
                Http2ConnectionRoundtripTest.this.http2Server.encoder().writeSettings(Http2ConnectionRoundtripTest.this.serverCtx(), new Http2Settings().copyFrom(Http2ConnectionRoundtripTest.this.http2Server.decoder().localSettings()).initialWindowSize(0), Http2ConnectionRoundtripTest.this.serverNewPromise());
                Http2ConnectionRoundtripTest.this.http2Server.flush(Http2ConnectionRoundtripTest.this.serverCtx());
            }
        });
        Assertions.assertTrue((boolean)serverSettingsAckLatch1.await(15L, TimeUnit.SECONDS));
        Http2TestUtil.runInChannel(this.clientChannel, new Http2TestUtil.Http2Runnable(){

            @Override
            public void run() throws Http2Exception {
                Http2ConnectionRoundtripTest.this.http2Client.encoder().writeHeaders(Http2ConnectionRoundtripTest.this.ctx(), 3, headers, 0, (short)16, false, 0, false, Http2ConnectionRoundtripTest.this.newPromise());
                Http2ConnectionRoundtripTest.this.http2Client.encoder().writeData(Http2ConnectionRoundtripTest.this.ctx(), 3, Unpooled.wrappedBuffer((byte[])data), 0, true, Http2ConnectionRoundtripTest.this.newPromise());
                Http2ConnectionRoundtripTest.this.http2Client.flush(Http2ConnectionRoundtripTest.this.ctx());
                clientWriteDataLatch.countDown();
            }
        });
        Assertions.assertTrue((boolean)clientWriteDataLatch.await(15L, TimeUnit.SECONDS));
        Http2TestUtil.runInChannel(this.serverConnectedChannel, new Http2TestUtil.Http2Runnable(){

            @Override
            public void run() throws Http2Exception {
                Http2ConnectionRoundtripTest.this.http2Server.encoder().writeSettings(Http2ConnectionRoundtripTest.this.serverCtx(), new Http2Settings().copyFrom(Http2ConnectionRoundtripTest.this.http2Server.decoder().localSettings()).initialWindowSize(data.length), Http2ConnectionRoundtripTest.this.serverNewPromise());
                Http2ConnectionRoundtripTest.this.http2Server.flush(Http2ConnectionRoundtripTest.this.serverCtx());
            }
        });
        Assertions.assertTrue((boolean)serverSettingsAckLatch2.await(15L, TimeUnit.SECONDS));
        Assertions.assertTrue((boolean)serverDataLatch.await(15L, TimeUnit.SECONDS));
        Assertions.assertArrayEquals((byte[])data, (byte[])out.toByteArray());
        ((Http2FrameListener)Mockito.verify((Object)this.serverListener, (VerificationMode)Mockito.never())).onGoAwayRead((ChannelHandlerContext)Mockito.any(ChannelHandlerContext.class), Mockito.anyInt(), Mockito.anyLong(), (ByteBuf)Mockito.any(ByteBuf.class));
        ((Http2FrameListener)Mockito.verify((Object)this.serverListener, (VerificationMode)Mockito.never())).onRstStreamRead((ChannelHandlerContext)Mockito.any(ChannelHandlerContext.class), Mockito.anyInt(), Mockito.anyLong());
        ((Http2FrameListener)Mockito.verify((Object)this.clientListener, (VerificationMode)Mockito.never())).onGoAwayRead((ChannelHandlerContext)Mockito.any(ChannelHandlerContext.class), Mockito.anyInt(), Mockito.anyLong(), (ByteBuf)Mockito.any(ByteBuf.class));
        ((Http2FrameListener)Mockito.verify((Object)this.clientListener, (VerificationMode)Mockito.never())).onRstStreamRead((ChannelHandlerContext)Mockito.any(ChannelHandlerContext.class), Mockito.anyInt(), Mockito.anyLong());
    }

    @Test
    public void priorityUsingHigherValuedStreamIdDoesNotPreventUsingLowerStreamId() throws Exception {
        this.bootstrapEnv(1, 1, 2, 0);
        final Http2Headers headers = Http2ConnectionRoundtripTest.dummyHeaders();
        Http2TestUtil.runInChannel(this.clientChannel, new Http2TestUtil.Http2Runnable(){

            @Override
            public void run() throws Http2Exception {
                Http2ConnectionRoundtripTest.this.http2Client.encoder().writePriority(Http2ConnectionRoundtripTest.this.ctx(), 5, 3, (short)14, false, Http2ConnectionRoundtripTest.this.newPromise());
                Http2ConnectionRoundtripTest.this.http2Client.encoder().writeHeaders(Http2ConnectionRoundtripTest.this.ctx(), 3, headers, 0, (short)16, false, 0, false, Http2ConnectionRoundtripTest.this.newPromise());
                Http2ConnectionRoundtripTest.this.http2Client.flush(Http2ConnectionRoundtripTest.this.ctx());
            }
        });
        Assertions.assertTrue((boolean)this.serverSettingsAckLatch.await(15L, TimeUnit.SECONDS));
        Assertions.assertTrue((boolean)this.requestLatch.await(15L, TimeUnit.SECONDS));
        ((Http2FrameListener)Mockito.verify((Object)this.serverListener)).onPriorityRead((ChannelHandlerContext)Mockito.any(ChannelHandlerContext.class), Mockito.eq((int)5), Mockito.eq((int)3), Mockito.eq((short)14), Mockito.eq((boolean)false));
        ((Http2FrameListener)Mockito.verify((Object)this.serverListener)).onHeadersRead((ChannelHandlerContext)Mockito.any(ChannelHandlerContext.class), Mockito.eq((int)3), (Http2Headers)Mockito.eq((Object)headers), Mockito.eq((int)0), Mockito.eq((short)16), Mockito.eq((boolean)false), Mockito.eq((int)0), Mockito.eq((boolean)false));
        ((Http2FrameListener)Mockito.verify((Object)this.serverListener, (VerificationMode)Mockito.never())).onGoAwayRead((ChannelHandlerContext)Mockito.any(ChannelHandlerContext.class), Mockito.anyInt(), Mockito.anyLong(), (ByteBuf)Mockito.any(ByteBuf.class));
        ((Http2FrameListener)Mockito.verify((Object)this.serverListener, (VerificationMode)Mockito.never())).onRstStreamRead((ChannelHandlerContext)Mockito.any(ChannelHandlerContext.class), Mockito.anyInt(), Mockito.anyLong());
        ((Http2FrameListener)Mockito.verify((Object)this.clientListener, (VerificationMode)Mockito.never())).onGoAwayRead((ChannelHandlerContext)Mockito.any(ChannelHandlerContext.class), Mockito.anyInt(), Mockito.anyLong(), (ByteBuf)Mockito.any(ByteBuf.class));
        ((Http2FrameListener)Mockito.verify((Object)this.clientListener, (VerificationMode)Mockito.never())).onRstStreamRead((ChannelHandlerContext)Mockito.any(ChannelHandlerContext.class), Mockito.anyInt(), Mockito.anyLong());
    }

    @Test
    public void headersUsingHigherValuedStreamIdPreventsUsingLowerStreamId() throws Exception {
        this.bootstrapEnv(1, 1, 1, 0);
        final Http2Headers headers = Http2ConnectionRoundtripTest.dummyHeaders();
        Http2TestUtil.runInChannel(this.clientChannel, new Http2TestUtil.Http2Runnable(){

            @Override
            public void run() throws Http2Exception {
                Http2ConnectionRoundtripTest.this.http2Client.encoder().writeHeaders(Http2ConnectionRoundtripTest.this.ctx(), 5, headers, 0, (short)16, false, 0, false, Http2ConnectionRoundtripTest.this.newPromise());
                Http2ConnectionRoundtripTest.this.http2Client.encoder().frameWriter().writeHeaders(Http2ConnectionRoundtripTest.this.ctx(), 3, headers, 0, (short)16, false, 0, false, Http2ConnectionRoundtripTest.this.newPromise());
                Http2ConnectionRoundtripTest.this.http2Client.flush(Http2ConnectionRoundtripTest.this.ctx());
            }
        });
        Assertions.assertTrue((boolean)this.serverSettingsAckLatch.await(15L, TimeUnit.SECONDS));
        Assertions.assertTrue((boolean)this.requestLatch.await(15L, TimeUnit.SECONDS));
        ((Http2FrameListener)Mockito.verify((Object)this.serverListener)).onHeadersRead((ChannelHandlerContext)Mockito.any(ChannelHandlerContext.class), Mockito.eq((int)5), (Http2Headers)Mockito.eq((Object)headers), Mockito.eq((int)0), Mockito.eq((short)16), Mockito.eq((boolean)false), Mockito.eq((int)0), Mockito.eq((boolean)false));
        ((Http2FrameListener)Mockito.verify((Object)this.serverListener, (VerificationMode)Mockito.never())).onHeadersRead((ChannelHandlerContext)Mockito.any(ChannelHandlerContext.class), Mockito.eq((int)3), (Http2Headers)Mockito.any(Http2Headers.class), Mockito.anyInt(), Mockito.anyShort(), Mockito.anyBoolean(), Mockito.anyInt(), Mockito.anyBoolean());
        ((Http2FrameListener)Mockito.verify((Object)this.serverListener, (VerificationMode)Mockito.never())).onGoAwayRead((ChannelHandlerContext)Mockito.any(ChannelHandlerContext.class), Mockito.anyInt(), Mockito.anyLong(), (ByteBuf)Mockito.any(ByteBuf.class));
        ((Http2FrameListener)Mockito.verify((Object)this.serverListener, (VerificationMode)Mockito.never())).onRstStreamRead((ChannelHandlerContext)Mockito.any(ChannelHandlerContext.class), Mockito.anyInt(), Mockito.anyLong());
        ((Http2FrameListener)Mockito.verify((Object)this.clientListener, (VerificationMode)Mockito.never())).onGoAwayRead((ChannelHandlerContext)Mockito.any(ChannelHandlerContext.class), Mockito.anyInt(), Mockito.anyLong(), (ByteBuf)Mockito.any(ByteBuf.class));
        ((Http2FrameListener)Mockito.verify((Object)this.clientListener, (VerificationMode)Mockito.never())).onRstStreamRead((ChannelHandlerContext)Mockito.any(ChannelHandlerContext.class), Mockito.anyInt(), Mockito.anyLong());
    }

    @Test
    public void headersWriteForPeerStreamWhichWasResetShouldNotGoAway() throws Exception {
        final CountDownLatch serverGotRstLatch = new CountDownLatch(1);
        final CountDownLatch serverWriteHeadersLatch = new CountDownLatch(1);
        final AtomicReference serverWriteHeadersCauseRef = new AtomicReference();
        int streamId = 3;
        ((Http2FrameListener)Mockito.doAnswer((Answer)new Answer<Void>(){

            public Void answer(InvocationOnMock invocationOnMock) throws Throwable {
                if (3 == (Integer)invocationOnMock.getArgument(1)) {
                    serverGotRstLatch.countDown();
                }
                return null;
            }
        }).when((Object)this.serverListener)).onRstStreamRead((ChannelHandlerContext)Mockito.any(ChannelHandlerContext.class), Mockito.eq((int)3), Mockito.anyLong());
        this.bootstrapEnv(1, 1, 1, 0);
        final Http2Headers headers = Http2ConnectionRoundtripTest.dummyHeaders();
        Http2TestUtil.runInChannel(this.clientChannel, new Http2TestUtil.Http2Runnable(){

            @Override
            public void run() throws Http2Exception {
                Http2ConnectionRoundtripTest.this.http2Client.encoder().writeHeaders(Http2ConnectionRoundtripTest.this.ctx(), 3, headers, 0, (short)16, false, 0, false, Http2ConnectionRoundtripTest.this.newPromise());
                Http2ConnectionRoundtripTest.this.http2Client.encoder().writeRstStream(Http2ConnectionRoundtripTest.this.ctx(), 3, Http2Error.CANCEL.code(), Http2ConnectionRoundtripTest.this.newPromise());
                Http2ConnectionRoundtripTest.this.http2Client.flush(Http2ConnectionRoundtripTest.this.ctx());
            }
        });
        Assertions.assertTrue((boolean)this.serverSettingsAckLatch.await(15L, TimeUnit.SECONDS));
        Assertions.assertTrue((boolean)serverGotRstLatch.await(15L, TimeUnit.SECONDS));
        ((Http2FrameListener)Mockito.verify((Object)this.serverListener)).onHeadersRead((ChannelHandlerContext)Mockito.any(ChannelHandlerContext.class), Mockito.eq((int)3), (Http2Headers)Mockito.eq((Object)headers), Mockito.anyInt(), Mockito.anyShort(), Mockito.anyBoolean(), Mockito.anyInt(), Mockito.eq((boolean)false));
        Http2TestUtil.runInChannel(this.serverConnectedChannel, new Http2TestUtil.Http2Runnable(){

            @Override
            public void run() throws Http2Exception {
                Http2ConnectionRoundtripTest.this.http2Server.encoder().writeHeaders(Http2ConnectionRoundtripTest.this.serverCtx(), 3, headers, 0, true, Http2ConnectionRoundtripTest.this.serverNewPromise()).addListener((GenericFutureListener)new ChannelFutureListener(){

                    public void operationComplete(ChannelFuture future) throws Exception {
                        serverWriteHeadersCauseRef.set(future.cause());
                        serverWriteHeadersLatch.countDown();
                    }
                });
                Http2ConnectionRoundtripTest.this.http2Server.flush(Http2ConnectionRoundtripTest.this.serverCtx());
            }
        });
        Assertions.assertTrue((boolean)serverWriteHeadersLatch.await(15L, TimeUnit.SECONDS));
        Throwable serverWriteHeadersCause = (Throwable)serverWriteHeadersCauseRef.get();
        Assertions.assertNotNull((Object)serverWriteHeadersCause);
        MatcherAssert.assertThat(serverWriteHeadersCauseRef.get(), (Matcher)CoreMatchers.not((Matcher)CoreMatchers.instanceOf(Http2Exception.class)));
        ((Http2FrameListener)Mockito.verify((Object)this.serverListener, (VerificationMode)Mockito.never())).onGoAwayRead((ChannelHandlerContext)Mockito.any(ChannelHandlerContext.class), Mockito.anyInt(), Mockito.anyLong(), (ByteBuf)Mockito.any(ByteBuf.class));
        ((Http2FrameListener)Mockito.verify((Object)this.clientListener, (VerificationMode)Mockito.never())).onGoAwayRead((ChannelHandlerContext)Mockito.any(ChannelHandlerContext.class), Mockito.anyInt(), Mockito.anyLong(), (ByteBuf)Mockito.any(ByteBuf.class));
        ((Http2FrameListener)Mockito.verify((Object)this.clientListener, (VerificationMode)Mockito.never())).onRstStreamRead((ChannelHandlerContext)Mockito.any(ChannelHandlerContext.class), Mockito.anyInt(), Mockito.anyLong());
    }

    @Test
    public void http2ExceptionInPipelineShouldCloseConnection() throws Exception {
        this.bootstrapEnv(1, 1, 2, 1);
        final CountDownLatch closeLatch = new CountDownLatch(1);
        this.clientChannel.closeFuture().addListener((GenericFutureListener)new ChannelFutureListener(){

            public void operationComplete(ChannelFuture future) throws Exception {
                closeLatch.countDown();
            }
        });
        final Http2Headers headers = Http2ConnectionRoundtripTest.dummyHeaders();
        Http2TestUtil.runInChannel(this.clientChannel, new Http2TestUtil.Http2Runnable(){

            @Override
            public void run() throws Http2Exception {
                Http2ConnectionRoundtripTest.this.http2Client.encoder().writeHeaders(Http2ConnectionRoundtripTest.this.ctx(), 3, headers, 0, (short)16, false, 0, false, Http2ConnectionRoundtripTest.this.newPromise());
                Http2ConnectionRoundtripTest.this.http2Client.flush(Http2ConnectionRoundtripTest.this.ctx());
            }
        });
        Assertions.assertTrue((boolean)this.serverSettingsAckLatch.await(15L, TimeUnit.SECONDS));
        Assertions.assertTrue((boolean)this.requestLatch.await(15L, TimeUnit.SECONDS));
        this.clientChannel.pipeline().addFirst(new ChannelHandler[]{new ChannelHandlerAdapter(){

            public void handlerAdded(ChannelHandlerContext ctx) throws Exception {
                throw Http2Exception.connectionError((Http2Error)Http2Error.PROTOCOL_ERROR, (String)"Fake Exception", (Object[])new Object[0]);
            }
        }});
        Assertions.assertTrue((boolean)closeLatch.await(15L, TimeUnit.SECONDS));
        Assertions.assertFalse((boolean)this.clientChannel.isOpen());
    }

    @Test
    public void listenerExceptionShouldCloseConnection() throws Exception {
        final Http2Headers headers = Http2ConnectionRoundtripTest.dummyHeaders();
        ((Http2FrameListener)Mockito.doThrow((Throwable[])new Throwable[]{new RuntimeException("Fake Exception")}).when((Object)this.serverListener)).onHeadersRead((ChannelHandlerContext)Mockito.any(ChannelHandlerContext.class), Mockito.eq((int)3), (Http2Headers)Mockito.eq((Object)headers), Mockito.eq((int)0), Mockito.eq((short)16), Mockito.eq((boolean)false), Mockito.eq((int)0), Mockito.eq((boolean)false));
        this.bootstrapEnv(1, 0, 1, 1);
        final CountDownLatch closeLatch = new CountDownLatch(1);
        this.clientChannel.closeFuture().addListener((GenericFutureListener)new ChannelFutureListener(){

            public void operationComplete(ChannelFuture future) throws Exception {
                closeLatch.countDown();
            }
        });
        Http2TestUtil.runInChannel(this.clientChannel, new Http2TestUtil.Http2Runnable(){

            @Override
            public void run() throws Http2Exception {
                Http2ConnectionRoundtripTest.this.http2Client.encoder().writeHeaders(Http2ConnectionRoundtripTest.this.ctx(), 3, headers, 0, (short)16, false, 0, false, Http2ConnectionRoundtripTest.this.newPromise());
                Http2ConnectionRoundtripTest.this.http2Client.flush(Http2ConnectionRoundtripTest.this.ctx());
            }
        });
        Assertions.assertTrue((boolean)this.serverSettingsAckLatch.await(15L, TimeUnit.SECONDS));
        Assertions.assertTrue((boolean)this.requestLatch.await(15L, TimeUnit.SECONDS));
        Assertions.assertTrue((boolean)closeLatch.await(15L, TimeUnit.SECONDS));
        Assertions.assertFalse((boolean)this.clientChannel.isOpen());
    }

    @Test
    public void writeOfEmptyReleasedBufferSingleBufferQueuedInFlowControllerShouldFail() throws Exception {
        this.writeOfEmptyReleasedBufferQueuedInFlowControllerShouldFail(WriteEmptyBufferMode.SINGLE_END_OF_STREAM);
    }

    @Test
    public void writeOfEmptyReleasedBufferSingleBufferTrailersQueuedInFlowControllerShouldFail() throws Exception {
        this.writeOfEmptyReleasedBufferQueuedInFlowControllerShouldFail(WriteEmptyBufferMode.SINGLE_WITH_TRAILERS);
    }

    @Test
    public void writeOfEmptyReleasedBufferMultipleBuffersQueuedInFlowControllerShouldFail() throws Exception {
        this.writeOfEmptyReleasedBufferQueuedInFlowControllerShouldFail(WriteEmptyBufferMode.SECOND_END_OF_STREAM);
    }

    @Test
    public void writeOfEmptyReleasedBufferMultipleBuffersTrailersQueuedInFlowControllerShouldFail() throws Exception {
        this.writeOfEmptyReleasedBufferQueuedInFlowControllerShouldFail(WriteEmptyBufferMode.SECOND_WITH_TRAILERS);
    }

    private void writeOfEmptyReleasedBufferQueuedInFlowControllerShouldFail(final WriteEmptyBufferMode mode) throws Exception {
        this.bootstrapEnv(1, 1, 2, 1);
        final ChannelPromise emptyDataPromise = this.newPromise();
        Http2TestUtil.runInChannel(this.clientChannel, new Http2TestUtil.Http2Runnable(){

            @Override
            public void run() throws Http2Exception {
                Http2ConnectionRoundtripTest.this.http2Client.encoder().writeHeaders(Http2ConnectionRoundtripTest.this.ctx(), 3, (Http2Headers)EmptyHttp2Headers.INSTANCE, 0, (short)16, false, 0, false, Http2ConnectionRoundtripTest.this.newPromise());
                ByteBuf emptyBuf = Unpooled.buffer();
                emptyBuf.release();
                switch (mode) {
                    case SINGLE_END_OF_STREAM: {
                        Http2ConnectionRoundtripTest.this.http2Client.encoder().writeData(Http2ConnectionRoundtripTest.this.ctx(), 3, emptyBuf, 0, true, emptyDataPromise);
                        break;
                    }
                    case SECOND_END_OF_STREAM: {
                        Http2ConnectionRoundtripTest.this.http2Client.encoder().writeData(Http2ConnectionRoundtripTest.this.ctx(), 3, emptyBuf, 0, false, emptyDataPromise);
                        Http2ConnectionRoundtripTest.this.http2Client.encoder().writeData(Http2ConnectionRoundtripTest.this.ctx(), 3, Http2ConnectionRoundtripTest.randomBytes(8), 0, true, Http2ConnectionRoundtripTest.this.newPromise());
                        break;
                    }
                    case SINGLE_WITH_TRAILERS: {
                        Http2ConnectionRoundtripTest.this.http2Client.encoder().writeData(Http2ConnectionRoundtripTest.this.ctx(), 3, emptyBuf, 0, false, emptyDataPromise);
                        Http2ConnectionRoundtripTest.this.http2Client.encoder().writeHeaders(Http2ConnectionRoundtripTest.this.ctx(), 3, (Http2Headers)EmptyHttp2Headers.INSTANCE, 0, (short)16, false, 0, true, Http2ConnectionRoundtripTest.this.newPromise());
                        break;
                    }
                    case SECOND_WITH_TRAILERS: {
                        Http2ConnectionRoundtripTest.this.http2Client.encoder().writeData(Http2ConnectionRoundtripTest.this.ctx(), 3, emptyBuf, 0, false, emptyDataPromise);
                        Http2ConnectionRoundtripTest.this.http2Client.encoder().writeData(Http2ConnectionRoundtripTest.this.ctx(), 3, Http2ConnectionRoundtripTest.randomBytes(8), 0, false, Http2ConnectionRoundtripTest.this.newPromise());
                        Http2ConnectionRoundtripTest.this.http2Client.encoder().writeHeaders(Http2ConnectionRoundtripTest.this.ctx(), 3, (Http2Headers)EmptyHttp2Headers.INSTANCE, 0, (short)16, false, 0, true, Http2ConnectionRoundtripTest.this.newPromise());
                        break;
                    }
                    default: {
                        throw new Error();
                    }
                }
                Http2ConnectionRoundtripTest.this.http2Client.flush(Http2ConnectionRoundtripTest.this.ctx());
            }
        });
        ExecutionException e = (ExecutionException)Assertions.assertThrows(ExecutionException.class, (Executable)new Executable(){

            public void execute() throws Throwable {
                emptyDataPromise.get();
            }
        });
        MatcherAssert.assertThat((Object)e.getCause(), (Matcher)Matchers.is((Matcher)CoreMatchers.instanceOf(IllegalReferenceCountException.class)));
    }

    @Test
    public void writeFailureFlowControllerRemoveFrame() throws Exception {
        this.bootstrapEnv(1, 1, 2, 1);
        final ChannelPromise dataPromise = this.newPromise();
        final ChannelPromise assertPromise = this.newPromise();
        Http2TestUtil.runInChannel(this.clientChannel, new Http2TestUtil.Http2Runnable(){

            @Override
            public void run() throws Http2Exception {
                Http2ConnectionRoundtripTest.this.http2Client.encoder().writeHeaders(Http2ConnectionRoundtripTest.this.ctx(), 3, (Http2Headers)EmptyHttp2Headers.INSTANCE, 0, (short)16, false, 0, false, Http2ConnectionRoundtripTest.this.newPromise());
                Http2ConnectionRoundtripTest.this.clientChannel.pipeline().addFirst(new ChannelHandler[]{new ChannelOutboundHandlerAdapter(){

                    public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) throws Exception {
                        ReferenceCountUtil.release((Object)msg);
                        Http2ConnectionRoundtripTest.this.http2Client.encoder().flowController().initialWindowSize(8);
                        promise.setFailure((Throwable)new IllegalStateException());
                    }
                }});
                Http2ConnectionRoundtripTest.this.http2Client.encoder().flowController().initialWindowSize(4);
                Http2ConnectionRoundtripTest.this.http2Client.encoder().writeData(Http2ConnectionRoundtripTest.this.ctx(), 3, Http2ConnectionRoundtripTest.randomBytes(8), 0, false, dataPromise);
                Assertions.assertTrue((boolean)Http2ConnectionRoundtripTest.this.http2Client.encoder().flowController().hasFlowControlled(Http2ConnectionRoundtripTest.this.http2Client.connection().stream(3)));
                Http2ConnectionRoundtripTest.this.http2Client.flush(Http2ConnectionRoundtripTest.this.ctx());
                try {
                    Assertions.assertFalse((boolean)Http2ConnectionRoundtripTest.this.http2Client.encoder().flowController().hasFlowControlled(Http2ConnectionRoundtripTest.this.http2Client.connection().stream(3)));
                    assertPromise.setSuccess();
                }
                catch (Throwable error) {
                    assertPromise.setFailure(error);
                }
            }
        });
        ExecutionException e = (ExecutionException)Assertions.assertThrows(ExecutionException.class, (Executable)new Executable(){

            public void execute() throws Throwable {
                dataPromise.get();
            }
        });
        MatcherAssert.assertThat((Object)e.getCause(), (Matcher)Matchers.is((Matcher)CoreMatchers.instanceOf(IllegalStateException.class)));
        assertPromise.sync();
    }

    @Test
    public void nonHttp2ExceptionInPipelineShouldNotCloseConnection() throws Exception {
        this.bootstrapEnv(1, 1, 2, 1);
        final CountDownLatch closeLatch = new CountDownLatch(1);
        this.clientChannel.closeFuture().addListener((GenericFutureListener)new ChannelFutureListener(){

            public void operationComplete(ChannelFuture future) throws Exception {
                closeLatch.countDown();
            }
        });
        final Http2Headers headers = Http2ConnectionRoundtripTest.dummyHeaders();
        Http2TestUtil.runInChannel(this.clientChannel, new Http2TestUtil.Http2Runnable(){

            @Override
            public void run() throws Http2Exception {
                Http2ConnectionRoundtripTest.this.http2Client.encoder().writeHeaders(Http2ConnectionRoundtripTest.this.ctx(), 3, headers, 0, (short)16, false, 0, false, Http2ConnectionRoundtripTest.this.newPromise());
                Http2ConnectionRoundtripTest.this.http2Client.flush(Http2ConnectionRoundtripTest.this.ctx());
            }
        });
        Assertions.assertTrue((boolean)this.serverSettingsAckLatch.await(15L, TimeUnit.SECONDS));
        Assertions.assertTrue((boolean)this.requestLatch.await(15L, TimeUnit.SECONDS));
        this.clientChannel.pipeline().addFirst(new ChannelHandler[]{new ChannelHandlerAdapter(){

            public void handlerAdded(ChannelHandlerContext ctx) throws Exception {
                throw new RuntimeException("Fake Exception");
            }
        }});
        Assertions.assertFalse((boolean)closeLatch.await(2L, TimeUnit.SECONDS));
        Assertions.assertTrue((boolean)this.clientChannel.isOpen());
        this.setClientGracefulShutdownTime(0L);
    }

    @Test
    public void noMoreStreamIdsShouldSendGoAway() throws Exception {
        this.bootstrapEnv(1, 1, 3, 1, 1);
        this.setClientGracefulShutdownTime(0L);
        final Http2Headers headers = Http2ConnectionRoundtripTest.dummyHeaders();
        Http2TestUtil.runInChannel(this.clientChannel, new Http2TestUtil.Http2Runnable(){

            @Override
            public void run() throws Http2Exception {
                Http2ConnectionRoundtripTest.this.http2Client.encoder().writeHeaders(Http2ConnectionRoundtripTest.this.ctx(), 3, headers, 0, (short)16, false, 0, true, Http2ConnectionRoundtripTest.this.newPromise());
                Http2ConnectionRoundtripTest.this.http2Client.flush(Http2ConnectionRoundtripTest.this.ctx());
            }
        });
        Assertions.assertTrue((boolean)this.serverSettingsAckLatch.await(15L, TimeUnit.SECONDS));
        Http2TestUtil.runInChannel(this.clientChannel, new Http2TestUtil.Http2Runnable(){

            @Override
            public void run() throws Http2Exception {
                Http2ConnectionRoundtripTest.this.http2Client.encoder().writeHeaders(Http2ConnectionRoundtripTest.this.ctx(), Integer.MIN_VALUE, headers, 0, (short)16, false, 0, true, Http2ConnectionRoundtripTest.this.newPromise());
                Http2ConnectionRoundtripTest.this.http2Client.flush(Http2ConnectionRoundtripTest.this.ctx());
            }
        });
        Assertions.assertTrue((boolean)this.goAwayLatch.await(15L, TimeUnit.SECONDS));
        ((Http2FrameListener)Mockito.verify((Object)this.serverListener)).onGoAwayRead((ChannelHandlerContext)Mockito.any(ChannelHandlerContext.class), Mockito.eq((int)0), Mockito.eq((long)Http2Error.PROTOCOL_ERROR.code()), (ByteBuf)Mockito.any(ByteBuf.class));
    }

    @Test
    public void createStreamAfterReceiveGoAwayShouldNotSendGoAway() throws Exception {
        final CountDownLatch clientGoAwayLatch = new CountDownLatch(1);
        ((Http2FrameListener)Mockito.doAnswer((Answer)new Answer<Void>(){

            public Void answer(InvocationOnMock invocationOnMock) throws Throwable {
                clientGoAwayLatch.countDown();
                return null;
            }
        }).when((Object)this.clientListener)).onGoAwayRead((ChannelHandlerContext)Mockito.any(ChannelHandlerContext.class), Mockito.anyInt(), Mockito.anyLong(), (ByteBuf)Mockito.any(ByteBuf.class));
        this.bootstrapEnv(1, 1, 2, 1, 1);
        this.setClientGracefulShutdownTime(10000L);
        this.setServerGracefulShutdownTime(10000L);
        final Http2Headers headers = Http2ConnectionRoundtripTest.dummyHeaders();
        Http2TestUtil.runInChannel(this.clientChannel, new Http2TestUtil.Http2Runnable(){

            @Override
            public void run() throws Http2Exception {
                Http2ConnectionRoundtripTest.this.http2Client.encoder().writeHeaders(Http2ConnectionRoundtripTest.this.ctx(), 3, headers, 0, (short)16, false, 0, false, Http2ConnectionRoundtripTest.this.newPromise());
                Http2ConnectionRoundtripTest.this.http2Client.flush(Http2ConnectionRoundtripTest.this.ctx());
            }
        });
        Assertions.assertTrue((boolean)this.serverSettingsAckLatch.await(15L, TimeUnit.SECONDS));
        Assertions.assertTrue((boolean)this.requestLatch.await(15L, TimeUnit.SECONDS));
        Http2TestUtil.runInChannel(this.serverChannel, new Http2TestUtil.Http2Runnable(){

            @Override
            public void run() throws Http2Exception {
                Http2ConnectionRoundtripTest.this.http2Server.encoder().writeGoAway(Http2ConnectionRoundtripTest.this.serverCtx(), 3, Http2Error.NO_ERROR.code(), Unpooled.EMPTY_BUFFER, Http2ConnectionRoundtripTest.this.serverNewPromise());
                Http2ConnectionRoundtripTest.this.http2Server.flush(Http2ConnectionRoundtripTest.this.serverCtx());
            }
        });
        Assertions.assertTrue((boolean)clientGoAwayLatch.await(15L, TimeUnit.SECONDS));
        ((Http2FrameListener)Mockito.verify((Object)this.clientListener)).onGoAwayRead((ChannelHandlerContext)Mockito.any(ChannelHandlerContext.class), Mockito.eq((int)3), Mockito.eq((long)Http2Error.NO_ERROR.code()), (ByteBuf)Mockito.any(ByteBuf.class));
        final AtomicReference clientWriteAfterGoAwayFutureRef = new AtomicReference();
        final CountDownLatch clientWriteAfterGoAwayLatch = new CountDownLatch(1);
        Http2TestUtil.runInChannel(this.clientChannel, new Http2TestUtil.Http2Runnable(){

            @Override
            public void run() throws Http2Exception {
                ChannelFuture f = Http2ConnectionRoundtripTest.this.http2Client.encoder().writeHeaders(Http2ConnectionRoundtripTest.this.ctx(), 5, headers, 0, (short)16, false, 0, true, Http2ConnectionRoundtripTest.this.newPromise());
                clientWriteAfterGoAwayFutureRef.set(f);
                Http2ConnectionRoundtripTest.this.http2Client.flush(Http2ConnectionRoundtripTest.this.ctx());
                f.addListener((GenericFutureListener)new ChannelFutureListener(){

                    public void operationComplete(ChannelFuture future) throws Exception {
                        clientWriteAfterGoAwayLatch.countDown();
                    }
                });
            }
        });
        Assertions.assertTrue((boolean)clientWriteAfterGoAwayLatch.await(15L, TimeUnit.SECONDS));
        ChannelFuture clientWriteAfterGoAwayFuture = (ChannelFuture)clientWriteAfterGoAwayFutureRef.get();
        Assertions.assertNotNull((Object)clientWriteAfterGoAwayFuture);
        Throwable clientCause = clientWriteAfterGoAwayFuture.cause();
        MatcherAssert.assertThat((Object)clientCause, (Matcher)Matchers.is((Matcher)CoreMatchers.instanceOf(Http2Exception.StreamException.class)));
        Assertions.assertEquals((long)Http2Error.REFUSED_STREAM.code(), (long)((Http2Exception.StreamException)clientCause).error().code());
        Assertions.assertFalse((boolean)this.goAwayLatch.await(1L, TimeUnit.SECONDS));
        ((Http2FrameListener)Mockito.verify((Object)this.serverListener, (VerificationMode)Mockito.never())).onGoAwayRead((ChannelHandlerContext)Mockito.any(ChannelHandlerContext.class), Mockito.anyInt(), Mockito.anyLong(), (ByteBuf)Mockito.any(ByteBuf.class));
        this.setClientGracefulShutdownTime(0L);
        this.setServerGracefulShutdownTime(0L);
    }

    @Test
    public void listenerIsNotifiedOfGoawayBeforeStreamsAreRemovedFromTheConnection() throws Exception {
        final AtomicReference clientStream3State = new AtomicReference();
        final CountDownLatch clientGoAwayLatch = new CountDownLatch(1);
        ((Http2FrameListener)Mockito.doAnswer((Answer)new Answer<Void>(){

            public Void answer(InvocationOnMock invocationOnMock) throws Throwable {
                clientStream3State.set(Http2ConnectionRoundtripTest.this.http2Client.connection().stream(3).state());
                clientGoAwayLatch.countDown();
                return null;
            }
        }).when((Object)this.clientListener)).onGoAwayRead((ChannelHandlerContext)Mockito.any(ChannelHandlerContext.class), Mockito.anyInt(), Mockito.anyLong(), (ByteBuf)Mockito.any(ByteBuf.class));
        this.bootstrapEnv(1, 1, 2, 1, 1);
        this.setClientGracefulShutdownTime(10000L);
        this.setServerGracefulShutdownTime(10000L);
        final Http2Headers headers = Http2ConnectionRoundtripTest.dummyHeaders();
        Http2TestUtil.runInChannel(this.clientChannel, new Http2TestUtil.Http2Runnable(){

            @Override
            public void run() throws Http2Exception {
                Http2ConnectionRoundtripTest.this.http2Client.encoder().writeHeaders(Http2ConnectionRoundtripTest.this.ctx(), 1, headers, 0, (short)16, false, 0, false, Http2ConnectionRoundtripTest.this.newPromise());
                Http2ConnectionRoundtripTest.this.http2Client.encoder().writeHeaders(Http2ConnectionRoundtripTest.this.ctx(), 3, headers, 0, (short)16, false, 0, false, Http2ConnectionRoundtripTest.this.newPromise());
                Http2ConnectionRoundtripTest.this.http2Client.flush(Http2ConnectionRoundtripTest.this.ctx());
            }
        });
        Assertions.assertTrue((boolean)this.serverSettingsAckLatch.await(15L, TimeUnit.SECONDS));
        Assertions.assertTrue((boolean)this.requestLatch.await(15L, TimeUnit.SECONDS));
        Http2TestUtil.runInChannel(this.serverChannel, new Http2TestUtil.Http2Runnable(){

            @Override
            public void run() throws Http2Exception {
                Http2ConnectionRoundtripTest.this.http2Server.encoder().writeGoAway(Http2ConnectionRoundtripTest.this.serverCtx(), 1, Http2Error.NO_ERROR.code(), Unpooled.EMPTY_BUFFER, Http2ConnectionRoundtripTest.this.serverNewPromise());
                Http2ConnectionRoundtripTest.this.http2Server.flush(Http2ConnectionRoundtripTest.this.serverCtx());
            }
        });
        Assertions.assertTrue((boolean)clientGoAwayLatch.await(15L, TimeUnit.SECONDS));
        ((Http2FrameListener)Mockito.verify((Object)this.clientListener)).onGoAwayRead((ChannelHandlerContext)Mockito.any(ChannelHandlerContext.class), Mockito.eq((int)1), Mockito.eq((long)Http2Error.NO_ERROR.code()), (ByteBuf)Mockito.any(ByteBuf.class));
        Assertions.assertEquals((Object)Http2Stream.State.OPEN, clientStream3State.get());
        final CountDownLatch probeStreamCount = new CountDownLatch(1);
        final AtomicBoolean stream3Exists = new AtomicBoolean();
        final AtomicInteger streamCount = new AtomicInteger();
        Http2TestUtil.runInChannel(this.clientChannel, new Http2TestUtil.Http2Runnable(){

            @Override
            public void run() throws Http2Exception {
                stream3Exists.set(Http2ConnectionRoundtripTest.this.http2Client.connection().stream(3) != null);
                streamCount.set(Http2ConnectionRoundtripTest.this.http2Client.connection().numActiveStreams());
                probeStreamCount.countDown();
            }
        });
        Assertions.assertTrue((boolean)probeStreamCount.await(15L, TimeUnit.SECONDS));
        Assertions.assertEquals((int)1, (int)streamCount.get());
        Assertions.assertFalse((boolean)stream3Exists.get());
        Assertions.assertFalse((boolean)this.goAwayLatch.await(1L, TimeUnit.SECONDS));
        ((Http2FrameListener)Mockito.verify((Object)this.serverListener, (VerificationMode)Mockito.never())).onGoAwayRead((ChannelHandlerContext)Mockito.any(ChannelHandlerContext.class), Mockito.anyInt(), Mockito.anyLong(), (ByteBuf)Mockito.any(ByteBuf.class));
        this.setClientGracefulShutdownTime(0L);
        this.setServerGracefulShutdownTime(0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void flowControlProperlyChunksLargeMessage() throws Exception {
        final Http2Headers headers = Http2ConnectionRoundtripTest.dummyHeaders();
        int length = 0xA00000;
        final ByteBuf data = Http2ConnectionRoundtripTest.randomBytes(0xA00000);
        final ByteArrayOutputStream out = new ByteArrayOutputStream(0xA00000);
        ((Http2FrameListener)Mockito.doAnswer((Answer)new Answer<Integer>(){

            public Integer answer(InvocationOnMock in) throws Throwable {
                ByteBuf buf = (ByteBuf)in.getArguments()[2];
                int padding = (Integer)in.getArguments()[3];
                int processedBytes = buf.readableBytes() + padding;
                buf.readBytes((OutputStream)out, buf.readableBytes());
                return processedBytes;
            }
        }).when((Object)this.serverListener)).onDataRead((ChannelHandlerContext)Mockito.any(ChannelHandlerContext.class), Mockito.eq((int)3), (ByteBuf)Mockito.any(ByteBuf.class), Mockito.eq((int)0), Mockito.anyBoolean());
        try {
            this.bootstrapEnv(0xA00000, 1, 2, 1);
            Http2TestUtil.runInChannel(this.clientChannel, new Http2TestUtil.Http2Runnable(){

                @Override
                public void run() throws Http2Exception {
                    Http2ConnectionRoundtripTest.this.http2Client.encoder().writeHeaders(Http2ConnectionRoundtripTest.this.ctx(), 3, headers, 0, (short)16, false, 0, false, Http2ConnectionRoundtripTest.this.newPromise());
                    Http2ConnectionRoundtripTest.this.http2Client.encoder().writeData(Http2ConnectionRoundtripTest.this.ctx(), 3, data.retainedDuplicate(), 0, false, Http2ConnectionRoundtripTest.this.newPromise());
                    Http2ConnectionRoundtripTest.this.http2Client.encoder().writeHeaders(Http2ConnectionRoundtripTest.this.ctx(), 3, headers, 0, (short)16, false, 0, true, Http2ConnectionRoundtripTest.this.newPromise());
                    Http2ConnectionRoundtripTest.this.http2Client.flush(Http2ConnectionRoundtripTest.this.ctx());
                }
            });
            Assertions.assertTrue((boolean)this.serverSettingsAckLatch.await(15L, TimeUnit.SECONDS));
            Assertions.assertTrue((boolean)this.trailersLatch.await(15L, TimeUnit.SECONDS));
            ((Http2FrameListener)Mockito.verify((Object)this.serverListener)).onHeadersRead((ChannelHandlerContext)Mockito.any(ChannelHandlerContext.class), Mockito.eq((int)3), (Http2Headers)Mockito.eq((Object)headers), Mockito.eq((int)0), Mockito.eq((short)16), Mockito.eq((boolean)false), Mockito.eq((int)0), Mockito.eq((boolean)false));
            ((Http2FrameListener)Mockito.verify((Object)this.serverListener)).onHeadersRead((ChannelHandlerContext)Mockito.any(ChannelHandlerContext.class), Mockito.eq((int)3), (Http2Headers)Mockito.eq((Object)headers), Mockito.eq((int)0), Mockito.eq((short)16), Mockito.eq((boolean)false), Mockito.eq((int)0), Mockito.eq((boolean)true));
            Assertions.assertEquals((long)0L, (long)this.dataLatch.getCount());
            out.flush();
            byte[] received = out.toByteArray();
            Assertions.assertArrayEquals((byte[])data.array(), (byte[])received);
        }
        finally {
            this.setClientGracefulShutdownTime(0L);
            data.release();
            out.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void stressTest() throws Exception {
        final Http2Headers headers = Http2ConnectionRoundtripTest.dummyHeaders();
        int length = 10;
        final ByteBuf data = Http2ConnectionRoundtripTest.randomBytes(length);
        final String dataAsHex = ByteBufUtil.hexDump((ByteBuf)data);
        long pingData = 8L;
        int numStreams = 2000;
        final long[] receivedPings = new long[2000];
        ((Http2FrameListener)Mockito.doAnswer((Answer)new Answer<Void>(){
            int nextIndex;

            public Void answer(InvocationOnMock in) throws Throwable {
                receivedPings[this.nextIndex++] = (Long)in.getArguments()[1];
                return null;
            }
        }).when((Object)this.serverListener)).onPingRead((ChannelHandlerContext)Mockito.any(ChannelHandlerContext.class), ((Long)Mockito.any(Long.class)).longValue());
        final StringBuilder[] receivedData = new StringBuilder[2000];
        ((Http2FrameListener)Mockito.doAnswer((Answer)new Answer<Integer>(){

            public Integer answer(InvocationOnMock in) throws Throwable {
                int streamId = (Integer)in.getArguments()[1];
                ByteBuf buf = (ByteBuf)in.getArguments()[2];
                int padding = (Integer)in.getArguments()[3];
                int processedBytes = buf.readableBytes() + padding;
                int streamIndex = (streamId - 3) / 2;
                StringBuilder builder = receivedData[streamIndex];
                if (builder == null) {
                    receivedData[streamIndex] = builder = new StringBuilder(dataAsHex.length());
                }
                builder.append(ByteBufUtil.hexDump((ByteBuf)buf));
                return processedBytes;
            }
        }).when((Object)this.serverListener)).onDataRead((ChannelHandlerContext)Mockito.any(ChannelHandlerContext.class), Mockito.anyInt(), (ByteBuf)Mockito.any(ByteBuf.class), Mockito.anyInt(), Mockito.anyBoolean());
        try {
            this.bootstrapEnv(2000 * length, 1, 8000, 2000);
            Http2TestUtil.runInChannel(this.clientChannel, new Http2TestUtil.Http2Runnable(){

                @Override
                public void run() throws Http2Exception {
                    int upperLimit = 4003;
                    for (int streamId = 3; streamId < upperLimit; streamId += 2) {
                        Http2ConnectionRoundtripTest.this.http2Client.encoder().writeHeaders(Http2ConnectionRoundtripTest.this.ctx(), streamId, headers, 0, (short)16, false, 0, false, Http2ConnectionRoundtripTest.this.newPromise());
                        Http2ConnectionRoundtripTest.this.http2Client.encoder().writePing(Http2ConnectionRoundtripTest.this.ctx(), false, 8L, Http2ConnectionRoundtripTest.this.newPromise());
                        Http2ConnectionRoundtripTest.this.http2Client.encoder().writeData(Http2ConnectionRoundtripTest.this.ctx(), streamId, data.retainedSlice(), 0, false, Http2ConnectionRoundtripTest.this.newPromise());
                        Http2ConnectionRoundtripTest.this.http2Client.encoder().writeHeaders(Http2ConnectionRoundtripTest.this.ctx(), streamId, headers, 0, (short)16, false, 0, true, Http2ConnectionRoundtripTest.this.newPromise());
                        Http2ConnectionRoundtripTest.this.http2Client.flush(Http2ConnectionRoundtripTest.this.ctx());
                    }
                }
            });
            Assertions.assertTrue((boolean)this.serverSettingsAckLatch.await(60L, TimeUnit.SECONDS));
            Assertions.assertTrue((boolean)this.trailersLatch.await(60L, TimeUnit.SECONDS));
            ((Http2FrameListener)Mockito.verify((Object)this.serverListener, (VerificationMode)Mockito.times((int)2000))).onHeadersRead((ChannelHandlerContext)Mockito.any(ChannelHandlerContext.class), Mockito.anyInt(), (Http2Headers)Mockito.eq((Object)headers), Mockito.eq((int)0), Mockito.eq((short)16), Mockito.eq((boolean)false), Mockito.eq((int)0), Mockito.eq((boolean)false));
            ((Http2FrameListener)Mockito.verify((Object)this.serverListener, (VerificationMode)Mockito.times((int)2000))).onHeadersRead((ChannelHandlerContext)Mockito.any(ChannelHandlerContext.class), Mockito.anyInt(), (Http2Headers)Mockito.eq((Object)headers), Mockito.eq((int)0), Mockito.eq((short)16), Mockito.eq((boolean)false), Mockito.eq((int)0), Mockito.eq((boolean)true));
            ((Http2FrameListener)Mockito.verify((Object)this.serverListener, (VerificationMode)Mockito.times((int)2000))).onPingRead((ChannelHandlerContext)Mockito.any(ChannelHandlerContext.class), ((Long)Mockito.any(Long.TYPE)).longValue());
            ((Http2FrameListener)Mockito.verify((Object)this.serverListener, (VerificationMode)Mockito.never())).onDataRead((ChannelHandlerContext)Mockito.any(ChannelHandlerContext.class), Mockito.anyInt(), (ByteBuf)Mockito.any(ByteBuf.class), Mockito.eq((int)0), Mockito.eq((boolean)true));
            for (StringBuilder builder : receivedData) {
                Assertions.assertEquals((Object)dataAsHex, (Object)builder.toString());
            }
            for (long receivedPing : receivedPings) {
                Assertions.assertEquals((long)8L, (long)receivedPing);
            }
        }
        finally {
            this.setClientGracefulShutdownTime(0L);
            data.release();
        }
    }

    private void bootstrapEnv(int dataCountDown, int settingsAckCount, int requestCountDown, int trailersCountDown) throws Exception {
        this.bootstrapEnv(dataCountDown, settingsAckCount, requestCountDown, trailersCountDown, -1);
    }

    private void bootstrapEnv(int dataCountDown, int settingsAckCount, int requestCountDown, int trailersCountDown, int goAwayCountDown) throws Exception {
        final CountDownLatch prefaceWrittenLatch = new CountDownLatch(1);
        this.requestLatch = new CountDownLatch(requestCountDown);
        this.serverSettingsAckLatch = new CountDownLatch(settingsAckCount);
        this.dataLatch = new CountDownLatch(dataCountDown);
        this.trailersLatch = new CountDownLatch(trailersCountDown);
        this.goAwayLatch = goAwayCountDown > 0 ? new CountDownLatch(goAwayCountDown) : this.requestLatch;
        this.sb = new ServerBootstrap();
        this.cb = new Bootstrap();
        final AtomicReference serverHandlerRef = new AtomicReference();
        final CountDownLatch serverInitLatch = new CountDownLatch(1);
        this.sb.group((EventLoopGroup)new DefaultEventLoopGroup());
        this.sb.channel(LocalServerChannel.class);
        this.sb.childHandler((ChannelHandler)new ChannelInitializer<Channel>(){

            protected void initChannel(Channel ch) throws Exception {
                Http2ConnectionRoundtripTest.this.serverConnectedChannel = ch;
                ChannelPipeline p = ch.pipeline();
                Http2ConnectionRoundtripTest.this.serverFrameCountDown = new Http2TestUtil.FrameCountDown(Http2ConnectionRoundtripTest.this.serverListener, Http2ConnectionRoundtripTest.this.serverSettingsAckLatch, Http2ConnectionRoundtripTest.this.requestLatch, Http2ConnectionRoundtripTest.this.dataLatch, Http2ConnectionRoundtripTest.this.trailersLatch, Http2ConnectionRoundtripTest.this.goAwayLatch);
                serverHandlerRef.set(new Http2ConnectionHandlerBuilder().server(true).frameListener((Http2FrameListener)Http2ConnectionRoundtripTest.this.serverFrameCountDown).validateHeaders(false).build());
                p.addLast(new ChannelHandler[]{(ChannelHandler)serverHandlerRef.get()});
                serverInitLatch.countDown();
            }
        });
        this.cb.group((EventLoopGroup)new DefaultEventLoopGroup());
        this.cb.channel(LocalChannel.class);
        this.cb.handler((ChannelHandler)new ChannelInitializer<Channel>(){

            protected void initChannel(Channel ch) throws Exception {
                ChannelPipeline p = ch.pipeline();
                p.addLast(new ChannelHandler[]{new Http2ConnectionHandlerBuilder().server(false).frameListener(Http2ConnectionRoundtripTest.this.clientListener).validateHeaders(false).gracefulShutdownTimeoutMillis(0L).build()});
                p.addLast(new ChannelHandler[]{new ChannelInboundHandlerAdapter(){

                    public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
                        if (evt == Http2ConnectionPrefaceAndSettingsFrameWrittenEvent.INSTANCE) {
                            prefaceWrittenLatch.countDown();
                            ctx.pipeline().remove((ChannelHandler)this);
                        }
                    }
                }});
            }
        });
        this.serverChannel = this.sb.bind((SocketAddress)new LocalAddress("Http2ConnectionRoundtripTest")).sync().channel();
        ChannelFuture ccf = this.cb.connect(this.serverChannel.localAddress());
        Assertions.assertTrue((boolean)ccf.awaitUninterruptibly().isSuccess());
        this.clientChannel = ccf.channel();
        Assertions.assertTrue((boolean)prefaceWrittenLatch.await(15L, TimeUnit.SECONDS));
        this.http2Client = (Http2ConnectionHandler)this.clientChannel.pipeline().get(Http2ConnectionHandler.class);
        Assertions.assertTrue((boolean)serverInitLatch.await(15L, TimeUnit.SECONDS));
        this.http2Server = (Http2ConnectionHandler)serverHandlerRef.get();
    }

    private ChannelHandlerContext ctx() {
        return this.clientChannel.pipeline().firstContext();
    }

    private ChannelHandlerContext serverCtx() {
        return this.serverConnectedChannel.pipeline().firstContext();
    }

    private ChannelPromise newPromise() {
        return this.ctx().newPromise();
    }

    private ChannelPromise serverNewPromise() {
        return this.serverCtx().newPromise();
    }

    private static Http2Headers dummyHeaders() {
        return (Http2Headers)new DefaultHttp2Headers(false).method((CharSequence)new AsciiString((CharSequence)"GET")).scheme((CharSequence)new AsciiString((CharSequence)"https")).authority((CharSequence)new AsciiString((CharSequence)"example.org")).path((CharSequence)new AsciiString((CharSequence)"/some/path/resource2")).add((Object)Http2TestUtil.randomString(), (Object)Http2TestUtil.randomString());
    }

    private static void mockFlowControl(Http2FrameListener listener) throws Http2Exception {
        ((Http2FrameListener)Mockito.doAnswer((Answer)new Answer<Integer>(){

            public Integer answer(InvocationOnMock invocation) throws Throwable {
                ByteBuf buf = (ByteBuf)invocation.getArguments()[2];
                int padding = (Integer)invocation.getArguments()[3];
                return buf.readableBytes() + padding;
            }
        }).when((Object)listener)).onDataRead((ChannelHandlerContext)Mockito.any(ChannelHandlerContext.class), Mockito.anyInt(), (ByteBuf)Mockito.any(ByteBuf.class), Mockito.anyInt(), Mockito.anyBoolean());
    }

    private void setClientGracefulShutdownTime(long millis) throws InterruptedException {
        Http2ConnectionRoundtripTest.setGracefulShutdownTime(this.clientChannel, this.http2Client, millis);
    }

    private void setServerGracefulShutdownTime(long millis) throws InterruptedException {
        Http2ConnectionRoundtripTest.setGracefulShutdownTime(this.serverChannel, this.http2Server, millis);
    }

    private static void setGracefulShutdownTime(Channel channel, final Http2ConnectionHandler handler, final long millis) throws InterruptedException {
        final CountDownLatch latch = new CountDownLatch(1);
        Http2TestUtil.runInChannel(channel, new Http2TestUtil.Http2Runnable(){

            @Override
            public void run() throws Http2Exception {
                handler.gracefulShutdownTimeoutMillis(millis);
                latch.countDown();
            }
        });
        Assertions.assertTrue((boolean)latch.await(15L, TimeUnit.SECONDS));
    }

    private static ByteBuf randomBytes(int length) {
        byte[] bytes = new byte[length];
        new Random().nextBytes(bytes);
        return Unpooled.wrappedBuffer((byte[])bytes);
    }

    private static enum WriteEmptyBufferMode {
        SINGLE_END_OF_STREAM,
        SECOND_END_OF_STREAM,
        SINGLE_WITH_TRAILERS,
        SECOND_WITH_TRAILERS;

    }
}

