/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http2;

import io.netty.handler.codec.Headers;
import io.netty.handler.codec.http2.DefaultHttp2Headers;
import io.netty.handler.codec.http2.Http2Exception;
import io.netty.handler.codec.http2.Http2Headers;
import io.netty.util.AsciiString;
import java.util.Map;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.function.Executable;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.CsvSource;

public class DefaultHttp2HeadersTest {
    @Test
    public void nullHeaderNameNotAllowed() {
        Assertions.assertThrows(Http2Exception.class, (Executable)new Executable(){

            public void execute() throws Throwable {
                new DefaultHttp2Headers().add(null, (Object)"foo");
            }
        });
    }

    @Test
    public void emptyHeaderNameNotAllowed() {
        Assertions.assertThrows(Http2Exception.class, (Executable)new Executable(){

            public void execute() throws Throwable {
                new DefaultHttp2Headers().add((Object)"", (Object)"foo");
            }
        });
    }

    @Test
    public void testPseudoHeadersMustComeFirstWhenIterating() {
        Http2Headers headers = DefaultHttp2HeadersTest.newHeaders();
        DefaultHttp2HeadersTest.verifyPseudoHeadersFirst(headers);
        DefaultHttp2HeadersTest.verifyAllPseudoHeadersPresent(headers);
    }

    @Test
    public void testPseudoHeadersWithRemovePreservesPseudoIterationOrder() {
        Http2Headers headers = DefaultHttp2HeadersTest.newHeaders();
        DefaultHttp2Headers nonPseudoHeaders = new DefaultHttp2Headers();
        for (Map.Entry entry : headers) {
            if (((CharSequence)entry.getKey()).length() != 0 && (((CharSequence)entry.getKey()).charAt(0) == ':' || nonPseudoHeaders.contains(entry.getKey()))) continue;
            nonPseudoHeaders.add(entry.getKey(), entry.getValue());
        }
        Assertions.assertFalse((boolean)nonPseudoHeaders.isEmpty());
        for (Map.Entry nonPseudoHeaderEntry : nonPseudoHeaders) {
            Assertions.assertTrue((boolean)headers.remove(nonPseudoHeaderEntry.getKey()));
            DefaultHttp2HeadersTest.verifyPseudoHeadersFirst(headers);
            DefaultHttp2HeadersTest.verifyAllPseudoHeadersPresent(headers);
        }
        for (Map.Entry nonPseudoHeaderEntry : nonPseudoHeaders) {
            headers.add(nonPseudoHeaderEntry.getKey(), (Object)AsciiString.of((CharSequence)"goo"));
            DefaultHttp2HeadersTest.verifyPseudoHeadersFirst(headers);
            DefaultHttp2HeadersTest.verifyAllPseudoHeadersPresent(headers);
        }
    }

    @Test
    public void testPseudoHeadersWithClearDoesNotLeak() {
        Http2Headers headers = DefaultHttp2HeadersTest.newHeaders();
        Assertions.assertFalse((boolean)headers.isEmpty());
        headers.clear();
        Assertions.assertTrue((boolean)headers.isEmpty());
        ((Http2Headers)headers.add((Object)"name1", (Object)"value1")).scheme((CharSequence)"nothing");
        DefaultHttp2HeadersTest.verifyPseudoHeadersFirst(headers);
        Http2Headers other = ((Http2Headers)new DefaultHttp2Headers().add((Object)"name2", (Object)"value2")).authority((CharSequence)"foo");
        DefaultHttp2HeadersTest.verifyPseudoHeadersFirst(other);
        headers.add((Headers)other);
        DefaultHttp2HeadersTest.verifyPseudoHeadersFirst(headers);
        Assertions.assertEquals((int)4, (int)headers.size());
        Assertions.assertEquals((Object)"value1", (Object)headers.get((Object)"name1"));
        Assertions.assertEquals((Object)"value2", (Object)headers.get((Object)"name2"));
        Assertions.assertEquals((Object)"nothing", (Object)headers.scheme());
        Assertions.assertEquals((Object)"foo", (Object)headers.authority());
    }

    @Test
    public void testSetHeadersOrdersPseudoHeadersCorrectly() {
        Http2Headers headers = DefaultHttp2HeadersTest.newHeaders();
        Http2Headers other = ((Http2Headers)new DefaultHttp2Headers().add((Object)"name2", (Object)"value2")).authority((CharSequence)"foo");
        headers.set((Headers)other);
        DefaultHttp2HeadersTest.verifyPseudoHeadersFirst(headers);
        Assertions.assertEquals((int)other.size(), (int)headers.size());
        Assertions.assertEquals((Object)"foo", (Object)headers.authority());
        Assertions.assertEquals((Object)"value2", (Object)headers.get((Object)"name2"));
    }

    @Test
    public void testSetAllOrdersPseudoHeadersCorrectly() {
        Http2Headers headers = DefaultHttp2HeadersTest.newHeaders();
        Http2Headers other = ((Http2Headers)new DefaultHttp2Headers().add((Object)"name2", (Object)"value2")).authority((CharSequence)"foo");
        int headersSizeBefore = headers.size();
        headers.setAll((Headers)other);
        DefaultHttp2HeadersTest.verifyPseudoHeadersFirst(headers);
        DefaultHttp2HeadersTest.verifyAllPseudoHeadersPresent(headers);
        Assertions.assertEquals((int)(headersSizeBefore + 1), (int)headers.size());
        Assertions.assertEquals((Object)"foo", (Object)headers.authority());
        Assertions.assertEquals((Object)"value2", (Object)headers.get((Object)"name2"));
    }

    @Test
    public void testHeaderNameValidation() {
        final Http2Headers headers = DefaultHttp2HeadersTest.newHeaders();
        Assertions.assertThrows(Http2Exception.class, (Executable)new Executable(){

            public void execute() throws Throwable {
                headers.add((Object)AsciiString.of((CharSequence)"Foo"), (Object)AsciiString.of((CharSequence)"foo"));
            }
        });
    }

    @Test
    public void testClearResetsPseudoHeaderDivision() {
        DefaultHttp2Headers http2Headers = new DefaultHttp2Headers();
        http2Headers.method((CharSequence)"POST");
        http2Headers.set((Object)"some", (Object)"value");
        http2Headers.clear();
        http2Headers.method((CharSequence)"GET");
        Assertions.assertEquals((int)1, (int)http2Headers.names().size());
    }

    @Test
    public void testContainsNameAndValue() {
        Http2Headers headers = DefaultHttp2HeadersTest.newHeaders();
        Assertions.assertTrue((boolean)headers.contains((Object)"name1", (Object)"value2"));
        Assertions.assertFalse((boolean)headers.contains((Object)"name1", (Object)"Value2"));
        Assertions.assertTrue((boolean)headers.contains((CharSequence)"2name", (CharSequence)"Value3", true));
        Assertions.assertFalse((boolean)headers.contains((CharSequence)"2name", (CharSequence)"Value3", false));
    }

    @Test
    void setMustOverwritePseudoHeaders() {
        Http2Headers headers = DefaultHttp2HeadersTest.newHeaders();
        headers.method((CharSequence)AsciiString.of((CharSequence)"GET"));
        headers.path((CharSequence)AsciiString.of((CharSequence)"/index2.html"));
        headers.status((CharSequence)AsciiString.of((CharSequence)"101"));
        headers.authority((CharSequence)AsciiString.of((CharSequence)"github.com"));
        headers.scheme((CharSequence)AsciiString.of((CharSequence)"http"));
        headers.set((Object)AsciiString.of((CharSequence)":protocol"), (Object)AsciiString.of((CharSequence)"http"));
        Assertions.assertEquals((Object)AsciiString.of((CharSequence)"GET"), (Object)headers.method());
        Assertions.assertEquals((Object)AsciiString.of((CharSequence)"/index2.html"), (Object)headers.path());
        Assertions.assertEquals((Object)AsciiString.of((CharSequence)"101"), (Object)headers.status());
        Assertions.assertEquals((Object)AsciiString.of((CharSequence)"github.com"), (Object)headers.authority());
        Assertions.assertEquals((Object)AsciiString.of((CharSequence)"http"), (Object)headers.scheme());
    }

    @ParameterizedTest(name="{displayName} [{index}] name={0} value={1}")
    @CsvSource(value={"upgrade,protocol1", "connection,close", "keep-alive,timeout=5", "proxy-connection,close", "transfer-encoding,chunked", "te,something-else"})
    void possibleToAddConnectionHeaders(String name, String value) {
        Http2Headers headers = DefaultHttp2HeadersTest.newHeaders();
        headers.add((Object)name, (Object)value);
        Assertions.assertTrue((boolean)headers.contains((Object)name, (Object)value));
    }

    private static void verifyAllPseudoHeadersPresent(Http2Headers headers) {
        for (Http2Headers.PseudoHeaderName pseudoName : Http2Headers.PseudoHeaderName.values()) {
            Assertions.assertNotNull((Object)headers.get((Object)pseudoName.value()));
        }
    }

    static void verifyPseudoHeadersFirst(Http2Headers headers) {
        CharSequence lastNonPseudoName = null;
        for (Map.Entry entry : headers) {
            if (((CharSequence)entry.getKey()).length() == 0 || ((CharSequence)entry.getKey()).charAt(0) != ':') {
                lastNonPseudoName = (CharSequence)entry.getKey();
                continue;
            }
            if (lastNonPseudoName == null) continue;
            Assertions.fail((String)("All pseudo headers must be first in iteration. Pseudo header " + entry.getKey() + " is after a non pseudo header " + lastNonPseudoName));
        }
    }

    private static Http2Headers newHeaders() {
        DefaultHttp2Headers headers = new DefaultHttp2Headers();
        headers.add((Object)AsciiString.of((CharSequence)"name1"), (Object[])new CharSequence[]{AsciiString.of((CharSequence)"value1"), AsciiString.of((CharSequence)"value2")});
        headers.method((CharSequence)AsciiString.of((CharSequence)"POST"));
        headers.add((Object)AsciiString.of((CharSequence)"2name"), (Object)AsciiString.of((CharSequence)"value3"));
        headers.path((CharSequence)AsciiString.of((CharSequence)"/index.html"));
        headers.status((CharSequence)AsciiString.of((CharSequence)"200"));
        headers.authority((CharSequence)AsciiString.of((CharSequence)"netty.io"));
        headers.add((Object)AsciiString.of((CharSequence)"name3"), (Object)AsciiString.of((CharSequence)"value4"));
        headers.scheme((CharSequence)AsciiString.of((CharSequence)"https"));
        headers.add((Object)AsciiString.of((CharSequence)":protocol"), (Object)AsciiString.of((CharSequence)"websocket"));
        return headers;
    }
}

