/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http2;

import io.netty.handler.codec.http2.Http2Settings;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.function.Executable;

public class Http2SettingsTest {
    private Http2Settings settings;

    @BeforeEach
    public void setup() {
        this.settings = new Http2Settings();
    }

    @Test
    public void standardSettingsShouldBeNotSet() {
        Assertions.assertEquals((int)0, (int)this.settings.size());
        Assertions.assertNull((Object)this.settings.headerTableSize());
        Assertions.assertNull((Object)this.settings.initialWindowSize());
        Assertions.assertNull((Object)this.settings.maxConcurrentStreams());
        Assertions.assertNull((Object)this.settings.pushEnabled());
        Assertions.assertNull((Object)this.settings.maxFrameSize());
        Assertions.assertNull((Object)this.settings.maxHeaderListSize());
    }

    @Test
    public void standardSettingsShouldBeSet() {
        this.settings.initialWindowSize(1);
        this.settings.maxConcurrentStreams(2L);
        this.settings.pushEnabled(true);
        this.settings.headerTableSize(3L);
        this.settings.maxFrameSize(0xFFFFFF);
        this.settings.maxHeaderListSize(4L);
        Assertions.assertEquals((int)1, (int)this.settings.initialWindowSize());
        Assertions.assertEquals((long)2L, (long)this.settings.maxConcurrentStreams());
        Assertions.assertTrue((boolean)this.settings.pushEnabled());
        Assertions.assertEquals((long)3L, (long)this.settings.headerTableSize());
        Assertions.assertEquals((int)0xFFFFFF, (int)this.settings.maxFrameSize());
        Assertions.assertEquals((long)4L, (long)this.settings.maxHeaderListSize());
    }

    @Test
    public void nonStandardSettingsShouldBeSet() {
        char key = '\u0000';
        this.settings.put(key, Long.valueOf(123L));
        Assertions.assertEquals((long)123L, (long)((Long)this.settings.get(key)));
    }

    @Test
    public void settingsShouldSupportUnsignedShort() {
        char key = '\u8000';
        this.settings.put(key, Long.valueOf(123L));
        Assertions.assertEquals((long)123L, (long)((Long)this.settings.get(key)));
    }

    @Test
    public void headerListSizeUnsignedInt() {
        this.settings.maxHeaderListSize(0xFFFFFFFFL);
        Assertions.assertEquals((long)0xFFFFFFFFL, (long)this.settings.maxHeaderListSize());
    }

    @Test
    public void headerListSizeBoundCheck() {
        Assertions.assertThrows(IllegalArgumentException.class, (Executable)new Executable(){

            public void execute() {
                Http2SettingsTest.this.settings.maxHeaderListSize(Long.MAX_VALUE);
            }
        });
    }

    @Test
    public void headerTableSizeUnsignedInt() {
        this.settings.put('\u0001', Long.valueOf(0xFFFFFFFFL));
        Assertions.assertEquals((long)0xFFFFFFFFL, (long)((Long)this.settings.get('\u0001')));
    }

    @Test
    public void headerTableSizeBoundCheck() {
        Assertions.assertThrows(IllegalArgumentException.class, (Executable)new Executable(){

            public void execute() {
                Http2SettingsTest.this.settings.put('\u0001', Long.valueOf(Long.MAX_VALUE));
            }
        });
    }

    @Test
    public void headerTableSizeBoundCheck2() {
        Assertions.assertThrows(IllegalArgumentException.class, (Executable)new Executable(){

            public void execute() {
                Http2SettingsTest.this.settings.put('\u0001', Long.valueOf(-1L));
            }
        });
    }
}

