/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http2;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelOutboundHandlerAdapter;
import io.netty.channel.ChannelPromise;
import io.netty.channel.embedded.EmbeddedChannel;
import io.netty.handler.codec.EncoderException;
import io.netty.handler.codec.http.DefaultFullHttpRequest;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.DefaultHttpContent;
import io.netty.handler.codec.http.DefaultHttpRequest;
import io.netty.handler.codec.http.DefaultHttpResponse;
import io.netty.handler.codec.http.DefaultLastHttpContent;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpScheme;
import io.netty.handler.codec.http.HttpUtil;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.LastHttpContent;
import io.netty.handler.codec.http2.DefaultHttp2DataFrame;
import io.netty.handler.codec.http2.DefaultHttp2GoAwayFrame;
import io.netty.handler.codec.http2.DefaultHttp2Headers;
import io.netty.handler.codec.http2.DefaultHttp2HeadersFrame;
import io.netty.handler.codec.http2.DefaultHttp2ResetFrame;
import io.netty.handler.codec.http2.Http2DataFrame;
import io.netty.handler.codec.http2.Http2FrameStream;
import io.netty.handler.codec.http2.Http2GoAwayFrame;
import io.netty.handler.codec.http2.Http2Headers;
import io.netty.handler.codec.http2.Http2HeadersFrame;
import io.netty.handler.codec.http2.Http2Stream;
import io.netty.handler.codec.http2.Http2StreamFrame;
import io.netty.handler.codec.http2.Http2StreamFrameToHttpObjectCodec;
import io.netty.handler.codec.http2.HttpConversionUtil;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslContextBuilder;
import io.netty.handler.ssl.SslProvider;
import io.netty.util.CharsetUtil;
import java.nio.charset.Charset;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.function.Executable;

public class Http2StreamFrameToHttpObjectCodecTest {
    @Test
    public void testUpgradeEmptyFullResponse() throws Exception {
        EmbeddedChannel ch = new EmbeddedChannel(new ChannelHandler[]{new Http2StreamFrameToHttpObjectCodec(true)});
        Assertions.assertTrue((boolean)ch.writeOutbound(new Object[]{new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK)}));
        Http2HeadersFrame headersFrame = (Http2HeadersFrame)ch.readOutbound();
        MatcherAssert.assertThat((Object)headersFrame.headers().status().toString(), (Matcher)CoreMatchers.is((Object)"200"));
        Assertions.assertTrue((boolean)headersFrame.isEndStream());
        MatcherAssert.assertThat((Object)ch.readOutbound(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
        Assertions.assertFalse((boolean)ch.finish());
    }

    @Test
    public void encode100ContinueAsHttp2HeadersFrameThatIsNotEndStream() throws Exception {
        EmbeddedChannel ch = new EmbeddedChannel(new ChannelHandler[]{new Http2StreamFrameToHttpObjectCodec(true)});
        Assertions.assertTrue((boolean)ch.writeOutbound(new Object[]{new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.CONTINUE)}));
        Http2HeadersFrame headersFrame = (Http2HeadersFrame)ch.readOutbound();
        MatcherAssert.assertThat((Object)headersFrame.headers().status().toString(), (Matcher)CoreMatchers.is((Object)"100"));
        Assertions.assertFalse((boolean)headersFrame.isEndStream());
        MatcherAssert.assertThat((Object)ch.readOutbound(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
        Assertions.assertFalse((boolean)ch.finish());
    }

    @Test
    public void encodeNonFullHttpResponse100ContinueIsRejected() throws Exception {
        final EmbeddedChannel ch = new EmbeddedChannel(new ChannelHandler[]{new Http2StreamFrameToHttpObjectCodec(true)});
        Assertions.assertThrows(EncoderException.class, (Executable)new Executable(){

            public void execute() {
                ch.writeOutbound(new Object[]{new DefaultHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.CONTINUE)});
            }
        });
        ch.finishAndReleaseAll();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testUpgradeNonEmptyFullResponse() throws Exception {
        EmbeddedChannel ch = new EmbeddedChannel(new ChannelHandler[]{new Http2StreamFrameToHttpObjectCodec(true)});
        ByteBuf hello = Unpooled.copiedBuffer((CharSequence)"hello world", (Charset)CharsetUtil.UTF_8);
        Assertions.assertTrue((boolean)ch.writeOutbound(new Object[]{new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK, hello)}));
        Http2HeadersFrame headersFrame = (Http2HeadersFrame)ch.readOutbound();
        MatcherAssert.assertThat((Object)headersFrame.headers().status().toString(), (Matcher)CoreMatchers.is((Object)"200"));
        Assertions.assertFalse((boolean)headersFrame.isEndStream());
        Http2DataFrame dataFrame = (Http2DataFrame)ch.readOutbound();
        try {
            MatcherAssert.assertThat((Object)dataFrame.content().toString(CharsetUtil.UTF_8), (Matcher)CoreMatchers.is((Object)"hello world"));
            Assertions.assertTrue((boolean)dataFrame.isEndStream());
        }
        finally {
            dataFrame.release();
        }
        MatcherAssert.assertThat((Object)ch.readOutbound(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
        Assertions.assertFalse((boolean)ch.finish());
    }

    @Test
    public void testUpgradeEmptyFullResponseWithTrailers() throws Exception {
        EmbeddedChannel ch = new EmbeddedChannel(new ChannelHandler[]{new Http2StreamFrameToHttpObjectCodec(true)});
        DefaultFullHttpResponse response = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK);
        HttpHeaders trailers = response.trailingHeaders();
        trailers.set("key", (Object)"value");
        Assertions.assertTrue((boolean)ch.writeOutbound(new Object[]{response}));
        Http2HeadersFrame headersFrame = (Http2HeadersFrame)ch.readOutbound();
        MatcherAssert.assertThat((Object)headersFrame.headers().status().toString(), (Matcher)CoreMatchers.is((Object)"200"));
        Assertions.assertFalse((boolean)headersFrame.isEndStream());
        Http2HeadersFrame trailersFrame = (Http2HeadersFrame)ch.readOutbound();
        MatcherAssert.assertThat((Object)((CharSequence)trailersFrame.headers().get((Object)"key")).toString(), (Matcher)CoreMatchers.is((Object)"value"));
        Assertions.assertTrue((boolean)trailersFrame.isEndStream());
        MatcherAssert.assertThat((Object)ch.readOutbound(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
        Assertions.assertFalse((boolean)ch.finish());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testUpgradeNonEmptyFullResponseWithTrailers() throws Exception {
        EmbeddedChannel ch = new EmbeddedChannel(new ChannelHandler[]{new Http2StreamFrameToHttpObjectCodec(true)});
        ByteBuf hello = Unpooled.copiedBuffer((CharSequence)"hello world", (Charset)CharsetUtil.UTF_8);
        DefaultFullHttpResponse response = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK, hello);
        HttpHeaders trailers = response.trailingHeaders();
        trailers.set("key", (Object)"value");
        Assertions.assertTrue((boolean)ch.writeOutbound(new Object[]{response}));
        Http2HeadersFrame headersFrame = (Http2HeadersFrame)ch.readOutbound();
        MatcherAssert.assertThat((Object)headersFrame.headers().status().toString(), (Matcher)CoreMatchers.is((Object)"200"));
        Assertions.assertFalse((boolean)headersFrame.isEndStream());
        Http2DataFrame dataFrame = (Http2DataFrame)ch.readOutbound();
        try {
            MatcherAssert.assertThat((Object)dataFrame.content().toString(CharsetUtil.UTF_8), (Matcher)CoreMatchers.is((Object)"hello world"));
            Assertions.assertFalse((boolean)dataFrame.isEndStream());
        }
        finally {
            dataFrame.release();
        }
        Http2HeadersFrame trailersFrame = (Http2HeadersFrame)ch.readOutbound();
        MatcherAssert.assertThat((Object)((CharSequence)trailersFrame.headers().get((Object)"key")).toString(), (Matcher)CoreMatchers.is((Object)"value"));
        Assertions.assertTrue((boolean)trailersFrame.isEndStream());
        MatcherAssert.assertThat((Object)ch.readOutbound(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
        Assertions.assertFalse((boolean)ch.finish());
    }

    @Test
    public void testUpgradeHeaders() throws Exception {
        EmbeddedChannel ch = new EmbeddedChannel(new ChannelHandler[]{new Http2StreamFrameToHttpObjectCodec(true)});
        DefaultHttpResponse response = new DefaultHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK);
        Assertions.assertTrue((boolean)ch.writeOutbound(new Object[]{response}));
        Http2HeadersFrame headersFrame = (Http2HeadersFrame)ch.readOutbound();
        MatcherAssert.assertThat((Object)headersFrame.headers().status().toString(), (Matcher)CoreMatchers.is((Object)"200"));
        Assertions.assertFalse((boolean)headersFrame.isEndStream());
        MatcherAssert.assertThat((Object)ch.readOutbound(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
        Assertions.assertFalse((boolean)ch.finish());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testUpgradeChunk() throws Exception {
        EmbeddedChannel ch = new EmbeddedChannel(new ChannelHandler[]{new Http2StreamFrameToHttpObjectCodec(true)});
        ByteBuf hello = Unpooled.copiedBuffer((CharSequence)"hello world", (Charset)CharsetUtil.UTF_8);
        DefaultHttpContent content = new DefaultHttpContent(hello);
        Assertions.assertTrue((boolean)ch.writeOutbound(new Object[]{content}));
        Http2DataFrame dataFrame = (Http2DataFrame)ch.readOutbound();
        try {
            MatcherAssert.assertThat((Object)dataFrame.content().toString(CharsetUtil.UTF_8), (Matcher)CoreMatchers.is((Object)"hello world"));
            Assertions.assertFalse((boolean)dataFrame.isEndStream());
        }
        finally {
            dataFrame.release();
        }
        MatcherAssert.assertThat((Object)ch.readOutbound(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
        Assertions.assertFalse((boolean)ch.finish());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testUpgradeEmptyEnd() throws Exception {
        EmbeddedChannel ch = new EmbeddedChannel(new ChannelHandler[]{new Http2StreamFrameToHttpObjectCodec(true)});
        LastHttpContent end = LastHttpContent.EMPTY_LAST_CONTENT;
        Assertions.assertTrue((boolean)ch.writeOutbound(new Object[]{end}));
        Http2DataFrame emptyFrame = (Http2DataFrame)ch.readOutbound();
        try {
            MatcherAssert.assertThat((Object)emptyFrame.content().readableBytes(), (Matcher)CoreMatchers.is((Object)0));
            Assertions.assertTrue((boolean)emptyFrame.isEndStream());
        }
        finally {
            emptyFrame.release();
        }
        MatcherAssert.assertThat((Object)ch.readOutbound(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
        Assertions.assertFalse((boolean)ch.finish());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testUpgradeDataEnd() throws Exception {
        EmbeddedChannel ch = new EmbeddedChannel(new ChannelHandler[]{new Http2StreamFrameToHttpObjectCodec(true)});
        ByteBuf hello = Unpooled.copiedBuffer((CharSequence)"hello world", (Charset)CharsetUtil.UTF_8);
        DefaultLastHttpContent end = new DefaultLastHttpContent(hello, true);
        Assertions.assertTrue((boolean)ch.writeOutbound(new Object[]{end}));
        Http2DataFrame dataFrame = (Http2DataFrame)ch.readOutbound();
        try {
            MatcherAssert.assertThat((Object)dataFrame.content().toString(CharsetUtil.UTF_8), (Matcher)CoreMatchers.is((Object)"hello world"));
            Assertions.assertTrue((boolean)dataFrame.isEndStream());
        }
        finally {
            dataFrame.release();
        }
        MatcherAssert.assertThat((Object)ch.readOutbound(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
        Assertions.assertFalse((boolean)ch.finish());
    }

    @Test
    public void testUpgradeTrailers() throws Exception {
        EmbeddedChannel ch = new EmbeddedChannel(new ChannelHandler[]{new Http2StreamFrameToHttpObjectCodec(true)});
        DefaultLastHttpContent trailers = new DefaultLastHttpContent(Unpooled.EMPTY_BUFFER, true);
        HttpHeaders headers = trailers.trailingHeaders();
        headers.set("key", (Object)"value");
        Assertions.assertTrue((boolean)ch.writeOutbound(new Object[]{trailers}));
        Http2HeadersFrame headerFrame = (Http2HeadersFrame)ch.readOutbound();
        MatcherAssert.assertThat((Object)((CharSequence)headerFrame.headers().get((Object)"key")).toString(), (Matcher)CoreMatchers.is((Object)"value"));
        Assertions.assertTrue((boolean)headerFrame.isEndStream());
        MatcherAssert.assertThat((Object)ch.readOutbound(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
        Assertions.assertFalse((boolean)ch.finish());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testUpgradeDataEndWithTrailers() throws Exception {
        EmbeddedChannel ch = new EmbeddedChannel(new ChannelHandler[]{new Http2StreamFrameToHttpObjectCodec(true)});
        ByteBuf hello = Unpooled.copiedBuffer((CharSequence)"hello world", (Charset)CharsetUtil.UTF_8);
        DefaultLastHttpContent trailers = new DefaultLastHttpContent(hello, true);
        HttpHeaders headers = trailers.trailingHeaders();
        headers.set("key", (Object)"value");
        Assertions.assertTrue((boolean)ch.writeOutbound(new Object[]{trailers}));
        Http2DataFrame dataFrame = (Http2DataFrame)ch.readOutbound();
        try {
            MatcherAssert.assertThat((Object)dataFrame.content().toString(CharsetUtil.UTF_8), (Matcher)CoreMatchers.is((Object)"hello world"));
            Assertions.assertFalse((boolean)dataFrame.isEndStream());
        }
        finally {
            dataFrame.release();
        }
        Http2HeadersFrame headerFrame = (Http2HeadersFrame)ch.readOutbound();
        MatcherAssert.assertThat((Object)((CharSequence)headerFrame.headers().get((Object)"key")).toString(), (Matcher)CoreMatchers.is((Object)"value"));
        Assertions.assertTrue((boolean)headerFrame.isEndStream());
        MatcherAssert.assertThat((Object)ch.readOutbound(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
        Assertions.assertFalse((boolean)ch.finish());
    }

    @Test
    public void testDowngradeHeaders() throws Exception {
        EmbeddedChannel ch = new EmbeddedChannel(new ChannelHandler[]{new Http2StreamFrameToHttpObjectCodec(true)});
        DefaultHttp2Headers headers = new DefaultHttp2Headers();
        headers.path((CharSequence)"/");
        headers.method((CharSequence)"GET");
        Assertions.assertTrue((boolean)ch.writeInbound(new Object[]{new DefaultHttp2HeadersFrame((Http2Headers)headers)}));
        HttpRequest request = (HttpRequest)ch.readInbound();
        MatcherAssert.assertThat((Object)request.uri(), (Matcher)CoreMatchers.is((Object)"/"));
        MatcherAssert.assertThat((Object)request.method(), (Matcher)CoreMatchers.is((Object)HttpMethod.GET));
        MatcherAssert.assertThat((Object)request.protocolVersion(), (Matcher)CoreMatchers.is((Object)HttpVersion.HTTP_1_1));
        Assertions.assertFalse((boolean)(request instanceof FullHttpRequest));
        Assertions.assertTrue((boolean)HttpUtil.isTransferEncodingChunked((HttpMessage)request));
        MatcherAssert.assertThat((Object)ch.readInbound(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
        Assertions.assertFalse((boolean)ch.finish());
    }

    @Test
    public void testDowngradeHeadersWithContentLength() throws Exception {
        EmbeddedChannel ch = new EmbeddedChannel(new ChannelHandler[]{new Http2StreamFrameToHttpObjectCodec(true)});
        DefaultHttp2Headers headers = new DefaultHttp2Headers();
        headers.path((CharSequence)"/");
        headers.method((CharSequence)"GET");
        headers.setInt((Object)"content-length", 0);
        Assertions.assertTrue((boolean)ch.writeInbound(new Object[]{new DefaultHttp2HeadersFrame((Http2Headers)headers)}));
        HttpRequest request = (HttpRequest)ch.readInbound();
        MatcherAssert.assertThat((Object)request.uri(), (Matcher)CoreMatchers.is((Object)"/"));
        MatcherAssert.assertThat((Object)request.method(), (Matcher)CoreMatchers.is((Object)HttpMethod.GET));
        MatcherAssert.assertThat((Object)request.protocolVersion(), (Matcher)CoreMatchers.is((Object)HttpVersion.HTTP_1_1));
        Assertions.assertFalse((boolean)(request instanceof FullHttpRequest));
        Assertions.assertFalse((boolean)HttpUtil.isTransferEncodingChunked((HttpMessage)request));
        MatcherAssert.assertThat((Object)ch.readInbound(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
        Assertions.assertFalse((boolean)ch.finish());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDowngradeFullHeaders() throws Exception {
        EmbeddedChannel ch = new EmbeddedChannel(new ChannelHandler[]{new Http2StreamFrameToHttpObjectCodec(true)});
        DefaultHttp2Headers headers = new DefaultHttp2Headers();
        headers.path((CharSequence)"/");
        headers.method((CharSequence)"GET");
        Assertions.assertTrue((boolean)ch.writeInbound(new Object[]{new DefaultHttp2HeadersFrame((Http2Headers)headers, true)}));
        FullHttpRequest request = (FullHttpRequest)ch.readInbound();
        try {
            MatcherAssert.assertThat((Object)request.uri(), (Matcher)CoreMatchers.is((Object)"/"));
            MatcherAssert.assertThat((Object)request.method(), (Matcher)CoreMatchers.is((Object)HttpMethod.GET));
            MatcherAssert.assertThat((Object)request.protocolVersion(), (Matcher)CoreMatchers.is((Object)HttpVersion.HTTP_1_1));
            MatcherAssert.assertThat((Object)request.content().readableBytes(), (Matcher)CoreMatchers.is((Object)0));
            Assertions.assertTrue((boolean)request.trailingHeaders().isEmpty());
            Assertions.assertFalse((boolean)HttpUtil.isTransferEncodingChunked((HttpMessage)request));
        }
        finally {
            request.release();
        }
        MatcherAssert.assertThat((Object)ch.readInbound(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
        Assertions.assertFalse((boolean)ch.finish());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDowngradeTrailers() throws Exception {
        EmbeddedChannel ch = new EmbeddedChannel(new ChannelHandler[]{new Http2StreamFrameToHttpObjectCodec(true)});
        DefaultHttp2Headers headers = new DefaultHttp2Headers();
        headers.set((Object)"key", (Object)"value");
        Assertions.assertTrue((boolean)ch.writeInbound(new Object[]{new DefaultHttp2HeadersFrame((Http2Headers)headers, true)}));
        LastHttpContent trailers = (LastHttpContent)ch.readInbound();
        try {
            MatcherAssert.assertThat((Object)trailers.content().readableBytes(), (Matcher)CoreMatchers.is((Object)0));
            MatcherAssert.assertThat((Object)trailers.trailingHeaders().get("key"), (Matcher)CoreMatchers.is((Object)"value"));
            Assertions.assertFalse((boolean)(trailers instanceof FullHttpRequest));
        }
        finally {
            trailers.release();
        }
        MatcherAssert.assertThat((Object)ch.readInbound(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
        Assertions.assertFalse((boolean)ch.finish());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDowngradeData() throws Exception {
        EmbeddedChannel ch = new EmbeddedChannel(new ChannelHandler[]{new Http2StreamFrameToHttpObjectCodec(true)});
        ByteBuf hello = Unpooled.copiedBuffer((CharSequence)"hello world", (Charset)CharsetUtil.UTF_8);
        Assertions.assertTrue((boolean)ch.writeInbound(new Object[]{new DefaultHttp2DataFrame(hello)}));
        HttpContent content = (HttpContent)ch.readInbound();
        try {
            MatcherAssert.assertThat((Object)content.content().toString(CharsetUtil.UTF_8), (Matcher)CoreMatchers.is((Object)"hello world"));
            Assertions.assertFalse((boolean)(content instanceof LastHttpContent));
        }
        finally {
            content.release();
        }
        MatcherAssert.assertThat((Object)ch.readInbound(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
        Assertions.assertFalse((boolean)ch.finish());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDowngradeEndData() throws Exception {
        EmbeddedChannel ch = new EmbeddedChannel(new ChannelHandler[]{new Http2StreamFrameToHttpObjectCodec(true)});
        ByteBuf hello = Unpooled.copiedBuffer((CharSequence)"hello world", (Charset)CharsetUtil.UTF_8);
        Assertions.assertTrue((boolean)ch.writeInbound(new Object[]{new DefaultHttp2DataFrame(hello, true)}));
        LastHttpContent content = (LastHttpContent)ch.readInbound();
        try {
            MatcherAssert.assertThat((Object)content.content().toString(CharsetUtil.UTF_8), (Matcher)CoreMatchers.is((Object)"hello world"));
            Assertions.assertTrue((boolean)content.trailingHeaders().isEmpty());
        }
        finally {
            content.release();
        }
        MatcherAssert.assertThat((Object)ch.readInbound(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
        Assertions.assertFalse((boolean)ch.finish());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testPassThroughOther() throws Exception {
        EmbeddedChannel ch = new EmbeddedChannel(new ChannelHandler[]{new Http2StreamFrameToHttpObjectCodec(true)});
        DefaultHttp2ResetFrame reset = new DefaultHttp2ResetFrame(0L);
        DefaultHttp2GoAwayFrame goaway = new DefaultHttp2GoAwayFrame(0L);
        Assertions.assertTrue((boolean)ch.writeInbound(new Object[]{reset}));
        Assertions.assertTrue((boolean)ch.writeInbound(new Object[]{goaway.retain()}));
        Assertions.assertEquals((Object)reset, (Object)ch.readInbound());
        Http2GoAwayFrame frame = (Http2GoAwayFrame)ch.readInbound();
        try {
            Assertions.assertEquals((Object)goaway, (Object)frame);
            MatcherAssert.assertThat((Object)ch.readInbound(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
            Assertions.assertFalse((boolean)ch.finish());
        }
        finally {
            goaway.release();
            frame.release();
        }
    }

    @Test
    public void testEncodeEmptyFullRequest() throws Exception {
        EmbeddedChannel ch = new EmbeddedChannel(new ChannelHandler[]{new Http2StreamFrameToHttpObjectCodec(false)});
        Assertions.assertTrue((boolean)ch.writeOutbound(new Object[]{new DefaultFullHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.GET, "/hello/world")}));
        Http2HeadersFrame headersFrame = (Http2HeadersFrame)ch.readOutbound();
        Http2Headers headers = headersFrame.headers();
        MatcherAssert.assertThat((Object)headers.scheme().toString(), (Matcher)CoreMatchers.is((Object)"http"));
        MatcherAssert.assertThat((Object)headers.method().toString(), (Matcher)CoreMatchers.is((Object)"GET"));
        MatcherAssert.assertThat((Object)headers.path().toString(), (Matcher)CoreMatchers.is((Object)"/hello/world"));
        Assertions.assertTrue((boolean)headersFrame.isEndStream());
        MatcherAssert.assertThat((Object)ch.readOutbound(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
        Assertions.assertFalse((boolean)ch.finish());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testEncodeHttpsSchemeWhenSslHandlerExists() throws Exception {
        final ConcurrentLinkedQueue frames = new ConcurrentLinkedQueue();
        SslContext ctx = SslContextBuilder.forClient().sslProvider(SslProvider.JDK).build();
        EmbeddedChannel ch = new EmbeddedChannel(new ChannelHandler[]{ctx.newHandler(ByteBufAllocator.DEFAULT), new ChannelOutboundHandlerAdapter(){

            public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) throws Exception {
                if (msg instanceof Http2StreamFrame) {
                    frames.add((Http2StreamFrame)msg);
                    ctx.write((Object)Unpooled.EMPTY_BUFFER, promise);
                } else {
                    ctx.write(msg, promise);
                }
            }
        }, new Http2StreamFrameToHttpObjectCodec(false)});
        try {
            DefaultFullHttpRequest req = new DefaultFullHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.GET, "/hello/world");
            Assertions.assertTrue((boolean)ch.writeOutbound(new Object[]{req}));
            ch.finishAndReleaseAll();
            Http2HeadersFrame headersFrame = (Http2HeadersFrame)frames.poll();
            Http2Headers headers = headersFrame.headers();
            MatcherAssert.assertThat((Object)headers.scheme().toString(), (Matcher)CoreMatchers.is((Object)"https"));
            MatcherAssert.assertThat((Object)headers.method().toString(), (Matcher)CoreMatchers.is((Object)"GET"));
            MatcherAssert.assertThat((Object)headers.path().toString(), (Matcher)CoreMatchers.is((Object)"/hello/world"));
            Assertions.assertTrue((boolean)headersFrame.isEndStream());
            Assertions.assertNull(frames.poll());
        }
        finally {
            ch.finishAndReleaseAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testEncodeNonEmptyFullRequest() throws Exception {
        EmbeddedChannel ch = new EmbeddedChannel(new ChannelHandler[]{new Http2StreamFrameToHttpObjectCodec(false)});
        ByteBuf hello = Unpooled.copiedBuffer((CharSequence)"hello world", (Charset)CharsetUtil.UTF_8);
        Assertions.assertTrue((boolean)ch.writeOutbound(new Object[]{new DefaultFullHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.PUT, "/hello/world", hello)}));
        Http2HeadersFrame headersFrame = (Http2HeadersFrame)ch.readOutbound();
        Http2Headers headers = headersFrame.headers();
        MatcherAssert.assertThat((Object)headers.scheme().toString(), (Matcher)CoreMatchers.is((Object)"http"));
        MatcherAssert.assertThat((Object)headers.method().toString(), (Matcher)CoreMatchers.is((Object)"PUT"));
        MatcherAssert.assertThat((Object)headers.path().toString(), (Matcher)CoreMatchers.is((Object)"/hello/world"));
        Assertions.assertFalse((boolean)headersFrame.isEndStream());
        Http2DataFrame dataFrame = (Http2DataFrame)ch.readOutbound();
        try {
            MatcherAssert.assertThat((Object)dataFrame.content().toString(CharsetUtil.UTF_8), (Matcher)CoreMatchers.is((Object)"hello world"));
            Assertions.assertTrue((boolean)dataFrame.isEndStream());
        }
        finally {
            dataFrame.release();
        }
        MatcherAssert.assertThat((Object)ch.readOutbound(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
        Assertions.assertFalse((boolean)ch.finish());
    }

    @Test
    public void testEncodeEmptyFullRequestWithTrailers() throws Exception {
        EmbeddedChannel ch = new EmbeddedChannel(new ChannelHandler[]{new Http2StreamFrameToHttpObjectCodec(false)});
        DefaultFullHttpRequest request = new DefaultFullHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.PUT, "/hello/world");
        HttpHeaders trailers = request.trailingHeaders();
        trailers.set("key", (Object)"value");
        Assertions.assertTrue((boolean)ch.writeOutbound(new Object[]{request}));
        Http2HeadersFrame headersFrame = (Http2HeadersFrame)ch.readOutbound();
        Http2Headers headers = headersFrame.headers();
        MatcherAssert.assertThat((Object)headers.scheme().toString(), (Matcher)CoreMatchers.is((Object)"http"));
        MatcherAssert.assertThat((Object)headers.method().toString(), (Matcher)CoreMatchers.is((Object)"PUT"));
        MatcherAssert.assertThat((Object)headers.path().toString(), (Matcher)CoreMatchers.is((Object)"/hello/world"));
        Assertions.assertFalse((boolean)headersFrame.isEndStream());
        Http2HeadersFrame trailersFrame = (Http2HeadersFrame)ch.readOutbound();
        MatcherAssert.assertThat((Object)((CharSequence)trailersFrame.headers().get((Object)"key")).toString(), (Matcher)CoreMatchers.is((Object)"value"));
        Assertions.assertTrue((boolean)trailersFrame.isEndStream());
        MatcherAssert.assertThat((Object)ch.readOutbound(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
        Assertions.assertFalse((boolean)ch.finish());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testEncodeNonEmptyFullRequestWithTrailers() throws Exception {
        EmbeddedChannel ch = new EmbeddedChannel(new ChannelHandler[]{new Http2StreamFrameToHttpObjectCodec(false)});
        ByteBuf hello = Unpooled.copiedBuffer((CharSequence)"hello world", (Charset)CharsetUtil.UTF_8);
        DefaultFullHttpRequest request = new DefaultFullHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.PUT, "/hello/world", hello);
        HttpHeaders trailers = request.trailingHeaders();
        trailers.set("key", (Object)"value");
        Assertions.assertTrue((boolean)ch.writeOutbound(new Object[]{request}));
        Http2HeadersFrame headersFrame = (Http2HeadersFrame)ch.readOutbound();
        Http2Headers headers = headersFrame.headers();
        MatcherAssert.assertThat((Object)headers.scheme().toString(), (Matcher)CoreMatchers.is((Object)"http"));
        MatcherAssert.assertThat((Object)headers.method().toString(), (Matcher)CoreMatchers.is((Object)"PUT"));
        MatcherAssert.assertThat((Object)headers.path().toString(), (Matcher)CoreMatchers.is((Object)"/hello/world"));
        Assertions.assertFalse((boolean)headersFrame.isEndStream());
        Http2DataFrame dataFrame = (Http2DataFrame)ch.readOutbound();
        try {
            MatcherAssert.assertThat((Object)dataFrame.content().toString(CharsetUtil.UTF_8), (Matcher)CoreMatchers.is((Object)"hello world"));
            Assertions.assertFalse((boolean)dataFrame.isEndStream());
        }
        finally {
            dataFrame.release();
        }
        Http2HeadersFrame trailersFrame = (Http2HeadersFrame)ch.readOutbound();
        MatcherAssert.assertThat((Object)((CharSequence)trailersFrame.headers().get((Object)"key")).toString(), (Matcher)CoreMatchers.is((Object)"value"));
        Assertions.assertTrue((boolean)trailersFrame.isEndStream());
        MatcherAssert.assertThat((Object)ch.readOutbound(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
        Assertions.assertFalse((boolean)ch.finish());
    }

    @Test
    public void testEncodeRequestHeaders() throws Exception {
        EmbeddedChannel ch = new EmbeddedChannel(new ChannelHandler[]{new Http2StreamFrameToHttpObjectCodec(false)});
        DefaultHttpRequest request = new DefaultHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.GET, "/hello/world");
        Assertions.assertTrue((boolean)ch.writeOutbound(new Object[]{request}));
        Http2HeadersFrame headersFrame = (Http2HeadersFrame)ch.readOutbound();
        Http2Headers headers = headersFrame.headers();
        MatcherAssert.assertThat((Object)headers.scheme().toString(), (Matcher)CoreMatchers.is((Object)"http"));
        MatcherAssert.assertThat((Object)headers.method().toString(), (Matcher)CoreMatchers.is((Object)"GET"));
        MatcherAssert.assertThat((Object)headers.path().toString(), (Matcher)CoreMatchers.is((Object)"/hello/world"));
        Assertions.assertFalse((boolean)headersFrame.isEndStream());
        MatcherAssert.assertThat((Object)ch.readOutbound(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
        Assertions.assertFalse((boolean)ch.finish());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testEncodeChunkAsClient() throws Exception {
        EmbeddedChannel ch = new EmbeddedChannel(new ChannelHandler[]{new Http2StreamFrameToHttpObjectCodec(false)});
        ByteBuf hello = Unpooled.copiedBuffer((CharSequence)"hello world", (Charset)CharsetUtil.UTF_8);
        DefaultHttpContent content = new DefaultHttpContent(hello);
        Assertions.assertTrue((boolean)ch.writeOutbound(new Object[]{content}));
        Http2DataFrame dataFrame = (Http2DataFrame)ch.readOutbound();
        try {
            MatcherAssert.assertThat((Object)dataFrame.content().toString(CharsetUtil.UTF_8), (Matcher)CoreMatchers.is((Object)"hello world"));
            Assertions.assertFalse((boolean)dataFrame.isEndStream());
        }
        finally {
            dataFrame.release();
        }
        MatcherAssert.assertThat((Object)ch.readOutbound(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
        Assertions.assertFalse((boolean)ch.finish());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testEncodeEmptyEndAsClient() throws Exception {
        EmbeddedChannel ch = new EmbeddedChannel(new ChannelHandler[]{new Http2StreamFrameToHttpObjectCodec(false)});
        LastHttpContent end = LastHttpContent.EMPTY_LAST_CONTENT;
        Assertions.assertTrue((boolean)ch.writeOutbound(new Object[]{end}));
        Http2DataFrame emptyFrame = (Http2DataFrame)ch.readOutbound();
        try {
            MatcherAssert.assertThat((Object)emptyFrame.content().readableBytes(), (Matcher)CoreMatchers.is((Object)0));
            Assertions.assertTrue((boolean)emptyFrame.isEndStream());
        }
        finally {
            emptyFrame.release();
        }
        MatcherAssert.assertThat((Object)ch.readOutbound(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
        Assertions.assertFalse((boolean)ch.finish());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testEncodeDataEndAsClient() throws Exception {
        EmbeddedChannel ch = new EmbeddedChannel(new ChannelHandler[]{new Http2StreamFrameToHttpObjectCodec(false)});
        ByteBuf hello = Unpooled.copiedBuffer((CharSequence)"hello world", (Charset)CharsetUtil.UTF_8);
        DefaultLastHttpContent end = new DefaultLastHttpContent(hello, true);
        Assertions.assertTrue((boolean)ch.writeOutbound(new Object[]{end}));
        Http2DataFrame dataFrame = (Http2DataFrame)ch.readOutbound();
        try {
            MatcherAssert.assertThat((Object)dataFrame.content().toString(CharsetUtil.UTF_8), (Matcher)CoreMatchers.is((Object)"hello world"));
            Assertions.assertTrue((boolean)dataFrame.isEndStream());
        }
        finally {
            dataFrame.release();
        }
        MatcherAssert.assertThat((Object)ch.readOutbound(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
        Assertions.assertFalse((boolean)ch.finish());
    }

    @Test
    public void testEncodeTrailersAsClient() throws Exception {
        EmbeddedChannel ch = new EmbeddedChannel(new ChannelHandler[]{new Http2StreamFrameToHttpObjectCodec(false)});
        DefaultLastHttpContent trailers = new DefaultLastHttpContent(Unpooled.EMPTY_BUFFER, true);
        HttpHeaders headers = trailers.trailingHeaders();
        headers.set("key", (Object)"value");
        Assertions.assertTrue((boolean)ch.writeOutbound(new Object[]{trailers}));
        Http2HeadersFrame headerFrame = (Http2HeadersFrame)ch.readOutbound();
        MatcherAssert.assertThat((Object)((CharSequence)headerFrame.headers().get((Object)"key")).toString(), (Matcher)CoreMatchers.is((Object)"value"));
        Assertions.assertTrue((boolean)headerFrame.isEndStream());
        MatcherAssert.assertThat((Object)ch.readOutbound(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
        Assertions.assertFalse((boolean)ch.finish());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testEncodeDataEndWithTrailersAsClient() throws Exception {
        EmbeddedChannel ch = new EmbeddedChannel(new ChannelHandler[]{new Http2StreamFrameToHttpObjectCodec(false)});
        ByteBuf hello = Unpooled.copiedBuffer((CharSequence)"hello world", (Charset)CharsetUtil.UTF_8);
        DefaultLastHttpContent trailers = new DefaultLastHttpContent(hello, true);
        HttpHeaders headers = trailers.trailingHeaders();
        headers.set("key", (Object)"value");
        Assertions.assertTrue((boolean)ch.writeOutbound(new Object[]{trailers}));
        Http2DataFrame dataFrame = (Http2DataFrame)ch.readOutbound();
        try {
            MatcherAssert.assertThat((Object)dataFrame.content().toString(CharsetUtil.UTF_8), (Matcher)CoreMatchers.is((Object)"hello world"));
            Assertions.assertFalse((boolean)dataFrame.isEndStream());
        }
        finally {
            dataFrame.release();
        }
        Http2HeadersFrame headerFrame = (Http2HeadersFrame)ch.readOutbound();
        MatcherAssert.assertThat((Object)((CharSequence)headerFrame.headers().get((Object)"key")).toString(), (Matcher)CoreMatchers.is((Object)"value"));
        Assertions.assertTrue((boolean)headerFrame.isEndStream());
        MatcherAssert.assertThat((Object)ch.readOutbound(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
        Assertions.assertFalse((boolean)ch.finish());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void decode100ContinueHttp2HeadersAsFullHttpResponse() throws Exception {
        EmbeddedChannel ch = new EmbeddedChannel(new ChannelHandler[]{new Http2StreamFrameToHttpObjectCodec(false)});
        DefaultHttp2Headers headers = new DefaultHttp2Headers();
        headers.scheme((CharSequence)HttpScheme.HTTP.name());
        headers.status((CharSequence)HttpResponseStatus.CONTINUE.codeAsText());
        Assertions.assertTrue((boolean)ch.writeInbound(new Object[]{new DefaultHttp2HeadersFrame((Http2Headers)headers, false)}));
        FullHttpResponse response = (FullHttpResponse)ch.readInbound();
        try {
            MatcherAssert.assertThat((Object)response.status(), (Matcher)CoreMatchers.is((Object)HttpResponseStatus.CONTINUE));
            MatcherAssert.assertThat((Object)response.protocolVersion(), (Matcher)CoreMatchers.is((Object)HttpVersion.HTTP_1_1));
        }
        finally {
            response.release();
        }
        MatcherAssert.assertThat((Object)ch.readInbound(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
        Assertions.assertFalse((boolean)ch.finish());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void decode103EarlyHintsHttp2HeadersAsFullHttpResponse() throws Exception {
        EmbeddedChannel ch = new EmbeddedChannel(new ChannelHandler[]{new Http2StreamFrameToHttpObjectCodec(false)});
        DefaultHttp2Headers headers = new DefaultHttp2Headers();
        headers.scheme((CharSequence)HttpScheme.HTTP.name());
        headers.status((CharSequence)HttpResponseStatus.EARLY_HINTS.codeAsText());
        headers.set((Object)"key", (Object)"value");
        Assertions.assertTrue((boolean)ch.writeInbound(new Object[]{new DefaultHttp2HeadersFrame((Http2Headers)headers, false)}));
        FullHttpResponse response = (FullHttpResponse)ch.readInbound();
        try {
            MatcherAssert.assertThat((Object)response.status(), (Matcher)CoreMatchers.is((Object)HttpResponseStatus.EARLY_HINTS));
            MatcherAssert.assertThat((Object)response.protocolVersion(), (Matcher)CoreMatchers.is((Object)HttpVersion.HTTP_1_1));
            MatcherAssert.assertThat((Object)response.headers().get("key"), (Matcher)CoreMatchers.is((Object)"value"));
        }
        finally {
            response.release();
        }
        MatcherAssert.assertThat((Object)ch.readInbound(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
        Assertions.assertFalse((boolean)ch.finish());
    }

    @Test
    public void testDecodeResponseHeaders() throws Exception {
        EmbeddedChannel ch = new EmbeddedChannel(new ChannelHandler[]{new Http2StreamFrameToHttpObjectCodec(false)});
        DefaultHttp2Headers headers = new DefaultHttp2Headers();
        headers.scheme((CharSequence)HttpScheme.HTTP.name());
        headers.status((CharSequence)HttpResponseStatus.OK.codeAsText());
        Assertions.assertTrue((boolean)ch.writeInbound(new Object[]{new DefaultHttp2HeadersFrame((Http2Headers)headers)}));
        HttpResponse response = (HttpResponse)ch.readInbound();
        MatcherAssert.assertThat((Object)response.status(), (Matcher)CoreMatchers.is((Object)HttpResponseStatus.OK));
        MatcherAssert.assertThat((Object)response.protocolVersion(), (Matcher)CoreMatchers.is((Object)HttpVersion.HTTP_1_1));
        Assertions.assertFalse((boolean)(response instanceof FullHttpResponse));
        Assertions.assertTrue((boolean)HttpUtil.isTransferEncodingChunked((HttpMessage)response));
        MatcherAssert.assertThat((Object)ch.readInbound(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
        Assertions.assertFalse((boolean)ch.finish());
    }

    @Test
    public void testDecodeResponseHeadersWithContentLength() throws Exception {
        EmbeddedChannel ch = new EmbeddedChannel(new ChannelHandler[]{new Http2StreamFrameToHttpObjectCodec(false)});
        DefaultHttp2Headers headers = new DefaultHttp2Headers();
        headers.scheme((CharSequence)HttpScheme.HTTP.name());
        headers.status((CharSequence)HttpResponseStatus.OK.codeAsText());
        headers.setInt((Object)"content-length", 0);
        Assertions.assertTrue((boolean)ch.writeInbound(new Object[]{new DefaultHttp2HeadersFrame((Http2Headers)headers)}));
        HttpResponse response = (HttpResponse)ch.readInbound();
        MatcherAssert.assertThat((Object)response.status(), (Matcher)CoreMatchers.is((Object)HttpResponseStatus.OK));
        MatcherAssert.assertThat((Object)response.protocolVersion(), (Matcher)CoreMatchers.is((Object)HttpVersion.HTTP_1_1));
        Assertions.assertFalse((boolean)(response instanceof FullHttpResponse));
        Assertions.assertFalse((boolean)HttpUtil.isTransferEncodingChunked((HttpMessage)response));
        MatcherAssert.assertThat((Object)ch.readInbound(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
        Assertions.assertFalse((boolean)ch.finish());
    }

    @Test
    public void testDecodeFullResponseHeaders() throws Exception {
        this.testDecodeFullResponseHeaders(false);
    }

    @Test
    public void testDecodeFullResponseHeadersWithStreamID() throws Exception {
        this.testDecodeFullResponseHeaders(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testDecodeFullResponseHeaders(boolean withStreamId) throws Exception {
        EmbeddedChannel ch = new EmbeddedChannel(new ChannelHandler[]{new Http2StreamFrameToHttpObjectCodec(false)});
        DefaultHttp2Headers headers = new DefaultHttp2Headers();
        headers.scheme((CharSequence)HttpScheme.HTTP.name());
        headers.status((CharSequence)HttpResponseStatus.OK.codeAsText());
        DefaultHttp2HeadersFrame frame = new DefaultHttp2HeadersFrame((Http2Headers)headers, true);
        if (withStreamId) {
            frame.stream(new Http2FrameStream(){

                public int id() {
                    return 1;
                }

                public Http2Stream.State state() {
                    return Http2Stream.State.OPEN;
                }
            });
        }
        Assertions.assertTrue((boolean)ch.writeInbound(new Object[]{frame}));
        FullHttpResponse response = (FullHttpResponse)ch.readInbound();
        try {
            MatcherAssert.assertThat((Object)response.status(), (Matcher)CoreMatchers.is((Object)HttpResponseStatus.OK));
            MatcherAssert.assertThat((Object)response.protocolVersion(), (Matcher)CoreMatchers.is((Object)HttpVersion.HTTP_1_1));
            MatcherAssert.assertThat((Object)response.content().readableBytes(), (Matcher)CoreMatchers.is((Object)0));
            Assertions.assertTrue((boolean)response.trailingHeaders().isEmpty());
            Assertions.assertFalse((boolean)HttpUtil.isTransferEncodingChunked((HttpMessage)response));
            if (withStreamId) {
                Assertions.assertEquals((int)1, (int)response.headers().getInt((CharSequence)HttpConversionUtil.ExtensionHeaderNames.STREAM_ID.text()));
            }
        }
        finally {
            response.release();
        }
        MatcherAssert.assertThat((Object)ch.readInbound(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
        Assertions.assertFalse((boolean)ch.finish());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDecodeResponseTrailersAsClient() throws Exception {
        EmbeddedChannel ch = new EmbeddedChannel(new ChannelHandler[]{new Http2StreamFrameToHttpObjectCodec(false)});
        DefaultHttp2Headers headers = new DefaultHttp2Headers();
        headers.set((Object)"key", (Object)"value");
        Assertions.assertTrue((boolean)ch.writeInbound(new Object[]{new DefaultHttp2HeadersFrame((Http2Headers)headers, true)}));
        LastHttpContent trailers = (LastHttpContent)ch.readInbound();
        try {
            MatcherAssert.assertThat((Object)trailers.content().readableBytes(), (Matcher)CoreMatchers.is((Object)0));
            MatcherAssert.assertThat((Object)trailers.trailingHeaders().get("key"), (Matcher)CoreMatchers.is((Object)"value"));
            Assertions.assertFalse((boolean)(trailers instanceof FullHttpRequest));
        }
        finally {
            trailers.release();
        }
        MatcherAssert.assertThat((Object)ch.readInbound(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
        Assertions.assertFalse((boolean)ch.finish());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDecodeDataAsClient() throws Exception {
        EmbeddedChannel ch = new EmbeddedChannel(new ChannelHandler[]{new Http2StreamFrameToHttpObjectCodec(false)});
        ByteBuf hello = Unpooled.copiedBuffer((CharSequence)"hello world", (Charset)CharsetUtil.UTF_8);
        Assertions.assertTrue((boolean)ch.writeInbound(new Object[]{new DefaultHttp2DataFrame(hello)}));
        HttpContent content = (HttpContent)ch.readInbound();
        try {
            MatcherAssert.assertThat((Object)content.content().toString(CharsetUtil.UTF_8), (Matcher)CoreMatchers.is((Object)"hello world"));
            Assertions.assertFalse((boolean)(content instanceof LastHttpContent));
        }
        finally {
            content.release();
        }
        MatcherAssert.assertThat((Object)ch.readInbound(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
        Assertions.assertFalse((boolean)ch.finish());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDecodeEndDataAsClient() throws Exception {
        EmbeddedChannel ch = new EmbeddedChannel(new ChannelHandler[]{new Http2StreamFrameToHttpObjectCodec(false)});
        ByteBuf hello = Unpooled.copiedBuffer((CharSequence)"hello world", (Charset)CharsetUtil.UTF_8);
        Assertions.assertTrue((boolean)ch.writeInbound(new Object[]{new DefaultHttp2DataFrame(hello, true)}));
        LastHttpContent content = (LastHttpContent)ch.readInbound();
        try {
            MatcherAssert.assertThat((Object)content.content().toString(CharsetUtil.UTF_8), (Matcher)CoreMatchers.is((Object)"hello world"));
            Assertions.assertTrue((boolean)content.trailingHeaders().isEmpty());
        }
        finally {
            content.release();
        }
        MatcherAssert.assertThat((Object)ch.readInbound(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
        Assertions.assertFalse((boolean)ch.finish());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testPassThroughOtherAsClient() throws Exception {
        EmbeddedChannel ch = new EmbeddedChannel(new ChannelHandler[]{new Http2StreamFrameToHttpObjectCodec(false)});
        DefaultHttp2ResetFrame reset = new DefaultHttp2ResetFrame(0L);
        DefaultHttp2GoAwayFrame goaway = new DefaultHttp2GoAwayFrame(0L);
        Assertions.assertTrue((boolean)ch.writeInbound(new Object[]{reset}));
        Assertions.assertTrue((boolean)ch.writeInbound(new Object[]{goaway.retain()}));
        Assertions.assertEquals((Object)reset, (Object)ch.readInbound());
        Http2GoAwayFrame frame = (Http2GoAwayFrame)ch.readInbound();
        try {
            Assertions.assertEquals((Object)goaway, (Object)frame);
            MatcherAssert.assertThat((Object)ch.readInbound(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
            Assertions.assertFalse((boolean)ch.finish());
        }
        finally {
            goaway.release();
            frame.release();
        }
    }

    @Test
    public void testIsSharableBetweenChannels() throws Exception {
        final ConcurrentLinkedQueue frames = new ConcurrentLinkedQueue();
        Http2StreamFrameToHttpObjectCodec sharedHandler = new Http2StreamFrameToHttpObjectCodec(false);
        SslContext ctx = SslContextBuilder.forClient().sslProvider(SslProvider.JDK).build();
        EmbeddedChannel tlsCh = new EmbeddedChannel(new ChannelHandler[]{ctx.newHandler(ByteBufAllocator.DEFAULT), new ChannelOutboundHandlerAdapter(){

            public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) {
                if (msg instanceof Http2StreamFrame) {
                    frames.add((Http2StreamFrame)msg);
                    promise.setSuccess();
                } else {
                    ctx.write(msg, promise);
                }
            }
        }, sharedHandler});
        EmbeddedChannel plaintextCh = new EmbeddedChannel(new ChannelHandler[]{new ChannelOutboundHandlerAdapter(){

            public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) {
                if (msg instanceof Http2StreamFrame) {
                    frames.add((Http2StreamFrame)msg);
                    promise.setSuccess();
                } else {
                    ctx.write(msg, promise);
                }
            }
        }, sharedHandler});
        DefaultFullHttpRequest req = new DefaultFullHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.GET, "/hello/world");
        Assertions.assertTrue((boolean)tlsCh.writeOutbound(new Object[]{req}));
        Assertions.assertTrue((boolean)tlsCh.finishAndReleaseAll());
        Http2HeadersFrame headersFrame = (Http2HeadersFrame)frames.poll();
        Http2Headers headers = headersFrame.headers();
        MatcherAssert.assertThat((Object)headers.scheme().toString(), (Matcher)CoreMatchers.is((Object)"https"));
        MatcherAssert.assertThat((Object)headers.method().toString(), (Matcher)CoreMatchers.is((Object)"GET"));
        MatcherAssert.assertThat((Object)headers.path().toString(), (Matcher)CoreMatchers.is((Object)"/hello/world"));
        Assertions.assertTrue((boolean)headersFrame.isEndStream());
        Assertions.assertNull(frames.poll());
        req = new DefaultFullHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.GET, "/hello/world");
        Assertions.assertFalse((boolean)plaintextCh.writeOutbound(new Object[]{req}));
        Assertions.assertFalse((boolean)plaintextCh.finishAndReleaseAll());
        headersFrame = (Http2HeadersFrame)frames.poll();
        headers = headersFrame.headers();
        MatcherAssert.assertThat((Object)headers.scheme().toString(), (Matcher)CoreMatchers.is((Object)"http"));
        MatcherAssert.assertThat((Object)headers.method().toString(), (Matcher)CoreMatchers.is((Object)"GET"));
        MatcherAssert.assertThat((Object)headers.path().toString(), (Matcher)CoreMatchers.is((Object)"/hello/world"));
        Assertions.assertTrue((boolean)headersFrame.isEndStream());
        Assertions.assertNull(frames.poll());
    }
}

