/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http2;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.channel.Channel;
import io.netty.channel.ChannelConfig;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.RecvByteBufAllocator;
import io.netty.util.UncheckedBooleanSupplier;
import java.util.concurrent.atomic.AtomicInteger;

@ChannelHandler.Sharable
public class TestChannelInitializer
extends ChannelInitializer<Channel> {
    ChannelHandler handler;
    AtomicInteger maxReads;

    public void initChannel(Channel channel) {
        if (this.handler != null) {
            channel.pipeline().addLast(new ChannelHandler[]{this.handler});
            this.handler = null;
        }
        if (this.maxReads != null) {
            channel.config().setRecvByteBufAllocator((RecvByteBufAllocator)new TestNumReadsRecvByteBufAllocator(this.maxReads));
        }
    }

    static final class TestNumReadsRecvByteBufAllocator
    implements RecvByteBufAllocator {
        private final AtomicInteger numReads;

        private TestNumReadsRecvByteBufAllocator(AtomicInteger numReads) {
            this.numReads = numReads;
        }

        public RecvByteBufAllocator.ExtendedHandle newHandle() {
            return new RecvByteBufAllocator.ExtendedHandle(){
                private int attemptedBytesRead;
                private int lastBytesRead;
                private int numMessagesRead;

                public ByteBuf allocate(ByteBufAllocator alloc) {
                    return alloc.ioBuffer(this.guess(), this.guess());
                }

                public int guess() {
                    return 1;
                }

                public void reset(ChannelConfig config) {
                    this.numMessagesRead = 0;
                }

                public void incMessagesRead(int numMessages) {
                    this.numMessagesRead += numMessages;
                }

                public void lastBytesRead(int bytes) {
                    this.lastBytesRead = bytes;
                }

                public int lastBytesRead() {
                    return this.lastBytesRead;
                }

                public void attemptedBytesRead(int bytes) {
                    this.attemptedBytesRead = bytes;
                }

                public int attemptedBytesRead() {
                    return this.attemptedBytesRead;
                }

                public boolean continueReading() {
                    return this.numMessagesRead < TestNumReadsRecvByteBufAllocator.this.numReads.get();
                }

                public boolean continueReading(UncheckedBooleanSupplier maybeMoreDataSupplier) {
                    return this.continueReading();
                }

                public void readComplete() {
                }
            };
        }
    }
}

