/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http2;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.buffer.UnpooledByteBufAllocator;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.channel.DefaultChannelPromise;
import io.netty.handler.codec.http2.DefaultHttp2FrameWriter;
import io.netty.handler.codec.http2.DefaultHttp2Headers;
import io.netty.handler.codec.http2.DefaultHttp2HeadersEncoder;
import io.netty.handler.codec.http2.HpackEncoder;
import io.netty.handler.codec.http2.Http2Exception;
import io.netty.handler.codec.http2.Http2Flags;
import io.netty.handler.codec.http2.Http2Headers;
import io.netty.handler.codec.http2.Http2HeadersEncoder;
import io.netty.util.ReferenceCountUtil;
import io.netty.util.concurrent.EventExecutor;
import io.netty.util.concurrent.ImmediateEventExecutor;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Arrays;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;

public class DefaultHttp2FrameWriterTest {
    private DefaultHttp2FrameWriter frameWriter;
    private ByteBuf outbound;
    private ByteBuf expectedOutbound;
    private ChannelPromise promise;
    private Http2HeadersEncoder http2HeadersEncoder;
    @Mock
    private Channel channel;
    @Mock
    private ChannelFuture future;
    @Mock
    private ChannelHandlerContext ctx;

    @BeforeEach
    public void setUp() throws Exception {
        MockitoAnnotations.initMocks((Object)this);
        this.http2HeadersEncoder = new DefaultHttp2HeadersEncoder(Http2HeadersEncoder.NEVER_SENSITIVE, new HpackEncoder(false, 16, 0));
        this.frameWriter = new DefaultHttp2FrameWriter((Http2HeadersEncoder)new DefaultHttp2HeadersEncoder(Http2HeadersEncoder.NEVER_SENSITIVE, new HpackEncoder(false, 16, 0)));
        this.outbound = Unpooled.buffer();
        this.expectedOutbound = Unpooled.EMPTY_BUFFER;
        this.promise = new DefaultChannelPromise(this.channel, (EventExecutor)ImmediateEventExecutor.INSTANCE);
        Answer<Object> answer = new Answer<Object>(){

            public Object answer(InvocationOnMock var1) throws Throwable {
                Object msg = var1.getArgument(0);
                if (msg instanceof ByteBuf) {
                    DefaultHttp2FrameWriterTest.this.outbound.writeBytes((ByteBuf)msg);
                }
                ReferenceCountUtil.release((Object)msg);
                return DefaultHttp2FrameWriterTest.this.future;
            }
        };
        Mockito.when((Object)this.ctx.write(Mockito.any())).then((Answer)answer);
        Mockito.when((Object)this.ctx.write(Mockito.any(), (ChannelPromise)Mockito.any(ChannelPromise.class))).then((Answer)answer);
        Mockito.when((Object)this.ctx.alloc()).thenReturn((Object)UnpooledByteBufAllocator.DEFAULT);
        Mockito.when((Object)this.ctx.channel()).thenReturn((Object)this.channel);
        Mockito.when((Object)this.ctx.executor()).thenReturn((Object)ImmediateEventExecutor.INSTANCE);
    }

    @AfterEach
    public void tearDown() throws Exception {
        this.outbound.release();
        this.expectedOutbound.release();
        this.frameWriter.close();
    }

    @Test
    public void writeHeaders() throws Exception {
        int streamId = 1;
        Http2Headers headers = new DefaultHttp2Headers().method((CharSequence)"GET").path((CharSequence)"/").authority((CharSequence)"foo.com").scheme((CharSequence)"https");
        this.frameWriter.writeHeaders(this.ctx, streamId, headers, 0, true, this.promise);
        byte[] expectedPayload = this.headerPayload(streamId, headers);
        byte[] expectedFrameBytes = new byte[]{0, 0, 10, 1, 5, 0, 0, 0, 1};
        this.expectedOutbound = Unpooled.copiedBuffer((byte[][])new byte[][]{expectedFrameBytes, expectedPayload});
        Assertions.assertEquals((Object)this.expectedOutbound, (Object)this.outbound);
    }

    @Test
    public void writeHeadersWithPadding() throws Exception {
        int streamId = 1;
        Http2Headers headers = new DefaultHttp2Headers().method((CharSequence)"GET").path((CharSequence)"/").authority((CharSequence)"foo.com").scheme((CharSequence)"https");
        this.frameWriter.writeHeaders(this.ctx, streamId, headers, 5, true, this.promise);
        byte[] expectedPayload = this.headerPayload(streamId, headers, (byte)4);
        byte[] expectedFrameBytes = new byte[]{0, 0, 15, 1, 13, 0, 0, 0, 1};
        this.expectedOutbound = Unpooled.copiedBuffer((byte[][])new byte[][]{expectedFrameBytes, expectedPayload});
        Assertions.assertEquals((Object)this.expectedOutbound, (Object)this.outbound);
    }

    @Test
    public void writeHeadersNotEndStream() throws Exception {
        int streamId = 1;
        Http2Headers headers = new DefaultHttp2Headers().method((CharSequence)"GET").path((CharSequence)"/").authority((CharSequence)"foo.com").scheme((CharSequence)"https");
        this.frameWriter.writeHeaders(this.ctx, streamId, headers, 0, false, this.promise);
        byte[] expectedPayload = this.headerPayload(streamId, headers);
        byte[] expectedFrameBytes = new byte[]{0, 0, 10, 1, 4, 0, 0, 0, 1};
        ByteBuf expectedOutbound = Unpooled.copiedBuffer((byte[][])new byte[][]{expectedFrameBytes, expectedPayload});
        Assertions.assertEquals((Object)expectedOutbound, (Object)this.outbound);
    }

    @Test
    public void writeEmptyDataWithPadding() {
        int streamId = 1;
        ByteBuf payloadByteBuf = Unpooled.buffer();
        this.frameWriter.writeData(this.ctx, streamId, payloadByteBuf, 2, true, this.promise);
        Assertions.assertEquals((int)0, (int)payloadByteBuf.refCnt());
        byte[] expectedFrameBytes = new byte[]{0, 0, 2, 0, 9, 0, 0, 0, 1, 1, 0};
        this.expectedOutbound = Unpooled.copiedBuffer((byte[])expectedFrameBytes);
        Assertions.assertEquals((Object)this.expectedOutbound, (Object)this.outbound);
    }

    @Test
    public void writeLargeHeaders() throws Exception {
        int streamId = 1;
        Http2Headers headers = new DefaultHttp2Headers().method((CharSequence)"GET").path((CharSequence)"/").authority((CharSequence)"foo.com").scheme((CharSequence)"https");
        headers = DefaultHttp2FrameWriterTest.dummyHeaders(headers, 20);
        this.http2HeadersEncoder.configuration().maxHeaderListSize(Integer.MAX_VALUE);
        this.frameWriter.headersConfiguration().maxHeaderListSize(Integer.MAX_VALUE);
        this.frameWriter.maxFrameSize(16384);
        this.frameWriter.writeHeaders(this.ctx, streamId, headers, 0, true, this.promise);
        byte[] expectedPayload = this.headerPayload(streamId, headers);
        Assertions.assertEquals((int)16384, (int)this.outbound.readUnsignedMedium());
        Assertions.assertEquals((int)1, (int)this.outbound.readByte());
        Assertions.assertEquals((int)1, (int)this.outbound.readByte());
        Assertions.assertEquals((int)streamId, (int)this.outbound.readInt());
        byte[] firstPayload = new byte[16384];
        this.outbound.readBytes(firstPayload);
        int remainPayloadLength = expectedPayload.length - 16384;
        Assertions.assertEquals((int)remainPayloadLength, (int)this.outbound.readUnsignedMedium());
        Assertions.assertEquals((int)9, (int)this.outbound.readByte());
        Assertions.assertEquals((int)4, (int)this.outbound.readByte());
        Assertions.assertEquals((int)streamId, (int)this.outbound.readInt());
        byte[] secondPayload = new byte[remainPayloadLength];
        this.outbound.readBytes(secondPayload);
        Assertions.assertArrayEquals((byte[])Arrays.copyOfRange(expectedPayload, 0, firstPayload.length), (byte[])firstPayload);
        Assertions.assertArrayEquals((byte[])Arrays.copyOfRange(expectedPayload, firstPayload.length, expectedPayload.length), (byte[])secondPayload);
    }

    @Test
    public void writeLargeHeaderWithPadding() throws Exception {
        int streamId = 1;
        Http2Headers headers = new DefaultHttp2Headers().method((CharSequence)"GET").path((CharSequence)"/").authority((CharSequence)"foo.com").scheme((CharSequence)"https");
        headers = DefaultHttp2FrameWriterTest.dummyHeaders(headers, 20);
        this.http2HeadersEncoder.configuration().maxHeaderListSize(Integer.MAX_VALUE);
        this.frameWriter.headersConfiguration().maxHeaderListSize(Integer.MAX_VALUE);
        this.frameWriter.maxFrameSize(16384);
        this.frameWriter.writeHeaders(this.ctx, streamId, headers, 5, true, this.promise);
        byte[] expectedPayload = this.buildLargeHeaderPayload(streamId, headers, (byte)4, 16384);
        Assertions.assertEquals((int)16384, (int)this.outbound.readUnsignedMedium());
        Assertions.assertEquals((int)1, (int)this.outbound.readByte());
        Assertions.assertEquals((int)9, (int)this.outbound.readByte());
        Assertions.assertEquals((int)streamId, (int)this.outbound.readInt());
        byte[] firstPayload = new byte[16384];
        this.outbound.readBytes(firstPayload);
        int remainPayloadLength = expectedPayload.length - 16384;
        Assertions.assertEquals((int)remainPayloadLength, (int)this.outbound.readUnsignedMedium());
        Assertions.assertEquals((int)9, (int)this.outbound.readByte());
        Assertions.assertEquals((int)4, (int)this.outbound.readByte());
        Assertions.assertEquals((int)streamId, (int)this.outbound.readInt());
        byte[] secondPayload = new byte[remainPayloadLength];
        this.outbound.readBytes(secondPayload);
        Assertions.assertArrayEquals((byte[])Arrays.copyOfRange(expectedPayload, 0, firstPayload.length), (byte[])firstPayload);
        Assertions.assertArrayEquals((byte[])Arrays.copyOfRange(expectedPayload, firstPayload.length, expectedPayload.length), (byte[])secondPayload);
    }

    @Test
    public void writeFrameZeroPayload() throws Exception {
        this.frameWriter.writeFrame(this.ctx, (byte)15, 0, new Http2Flags(), Unpooled.EMPTY_BUFFER, this.promise);
        byte[] expectedFrameBytes = new byte[]{0, 0, 0, 15, 0, 0, 0, 0, 0};
        this.expectedOutbound = Unpooled.wrappedBuffer((byte[])expectedFrameBytes);
        Assertions.assertEquals((Object)this.expectedOutbound, (Object)this.outbound);
    }

    @Test
    public void writeFrameHasPayload() throws Exception {
        byte[] payload = new byte[]{1, 3, 5, 7, 9};
        ByteBuf payloadByteBuf = Unpooled.wrappedBuffer((byte[])payload);
        this.frameWriter.writeFrame(this.ctx, (byte)15, 0, new Http2Flags(), payloadByteBuf, this.promise);
        byte[] expectedFrameHeaderBytes = new byte[]{0, 0, 5, 15, 0, 0, 0, 0, 0};
        this.expectedOutbound = Unpooled.copiedBuffer((byte[][])new byte[][]{expectedFrameHeaderBytes, payload});
        Assertions.assertEquals((Object)this.expectedOutbound, (Object)this.outbound);
    }

    @Test
    public void writePriority() {
        this.frameWriter.writePriority(this.ctx, 1, 2, (short)256, true, this.promise);
        this.expectedOutbound = Unpooled.copiedBuffer((byte[])new byte[]{0, 0, 5, 2, 0, 0, 0, 0, 1, -128, 0, 0, 2, -1});
        Assertions.assertEquals((Object)this.expectedOutbound, (Object)this.outbound);
    }

    @Test
    public void writePriorityDefaults() {
        this.frameWriter.writePriority(this.ctx, 1, 0, (short)16, false, this.promise);
        this.expectedOutbound = Unpooled.copiedBuffer((byte[])new byte[]{0, 0, 5, 2, 0, 0, 0, 0, 1, 0, 0, 0, 0, 15});
        Assertions.assertEquals((Object)this.expectedOutbound, (Object)this.outbound);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] headerPayload(int streamId, Http2Headers headers, byte padding) throws Http2Exception, IOException {
        if (padding == 0) {
            return this.headerPayload(streamId, headers);
        }
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        try {
            outputStream.write(padding);
            outputStream.write(this.headerPayload(streamId, headers));
            outputStream.write(new byte[padding]);
            byte[] byArray = outputStream.toByteArray();
            return byArray;
        }
        finally {
            outputStream.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] headerPayload(int streamId, Http2Headers headers) throws Http2Exception {
        ByteBuf byteBuf = Unpooled.buffer();
        try {
            this.http2HeadersEncoder.encodeHeaders(streamId, headers, byteBuf);
            byte[] bytes = new byte[byteBuf.readableBytes()];
            byteBuf.readBytes(bytes);
            byte[] byArray = bytes;
            return byArray;
        }
        finally {
            byteBuf.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] buildLargeHeaderPayload(int streamId, Http2Headers headers, byte padding, int maxFrameSize) throws Http2Exception, IOException {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        try {
            outputStream.write(padding);
            byte[] payload = this.headerPayload(streamId, headers);
            int firstPayloadSize = maxFrameSize - (padding + 1);
            outputStream.write(payload, 0, firstPayloadSize);
            outputStream.write(new byte[padding]);
            outputStream.write(payload, firstPayloadSize, payload.length - firstPayloadSize);
            byte[] byArray = outputStream.toByteArray();
            return byArray;
        }
        finally {
            outputStream.close();
        }
    }

    private static Http2Headers dummyHeaders(Http2Headers headers, int times) {
        String largeValue = DefaultHttp2FrameWriterTest.repeat("dummy-value", 100);
        for (int i = 0; i < times; ++i) {
            headers.add((Object)String.format("dummy-%d", i), (Object)largeValue);
        }
        return headers;
    }

    private static String repeat(String str, int count) {
        return String.format(String.format("%%%ds", count), " ").replace(" ", str);
    }
}

