/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http2;

import io.netty.bootstrap.Bootstrap;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.handler.codec.http2.DefaultHttp2DataFrame;
import io.netty.handler.codec.http2.DefaultHttp2Headers;
import io.netty.handler.codec.http2.DefaultHttp2HeadersFrame;
import io.netty.handler.codec.http2.DefaultHttp2SettingsFrame;
import io.netty.handler.codec.http2.Http2DataFrame;
import io.netty.handler.codec.http2.Http2FrameCodec;
import io.netty.handler.codec.http2.Http2FrameCodecBuilder;
import io.netty.handler.codec.http2.Http2Headers;
import io.netty.handler.codec.http2.Http2HeadersFrame;
import io.netty.handler.codec.http2.Http2MultiplexCodecBuilder;
import io.netty.handler.codec.http2.Http2MultiplexHandler;
import io.netty.handler.codec.http2.Http2SecurityUtil;
import io.netty.handler.codec.http2.Http2Settings;
import io.netty.handler.codec.http2.Http2SettingsAckFrame;
import io.netty.handler.codec.http2.Http2SettingsFrame;
import io.netty.handler.codec.http2.Http2StreamChannel;
import io.netty.handler.codec.http2.Http2StreamChannelBootstrap;
import io.netty.handler.ssl.ApplicationProtocolConfig;
import io.netty.handler.ssl.ApplicationProtocolNegotiationHandler;
import io.netty.handler.ssl.CipherSuiteFilter;
import io.netty.handler.ssl.ClientAuth;
import io.netty.handler.ssl.OpenSsl;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslContextBuilder;
import io.netty.handler.ssl.SslHandshakeCompletionEvent;
import io.netty.handler.ssl.SslProvider;
import io.netty.handler.ssl.SupportedCipherSuiteFilter;
import io.netty.handler.ssl.util.InsecureTrustManagerFactory;
import io.netty.handler.ssl.util.SelfSignedCertificate;
import io.netty.util.CharsetUtil;
import io.netty.util.NetUtil;
import io.netty.util.ReferenceCountUtil;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.FutureListener;
import io.netty.util.concurrent.GenericFutureListener;
import java.io.File;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.charset.Charset;
import java.security.cert.CertificateException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import javax.net.ssl.SSLException;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Assumptions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;
import org.junit.jupiter.api.condition.DisabledOnOs;
import org.junit.jupiter.api.condition.OS;

public class Http2MultiplexTransportTest {
    private static final ChannelHandler DISCARD_HANDLER = new ChannelInboundHandlerAdapter(){

        public boolean isSharable() {
            return true;
        }

        public void channelRead(ChannelHandlerContext ctx, Object msg) {
            ReferenceCountUtil.release((Object)msg);
        }

        public void userEventTriggered(ChannelHandlerContext ctx, Object evt) {
            ReferenceCountUtil.release((Object)evt);
        }
    };
    private EventLoopGroup eventLoopGroup;
    private Channel clientChannel;
    private Channel serverChannel;
    private Channel serverConnectedChannel;

    @BeforeEach
    public void setup() {
        this.eventLoopGroup = new NioEventLoopGroup();
    }

    @AfterEach
    public void teardown() {
        if (this.clientChannel != null) {
            this.clientChannel.close();
        }
        if (this.serverChannel != null) {
            this.serverChannel.close();
        }
        if (this.serverConnectedChannel != null) {
            this.serverConnectedChannel.close();
        }
        this.eventLoopGroup.shutdownGracefully(0L, 0L, TimeUnit.MILLISECONDS);
    }

    @Test
    @Timeout(value=10000L, unit=TimeUnit.MILLISECONDS)
    public void asyncSettingsAckWithMultiplexCodec() throws InterruptedException {
        this.asyncSettingsAck0((Http2FrameCodec)new Http2MultiplexCodecBuilder(true, DISCARD_HANDLER).build(), null);
    }

    @Test
    @Timeout(value=10000L, unit=TimeUnit.MILLISECONDS)
    public void asyncSettingsAckWithMultiplexHandler() throws InterruptedException {
        this.asyncSettingsAck0(new Http2FrameCodecBuilder(true).build(), (ChannelHandler)new Http2MultiplexHandler(DISCARD_HANDLER));
    }

    private void asyncSettingsAck0(final Http2FrameCodec codec, final ChannelHandler multiplexer) throws InterruptedException {
        final CountDownLatch serverAckOneLatch = new CountDownLatch(1);
        final CountDownLatch serverAckAllLatch = new CountDownLatch(2);
        final CountDownLatch clientSettingsLatch = new CountDownLatch(2);
        final CountDownLatch serverConnectedChannelLatch = new CountDownLatch(1);
        final AtomicReference serverConnectedChannelRef = new AtomicReference();
        ServerBootstrap sb = new ServerBootstrap();
        sb.group(this.eventLoopGroup);
        sb.channel(NioServerSocketChannel.class);
        sb.childHandler((ChannelHandler)new ChannelInitializer<Channel>(){

            protected void initChannel(Channel ch) {
                ch.pipeline().addLast(new ChannelHandler[]{codec});
                if (multiplexer != null) {
                    ch.pipeline().addLast(new ChannelHandler[]{multiplexer});
                }
                ch.pipeline().addLast(new ChannelHandler[]{new ChannelInboundHandlerAdapter(){

                    public void channelActive(ChannelHandlerContext ctx) {
                        serverConnectedChannelRef.set(ctx.channel());
                        serverConnectedChannelLatch.countDown();
                    }

                    public void channelRead(ChannelHandlerContext ctx, Object msg) {
                        if (msg instanceof Http2SettingsAckFrame) {
                            serverAckOneLatch.countDown();
                            serverAckAllLatch.countDown();
                        }
                        ReferenceCountUtil.release((Object)msg);
                    }
                }});
            }
        });
        this.serverChannel = sb.bind((SocketAddress)new InetSocketAddress(NetUtil.LOCALHOST, 0)).awaitUninterruptibly().channel();
        Bootstrap bs = new Bootstrap();
        bs.group(this.eventLoopGroup);
        bs.channel(NioSocketChannel.class);
        bs.handler((ChannelHandler)new ChannelInitializer<Channel>(){

            protected void initChannel(Channel ch) {
                ch.pipeline().addLast(new ChannelHandler[]{Http2MultiplexCodecBuilder.forClient((ChannelHandler)DISCARD_HANDLER).autoAckSettingsFrame(false).build()});
                ch.pipeline().addLast(new ChannelHandler[]{new ChannelInboundHandlerAdapter(){

                    public void channelRead(ChannelHandlerContext ctx, Object msg) {
                        if (msg instanceof Http2SettingsFrame) {
                            clientSettingsLatch.countDown();
                        }
                        ReferenceCountUtil.release((Object)msg);
                    }
                }});
            }
        });
        this.clientChannel = bs.connect(this.serverChannel.localAddress()).awaitUninterruptibly().channel();
        serverConnectedChannelLatch.await();
        this.serverConnectedChannel = (Channel)serverConnectedChannelRef.get();
        this.serverConnectedChannel.writeAndFlush((Object)new DefaultHttp2SettingsFrame(new Http2Settings().maxConcurrentStreams(10L))).sync();
        clientSettingsLatch.await();
        Assertions.assertFalse((boolean)serverAckOneLatch.await(300L, TimeUnit.MILLISECONDS));
        this.clientChannel.writeAndFlush((Object)Http2SettingsAckFrame.INSTANCE).sync();
        this.clientChannel.writeAndFlush((Object)Http2SettingsAckFrame.INSTANCE).sync();
        serverAckAllLatch.await();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @Timeout(value=5000L, unit=TimeUnit.MILLISECONDS)
    public void testFlushNotDiscarded() throws InterruptedException {
        final ScheduledExecutorService executorService = Executors.newScheduledThreadPool(1);
        try {
            ServerBootstrap sb = new ServerBootstrap();
            sb.group(this.eventLoopGroup);
            sb.channel(NioServerSocketChannel.class);
            sb.childHandler((ChannelHandler)new ChannelInitializer<Channel>(){

                protected void initChannel(Channel ch) {
                    ch.pipeline().addLast(new ChannelHandler[]{new Http2FrameCodecBuilder(true).build()});
                    ch.pipeline().addLast(new ChannelHandler[]{new Http2MultiplexHandler((ChannelHandler)new ChannelInboundHandlerAdapter(){

                        public void channelRead(final ChannelHandlerContext ctx, Object msg) {
                            if (msg instanceof Http2HeadersFrame && ((Http2HeadersFrame)msg).isEndStream()) {
                                executorService.schedule(new Runnable(){

                                    @Override
                                    public void run() {
                                        ctx.writeAndFlush((Object)new DefaultHttp2HeadersFrame((Http2Headers)new DefaultHttp2Headers(), false)).addListener((GenericFutureListener)new ChannelFutureListener(){

                                            public void operationComplete(ChannelFuture future) {
                                                ctx.write((Object)new DefaultHttp2DataFrame(Unpooled.copiedBuffer((CharSequence)"Hello World", (Charset)CharsetUtil.US_ASCII), true));
                                                ctx.channel().eventLoop().execute(new Runnable(){

                                                    @Override
                                                    public void run() {
                                                        ctx.flush();
                                                    }
                                                });
                                            }
                                        });
                                    }
                                }, 500L, TimeUnit.MILLISECONDS);
                            }
                            ReferenceCountUtil.release((Object)msg);
                        }
                    })});
                }
            });
            this.serverChannel = sb.bind((SocketAddress)new InetSocketAddress(NetUtil.LOCALHOST, 0)).syncUninterruptibly().channel();
            final CountDownLatch latch = new CountDownLatch(1);
            Bootstrap bs = new Bootstrap();
            bs.group(this.eventLoopGroup);
            bs.channel(NioSocketChannel.class);
            bs.handler((ChannelHandler)new ChannelInitializer<Channel>(){

                protected void initChannel(Channel ch) {
                    ch.pipeline().addLast(new ChannelHandler[]{new Http2FrameCodecBuilder(false).build()});
                    ch.pipeline().addLast(new ChannelHandler[]{new Http2MultiplexHandler(DISCARD_HANDLER)});
                }
            });
            this.clientChannel = bs.connect(this.serverChannel.localAddress()).syncUninterruptibly().channel();
            Http2StreamChannelBootstrap h2Bootstrap = new Http2StreamChannelBootstrap(this.clientChannel);
            h2Bootstrap.handler((ChannelHandler)new ChannelInboundHandlerAdapter(){

                public void channelRead(ChannelHandlerContext ctx, Object msg) {
                    if (msg instanceof Http2DataFrame && ((Http2DataFrame)msg).isEndStream()) {
                        latch.countDown();
                    }
                    ReferenceCountUtil.release((Object)msg);
                }
            });
            Http2StreamChannel streamChannel = (Http2StreamChannel)h2Bootstrap.open().syncUninterruptibly().getNow();
            streamChannel.writeAndFlush((Object)new DefaultHttp2HeadersFrame((Http2Headers)new DefaultHttp2Headers(), true)).syncUninterruptibly();
            latch.await();
        }
        finally {
            executorService.shutdown();
        }
    }

    @Test
    @Timeout(value=5000L, unit=TimeUnit.MILLISECONDS)
    public void testSSLExceptionOpenSslTLSv12() throws Exception {
        this.testSslException(SslProvider.OPENSSL, false);
    }

    @Test
    @Timeout(value=5000L, unit=TimeUnit.MILLISECONDS)
    public void testSSLExceptionOpenSslTLSv13() throws Exception {
        this.testSslException(SslProvider.OPENSSL, true);
    }

    @Disabled(value="JDK SSLEngine does not produce an alert")
    @Test
    @Timeout(value=5000L, unit=TimeUnit.MILLISECONDS)
    public void testSSLExceptionJDKTLSv12() throws Exception {
        this.testSslException(SslProvider.JDK, false);
    }

    @Disabled(value="JDK SSLEngine does not produce an alert")
    @Test
    @Timeout(value=5000L, unit=TimeUnit.MILLISECONDS)
    public void testSSLExceptionJDKTLSv13() throws Exception {
        this.testSslException(SslProvider.JDK, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testSslException(SslProvider provider, final boolean tlsv13) throws Exception {
        Assumptions.assumeTrue((boolean)SslProvider.isAlpnSupported((SslProvider)provider));
        if (tlsv13) {
            Assumptions.assumeTrue((boolean)SslProvider.isTlsv13Supported((SslProvider)provider));
        }
        String protocol = tlsv13 ? "TLSv1.3" : "TLSv1.2";
        SelfSignedCertificate ssc = null;
        try {
            ssc = new SelfSignedCertificate();
            final SslContext sslCtx = SslContextBuilder.forServer((File)ssc.certificate(), (File)ssc.privateKey()).trustManager((TrustManager)new X509TrustManager(){

                @Override
                public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                    throw new CertificateExpiredException();
                }

                @Override
                public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                    throw new CertificateExpiredException();
                }

                @Override
                public X509Certificate[] getAcceptedIssuers() {
                    return new X509Certificate[0];
                }
            }).sslProvider(provider).ciphers((Iterable)Http2SecurityUtil.CIPHERS, (CipherSuiteFilter)SupportedCipherSuiteFilter.INSTANCE).protocols(new String[]{protocol}).applicationProtocolConfig(new ApplicationProtocolConfig(ApplicationProtocolConfig.Protocol.ALPN, ApplicationProtocolConfig.SelectorFailureBehavior.NO_ADVERTISE, ApplicationProtocolConfig.SelectedListenerFailureBehavior.ACCEPT, new String[]{"h2", "http/1.1"})).clientAuth(ClientAuth.REQUIRE).build();
            ServerBootstrap sb = new ServerBootstrap();
            sb.group(this.eventLoopGroup);
            sb.channel(NioServerSocketChannel.class);
            sb.childHandler((ChannelHandler)new ChannelInitializer<Channel>(){

                protected void initChannel(Channel ch) {
                    ch.pipeline().addLast(new ChannelHandler[]{sslCtx.newHandler(ch.alloc())});
                    ch.pipeline().addLast(new ChannelHandler[]{new Http2FrameCodecBuilder(true).build()});
                    ch.pipeline().addLast(new ChannelHandler[]{new Http2MultiplexHandler(DISCARD_HANDLER)});
                }
            });
            this.serverChannel = sb.bind((SocketAddress)new InetSocketAddress(NetUtil.LOCALHOST, 0)).syncUninterruptibly().channel();
            final SslContext clientCtx = SslContextBuilder.forClient().keyManager(ssc.key(), new X509Certificate[]{ssc.cert()}).sslProvider(provider).ciphers((Iterable)Http2SecurityUtil.CIPHERS, (CipherSuiteFilter)SupportedCipherSuiteFilter.INSTANCE).trustManager(InsecureTrustManagerFactory.INSTANCE).protocols(new String[]{protocol}).applicationProtocolConfig(new ApplicationProtocolConfig(ApplicationProtocolConfig.Protocol.ALPN, ApplicationProtocolConfig.SelectorFailureBehavior.NO_ADVERTISE, ApplicationProtocolConfig.SelectedListenerFailureBehavior.ACCEPT, new String[]{"h2", "http/1.1"})).build();
            final CountDownLatch latch = new CountDownLatch(2);
            final AtomicReference errorRef = new AtomicReference();
            Bootstrap bs = new Bootstrap();
            bs.group(this.eventLoopGroup);
            bs.channel(NioSocketChannel.class);
            bs.handler((ChannelHandler)new ChannelInitializer<Channel>(){

                protected void initChannel(Channel ch) {
                    ch.pipeline().addLast(new ChannelHandler[]{clientCtx.newHandler(ch.alloc())});
                    ch.pipeline().addLast(new ChannelHandler[]{new Http2FrameCodecBuilder(false).build()});
                    ch.pipeline().addLast(new ChannelHandler[]{new Http2MultiplexHandler(DISCARD_HANDLER)});
                    ch.pipeline().addLast(new ChannelHandler[]{new ChannelInboundHandlerAdapter(){

                        public void userEventTriggered(ChannelHandlerContext ctx, Object evt) {
                            if (evt instanceof SslHandshakeCompletionEvent) {
                                SslHandshakeCompletionEvent handshakeCompletionEvent = (SslHandshakeCompletionEvent)evt;
                                if (handshakeCompletionEvent.isSuccess()) {
                                    if (!tlsv13) {
                                        errorRef.set(new AssertionError((Object)"TLSv1.3 expected"));
                                    }
                                    Http2StreamChannelBootstrap h2Bootstrap = new Http2StreamChannelBootstrap(ctx.channel());
                                    h2Bootstrap.handler((ChannelHandler)new ChannelInboundHandlerAdapter(){

                                        public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
                                            if (cause.getCause() instanceof SSLException) {
                                                latch.countDown();
                                            }
                                        }

                                        public void channelInactive(ChannelHandlerContext ctx) {
                                            latch.countDown();
                                        }
                                    });
                                    h2Bootstrap.open().addListener((GenericFutureListener)new FutureListener<Channel>(){

                                        public void operationComplete(Future<Channel> future) {
                                            if (future.isSuccess()) {
                                                ((Channel)future.getNow()).writeAndFlush((Object)new DefaultHttp2HeadersFrame((Http2Headers)new DefaultHttp2Headers(), false));
                                            }
                                        }
                                    });
                                } else if (handshakeCompletionEvent.cause() instanceof SSLException) {
                                    if (tlsv13) {
                                        errorRef.set(new AssertionError((Object)"TLSv1.2 expected"));
                                    }
                                    latch.countDown();
                                    latch.countDown();
                                }
                            }
                        }
                    }});
                }
            });
            this.clientChannel = bs.connect(this.serverChannel.localAddress()).syncUninterruptibly().channel();
            latch.await();
            AssertionError error = (AssertionError)errorRef.get();
            if (error != null) {
                throw error;
            }
        }
        finally {
            if (ssc != null) {
                ssc.delete();
            }
        }
    }

    @Test
    @DisabledOnOs(value={OS.WINDOWS}, disabledReason="See: https://github.com/netty/netty/issues/11542")
    @Timeout(value=5000L, unit=TimeUnit.MILLISECONDS)
    public void testFireChannelReadAfterHandshakeSuccess_JDK() throws Exception {
        Assumptions.assumeTrue((boolean)SslProvider.isAlpnSupported((SslProvider)SslProvider.JDK));
        this.testFireChannelReadAfterHandshakeSuccess(SslProvider.JDK);
    }

    @Test
    @DisabledOnOs(value={OS.WINDOWS}, disabledReason="See: https://github.com/netty/netty/issues/11542")
    @Timeout(value=5000L, unit=TimeUnit.MILLISECONDS)
    public void testFireChannelReadAfterHandshakeSuccess_OPENSSL() throws Exception {
        Assumptions.assumeTrue((boolean)OpenSsl.isAvailable());
        Assumptions.assumeTrue((boolean)SslProvider.isAlpnSupported((SslProvider)SslProvider.OPENSSL));
        this.testFireChannelReadAfterHandshakeSuccess(SslProvider.OPENSSL);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testFireChannelReadAfterHandshakeSuccess(SslProvider provider) throws Exception {
        SelfSignedCertificate ssc = null;
        try {
            ssc = new SelfSignedCertificate();
            final SslContext serverCtx = SslContextBuilder.forServer((File)ssc.certificate(), (File)ssc.privateKey()).sslProvider(provider).ciphers((Iterable)Http2SecurityUtil.CIPHERS, (CipherSuiteFilter)SupportedCipherSuiteFilter.INSTANCE).applicationProtocolConfig(new ApplicationProtocolConfig(ApplicationProtocolConfig.Protocol.ALPN, ApplicationProtocolConfig.SelectorFailureBehavior.NO_ADVERTISE, ApplicationProtocolConfig.SelectedListenerFailureBehavior.ACCEPT, new String[]{"h2", "http/1.1"})).build();
            ServerBootstrap sb = new ServerBootstrap();
            sb.group(this.eventLoopGroup);
            sb.channel(NioServerSocketChannel.class);
            sb.childHandler((ChannelHandler)new ChannelInitializer<Channel>(){

                protected void initChannel(Channel ch) {
                    ch.pipeline().addLast(new ChannelHandler[]{serverCtx.newHandler(ch.alloc())});
                    ch.pipeline().addLast(new ChannelHandler[]{new ApplicationProtocolNegotiationHandler("http/1.1"){

                        protected void configurePipeline(ChannelHandlerContext ctx, String protocol) {
                            ctx.pipeline().addLast(new ChannelHandler[]{new Http2FrameCodecBuilder(true).build()});
                            ctx.pipeline().addLast(new ChannelHandler[]{new Http2MultiplexHandler((ChannelHandler)new ChannelInboundHandlerAdapter(){

                                public void channelRead(final ChannelHandlerContext ctx, Object msg) {
                                    if (msg instanceof Http2HeadersFrame && ((Http2HeadersFrame)msg).isEndStream()) {
                                        ctx.writeAndFlush((Object)new DefaultHttp2HeadersFrame((Http2Headers)new DefaultHttp2Headers(), false)).addListener((GenericFutureListener)new ChannelFutureListener(){

                                            public void operationComplete(ChannelFuture future) {
                                                ctx.writeAndFlush((Object)new DefaultHttp2DataFrame(Unpooled.copiedBuffer((CharSequence)"Hello World", (Charset)CharsetUtil.US_ASCII), true));
                                            }
                                        });
                                    }
                                    ReferenceCountUtil.release((Object)msg);
                                }
                            })});
                        }
                    }});
                }
            });
            this.serverChannel = sb.bind((SocketAddress)new InetSocketAddress(NetUtil.LOCALHOST, 0)).sync().channel();
            final SslContext clientCtx = SslContextBuilder.forClient().sslProvider(provider).ciphers((Iterable)Http2SecurityUtil.CIPHERS, (CipherSuiteFilter)SupportedCipherSuiteFilter.INSTANCE).trustManager(InsecureTrustManagerFactory.INSTANCE).applicationProtocolConfig(new ApplicationProtocolConfig(ApplicationProtocolConfig.Protocol.ALPN, ApplicationProtocolConfig.SelectorFailureBehavior.NO_ADVERTISE, ApplicationProtocolConfig.SelectedListenerFailureBehavior.ACCEPT, new String[]{"h2", "http/1.1"})).build();
            final CountDownLatch latch = new CountDownLatch(1);
            Bootstrap bs = new Bootstrap();
            bs.group(this.eventLoopGroup);
            bs.channel(NioSocketChannel.class);
            bs.handler((ChannelHandler)new ChannelInitializer<Channel>(){

                protected void initChannel(Channel ch) {
                    ch.pipeline().addLast(new ChannelHandler[]{clientCtx.newHandler(ch.alloc())});
                    ch.pipeline().addLast(new ChannelHandler[]{new Http2FrameCodecBuilder(false).build()});
                    ch.pipeline().addLast(new ChannelHandler[]{new Http2MultiplexHandler(DISCARD_HANDLER)});
                    ch.pipeline().addLast(new ChannelHandler[]{new ChannelInboundHandlerAdapter(){

                        public void userEventTriggered(ChannelHandlerContext ctx, Object evt) {
                            SslHandshakeCompletionEvent handshakeCompletionEvent;
                            if (evt instanceof SslHandshakeCompletionEvent && (handshakeCompletionEvent = (SslHandshakeCompletionEvent)evt).isSuccess()) {
                                Http2StreamChannelBootstrap h2Bootstrap = new Http2StreamChannelBootstrap(Http2MultiplexTransportTest.this.clientChannel);
                                h2Bootstrap.handler((ChannelHandler)new ChannelInboundHandlerAdapter(){

                                    public void channelRead(ChannelHandlerContext ctx, Object msg) {
                                        if (msg instanceof Http2DataFrame && ((Http2DataFrame)msg).isEndStream()) {
                                            latch.countDown();
                                        }
                                        ReferenceCountUtil.release((Object)msg);
                                    }
                                });
                                h2Bootstrap.open().addListener((GenericFutureListener)new FutureListener<Channel>(){

                                    public void operationComplete(Future<Channel> future) {
                                        if (future.isSuccess()) {
                                            ((Channel)future.getNow()).writeAndFlush((Object)new DefaultHttp2HeadersFrame((Http2Headers)new DefaultHttp2Headers(), true));
                                        }
                                    }
                                });
                            }
                        }
                    }});
                }
            });
            this.clientChannel = bs.connect(this.serverChannel.localAddress()).sync().channel();
            latch.await();
        }
        finally {
            if (ssc != null) {
                ssc.delete();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @Timeout(value=120000L, unit=TimeUnit.MILLISECONDS)
    public void streamHandlerInactivatedResponseFlushed() throws InterruptedException {
        NioEventLoopGroup serverEventLoopGroup = null;
        NioEventLoopGroup clientEventLoopGroup = null;
        try {
            int i;
            serverEventLoopGroup = new NioEventLoopGroup(1, new ThreadFactory(){

                @Override
                public Thread newThread(Runnable r) {
                    return new Thread(r, "serverloop");
                }
            });
            clientEventLoopGroup = new NioEventLoopGroup(1, new ThreadFactory(){

                @Override
                public Thread newThread(Runnable r) {
                    return new Thread(r, "clientloop");
                }
            });
            int streams = 10;
            final CountDownLatch latchClientResponses = new CountDownLatch(10);
            final CountDownLatch latchHandlerInactive = new CountDownLatch(10);
            final AtomicInteger handlerInactivatedFlushed = new AtomicInteger();
            final AtomicInteger handleInactivatedNotFlushed = new AtomicInteger();
            ServerBootstrap sb = new ServerBootstrap();
            sb.group((EventLoopGroup)serverEventLoopGroup);
            sb.channel(NioServerSocketChannel.class);
            sb.childHandler((ChannelHandler)new ChannelInitializer<Channel>(){

                protected void initChannel(Channel ch) {
                    ch.config().setOption(ChannelOption.SO_SNDBUF, (Object)1);
                    ch.pipeline().addLast(new ChannelHandler[]{new Http2FrameCodecBuilder(true).build()});
                    ch.pipeline().addLast(new ChannelHandler[]{new Http2MultiplexHandler((ChannelHandler)new ChannelInitializer<Channel>(){

                        protected void initChannel(Channel ch) {
                            ch.pipeline().remove((ChannelHandler)this);
                            ch.pipeline().addLast(new ChannelHandler[]{new MultiplexInboundStream(handlerInactivatedFlushed, handleInactivatedNotFlushed, latchHandlerInactive)});
                        }
                    })});
                }
            });
            this.serverChannel = sb.bind((SocketAddress)new InetSocketAddress(NetUtil.LOCALHOST, 0)).syncUninterruptibly().channel();
            Bootstrap bs = new Bootstrap();
            bs.group((EventLoopGroup)clientEventLoopGroup);
            bs.channel(NioSocketChannel.class);
            bs.handler((ChannelHandler)new ChannelInitializer<Channel>(){

                protected void initChannel(Channel ch) {
                    ch.pipeline().addLast(new ChannelHandler[]{new Http2FrameCodecBuilder(false).build()});
                    ch.pipeline().addLast(new ChannelHandler[]{new Http2MultiplexHandler(DISCARD_HANDLER)});
                }
            });
            this.clientChannel = bs.connect(this.serverChannel.localAddress()).syncUninterruptibly().channel();
            Http2StreamChannelBootstrap h2Bootstrap = new Http2StreamChannelBootstrap(this.clientChannel);
            h2Bootstrap.handler((ChannelHandler)new ChannelInboundHandlerAdapter(){

                public void channelRead(ChannelHandlerContext ctx, Object msg) {
                    if (msg instanceof Http2DataFrame && ((Http2DataFrame)msg).isEndStream()) {
                        latchClientResponses.countDown();
                    }
                    ReferenceCountUtil.release((Object)msg);
                }

                public boolean isSharable() {
                    return true;
                }
            });
            ArrayList<ChannelFuture> streamFutures = new ArrayList<ChannelFuture>();
            for (i = 0; i < 10; ++i) {
                Http2StreamChannel stream = (Http2StreamChannel)h2Bootstrap.open().syncUninterruptibly().getNow();
                streamFutures.add(stream.writeAndFlush((Object)new DefaultHttp2HeadersFrame((Http2Headers)new DefaultHttp2Headers(), true)));
            }
            for (i = 0; i < 10; ++i) {
                ((ChannelFuture)streamFutures.get(i)).syncUninterruptibly();
            }
            Assertions.assertTrue((boolean)latchHandlerInactive.await(120000L, TimeUnit.MILLISECONDS));
            Assertions.assertTrue((boolean)latchClientResponses.await(120000L, TimeUnit.MILLISECONDS));
            Assertions.assertEquals((int)0, (int)handleInactivatedNotFlushed.get());
            Assertions.assertEquals((int)10, (int)handlerInactivatedFlushed.get());
        }
        finally {
            if (serverEventLoopGroup != null) {
                serverEventLoopGroup.shutdownGracefully(0L, 0L, TimeUnit.MILLISECONDS);
            }
            if (clientEventLoopGroup != null) {
                clientEventLoopGroup.shutdownGracefully(0L, 0L, TimeUnit.MILLISECONDS);
            }
        }
    }

    private static final class MultiplexInboundStream
    extends ChannelInboundHandlerAdapter {
        ChannelFuture responseFuture;
        final AtomicInteger handlerInactivatedFlushed;
        final AtomicInteger handleInactivatedNotFlushed;
        final CountDownLatch latchHandlerInactive;
        static final String LARGE_STRING = MultiplexInboundStream.generateLargeString(10240);

        MultiplexInboundStream(AtomicInteger handleInactivatedFlushed, AtomicInteger handleInactivatedNotFlushed, CountDownLatch latchHandlerInactive) {
            this.handlerInactivatedFlushed = handleInactivatedFlushed;
            this.handleInactivatedNotFlushed = handleInactivatedNotFlushed;
            this.latchHandlerInactive = latchHandlerInactive;
        }

        public void channelRead(ChannelHandlerContext ctx, Object msg) {
            if (msg instanceof Http2HeadersFrame && ((Http2HeadersFrame)msg).isEndStream()) {
                ByteBuf response = Unpooled.copiedBuffer((CharSequence)LARGE_STRING, (Charset)CharsetUtil.US_ASCII);
                this.responseFuture = ctx.writeAndFlush((Object)new DefaultHttp2DataFrame(response, true));
            }
            ReferenceCountUtil.release((Object)msg);
        }

        public void channelInactive(ChannelHandlerContext ctx) throws Exception {
            if (this.responseFuture.isSuccess()) {
                this.handlerInactivatedFlushed.incrementAndGet();
            } else {
                this.handleInactivatedNotFlushed.incrementAndGet();
            }
            this.latchHandlerInactive.countDown();
            ctx.fireChannelInactive();
        }

        private static String generateLargeString(int sizeInBytes) {
            StringBuilder sb = new StringBuilder(sizeInBytes);
            for (int i = 0; i < sizeInBytes; ++i) {
                sb.append('X');
            }
            return sb.toString();
        }
    }
}

