/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.memcache.binary;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.handler.codec.memcache.binary.BinaryMemcacheMessage;
import io.netty.handler.codec.memcache.binary.DefaultBinaryMemcacheRequest;
import io.netty.handler.codec.memcache.binary.DefaultBinaryMemcacheResponse;
import io.netty.handler.codec.memcache.binary.DefaultFullBinaryMemcacheRequest;
import io.netty.handler.codec.memcache.binary.DefaultFullBinaryMemcacheResponse;
import io.netty.util.CharsetUtil;
import java.nio.charset.Charset;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class BinaryMemcacheMessageTest {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSetLengths() {
        ByteBuf key = Unpooled.copiedBuffer((CharSequence)"Netty  Rocks!", (Charset)CharsetUtil.UTF_8);
        ByteBuf extras = Unpooled.copiedBuffer((CharSequence)"some extras", (Charset)CharsetUtil.UTF_8);
        ByteBuf content = Unpooled.copiedBuffer((CharSequence)"content", (Charset)CharsetUtil.UTF_8);
        try {
            BinaryMemcacheMessageTest.testSettingLengths((BinaryMemcacheMessage)new DefaultBinaryMemcacheRequest(), 0, 0, 0);
            BinaryMemcacheMessageTest.testSettingLengths((BinaryMemcacheMessage)new DefaultBinaryMemcacheRequest(key.retain()), key.readableBytes(), 0, 0);
            BinaryMemcacheMessageTest.testSettingLengths((BinaryMemcacheMessage)new DefaultBinaryMemcacheRequest(key.retain(), extras.retain()), key.readableBytes(), extras.readableBytes(), 0);
            BinaryMemcacheMessageTest.testSettingLengths((BinaryMemcacheMessage)new DefaultBinaryMemcacheResponse(), 0, 0, 0);
            BinaryMemcacheMessageTest.testSettingLengths((BinaryMemcacheMessage)new DefaultBinaryMemcacheResponse(key.retain()), key.readableBytes(), 0, 0);
            BinaryMemcacheMessageTest.testSettingLengths((BinaryMemcacheMessage)new DefaultBinaryMemcacheResponse(key.retain(), extras.retain()), key.readableBytes(), extras.readableBytes(), 0);
            BinaryMemcacheMessageTest.testSettingLengths((BinaryMemcacheMessage)new DefaultFullBinaryMemcacheRequest(key.retain(), extras.retain()), key.readableBytes(), extras.readableBytes(), 0);
            BinaryMemcacheMessageTest.testSettingLengths((BinaryMemcacheMessage)new DefaultFullBinaryMemcacheRequest(null, extras.retain()), 0, extras.readableBytes(), 0);
            BinaryMemcacheMessageTest.testSettingLengths((BinaryMemcacheMessage)new DefaultFullBinaryMemcacheRequest(key.retain(), null), key.readableBytes(), 0, 0);
            BinaryMemcacheMessageTest.testSettingLengths((BinaryMemcacheMessage)new DefaultFullBinaryMemcacheRequest(null, null), 0, 0, 0);
            BinaryMemcacheMessageTest.testSettingLengths((BinaryMemcacheMessage)new DefaultFullBinaryMemcacheRequest(key.retain(), extras.retain(), content.retain()), key.readableBytes(), extras.readableBytes(), content.readableBytes());
            BinaryMemcacheMessageTest.testSettingLengths((BinaryMemcacheMessage)new DefaultFullBinaryMemcacheRequest(null, extras.retain(), content.retain()), 0, extras.readableBytes(), content.readableBytes());
            BinaryMemcacheMessageTest.testSettingLengths((BinaryMemcacheMessage)new DefaultFullBinaryMemcacheRequest(key.retain(), null, content.retain()), key.readableBytes(), 0, content.readableBytes());
            BinaryMemcacheMessageTest.testSettingLengths((BinaryMemcacheMessage)new DefaultFullBinaryMemcacheRequest(null, null, content.retain()), 0, 0, content.readableBytes());
            BinaryMemcacheMessageTest.testSettingLengths((BinaryMemcacheMessage)new DefaultFullBinaryMemcacheResponse(key.retain(), extras.retain()), key.readableBytes(), extras.readableBytes(), 0);
            BinaryMemcacheMessageTest.testSettingLengths((BinaryMemcacheMessage)new DefaultFullBinaryMemcacheResponse(null, extras.retain()), 0, extras.readableBytes(), 0);
            BinaryMemcacheMessageTest.testSettingLengths((BinaryMemcacheMessage)new DefaultFullBinaryMemcacheResponse(key.retain(), null), key.readableBytes(), 0, 0);
            BinaryMemcacheMessageTest.testSettingLengths((BinaryMemcacheMessage)new DefaultFullBinaryMemcacheResponse(null, null), 0, 0, 0);
            BinaryMemcacheMessageTest.testSettingLengths((BinaryMemcacheMessage)new DefaultFullBinaryMemcacheResponse(key.retain(), extras.retain(), content.retain()), key.readableBytes(), extras.readableBytes(), content.readableBytes());
            BinaryMemcacheMessageTest.testSettingLengths((BinaryMemcacheMessage)new DefaultFullBinaryMemcacheResponse(null, extras.retain(), content.retain()), 0, extras.readableBytes(), content.readableBytes());
            BinaryMemcacheMessageTest.testSettingLengths((BinaryMemcacheMessage)new DefaultFullBinaryMemcacheResponse(key.retain(), null, content.retain()), key.readableBytes(), 0, content.readableBytes());
            BinaryMemcacheMessageTest.testSettingLengths((BinaryMemcacheMessage)new DefaultFullBinaryMemcacheResponse(null, null, content.retain()), 0, 0, content.readableBytes());
        }
        finally {
            key.release();
            extras.release();
            content.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void testSettingLengths(BinaryMemcacheMessage message, int initialKeyLength, int initialExtrasLength, int contentLength) {
        ByteBuf key = Unpooled.copiedBuffer((CharSequence)"netty", (Charset)CharsetUtil.UTF_8);
        ByteBuf extras = Unpooled.copiedBuffer((CharSequence)"extras", (Charset)CharsetUtil.UTF_8);
        ByteBuf key2 = Unpooled.copiedBuffer((CharSequence)"netty!", (Charset)CharsetUtil.UTF_8);
        ByteBuf extras2 = Unpooled.copiedBuffer((CharSequence)"extras!", (Charset)CharsetUtil.UTF_8);
        try {
            Assertions.assertEquals((int)initialKeyLength, (int)message.keyLength());
            Assertions.assertEquals((int)initialExtrasLength, (int)message.extrasLength());
            Assertions.assertEquals((int)(initialKeyLength + initialExtrasLength + contentLength), (int)message.totalBodyLength());
            message.setKey(key.retain());
            Assertions.assertEquals((int)key.readableBytes(), (int)message.keyLength());
            Assertions.assertEquals((int)initialExtrasLength, (int)message.extrasLength());
            Assertions.assertEquals((int)(key.readableBytes() + initialExtrasLength + contentLength), (int)message.totalBodyLength());
            message.setExtras(extras.retain());
            Assertions.assertEquals((int)key.readableBytes(), (int)message.keyLength());
            Assertions.assertEquals((int)extras.readableBytes(), (int)message.extrasLength());
            Assertions.assertEquals((int)(key.readableBytes() + extras.readableBytes() + contentLength), (int)message.totalBodyLength());
            message.setKey(key2.retain());
            Assertions.assertEquals((int)key2.readableBytes(), (int)message.keyLength());
            Assertions.assertEquals((int)extras.readableBytes(), (int)message.extrasLength());
            Assertions.assertEquals((int)(key2.readableBytes() + extras.readableBytes() + contentLength), (int)message.totalBodyLength());
            message.setExtras(extras2.retain());
            Assertions.assertEquals((int)key2.readableBytes(), (int)message.keyLength());
            Assertions.assertEquals((int)extras2.readableBytes(), (int)message.extrasLength());
            Assertions.assertEquals((int)(key2.readableBytes() + extras2.readableBytes() + contentLength), (int)message.totalBodyLength());
        }
        finally {
            key.release();
            extras.release();
            key2.release();
            extras2.release();
            message.release();
        }
    }
}

