/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.mqtt;

import io.netty.handler.codec.mqtt.MqttReasonCodes;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class MqttReasonCodesTest {
    MqttReasonCodesTest() {
    }

    @Test
    public void givenADisconnectReasonCodeTheCorrectEnumerationValueIsReturned() {
        Assertions.assertEquals((Object)MqttReasonCodes.Disconnect.WILDCARD_SUBSCRIPTIONS_NOT_SUPPORTED, (Object)MqttReasonCodes.Disconnect.valueOf((byte)-94), (String)"0xA2 must match 'wildcard subscriptions not supported'");
    }

    @Test
    public void testDisconnectReasonCodesCorrectlyMapToConstant() {
        for (MqttReasonCodes.Disconnect reasonCode : MqttReasonCodes.Disconnect.values()) {
            Assertions.assertEquals((Object)reasonCode, (Object)MqttReasonCodes.Disconnect.valueOf((byte)((byte)(reasonCode.byteValue() & 0xFF))), (String)"Disconnect hex doesn't match the proper constant");
        }
    }

    @Test
    public void testAuthReasonCodesCorrectlyMapToConstant() {
        for (MqttReasonCodes.Auth reasonCode : MqttReasonCodes.Auth.values()) {
            Assertions.assertEquals((Object)reasonCode, (Object)MqttReasonCodes.Auth.valueOf((byte)((byte)(reasonCode.byteValue() & 0xFF))), (String)"Auth hex doesn't match the proper constant");
        }
    }

    @Test
    public void testPubAckReasonCodesCorrectlyMapToConstant() {
        for (MqttReasonCodes.PubAck reasonCode : MqttReasonCodes.PubAck.values()) {
            Assertions.assertEquals((Object)reasonCode, (Object)MqttReasonCodes.PubAck.valueOf((byte)((byte)(reasonCode.byteValue() & 0xFF))), (String)"PubAck hex doesn't match the proper constant");
        }
    }

    @Test
    public void testPubRecReasonCodesCorrectlyMapToConstant() {
        for (MqttReasonCodes.PubRec reasonCode : MqttReasonCodes.PubRec.values()) {
            Assertions.assertEquals((Object)reasonCode, (Object)MqttReasonCodes.PubRec.valueOf((byte)((byte)(reasonCode.byteValue() & 0xFF))), (String)"PubRec hex doesn't match the proper constant");
        }
    }

    @Test
    public void testPubRelReasonCodesCorrectlyMapToConstant() {
        for (MqttReasonCodes.PubRel reasonCode : MqttReasonCodes.PubRel.values()) {
            Assertions.assertEquals((Object)reasonCode, (Object)MqttReasonCodes.PubRel.valueOf((byte)((byte)(reasonCode.byteValue() & 0xFF))), (String)"PubRel hex doesn't match the proper constant");
        }
    }

    @Test
    public void testPubCompReasonCodesCorrectlyMapToConstant() {
        for (MqttReasonCodes.PubComp reasonCode : MqttReasonCodes.PubComp.values()) {
            Assertions.assertEquals((Object)reasonCode, (Object)MqttReasonCodes.PubComp.valueOf((byte)((byte)(reasonCode.byteValue() & 0xFF))), (String)"PubComp hex doesn't match the proper constant");
        }
    }

    @Test
    public void testSubAckReasonCodesCorrectlyMapToConstant() {
        for (MqttReasonCodes.SubAck reasonCode : MqttReasonCodes.SubAck.values()) {
            Assertions.assertEquals((Object)reasonCode, (Object)MqttReasonCodes.SubAck.valueOf((byte)((byte)(reasonCode.byteValue() & 0xFF))), (String)"SubAck hex doesn't match the proper constant");
        }
    }

    @Test
    public void testUnsubAckReasonCodesCorrectlyMapToConstant() {
        for (MqttReasonCodes.UnsubAck reasonCode : MqttReasonCodes.UnsubAck.values()) {
            Assertions.assertEquals((Object)reasonCode, (Object)MqttReasonCodes.UnsubAck.valueOf((byte)((byte)(reasonCode.byteValue() & 0xFF))), (String)"UnsubAck hex doesn't match the proper constant");
        }
    }
}

