/*
 * Decompiled with CFR 0.152.
 */
package io.netty.codec.socks;

import io.netty.buffer.ByteBuf;
import io.netty.codec.socks.SocksMessage;
import io.netty.codec.socks.SocksResponse;

public final class SocksCmdResponse
extends SocksResponse {
    private final SocksMessage.CmdStatus cmdStatus;
    private final SocksMessage.AddressType addressType;
    private static final byte[] IPv4_HOSTNAME_ZEROED = new byte[]{0, 0, 0, 0};
    private static final byte[] IPv6_HOSTNAME_ZEROED = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};

    public SocksCmdResponse(SocksMessage.CmdStatus cmdStatus, SocksMessage.AddressType addressType) {
        super(SocksResponse.SocksResponseType.CMD);
        if (cmdStatus == null) {
            throw new NullPointerException("cmdStatus");
        }
        if (addressType == null) {
            throw new NullPointerException("addressType");
        }
        this.cmdStatus = cmdStatus;
        this.addressType = addressType;
    }

    public SocksMessage.CmdStatus getCmdStatus() {
        return this.cmdStatus;
    }

    public SocksMessage.AddressType getAddressType() {
        return this.addressType;
    }

    @Override
    public void encodeAsByteBuf(ByteBuf byteBuf) {
        byteBuf.writeByte((int)this.getProtocolVersion().getByteValue());
        byteBuf.writeByte((int)this.cmdStatus.getByteValue());
        byteBuf.writeByte(0);
        byteBuf.writeByte((int)this.addressType.getByteValue());
        switch (this.addressType) {
            case IPv4: {
                byteBuf.writeBytes(IPv4_HOSTNAME_ZEROED);
                byteBuf.writeShort(0);
                break;
            }
            case DOMAIN: {
                byteBuf.writeByte(1);
                byteBuf.writeByte(0);
                byteBuf.writeShort(0);
                break;
            }
            case IPv6: {
                byteBuf.writeBytes(IPv6_HOSTNAME_ZEROED);
                byteBuf.writeShort(0);
            }
        }
    }
}

