/*
 * Decompiled with CFR 0.152.
 */
package io.netty.codec.socks;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.codec.socks.SocksCommonUtils;
import io.netty.codec.socks.SocksInitRequest;
import io.netty.codec.socks.SocksMessage;
import io.netty.codec.socks.SocksRequest;
import io.netty.handler.codec.ReplayingDecoder;
import java.util.ArrayList;
import java.util.List;

public class SocksInitRequestDecoder
extends ReplayingDecoder<SocksRequest, State> {
    private static final String name = "SOCKS_INIT_REQUEST_DECODER";
    private final List<SocksMessage.AuthScheme> authSchemes = new ArrayList<SocksMessage.AuthScheme>();
    private SocksMessage.ProtocolVersion version;
    private byte authSchemeNum;
    private SocksRequest msg = SocksCommonUtils.UNKNOWN_SOCKS_REQUEST;

    public static String getName() {
        return name;
    }

    public SocksInitRequestDecoder() {
        super((Object)State.CHECK_PROTOCOL_VERSION);
    }

    public SocksRequest decode(ChannelHandlerContext ctx, ByteBuf byteBuf) throws Exception {
        switch ((State)((Object)this.state())) {
            case CHECK_PROTOCOL_VERSION: {
                this.version = SocksMessage.ProtocolVersion.fromByte(byteBuf.readByte());
                if (this.version != SocksMessage.ProtocolVersion.SOCKS5) break;
                this.checkpoint((Object)State.READ_AUTH_SCHEMES);
            }
            case READ_AUTH_SCHEMES: {
                this.authSchemes.clear();
                this.authSchemeNum = byteBuf.readByte();
                for (int i = 0; i < this.authSchemeNum; ++i) {
                    this.authSchemes.add(SocksMessage.AuthScheme.fromByte(byteBuf.readByte()));
                }
                this.msg = new SocksInitRequest(this.authSchemes);
            }
        }
        ctx.pipeline().remove((ChannelHandler)this);
        return this.msg;
    }

    static enum State {
        CHECK_PROTOCOL_VERSION,
        READ_AUTH_SCHEMES;

    }
}

