/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.socksx.v5;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.ReplayingDecoder;
import io.netty.handler.codec.socksx.SocksProtocolVersion;
import io.netty.handler.codec.socksx.v5.Socks5AuthScheme;
import io.netty.handler.codec.socksx.v5.Socks5InitResponse;
import io.netty.handler.codec.socksx.v5.Socks5Response;
import io.netty.handler.codec.socksx.v5.UnknownSocks5Response;
import java.util.List;

public class Socks5InitResponseDecoder
extends ReplayingDecoder<State> {
    private SocksProtocolVersion version;
    private Socks5AuthScheme authScheme;
    private Socks5Response msg = UnknownSocks5Response.INSTANCE;

    public Socks5InitResponseDecoder() {
        super((Object)State.CHECK_PROTOCOL_VERSION);
    }

    protected void decode(ChannelHandlerContext ctx, ByteBuf byteBuf, List<Object> out) throws Exception {
        switch ((State)((Object)this.state())) {
            case CHECK_PROTOCOL_VERSION: {
                this.version = SocksProtocolVersion.valueOf(byteBuf.readByte());
                if (this.version != SocksProtocolVersion.SOCKS5) break;
                this.checkpoint((Object)State.READ_PREFFERED_AUTH_TYPE);
            }
            case READ_PREFFERED_AUTH_TYPE: {
                this.authScheme = Socks5AuthScheme.valueOf(byteBuf.readByte());
                this.msg = new Socks5InitResponse(this.authScheme);
            }
        }
        ctx.pipeline().remove((ChannelHandler)this);
        out.add(this.msg);
    }

    static enum State {
        CHECK_PROTOCOL_VERSION,
        READ_PREFFERED_AUTH_TYPE;

    }
}

