/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.socks;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.netty.buffer.Unpooled;
import io.netty.handler.codec.socks.SocksAddressType;
import io.netty.handler.codec.socks.SocksCmdRequest;
import io.netty.handler.codec.socks.SocksCmdType;
import io.netty.handler.codec.socks.SocksProtocolVersion;
import io.netty.util.CharsetUtil;
import java.net.IDN;
import java.nio.ByteOrder;
import java.nio.CharBuffer;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class SocksCmdRequestTest {
    @Test
    public void testConstructorParamsAreNotNull() {
        try {
            new SocksCmdRequest(null, SocksAddressType.UNKNOWN, "", 1);
        }
        catch (Exception e) {
            Assertions.assertTrue((boolean)(e instanceof NullPointerException));
        }
        try {
            new SocksCmdRequest(SocksCmdType.UNKNOWN, null, "", 1);
        }
        catch (Exception e) {
            Assertions.assertTrue((boolean)(e instanceof NullPointerException));
        }
        try {
            new SocksCmdRequest(SocksCmdType.UNKNOWN, SocksAddressType.UNKNOWN, null, 1);
        }
        catch (Exception e) {
            Assertions.assertTrue((boolean)(e instanceof NullPointerException));
        }
    }

    @Test
    public void testIPv4CorrectAddress() {
        try {
            new SocksCmdRequest(SocksCmdType.BIND, SocksAddressType.IPv4, "54.54.1111.253", 1);
        }
        catch (Exception e) {
            Assertions.assertTrue((boolean)(e instanceof IllegalArgumentException));
        }
    }

    @Test
    public void testIPv6CorrectAddress() {
        try {
            new SocksCmdRequest(SocksCmdType.BIND, SocksAddressType.IPv6, "xxx:xxx:xxx", 1);
        }
        catch (Exception e) {
            Assertions.assertTrue((boolean)(e instanceof IllegalArgumentException));
        }
    }

    @Test
    public void testIDNNotExceeds255CharsLimit() {
        try {
            new SocksCmdRequest(SocksCmdType.BIND, SocksAddressType.DOMAIN, "\u03c0\u03b1\u03c1\u03ac\u03b4\u03b5\u03b9\u03b3\u03bc\u03b1.\u03b4\u03bf\u03ba\u03b9\u03bc\u03ae\u03c0\u03b1\u03c1\u03ac\u03b4\u03b5\u03b9\u03b3\u03bc\u03b1.\u03b4\u03bf\u03ba\u03b9\u03bc\u03ae\u03c0\u03b1\u03c1\u03ac\u03b4\u03b5\u03b9\u03b3\u03bc\u03b1.\u03b4\u03bf\u03ba\u03b9\u03bc\u03ae\u03c0\u03b1\u03c1\u03ac\u03b4\u03b5\u03b9\u03b3\u03bc\u03b1.\u03b4\u03bf\u03ba\u03b9\u03bc\u03ae\u03c0\u03b1\u03c1\u03ac\u03b4\u03b5\u03b9\u03b3\u03bc\u03b1.\u03b4\u03bf\u03ba\u03b9\u03bc\u03ae\u03c0\u03b1\u03c1\u03ac\u03b4\u03b5\u03b9\u03b3\u03bc\u03b1.\u03b4\u03bf\u03ba\u03b9\u03bc\u03ae\u03c0\u03b1\u03c1\u03ac\u03b4\u03b5\u03b9\u03b3\u03bc\u03b1.\u03b4\u03bf\u03ba\u03b9\u03bc\u03ae\u03c0\u03b1\u03c1\u03ac\u03b4\u03b5\u03b9\u03b3\u03bc\u03b1.\u03b4\u03bf\u03ba\u03b9\u03bc\u03ae\u03c0\u03b1\u03c1\u03ac\u03b4\u03b5\u03b9\u03b3\u03bc\u03b1.\u03b4\u03bf\u03ba\u03b9\u03bc\u03ae\u03c0\u03b1\u03c1\u03ac\u03b4\u03b5\u03b9\u03b3\u03bc\u03b1.\u03b4\u03bf\u03ba\u03b9\u03bc\u03ae\u03c0\u03b1\u03c1\u03ac\u03b4\u03b5\u03b9\u03b3\u03bc\u03b1.\u03b4\u03bf\u03ba\u03b9\u03bc\u03ae\u03c0\u03b1\u03c1\u03ac\u03b4\u03b5\u03b9\u03b3\u03bc\u03b1.\u03b4\u03bf\u03ba\u03b9\u03bc\u03ae\u03c0\u03b1\u03c1\u03ac\u03b4\u03b5\u03b9\u03b3\u03bc\u03b1.\u03b4\u03bf\u03ba\u03b9\u03bc\u03ae\u03c0\u03b1\u03c1\u03ac\u03b4\u03b5\u03b9\u03b3\u03bc\u03b1.\u03b4\u03bf\u03ba\u03b9\u03bc\u03ae\u03c0\u03b1\u03c1\u03ac\u03b4\u03b5\u03b9\u03b3\u03bc\u03b1.\u03b4\u03bf\u03ba\u03b9\u03bc\u03ae\u03c0\u03b1\u03c1\u03ac\u03b4\u03b5\u03b9\u03b3\u03bc\u03b1.\u03b4\u03bf\u03ba\u03b9\u03bc\u03ae", 1);
        }
        catch (Exception e) {
            Assertions.assertTrue((boolean)(e instanceof IllegalArgumentException));
        }
    }

    @Test
    public void testHostNotEncodedForUnknown() {
        String asciiHost = "xn--e1aybc.xn--p1ai";
        int port = 10000;
        SocksCmdRequest rq = new SocksCmdRequest(SocksCmdType.BIND, SocksAddressType.UNKNOWN, asciiHost, port);
        Assertions.assertEquals((Object)asciiHost, (Object)rq.host());
        ByteBuf buffer = Unpooled.buffer((int)16);
        rq.encodeAsByteBuf(buffer);
        buffer.resetReaderIndex();
        Assertions.assertEquals((byte)SocksProtocolVersion.SOCKS5.byteValue(), (byte)buffer.readByte());
        Assertions.assertEquals((byte)SocksCmdType.BIND.byteValue(), (byte)buffer.readByte());
        Assertions.assertEquals((byte)0, (byte)buffer.readByte());
        Assertions.assertEquals((byte)SocksAddressType.UNKNOWN.byteValue(), (byte)buffer.readByte());
        Assertions.assertFalse((boolean)buffer.isReadable());
        buffer.release();
    }

    @Test
    public void testIDNEncodeToAsciiForDomain() {
        String host = "\u0442\u0435\u0441\u0442.\u0440\u0444";
        CharBuffer asciiHost = CharBuffer.wrap(IDN.toASCII(host));
        int port = 10000;
        SocksCmdRequest rq = new SocksCmdRequest(SocksCmdType.BIND, SocksAddressType.DOMAIN, host, port);
        Assertions.assertEquals((Object)host, (Object)rq.host());
        ByteBuf buffer = Unpooled.buffer((int)24);
        rq.encodeAsByteBuf(buffer);
        buffer.resetReaderIndex();
        Assertions.assertEquals((byte)SocksProtocolVersion.SOCKS5.byteValue(), (byte)buffer.readByte());
        Assertions.assertEquals((byte)SocksCmdType.BIND.byteValue(), (byte)buffer.readByte());
        Assertions.assertEquals((byte)0, (byte)buffer.readByte());
        Assertions.assertEquals((byte)SocksAddressType.DOMAIN.byteValue(), (byte)buffer.readByte());
        Assertions.assertEquals((short)((byte)asciiHost.length()), (short)buffer.readUnsignedByte());
        Assertions.assertEquals((Object)asciiHost, (Object)CharBuffer.wrap(buffer.readCharSequence(asciiHost.length(), CharsetUtil.US_ASCII)));
        Assertions.assertEquals((int)port, (int)ByteBufUtil.readUnsignedShortBE((ByteBuf)buffer));
        buffer.release();
    }

    @Test
    public void testEndianessForPort() {
        String host = "localhost";
        CharBuffer asciiHost = CharBuffer.wrap(host);
        int port = 10000;
        SocksCmdRequest rq = new SocksCmdRequest(SocksCmdType.BIND, SocksAddressType.DOMAIN, host, port);
        Assertions.assertEquals((Object)host, (Object)rq.host());
        ByteBuf buffer = Unpooled.buffer((int)24).order(ByteOrder.LITTLE_ENDIAN);
        rq.encodeAsByteBuf(buffer);
        Assertions.assertEquals((byte)SocksProtocolVersion.SOCKS5.byteValue(), (byte)buffer.readByte());
        Assertions.assertEquals((byte)SocksCmdType.BIND.byteValue(), (byte)buffer.readByte());
        Assertions.assertEquals((byte)0, (byte)buffer.readByte());
        Assertions.assertEquals((byte)SocksAddressType.DOMAIN.byteValue(), (byte)buffer.readByte());
        Assertions.assertEquals((short)((byte)asciiHost.length()), (short)buffer.readUnsignedByte());
        Assertions.assertEquals((Object)asciiHost, (Object)CharBuffer.wrap(buffer.readCharSequence(asciiHost.length(), CharsetUtil.US_ASCII)));
        Assertions.assertEquals((int)port, (int)ByteBufUtil.readUnsignedShortBE((ByteBuf)buffer));
        buffer.release();
    }

    @Test
    public void testValidPortRange() {
        try {
            new SocksCmdRequest(SocksCmdType.BIND, SocksAddressType.DOMAIN, "\u03c0\u03b1\u03c1\u03ac\u03b4\u03b5\u03b9\u03b3\u03bc\u03b1.\u03b4\u03bf\u03ba\u03b9\u03bc\u03ae\u03c0\u03b1\u03c1\u03ac\u03b4\u03b5\u03b9", 0);
        }
        catch (Exception e) {
            Assertions.assertTrue((boolean)(e instanceof IllegalArgumentException));
        }
        try {
            new SocksCmdRequest(SocksCmdType.BIND, SocksAddressType.DOMAIN, "\u03c0\u03b1\u03c1\u03ac\u03b4\u03b5\u03b9\u03b3\u03bc\u03b1.\u03b4\u03bf\u03ba\u03b9\u03bc\u03ae\u03c0\u03b1\u03c1\u03ac\u03b4\u03b5\u03b9", 65536);
        }
        catch (Exception e) {
            Assertions.assertTrue((boolean)(e instanceof IllegalArgumentException));
        }
    }
}

