/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.socksx.v5;

import io.netty.channel.ChannelHandler;
import io.netty.channel.embedded.EmbeddedChannel;
import io.netty.handler.codec.socksx.v5.DefaultSocks5CommandResponse;
import io.netty.handler.codec.socksx.v5.Socks5AddressType;
import io.netty.handler.codec.socksx.v5.Socks5CommandResponse;
import io.netty.handler.codec.socksx.v5.Socks5CommandResponseDecoder;
import io.netty.handler.codec.socksx.v5.Socks5CommandStatus;
import io.netty.handler.codec.socksx.v5.Socks5CommonTestUtils;
import io.netty.handler.codec.socksx.v5.Socks5Message;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.util.Arrays;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.function.Executable;

public class Socks5CommandResponseDecoderTest {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(Socks5CommandResponseDecoderTest.class);
    private static final Socks5CommandStatus[] STATUSES = new Socks5CommandStatus[]{Socks5CommandStatus.ADDRESS_UNSUPPORTED, Socks5CommandStatus.COMMAND_UNSUPPORTED, Socks5CommandStatus.CONNECTION_REFUSED, Socks5CommandStatus.FAILURE, Socks5CommandStatus.FORBIDDEN, Socks5CommandStatus.HOST_UNREACHABLE, Socks5CommandStatus.NETWORK_UNREACHABLE, Socks5CommandStatus.SUCCESS, Socks5CommandStatus.TTL_EXPIRED};

    private static void test(Socks5CommandStatus status, Socks5AddressType bndAddrType, String bndAddr, int bndPort) {
        logger.debug("Testing status: " + status + " bndAddrType: " + bndAddrType);
        DefaultSocks5CommandResponse msg = new DefaultSocks5CommandResponse(status, bndAddrType, bndAddr, bndPort);
        EmbeddedChannel embedder = new EmbeddedChannel(new ChannelHandler[]{new Socks5CommandResponseDecoder()});
        Socks5CommonTestUtils.writeFromServerToClient(embedder, (Socks5Message)msg);
        msg = (Socks5CommandResponse)embedder.readInbound();
        Assertions.assertEquals((Object)msg.status(), (Object)status);
        if (bndAddr != null) {
            Assertions.assertEquals((Object)msg.bndAddr(), (Object)bndAddr);
        }
        Assertions.assertEquals((int)msg.bndPort(), (int)bndPort);
        Assertions.assertNull((Object)embedder.readInbound());
    }

    @Test
    public void testSocksCmdResponseDecoder() {
        for (Socks5CommandStatus cmdStatus : STATUSES) {
            for (Socks5AddressType addressType : Arrays.asList(Socks5AddressType.DOMAIN, Socks5AddressType.IPv4, Socks5AddressType.IPv6)) {
                Socks5CommandResponseDecoderTest.test(cmdStatus, addressType, null, 0);
            }
        }
    }

    @Test
    public void testInvalidAddress() {
        Assertions.assertThrows(IllegalArgumentException.class, (Executable)new Executable(){

            public void execute() {
                Socks5CommandResponseDecoderTest.test(Socks5CommandStatus.SUCCESS, Socks5AddressType.IPv4, "1", 80);
            }
        });
    }

    @Test
    public void testSocksCmdResponseDecoderIncludingHost() {
        for (Socks5CommandStatus cmdStatus : STATUSES) {
            Socks5CommandResponseDecoderTest.test(cmdStatus, Socks5AddressType.IPv4, "127.0.0.1", 80);
            Socks5CommandResponseDecoderTest.test(cmdStatus, Socks5AddressType.DOMAIN, "testDomain.com", 80);
            Socks5CommandResponseDecoderTest.test(cmdStatus, Socks5AddressType.IPv6, "2001:db8:85a3:42:1000:8a2e:370:7334", 80);
            Socks5CommandResponseDecoderTest.test(cmdStatus, Socks5AddressType.IPv6, "1111:111:11:1::1", 80);
        }
    }
}

