/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.socks;

import io.netty.channel.ChannelHandler;
import io.netty.channel.embedded.EmbeddedChannel;
import io.netty.handler.codec.socks.SocksAddressType;
import io.netty.handler.codec.socks.SocksCmdRequest;
import io.netty.handler.codec.socks.SocksCmdRequestDecoder;
import io.netty.handler.codec.socks.SocksCmdType;
import io.netty.handler.codec.socks.SocksCommonTestUtils;
import io.netty.handler.codec.socks.SocksCommonUtils;
import io.netty.handler.codec.socks.SocksMessage;
import io.netty.handler.codec.socks.UnknownSocksRequest;
import io.netty.util.internal.SocketUtils;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.net.UnknownHostException;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class SocksCmdRequestDecoderTest {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(SocksCmdRequestDecoderTest.class);

    private static void testSocksCmdRequestDecoderWithDifferentParams(SocksCmdType cmdType, SocksAddressType addressType, String host, int port) {
        logger.debug("Testing cmdType: " + cmdType + " addressType: " + addressType + " host: " + host + " port: " + port);
        SocksCmdRequest msg = new SocksCmdRequest(cmdType, addressType, host, port);
        SocksCmdRequestDecoder decoder = new SocksCmdRequestDecoder();
        EmbeddedChannel embedder = new EmbeddedChannel(new ChannelHandler[]{decoder});
        SocksCommonTestUtils.writeMessageIntoEmbedder(embedder, (SocksMessage)msg);
        if (msg.addressType() == SocksAddressType.UNKNOWN) {
            Assertions.assertTrue((boolean)(embedder.readInbound() instanceof UnknownSocksRequest));
        } else {
            msg = (SocksCmdRequest)embedder.readInbound();
            Assertions.assertSame((Object)msg.cmdType(), (Object)cmdType);
            Assertions.assertSame((Object)msg.addressType(), (Object)addressType);
            Assertions.assertEquals((Object)msg.host(), (Object)host);
            Assertions.assertEquals((int)msg.port(), (int)port);
        }
        Assertions.assertNull((Object)embedder.readInbound());
    }

    @Test
    public void testCmdRequestDecoderIPv4() {
        String[] hosts = new String[]{"127.0.0.1"};
        int[] ports = new int[]{1, 32769, 65535};
        for (SocksCmdType cmdType : SocksCmdType.values()) {
            for (String host : hosts) {
                for (int port : ports) {
                    SocksCmdRequestDecoderTest.testSocksCmdRequestDecoderWithDifferentParams(cmdType, SocksAddressType.IPv4, host, port);
                }
            }
        }
    }

    @Test
    public void testCmdRequestDecoderIPv6() throws UnknownHostException {
        String[] hosts = new String[]{SocksCommonUtils.ipv6toStr((byte[])SocketUtils.addressByName((String)"::1").getAddress())};
        int[] ports = new int[]{1, 32769, 65535};
        for (SocksCmdType cmdType : SocksCmdType.values()) {
            for (String host : hosts) {
                for (int port : ports) {
                    SocksCmdRequestDecoderTest.testSocksCmdRequestDecoderWithDifferentParams(cmdType, SocksAddressType.IPv6, host, port);
                }
            }
        }
    }

    @Test
    public void testCmdRequestDecoderDomain() {
        String[] hosts = new String[]{"google.com", "\u0645\u062b\u0627\u0644.\u0625\u062e\u062a\u0628\u0627\u0631", "\u03c0\u03b1\u03c1\u03ac\u03b4\u03b5\u03b9\u03b3\u03bc\u03b1.\u03b4\u03bf\u03ba\u03b9\u03bc\u03ae", "\u0645\u062b\u0627\u0644.\u0622\u0632\u0645\u0627\u06cc\u0634\u06cc", "\u043f\u0440\u0438\u043c\u0435\u0440.\u0438\u0441\u043f\u044b\u0442\u0430\u043d\u0438\u0435", "\u05d1\u05f2\u05b7\u05e9\u05e4\u05bc\u05d9\u05dc.\u05d8\u05e2\u05e1\u05d8", "\u4f8b\u5b50.\u6d4b\u8bd5", "\u4f8b\u5b50.\u6e2c\u8a66", "\u0909\u0926\u093e\u0939\u0930\u0923.\u092a\u0930\u0940\u0915\u094d\u0937\u093e", "\u4f8b\u3048.\u30c6\u30b9\u30c8", "\uc2e4\ub840.\ud14c\uc2a4\ud2b8", "\u0b89\u0ba4\u0bbe\u0bb0\u0ba3\u0bae\u0bcd.\u0baa\u0bb0\u0bbf\u0b9f\u0bcd\u0b9a\u0bc8"};
        int[] ports = new int[]{1, 32769, 65535};
        for (SocksCmdType cmdType : SocksCmdType.values()) {
            for (String host : hosts) {
                for (int port : ports) {
                    SocksCmdRequestDecoderTest.testSocksCmdRequestDecoderWithDifferentParams(cmdType, SocksAddressType.DOMAIN, host, port);
                }
            }
        }
    }

    @Test
    public void testCmdRequestDecoderUnknown() {
        String host = "google.com";
        int port = 80;
        for (SocksCmdType cmdType : SocksCmdType.values()) {
            SocksCmdRequestDecoderTest.testSocksCmdRequestDecoderWithDifferentParams(cmdType, SocksAddressType.UNKNOWN, host, port);
        }
    }
}

