/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.stomp;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandler;
import io.netty.channel.embedded.EmbeddedChannel;
import io.netty.handler.codec.stomp.LastStompContentSubframe;
import io.netty.handler.codec.stomp.StompCommand;
import io.netty.handler.codec.stomp.StompContentSubframe;
import io.netty.handler.codec.stomp.StompHeadersSubframe;
import io.netty.handler.codec.stomp.StompSubframeDecoder;
import io.netty.util.CharsetUtil;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class StompSubframeDecoderTest {
    private EmbeddedChannel channel;

    @BeforeEach
    public void setup() throws Exception {
        this.channel = new EmbeddedChannel(new ChannelHandler[]{new StompSubframeDecoder()});
    }

    @AfterEach
    public void teardown() throws Exception {
        Assertions.assertFalse((boolean)this.channel.finish());
    }

    @Test
    public void testSingleFrameDecoding() {
        ByteBuf incoming = Unpooled.buffer();
        incoming.writeBytes("CONNECT\nhost:stomp.github.org\naccept-version:1.1,1.2\n\n\u0000".getBytes());
        this.channel.writeInbound(new Object[]{incoming});
        StompHeadersSubframe frame = (StompHeadersSubframe)this.channel.readInbound();
        Assertions.assertNotNull((Object)frame);
        Assertions.assertEquals((Object)StompCommand.CONNECT, (Object)frame.command());
        StompContentSubframe content = (StompContentSubframe)this.channel.readInbound();
        Assertions.assertSame((Object)LastStompContentSubframe.EMPTY_LAST_CONTENT, (Object)content);
        content.release();
        Object o = this.channel.readInbound();
        Assertions.assertNull((Object)o);
    }

    @Test
    public void testSingleFrameWithBodyAndContentLength() {
        ByteBuf incoming = Unpooled.buffer();
        incoming.writeBytes("SEND\ndestination:/queue/a\ncontent-type:text/plain\ncontent-length:17\n\nhello, queue a!!!\u0000\n".getBytes());
        this.channel.writeInbound(new Object[]{incoming});
        StompHeadersSubframe frame = (StompHeadersSubframe)this.channel.readInbound();
        Assertions.assertNotNull((Object)frame);
        Assertions.assertEquals((Object)StompCommand.SEND, (Object)frame.command());
        StompContentSubframe content = (StompContentSubframe)this.channel.readInbound();
        Assertions.assertTrue((boolean)(content instanceof LastStompContentSubframe));
        String s = content.content().toString(CharsetUtil.UTF_8);
        Assertions.assertEquals((Object)"hello, queue a!!!", (Object)s);
        content.release();
        Assertions.assertNull((Object)this.channel.readInbound());
    }

    @Test
    public void testSingleFrameWithBodyWithoutContentLength() {
        ByteBuf incoming = Unpooled.buffer();
        incoming.writeBytes("SEND\ndestination:/queue/a\ncontent-type:text/plain\n\nhello, queue a!\u0000\n".getBytes());
        this.channel.writeInbound(new Object[]{incoming});
        StompHeadersSubframe frame = (StompHeadersSubframe)this.channel.readInbound();
        Assertions.assertNotNull((Object)frame);
        Assertions.assertEquals((Object)StompCommand.SEND, (Object)frame.command());
        StompContentSubframe content = (StompContentSubframe)this.channel.readInbound();
        Assertions.assertTrue((boolean)(content instanceof LastStompContentSubframe));
        String s = content.content().toString(CharsetUtil.UTF_8);
        Assertions.assertEquals((Object)"hello, queue a!", (Object)s);
        content.release();
        Assertions.assertNull((Object)this.channel.readInbound());
    }

    @Test
    public void testSingleFrameChunked() {
        EmbeddedChannel channel = new EmbeddedChannel(new ChannelHandler[]{new StompSubframeDecoder(10000, 5)});
        ByteBuf incoming = Unpooled.buffer();
        incoming.writeBytes("SEND\ndestination:/queue/a\ncontent-type:text/plain\ncontent-length:17\n\nhello, queue a!!!\u0000\n".getBytes());
        channel.writeInbound(new Object[]{incoming});
        StompHeadersSubframe frame = (StompHeadersSubframe)channel.readInbound();
        Assertions.assertNotNull((Object)frame);
        Assertions.assertEquals((Object)StompCommand.SEND, (Object)frame.command());
        StompContentSubframe content = (StompContentSubframe)channel.readInbound();
        String s = content.content().toString(CharsetUtil.UTF_8);
        Assertions.assertEquals((Object)"hello", (Object)s);
        content.release();
        content = (StompContentSubframe)channel.readInbound();
        s = content.content().toString(CharsetUtil.UTF_8);
        Assertions.assertEquals((Object)", que", (Object)s);
        content.release();
        content = (StompContentSubframe)channel.readInbound();
        s = content.content().toString(CharsetUtil.UTF_8);
        Assertions.assertEquals((Object)"ue a!", (Object)s);
        content.release();
        content = (StompContentSubframe)channel.readInbound();
        s = content.content().toString(CharsetUtil.UTF_8);
        Assertions.assertEquals((Object)"!!", (Object)s);
        content.release();
        Assertions.assertNull((Object)channel.readInbound());
    }

    @Test
    public void testMultipleFramesDecoding() {
        ByteBuf incoming = Unpooled.buffer();
        incoming.writeBytes("CONNECT\nhost:stomp.github.org\naccept-version:1.1,1.2\n\n\u0000".getBytes());
        incoming.writeBytes("CONNECTED\nversion:1.2\n\n\u0000\n".getBytes());
        this.channel.writeInbound(new Object[]{incoming});
        StompHeadersSubframe frame = (StompHeadersSubframe)this.channel.readInbound();
        Assertions.assertNotNull((Object)frame);
        Assertions.assertEquals((Object)StompCommand.CONNECT, (Object)frame.command());
        StompContentSubframe content = (StompContentSubframe)this.channel.readInbound();
        Assertions.assertSame((Object)LastStompContentSubframe.EMPTY_LAST_CONTENT, (Object)content);
        content.release();
        StompHeadersSubframe frame2 = (StompHeadersSubframe)this.channel.readInbound();
        Assertions.assertNotNull((Object)frame2);
        Assertions.assertEquals((Object)StompCommand.CONNECTED, (Object)frame2.command());
        StompContentSubframe content2 = (StompContentSubframe)this.channel.readInbound();
        Assertions.assertSame((Object)LastStompContentSubframe.EMPTY_LAST_CONTENT, (Object)content2);
        content2.release();
        Assertions.assertNull((Object)this.channel.readInbound());
    }

    @Test
    public void testValidateHeadersDecodingDisabled() {
        ByteBuf invalidIncoming = Unpooled.copiedBuffer((byte[])"SEND\ndestination:/some-destination\ncontent-type:text/plain\ncurrent-time:2000-01-01T00:00:00\n\nsome body\u0000".getBytes(CharsetUtil.UTF_8));
        Assertions.assertTrue((boolean)this.channel.writeInbound(new Object[]{invalidIncoming}));
        StompHeadersSubframe frame = (StompHeadersSubframe)this.channel.readInbound();
        Assertions.assertNotNull((Object)frame);
        Assertions.assertEquals((Object)StompCommand.SEND, (Object)frame.command());
        Assertions.assertTrue((boolean)frame.headers().contains((Object)"destination"));
        Assertions.assertTrue((boolean)frame.headers().contains((Object)"content-type"));
        Assertions.assertFalse((boolean)frame.headers().contains((Object)"current-time"));
        StompContentSubframe content = (StompContentSubframe)this.channel.readInbound();
        String s = content.content().toString(CharsetUtil.UTF_8);
        Assertions.assertEquals((Object)"some body", (Object)s);
        content.release();
    }

    @Test
    public void testValidateHeadersDecodingEnabled() {
        this.channel = new EmbeddedChannel(new ChannelHandler[]{new StompSubframeDecoder(true)});
        ByteBuf invalidIncoming = Unpooled.wrappedBuffer((byte[])"SEND\ndestination:/some-destination\ncontent-type:text/plain\ncurrent-time:2000-01-01T00:00:00\n\nsome body\u0000".getBytes(CharsetUtil.UTF_8));
        Assertions.assertTrue((boolean)this.channel.writeInbound(new Object[]{invalidIncoming}));
        StompHeadersSubframe frame = (StompHeadersSubframe)this.channel.readInbound();
        Assertions.assertNotNull((Object)frame);
        Assertions.assertTrue((boolean)frame.decoderResult().isFailure());
        Assertions.assertEquals((Object)"a header value or name contains a prohibited character ':', current-time:2000-01-01T00:00:00", (Object)frame.decoderResult().cause().getMessage());
    }

    @Test
    public void testNotValidFrameWithEmptyHeaderName() {
        this.channel = new EmbeddedChannel(new ChannelHandler[]{new StompSubframeDecoder(true)});
        ByteBuf invalidIncoming = Unpooled.wrappedBuffer((byte[])"SEND\ndestination:/some-destination\ncontent-type:text/plain\n:header-value\n\nsome body\u0000".getBytes(CharsetUtil.UTF_8));
        Assertions.assertTrue((boolean)this.channel.writeInbound(new Object[]{invalidIncoming}));
        StompHeadersSubframe frame = (StompHeadersSubframe)this.channel.readInbound();
        Assertions.assertNotNull((Object)frame);
        Assertions.assertTrue((boolean)frame.decoderResult().isFailure());
        Assertions.assertEquals((Object)"received an invalid header line ':header-value'", (Object)frame.decoderResult().cause().getMessage());
    }

    @Test
    public void testUtf8FrameDecoding() {
        this.channel = new EmbeddedChannel(new ChannelHandler[]{new StompSubframeDecoder(true)});
        ByteBuf incoming = Unpooled.wrappedBuffer((byte[])"SEND\ndestination:/queue/\u211611\u00b1\u265b\u043d\u0435\u0442\u0442\u0438\u2655\ncontent-type:text/plain\n\nbody\u0000".getBytes(CharsetUtil.UTF_8));
        Assertions.assertTrue((boolean)this.channel.writeInbound(new Object[]{incoming}));
        StompHeadersSubframe headersSubFrame = (StompHeadersSubframe)this.channel.readInbound();
        Assertions.assertNotNull((Object)headersSubFrame);
        Assertions.assertFalse((boolean)headersSubFrame.decoderResult().isFailure());
        Assertions.assertEquals((Object)"/queue/\u211611\u00b1\u265b\u043d\u0435\u0442\u0442\u0438\u2655", (Object)headersSubFrame.headers().getAsString((CharSequence)"destination"));
        Assertions.assertTrue((boolean)headersSubFrame.headers().contains((Object)"content-type"));
        StompContentSubframe contentSubFrame = (StompContentSubframe)this.channel.readInbound();
        Assertions.assertNotNull((Object)contentSubFrame);
        Assertions.assertEquals((Object)"body", (Object)contentSubFrame.content().toString(CharsetUtil.UTF_8));
        Assertions.assertTrue((boolean)contentSubFrame.release());
    }

    @Test
    void testFrameWithContentLengthAndWithoutNullEnding() {
        this.channel = new EmbeddedChannel(new ChannelHandler[]{new StompSubframeDecoder(true)});
        ByteBuf incoming = Unpooled.wrappedBuffer((byte[])"SEND\ndestination:/queue/a\ncontent-type:text/plain\ncontent-length:4\n\nbody\u0001".getBytes(CharsetUtil.UTF_8));
        Assertions.assertTrue((boolean)this.channel.writeInbound(new Object[]{incoming}));
        StompHeadersSubframe headersFrame = (StompHeadersSubframe)this.channel.readInbound();
        Assertions.assertNotNull((Object)headersFrame);
        Assertions.assertFalse((boolean)headersFrame.decoderResult().isFailure());
        StompContentSubframe lastContentFrame = (StompContentSubframe)this.channel.readInbound();
        Assertions.assertNotNull((Object)lastContentFrame);
        Assertions.assertTrue((boolean)lastContentFrame.decoderResult().isFailure());
        Assertions.assertEquals((Object)"unexpected byte in buffer 1 while expecting NULL byte", (Object)lastContentFrame.decoderResult().cause().getMessage());
    }
}

