/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec;

import io.netty.buffer.MessageBuf;
import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundMessageHandler;
import io.netty.channel.ChannelOutboundMessageHandler;
import io.netty.channel.ChannelPromise;
import io.netty.handler.codec.MessageToMessageDecoder;
import io.netty.handler.codec.MessageToMessageEncoder;
import io.netty.util.internal.TypeParameterMatcher;

public abstract class MessageToMessageCodec<INBOUND_IN, OUTBOUND_IN>
extends ChannelDuplexHandler
implements ChannelInboundMessageHandler<INBOUND_IN>,
ChannelOutboundMessageHandler<OUTBOUND_IN> {
    private final MessageToMessageEncoder<Object> encoder = new MessageToMessageEncoder<Object>(){

        public boolean acceptOutboundMessage(Object msg) throws Exception {
            return MessageToMessageCodec.this.acceptOutboundMessage(msg);
        }

        @Override
        protected Object encode(ChannelHandlerContext ctx, Object msg) throws Exception {
            return MessageToMessageCodec.this.encode(ctx, msg);
        }
    };
    private final MessageToMessageDecoder<Object> decoder = new MessageToMessageDecoder<Object>(){

        public boolean acceptInboundMessage(Object msg) throws Exception {
            return MessageToMessageCodec.this.acceptInboundMessage(msg);
        }

        @Override
        protected Object decode(ChannelHandlerContext ctx, Object msg) throws Exception {
            return MessageToMessageCodec.this.decode(ctx, msg);
        }
    };
    private final TypeParameterMatcher inboundMsgMatcher = TypeParameterMatcher.find((Object)((Object)this), MessageToMessageCodec.class, (String)"INBOUND_IN");
    private final TypeParameterMatcher outboundMsgMatcher = TypeParameterMatcher.find((Object)((Object)this), MessageToMessageCodec.class, (String)"OUTBOUND_IN");

    protected MessageToMessageCodec() {
    }

    public MessageBuf<INBOUND_IN> newInboundBuffer(ChannelHandlerContext ctx) throws Exception {
        return this.decoder.newInboundBuffer(ctx);
    }

    public void freeInboundBuffer(ChannelHandlerContext ctx) throws Exception {
        this.decoder.freeInboundBuffer(ctx);
    }

    public MessageBuf<OUTBOUND_IN> newOutboundBuffer(ChannelHandlerContext ctx) throws Exception {
        return this.encoder.newOutboundBuffer(ctx);
    }

    public void freeOutboundBuffer(ChannelHandlerContext ctx) throws Exception {
        this.encoder.freeOutboundBuffer(ctx);
    }

    public void inboundBufferUpdated(ChannelHandlerContext ctx) throws Exception {
        this.decoder.inboundBufferUpdated(ctx);
    }

    public void flush(ChannelHandlerContext ctx, ChannelPromise future) throws Exception {
        this.encoder.flush(ctx, future);
    }

    public boolean acceptInboundMessage(Object msg) throws Exception {
        return this.inboundMsgMatcher.match(msg);
    }

    public boolean acceptOutboundMessage(Object msg) throws Exception {
        return this.outboundMsgMatcher.match(msg);
    }

    protected abstract Object encode(ChannelHandlerContext var1, OUTBOUND_IN var2) throws Exception;

    protected abstract Object decode(ChannelHandlerContext var1, INBOUND_IN var2) throws Exception;
}

