/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.MessageBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.ByteToMessageDecoder;
import io.netty.handler.codec.CodecException;
import io.netty.handler.codec.DecoderException;
import io.netty.handler.codec.OutputMessageBuf;
import io.netty.handler.codec.ReplayingDecoderBuffer;
import io.netty.util.Signal;

public abstract class ReplayingDecoder<S>
extends ByteToMessageDecoder {
    static final Signal REPLAY = new Signal(ReplayingDecoder.class.getName() + ".REPLAY");
    private ChannelHandlerContext ctx;
    private final ReplayingDecoderBuffer replayable = new ReplayingDecoderBuffer();
    private S state;
    private int checkpoint = -1;
    private boolean decodeWasNull;

    protected ReplayingDecoder() {
        this(null);
    }

    protected ReplayingDecoder(S initialState) {
        this.state = initialState;
    }

    protected void checkpoint() {
        this.checkpoint = this.internalBuffer().readerIndex();
    }

    protected void checkpoint(S state) {
        this.checkpoint();
        this.state(state);
    }

    protected S state() {
        return this.state;
    }

    protected S state(S newState) {
        S oldState = this.state;
        this.state = newState;
        return oldState;
    }

    protected int actualReadableBytes() {
        return this.internalBuffer().readableBytes();
    }

    protected ByteBuf internalBuffer() {
        return this.ctx.inboundByteBuffer();
    }

    public void handlerAdded(ChannelHandlerContext ctx) throws Exception {
        this.ctx = ctx;
    }

    public final void discardInboundReadBytes(ChannelHandlerContext ctx) throws Exception {
        ByteBuf in = ctx.inboundByteBuffer();
        int oldReaderIndex = in.readerIndex();
        this.discardInboundReadBytes0(ctx);
        int newReaderIndex = in.readerIndex();
        this.checkpoint -= oldReaderIndex - newReaderIndex;
    }

    protected void discardInboundReadBytes0(ChannelHandlerContext ctx) throws Exception {
        super.discardInboundReadBytes(ctx);
    }

    @Override
    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        OutputMessageBuf out = OutputMessageBuf.get();
        try {
            this.replayable.terminate();
            ByteBuf in = this.internalBuffer();
            this.replayable.setCumulation(in);
            if (in.isReadable()) {
                this.callDecode(ctx, in);
            }
            this.decodeLast(ctx, this.replayable, (MessageBuf<Object>)out);
        }
        catch (Signal replay) {
            replay.expect(REPLAY);
        }
        catch (CodecException e) {
            throw e;
        }
        catch (Throwable cause) {
            throw new DecoderException(cause);
        }
        finally {
            if (out.drainToNextInbound(ctx)) {
                ctx.fireInboundBufferUpdated();
            }
            ctx.fireChannelInactive();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected void callDecode(ChannelHandlerContext ctx, ByteBuf buf) {
        boolean wasNull = false;
        ByteBuf in = this.internalBuffer();
        this.replayable.setCumulation(in);
        OutputMessageBuf out = OutputMessageBuf.get();
        try {
            while (in.isReadable()) {
                int oldReaderIndex = this.checkpoint = in.readerIndex();
                int outSize = out.size();
                S oldState = this.state;
                try {
                    this.decode(ctx, this.replayable, (MessageBuf<Object>)out);
                    if (outSize == out.size()) {
                        wasNull = true;
                        if (oldReaderIndex != in.readerIndex() || oldState != this.state) continue;
                        throw new IllegalStateException("null cannot be returned if no data is consumed and state didn't change.");
                    }
                }
                catch (Signal replay) {
                    replay.expect(REPLAY);
                    int checkpoint = this.checkpoint;
                    if (checkpoint < 0) return;
                    in.readerIndex(checkpoint);
                    return;
                }
                wasNull = false;
                if (oldReaderIndex == in.readerIndex() && oldState == this.state) {
                    throw new IllegalStateException("decode() method must consume at least one byte if it returned a decoded message (caused by: " + ((Object)((Object)this)).getClass() + ')');
                }
                if (this.isSingleDecode()) return;
            }
            return;
        }
        catch (CodecException e) {
            throw e;
        }
        catch (Throwable cause) {
            throw new DecoderException(cause);
        }
        finally {
            if (out.drainToNextInbound(ctx)) {
                this.decodeWasNull = false;
                ctx.fireInboundBufferUpdated();
            } else if (wasNull) {
                this.decodeWasNull = true;
            }
        }
    }

    @Override
    public void channelReadSuspended(ChannelHandlerContext ctx) throws Exception {
        if (this.decodeWasNull) {
            this.decodeWasNull = false;
            if (!ctx.channel().config().isAutoRead()) {
                ctx.read();
            }
        }
        super.channelReadSuspended(ctx);
    }
}

