/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.ByteBufIndexFinder;
import io.netty.buffer.ByteBufProcessor;
import io.netty.buffer.SwappedByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.handler.codec.ReplayingDecoder;
import io.netty.handler.codec.UnreplayableOperationException;
import io.netty.util.Signal;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.GatheringByteChannel;
import java.nio.channels.ScatteringByteChannel;
import java.nio.charset.Charset;

final class ReplayingDecoderBuffer
implements ByteBuf {
    private static final Signal REPLAY = ReplayingDecoder.REPLAY;
    private ByteBuf buffer;
    private boolean terminated;
    private SwappedByteBuf swapped;
    static final ReplayingDecoderBuffer EMPTY_BUFFER = new ReplayingDecoderBuffer(Unpooled.EMPTY_BUFFER);

    ReplayingDecoderBuffer() {
    }

    ReplayingDecoderBuffer(ByteBuf buffer) {
        this.setCumulation(buffer);
    }

    void setCumulation(ByteBuf buffer) {
        this.buffer = buffer;
    }

    void terminate() {
        this.terminated = true;
    }

    public int capacity() {
        if (this.terminated) {
            return this.buffer.capacity();
        }
        return Integer.MAX_VALUE;
    }

    public ByteBuf capacity(int newCapacity) {
        throw new UnreplayableOperationException();
    }

    public int maxCapacity() {
        return this.capacity();
    }

    public ByteBufAllocator alloc() {
        return this.buffer.alloc();
    }

    public boolean isDirect() {
        return this.buffer.isDirect();
    }

    public boolean hasArray() {
        return false;
    }

    public byte[] array() {
        throw new UnsupportedOperationException();
    }

    public int arrayOffset() {
        throw new UnsupportedOperationException();
    }

    public boolean hasMemoryAddress() {
        return false;
    }

    public long memoryAddress() {
        throw new UnsupportedOperationException();
    }

    public ByteBuf clear() {
        throw new UnreplayableOperationException();
    }

    public boolean equals(Object obj) {
        return this == obj;
    }

    public int compareTo(ByteBuf buffer) {
        throw new UnreplayableOperationException();
    }

    public ByteBuf copy() {
        throw new UnreplayableOperationException();
    }

    public ByteBuf copy(int index, int length) {
        this.checkIndex(index, length);
        return this.buffer.copy(index, length);
    }

    public ByteBuf discardReadBytes() {
        throw new UnreplayableOperationException();
    }

    public ByteBuf ensureWritable(int writableBytes) {
        throw new UnreplayableOperationException();
    }

    @Deprecated
    public ByteBuf ensureWritableBytes(int writableBytes) {
        throw new UnreplayableOperationException();
    }

    public int ensureWritable(int minWritableBytes, boolean force) {
        throw new UnreplayableOperationException();
    }

    public ByteBuf duplicate() {
        throw new UnreplayableOperationException();
    }

    public boolean getBoolean(int index) {
        this.checkIndex(index, 1);
        return this.buffer.getBoolean(index);
    }

    public byte getByte(int index) {
        this.checkIndex(index, 1);
        return this.buffer.getByte(index);
    }

    public short getUnsignedByte(int index) {
        this.checkIndex(index, 1);
        return this.buffer.getUnsignedByte(index);
    }

    public ByteBuf getBytes(int index, byte[] dst, int dstIndex, int length) {
        this.checkIndex(index, length);
        this.buffer.getBytes(index, dst, dstIndex, length);
        return this;
    }

    public ByteBuf getBytes(int index, byte[] dst) {
        this.checkIndex(index, dst.length);
        this.buffer.getBytes(index, dst);
        return this;
    }

    public ByteBuf getBytes(int index, ByteBuffer dst) {
        throw new UnreplayableOperationException();
    }

    public ByteBuf getBytes(int index, ByteBuf dst, int dstIndex, int length) {
        this.checkIndex(index, length);
        this.buffer.getBytes(index, dst, dstIndex, length);
        return this;
    }

    public ByteBuf getBytes(int index, ByteBuf dst, int length) {
        throw new UnreplayableOperationException();
    }

    public ByteBuf getBytes(int index, ByteBuf dst) {
        throw new UnreplayableOperationException();
    }

    public int getBytes(int index, GatheringByteChannel out, int length) {
        throw new UnreplayableOperationException();
    }

    public ByteBuf getBytes(int index, OutputStream out, int length) {
        throw new UnreplayableOperationException();
    }

    public int getInt(int index) {
        this.checkIndex(index, 4);
        return this.buffer.getInt(index);
    }

    public long getUnsignedInt(int index) {
        this.checkIndex(index, 4);
        return this.buffer.getUnsignedInt(index);
    }

    public long getLong(int index) {
        this.checkIndex(index, 8);
        return this.buffer.getLong(index);
    }

    public int getMedium(int index) {
        this.checkIndex(index, 3);
        return this.buffer.getMedium(index);
    }

    public int getUnsignedMedium(int index) {
        this.checkIndex(index, 3);
        return this.buffer.getUnsignedMedium(index);
    }

    public short getShort(int index) {
        this.checkIndex(index, 2);
        return this.buffer.getShort(index);
    }

    public int getUnsignedShort(int index) {
        this.checkIndex(index, 2);
        return this.buffer.getUnsignedShort(index);
    }

    public char getChar(int index) {
        this.checkIndex(index, 2);
        return this.buffer.getChar(index);
    }

    public float getFloat(int index) {
        this.checkIndex(index, 4);
        return this.buffer.getFloat(index);
    }

    public double getDouble(int index) {
        this.checkIndex(index, 8);
        return this.buffer.getDouble(index);
    }

    public int hashCode() {
        throw new UnreplayableOperationException();
    }

    public int indexOf(int fromIndex, int toIndex, byte value) {
        int endIndex = this.buffer.indexOf(fromIndex, toIndex, value);
        if (endIndex < 0) {
            throw REPLAY;
        }
        return endIndex;
    }

    @Deprecated
    public int indexOf(int fromIndex, int toIndex, ByteBufIndexFinder indexFinder) {
        int endIndex = this.buffer.indexOf(fromIndex, toIndex, indexFinder);
        if (endIndex < 0) {
            throw REPLAY;
        }
        return endIndex;
    }

    public int bytesBefore(byte value) {
        int bytes = this.buffer.bytesBefore(value);
        if (bytes < 0) {
            throw REPLAY;
        }
        return bytes;
    }

    @Deprecated
    public int bytesBefore(ByteBufIndexFinder indexFinder) {
        int bytes = this.buffer.bytesBefore(indexFinder);
        if (bytes < 0) {
            throw REPLAY;
        }
        return bytes;
    }

    public int bytesBefore(int length, byte value) {
        this.checkReadableBytes(length);
        int bytes = this.buffer.bytesBefore(length, value);
        if (bytes < 0) {
            throw REPLAY;
        }
        return bytes;
    }

    @Deprecated
    public int bytesBefore(int length, ByteBufIndexFinder indexFinder) {
        this.checkReadableBytes(length);
        int bytes = this.buffer.bytesBefore(length, indexFinder);
        if (bytes < 0) {
            throw REPLAY;
        }
        return bytes;
    }

    public int bytesBefore(int index, int length, byte value) {
        int bytes = this.buffer.bytesBefore(index, length, value);
        if (bytes < 0) {
            throw REPLAY;
        }
        return bytes;
    }

    @Deprecated
    public int bytesBefore(int index, int length, ByteBufIndexFinder indexFinder) {
        int bytes = this.buffer.bytesBefore(index, length, indexFinder);
        if (bytes < 0) {
            throw REPLAY;
        }
        return bytes;
    }

    public int forEachByte(ByteBufProcessor processor) {
        int ret = this.buffer.forEachByte(processor);
        if (!this.terminated && ret < 0) {
            throw REPLAY;
        }
        return ret;
    }

    public int forEachByte(int index, int length, ByteBufProcessor processor) {
        int writerIndex = this.buffer.writerIndex();
        if (index >= writerIndex) {
            throw REPLAY;
        }
        if (index + length <= writerIndex) {
            return this.buffer.forEachByte(index, length, processor);
        }
        int ret = this.buffer.forEachByte(index, writerIndex - index, processor);
        if (ret < 0) {
            throw REPLAY;
        }
        return ret;
    }

    public int forEachByteDesc(ByteBufProcessor processor) {
        if (this.terminated) {
            return this.buffer.forEachByteDesc(processor);
        }
        throw new UnreplayableOperationException();
    }

    public int forEachByteDesc(int index, int length, ByteBufProcessor processor) {
        if (index + length > this.buffer.writerIndex()) {
            throw REPLAY;
        }
        return this.buffer.forEachByteDesc(index, length, processor);
    }

    public ByteBuf markReaderIndex() {
        this.buffer.markReaderIndex();
        return this;
    }

    public ByteBuf markWriterIndex() {
        throw new UnreplayableOperationException();
    }

    public ByteOrder order() {
        return this.buffer.order();
    }

    public ByteBuf order(ByteOrder endianness) {
        if (endianness == null) {
            throw new NullPointerException("endianness");
        }
        if (endianness == this.order()) {
            return this;
        }
        SwappedByteBuf swapped = this.swapped;
        if (swapped == null) {
            this.swapped = swapped = new SwappedByteBuf((ByteBuf)this);
        }
        return swapped;
    }

    public boolean isReadable() {
        return this.terminated ? this.buffer.isReadable() : true;
    }

    @Deprecated
    public boolean readable() {
        return this.isReadable();
    }

    public boolean isReadable(int size) {
        return this.terminated ? this.buffer.isReadable(size) : true;
    }

    public int readableBytes() {
        if (this.terminated) {
            return this.buffer.readableBytes();
        }
        return Integer.MAX_VALUE - this.buffer.readerIndex();
    }

    public boolean readBoolean() {
        this.checkReadableBytes(1);
        return this.buffer.readBoolean();
    }

    public byte readByte() {
        this.checkReadableBytes(1);
        return this.buffer.readByte();
    }

    public short readUnsignedByte() {
        this.checkReadableBytes(1);
        return this.buffer.readUnsignedByte();
    }

    public ByteBuf readBytes(byte[] dst, int dstIndex, int length) {
        this.checkReadableBytes(length);
        this.buffer.readBytes(dst, dstIndex, length);
        return this;
    }

    public ByteBuf readBytes(byte[] dst) {
        this.checkReadableBytes(dst.length);
        this.buffer.readBytes(dst);
        return this;
    }

    public ByteBuf readBytes(ByteBuffer dst) {
        throw new UnreplayableOperationException();
    }

    public ByteBuf readBytes(ByteBuf dst, int dstIndex, int length) {
        this.checkReadableBytes(length);
        this.buffer.readBytes(dst, dstIndex, length);
        return this;
    }

    public ByteBuf readBytes(ByteBuf dst, int length) {
        throw new UnreplayableOperationException();
    }

    public ByteBuf readBytes(ByteBuf dst) {
        this.checkReadableBytes(dst.writableBytes());
        this.buffer.readBytes(dst);
        return this;
    }

    public int readBytes(GatheringByteChannel out, int length) {
        throw new UnreplayableOperationException();
    }

    public ByteBuf readBytes(int length) {
        this.checkReadableBytes(length);
        return this.buffer.readBytes(length);
    }

    public ByteBuf readSlice(int length) {
        this.checkReadableBytes(length);
        return this.buffer.readSlice(length);
    }

    public ByteBuf readBytes(OutputStream out, int length) {
        throw new UnreplayableOperationException();
    }

    public int readerIndex() {
        return this.buffer.readerIndex();
    }

    public ByteBuf readerIndex(int readerIndex) {
        this.buffer.readerIndex(readerIndex);
        return this;
    }

    public int readInt() {
        this.checkReadableBytes(4);
        return this.buffer.readInt();
    }

    public long readUnsignedInt() {
        this.checkReadableBytes(4);
        return this.buffer.readUnsignedInt();
    }

    public long readLong() {
        this.checkReadableBytes(8);
        return this.buffer.readLong();
    }

    public int readMedium() {
        this.checkReadableBytes(3);
        return this.buffer.readMedium();
    }

    public int readUnsignedMedium() {
        this.checkReadableBytes(3);
        return this.buffer.readUnsignedMedium();
    }

    public short readShort() {
        this.checkReadableBytes(2);
        return this.buffer.readShort();
    }

    public int readUnsignedShort() {
        this.checkReadableBytes(2);
        return this.buffer.readUnsignedShort();
    }

    public char readChar() {
        this.checkReadableBytes(2);
        return this.buffer.readChar();
    }

    public float readFloat() {
        this.checkReadableBytes(4);
        return this.buffer.readFloat();
    }

    public double readDouble() {
        this.checkReadableBytes(8);
        return this.buffer.readDouble();
    }

    public ByteBuf resetReaderIndex() {
        this.buffer.resetReaderIndex();
        return this;
    }

    public ByteBuf resetWriterIndex() {
        throw new UnreplayableOperationException();
    }

    public ByteBuf setBoolean(int index, boolean value) {
        throw new UnreplayableOperationException();
    }

    public ByteBuf setByte(int index, int value) {
        throw new UnreplayableOperationException();
    }

    public ByteBuf setBytes(int index, byte[] src, int srcIndex, int length) {
        throw new UnreplayableOperationException();
    }

    public ByteBuf setBytes(int index, byte[] src) {
        throw new UnreplayableOperationException();
    }

    public ByteBuf setBytes(int index, ByteBuffer src) {
        throw new UnreplayableOperationException();
    }

    public ByteBuf setBytes(int index, ByteBuf src, int srcIndex, int length) {
        throw new UnreplayableOperationException();
    }

    public ByteBuf setBytes(int index, ByteBuf src, int length) {
        throw new UnreplayableOperationException();
    }

    public ByteBuf setBytes(int index, ByteBuf src) {
        throw new UnreplayableOperationException();
    }

    public int setBytes(int index, InputStream in, int length) {
        throw new UnreplayableOperationException();
    }

    public ByteBuf setZero(int index, int length) {
        throw new UnreplayableOperationException();
    }

    public int setBytes(int index, ScatteringByteChannel in, int length) {
        throw new UnreplayableOperationException();
    }

    public ByteBuf setIndex(int readerIndex, int writerIndex) {
        throw new UnreplayableOperationException();
    }

    public ByteBuf setInt(int index, int value) {
        throw new UnreplayableOperationException();
    }

    public ByteBuf setLong(int index, long value) {
        throw new UnreplayableOperationException();
    }

    public ByteBuf setMedium(int index, int value) {
        throw new UnreplayableOperationException();
    }

    public ByteBuf setShort(int index, int value) {
        throw new UnreplayableOperationException();
    }

    public ByteBuf setChar(int index, int value) {
        throw new UnreplayableOperationException();
    }

    public ByteBuf setFloat(int index, float value) {
        throw new UnreplayableOperationException();
    }

    public ByteBuf setDouble(int index, double value) {
        throw new UnreplayableOperationException();
    }

    public ByteBuf skipBytes(int length) {
        this.checkReadableBytes(length);
        this.buffer.skipBytes(length);
        return this;
    }

    public ByteBuf slice() {
        throw new UnreplayableOperationException();
    }

    public ByteBuf slice(int index, int length) {
        this.checkIndex(index, length);
        return this.buffer.slice(index, length);
    }

    public int nioBufferCount() {
        return this.buffer.nioBufferCount();
    }

    public ByteBuffer nioBuffer() {
        throw new UnreplayableOperationException();
    }

    public ByteBuffer nioBuffer(int index, int length) {
        this.checkIndex(index, length);
        return this.buffer.nioBuffer(index, length);
    }

    public ByteBuffer[] nioBuffers() {
        throw new UnreplayableOperationException();
    }

    public ByteBuffer[] nioBuffers(int index, int length) {
        this.checkIndex(index, length);
        return this.buffer.nioBuffers(index, length);
    }

    public ByteBuffer internalNioBuffer(int index, int length) {
        this.checkIndex(index, length);
        return this.buffer.internalNioBuffer(index, length);
    }

    public String toString(int index, int length, Charset charset) {
        this.checkIndex(index, length);
        return this.buffer.toString(index, length, charset);
    }

    public String toString(Charset charsetName) {
        throw new UnreplayableOperationException();
    }

    public String toString() {
        return this.getClass().getSimpleName() + '(' + "ridx=" + this.readerIndex() + ", " + "widx=" + this.writerIndex() + ')';
    }

    public boolean isWritable() {
        return false;
    }

    @Deprecated
    public boolean writable() {
        return false;
    }

    public boolean isWritable(int size) {
        return false;
    }

    public int writableBytes() {
        return 0;
    }

    public int maxWritableBytes() {
        return 0;
    }

    public ByteBuf writeBoolean(boolean value) {
        throw new UnreplayableOperationException();
    }

    public ByteBuf writeByte(int value) {
        throw new UnreplayableOperationException();
    }

    public ByteBuf writeBytes(byte[] src, int srcIndex, int length) {
        throw new UnreplayableOperationException();
    }

    public ByteBuf writeBytes(byte[] src) {
        throw new UnreplayableOperationException();
    }

    public ByteBuf writeBytes(ByteBuffer src) {
        throw new UnreplayableOperationException();
    }

    public ByteBuf writeBytes(ByteBuf src, int srcIndex, int length) {
        throw new UnreplayableOperationException();
    }

    public ByteBuf writeBytes(ByteBuf src, int length) {
        throw new UnreplayableOperationException();
    }

    public ByteBuf writeBytes(ByteBuf src) {
        throw new UnreplayableOperationException();
    }

    public int writeBytes(InputStream in, int length) {
        throw new UnreplayableOperationException();
    }

    public int writeBytes(ScatteringByteChannel in, int length) {
        throw new UnreplayableOperationException();
    }

    public ByteBuf writeInt(int value) {
        throw new UnreplayableOperationException();
    }

    public ByteBuf writeLong(long value) {
        throw new UnreplayableOperationException();
    }

    public ByteBuf writeMedium(int value) {
        throw new UnreplayableOperationException();
    }

    public ByteBuf writeZero(int length) {
        throw new UnreplayableOperationException();
    }

    public int writerIndex() {
        return this.buffer.writerIndex();
    }

    public ByteBuf writerIndex(int writerIndex) {
        throw new UnreplayableOperationException();
    }

    public ByteBuf writeShort(int value) {
        throw new UnreplayableOperationException();
    }

    public ByteBuf writeChar(int value) {
        throw new UnreplayableOperationException();
    }

    public ByteBuf writeFloat(float value) {
        throw new UnreplayableOperationException();
    }

    public ByteBuf writeDouble(double value) {
        throw new UnreplayableOperationException();
    }

    private void checkIndex(int index, int length) {
        if (index + length > this.buffer.writerIndex()) {
            throw REPLAY;
        }
    }

    private void checkReadableBytes(int readableBytes) {
        if (this.buffer.readableBytes() < readableBytes) {
            throw REPLAY;
        }
    }

    public ByteBuf discardSomeReadBytes() {
        throw new UnreplayableOperationException();
    }

    public int refCnt() {
        return this.buffer.refCnt();
    }

    public ByteBuf retain() {
        throw new UnreplayableOperationException();
    }

    public ByteBuf retain(int increment) {
        throw new UnreplayableOperationException();
    }

    public boolean release() {
        throw new UnreplayableOperationException();
    }

    public boolean release(int decrement) {
        throw new UnreplayableOperationException();
    }

    public ByteBuf unwrap() {
        throw new UnreplayableOperationException();
    }

    static {
        EMPTY_BUFFER.terminate();
    }
}

