/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec;

import io.netty.handler.codec.Headers;
import io.netty.handler.codec.ValueConverter;
import io.netty.util.HashingStrategy;
import io.netty.util.concurrent.FastThreadLocal;
import io.netty.util.internal.ObjectUtil;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.TimeZone;

public class DefaultHeaders<T>
implements Headers<T> {
    private static final int ARRAY_SIZE = 16;
    private static final int HASH_MASK = 15;
    private final HeaderEntry<T>[] entries = new HeaderEntry[16];
    protected final HeaderEntry<T> head = new HeaderEntry();
    private final ValueConverter<T> valueConverter;
    private final NameValidator<T> nameValidator;
    private final HashingStrategy<T> hashingStrategy;
    int size;

    private static int index(int hash) {
        return (hash >>> 16 ^ hash) & 0xF;
    }

    public DefaultHeaders(ValueConverter<T> valueConverter) {
        this(HashingStrategy.JAVA_HASHER, valueConverter, NameValidator.NOT_NULL);
    }

    public DefaultHeaders(HashingStrategy<T> nameHashingStrategy, ValueConverter<T> valueConverter, NameValidator<T> nameValidator) {
        this.valueConverter = (ValueConverter)ObjectUtil.checkNotNull(valueConverter, (String)"valueConverter");
        this.nameValidator = (NameValidator)ObjectUtil.checkNotNull(nameValidator, (String)"nameValidator");
        this.hashingStrategy = (HashingStrategy)ObjectUtil.checkNotNull(nameHashingStrategy, (String)"nameHashingStrategy");
        this.head.after = this.head;
        this.head.before = this.head.after;
    }

    @Override
    public T get(T name) {
        ObjectUtil.checkNotNull(name, (String)"name");
        int h = this.hashingStrategy.hashCode(name);
        int i = DefaultHeaders.index(h);
        HeaderEntry<T> e = this.entries[i];
        T value = null;
        while (e != null) {
            if (e.hash == h && this.hashingStrategy.equals(name, e.key)) {
                value = e.value;
            }
            e = e.next;
        }
        return value;
    }

    @Override
    public T get(T name, T defaultValue) {
        T value = this.get(name);
        if (value == null) {
            return defaultValue;
        }
        return value;
    }

    @Override
    public T getAndRemove(T name) {
        int h = this.hashingStrategy.hashCode(name);
        return (T)this.remove0(h, DefaultHeaders.index(h), ObjectUtil.checkNotNull(name, (String)"name"));
    }

    @Override
    public T getAndRemove(T name, T defaultValue) {
        T value = this.getAndRemove(name);
        if (value == null) {
            return defaultValue;
        }
        return value;
    }

    @Override
    public List<T> getAll(T name) {
        ObjectUtil.checkNotNull(name, (String)"name");
        LinkedList<T> values = new LinkedList<T>();
        int h = this.hashingStrategy.hashCode(name);
        int i = DefaultHeaders.index(h);
        HeaderEntry<T> e = this.entries[i];
        while (e != null) {
            if (e.hash == h && this.hashingStrategy.equals(name, e.key)) {
                values.addFirst(e.getValue());
            }
            e = e.next;
        }
        return values;
    }

    @Override
    public List<T> getAllAndRemove(T name) {
        List<T> all = this.getAll(name);
        this.remove(name);
        return all;
    }

    @Override
    public boolean contains(T name) {
        return this.get(name) != null;
    }

    @Override
    public boolean containsObject(T name, Object value) {
        return this.contains(name, this.valueConverter.convertObject(ObjectUtil.checkNotNull((Object)value, (String)"value")));
    }

    @Override
    public boolean containsBoolean(T name, boolean value) {
        return this.contains(name, this.valueConverter.convertBoolean(value));
    }

    @Override
    public boolean containsByte(T name, byte value) {
        return this.contains(name, this.valueConverter.convertByte(value));
    }

    @Override
    public boolean containsChar(T name, char value) {
        return this.contains(name, this.valueConverter.convertChar(value));
    }

    @Override
    public boolean containsShort(T name, short value) {
        return this.contains(name, this.valueConverter.convertShort(value));
    }

    @Override
    public boolean containsInt(T name, int value) {
        return this.contains(name, this.valueConverter.convertInt(value));
    }

    @Override
    public boolean containsLong(T name, long value) {
        return this.contains(name, this.valueConverter.convertLong(value));
    }

    @Override
    public boolean containsFloat(T name, float value) {
        return this.contains(name, this.valueConverter.convertFloat(value));
    }

    @Override
    public boolean containsDouble(T name, double value) {
        return this.contains(name, this.valueConverter.convertDouble(value));
    }

    @Override
    public boolean containsTimeMillis(T name, long value) {
        return this.contains(name, this.valueConverter.convertTimeMillis(value));
    }

    @Override
    public boolean contains(T name, T value) {
        return this.contains(name, value, HashingStrategy.JAVA_HASHER);
    }

    public final boolean contains(T name, T value, HashingStrategy<? super T> valueHashingStrategy) {
        ObjectUtil.checkNotNull(name, (String)"name");
        int h = this.hashingStrategy.hashCode(name);
        int i = DefaultHeaders.index(h);
        HeaderEntry<T> e = this.entries[i];
        while (e != null) {
            if (e.hash == h && this.hashingStrategy.equals(name, e.key) && valueHashingStrategy.equals(value, e.value)) {
                return true;
            }
            e = e.next;
        }
        return false;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.head == this.head.after;
    }

    @Override
    public Set<T> names() {
        if (this.isEmpty()) {
            return Collections.emptySet();
        }
        LinkedHashSet names = new LinkedHashSet(this.size());
        HeaderEntry e = this.head.after;
        while (e != this.head) {
            names.add(e.getKey());
            e = e.after;
        }
        return names;
    }

    @Override
    public Headers<T> add(T name, T value) {
        this.nameValidator.validateName(name);
        ObjectUtil.checkNotNull(value, (String)"value");
        int h = this.hashingStrategy.hashCode(name);
        int i = DefaultHeaders.index(h);
        this.add0(h, i, name, value);
        return this;
    }

    @Override
    public Headers<T> add(T name, Iterable<? extends T> values) {
        this.nameValidator.validateName(name);
        int h = this.hashingStrategy.hashCode(name);
        int i = DefaultHeaders.index(h);
        for (T v : values) {
            this.add0(h, i, name, v);
        }
        return this;
    }

    @Override
    public Headers<T> add(T name, T ... values) {
        this.nameValidator.validateName(name);
        int h = this.hashingStrategy.hashCode(name);
        int i = DefaultHeaders.index(h);
        for (T v : values) {
            this.add0(h, i, name, v);
        }
        return this;
    }

    @Override
    public Headers<T> addObject(T name, Object value) {
        return this.add(name, this.valueConverter.convertObject(ObjectUtil.checkNotNull((Object)value, (String)"value")));
    }

    @Override
    public Headers<T> addObject(T name, Iterable<?> values) {
        ObjectUtil.checkNotNull(values, (String)"values");
        for (Object value : values) {
            this.addObject(name, value);
        }
        return this;
    }

    @Override
    public Headers<T> addObject(T name, Object ... values) {
        ObjectUtil.checkNotNull((Object)values, (String)"values");
        for (int i = 0; i < values.length; ++i) {
            this.addObject(name, values[i]);
        }
        return this;
    }

    @Override
    public Headers<T> addInt(T name, int value) {
        return this.add(name, this.valueConverter.convertInt(value));
    }

    @Override
    public Headers<T> addLong(T name, long value) {
        return this.add(name, this.valueConverter.convertLong(value));
    }

    @Override
    public Headers<T> addDouble(T name, double value) {
        return this.add(name, this.valueConverter.convertDouble(value));
    }

    @Override
    public Headers<T> addTimeMillis(T name, long value) {
        return this.add(name, this.valueConverter.convertTimeMillis(value));
    }

    @Override
    public Headers<T> addChar(T name, char value) {
        return this.add(name, this.valueConverter.convertChar(value));
    }

    @Override
    public Headers<T> addBoolean(T name, boolean value) {
        return this.add(name, this.valueConverter.convertBoolean(value));
    }

    @Override
    public Headers<T> addFloat(T name, float value) {
        return this.add(name, this.valueConverter.convertFloat(value));
    }

    @Override
    public Headers<T> addByte(T name, byte value) {
        return this.add(name, this.valueConverter.convertByte(value));
    }

    @Override
    public Headers<T> addShort(T name, short value) {
        return this.add(name, this.valueConverter.convertShort(value));
    }

    @Override
    public Headers<T> add(Headers<? extends T> headers) {
        ObjectUtil.checkNotNull(headers, (String)"headers");
        if (headers == this) {
            throw new IllegalArgumentException("can't add to itself.");
        }
        if (headers instanceof DefaultHeaders) {
            DefaultHeaders defaultHeaders = (DefaultHeaders)headers;
            HeaderEntry e = defaultHeaders.head.after;
            while (e != defaultHeaders.head) {
                this.add((T)e.key, (T)e.value);
                e = e.after;
            }
            return this;
        }
        for (Map.Entry<T, T> header : headers) {
            this.add(header.getKey(), header.getValue());
        }
        return this;
    }

    @Override
    public Headers<T> set(T name, T value) {
        this.nameValidator.validateName(name);
        ObjectUtil.checkNotNull(value, (String)"value");
        int h = this.hashingStrategy.hashCode(name);
        int i = DefaultHeaders.index(h);
        this.remove0(h, i, name);
        this.add0(h, i, name, value);
        return this;
    }

    @Override
    public Headers<T> set(T name, Iterable<? extends T> values) {
        this.nameValidator.validateName(name);
        ObjectUtil.checkNotNull(values, (String)"values");
        int h = this.hashingStrategy.hashCode(name);
        int i = DefaultHeaders.index(h);
        this.remove0(h, i, name);
        for (T v : values) {
            if (v == null) break;
            this.add0(h, i, name, v);
        }
        return this;
    }

    @Override
    public Headers<T> set(T name, T ... values) {
        this.nameValidator.validateName(name);
        ObjectUtil.checkNotNull(values, (String)"values");
        int h = this.hashingStrategy.hashCode(name);
        int i = DefaultHeaders.index(h);
        this.remove0(h, i, name);
        for (T v : values) {
            if (v == null) break;
            this.add0(h, i, name, v);
        }
        return this;
    }

    @Override
    public Headers<T> setObject(T name, Object value) {
        ObjectUtil.checkNotNull((Object)value, (String)"value");
        Object convertedValue = ObjectUtil.checkNotNull(this.valueConverter.convertObject(value), (String)"convertedValue");
        return this.set(name, (T)convertedValue);
    }

    @Override
    public Headers<T> setObject(T name, Iterable<?> values) {
        this.nameValidator.validateName(name);
        ObjectUtil.checkNotNull(values, (String)"values");
        int h = this.hashingStrategy.hashCode(name);
        int i = DefaultHeaders.index(h);
        this.remove0(h, i, name);
        for (Object v : values) {
            if (v == null) break;
            this.add0(h, i, name, this.valueConverter.convertObject(v));
        }
        return this;
    }

    @Override
    public Headers<T> setObject(T name, Object ... values) {
        this.nameValidator.validateName(name);
        ObjectUtil.checkNotNull((Object)values, (String)"values");
        int h = this.hashingStrategy.hashCode(name);
        int i = DefaultHeaders.index(h);
        this.remove0(h, i, name);
        for (Object v : values) {
            if (v == null) break;
            this.add0(h, i, name, this.valueConverter.convertObject(v));
        }
        return this;
    }

    @Override
    public Headers<T> setInt(T name, int value) {
        return this.set(name, this.valueConverter.convertInt(value));
    }

    @Override
    public Headers<T> setLong(T name, long value) {
        return this.set(name, this.valueConverter.convertLong(value));
    }

    @Override
    public Headers<T> setDouble(T name, double value) {
        return this.set(name, this.valueConverter.convertDouble(value));
    }

    @Override
    public Headers<T> setTimeMillis(T name, long value) {
        return this.set(name, this.valueConverter.convertTimeMillis(value));
    }

    @Override
    public Headers<T> setFloat(T name, float value) {
        return this.set(name, this.valueConverter.convertFloat(value));
    }

    @Override
    public Headers<T> setChar(T name, char value) {
        return this.set(name, this.valueConverter.convertChar(value));
    }

    @Override
    public Headers<T> setBoolean(T name, boolean value) {
        return this.set(name, this.valueConverter.convertBoolean(value));
    }

    @Override
    public Headers<T> setByte(T name, byte value) {
        return this.set(name, this.valueConverter.convertByte(value));
    }

    @Override
    public Headers<T> setShort(T name, short value) {
        return this.set(name, this.valueConverter.convertShort(value));
    }

    @Override
    public Headers<T> set(Headers<? extends T> headers) {
        ObjectUtil.checkNotNull(headers, (String)"headers");
        if (headers == this) {
            return this;
        }
        this.clear();
        if (headers instanceof DefaultHeaders) {
            DefaultHeaders defaultHeaders = (DefaultHeaders)headers;
            HeaderEntry e = defaultHeaders.head.after;
            while (e != defaultHeaders.head) {
                this.add((T)e.key, (T)e.value);
                e = e.after;
            }
        } else {
            this.add(headers);
        }
        return this;
    }

    @Override
    public Headers<T> setAll(Headers<? extends T> headers) {
        ObjectUtil.checkNotNull(headers, (String)"headers");
        if (headers == this) {
            return this;
        }
        for (T t : headers.names()) {
            this.remove(t);
        }
        for (Map.Entry entry : headers) {
            this.add((T)entry.getKey(), (T)entry.getValue());
        }
        return this;
    }

    @Override
    public boolean remove(T name) {
        return this.getAndRemove(name) != null;
    }

    @Override
    public Headers<T> clear() {
        Arrays.fill(this.entries, null);
        this.head.after = this.head;
        this.head.before = this.head.after;
        this.size = 0;
        return this;
    }

    @Override
    public Iterator<Map.Entry<T, T>> iterator() {
        return new HeaderIterator();
    }

    @Override
    public Boolean getBoolean(T name) {
        T v = this.get(name);
        return v != null ? Boolean.valueOf(this.valueConverter.convertToBoolean(v)) : null;
    }

    @Override
    public boolean getBoolean(T name, boolean defaultValue) {
        Boolean v = this.getBoolean(name);
        return v != null ? v : defaultValue;
    }

    @Override
    public Byte getByte(T name) {
        T v = this.get(name);
        return v != null ? Byte.valueOf(this.valueConverter.convertToByte(v)) : null;
    }

    @Override
    public byte getByte(T name, byte defaultValue) {
        Byte v = this.getByte(name);
        return v != null ? v : defaultValue;
    }

    @Override
    public Character getChar(T name) {
        T v = this.get(name);
        return v != null ? Character.valueOf(this.valueConverter.convertToChar(v)) : null;
    }

    @Override
    public char getChar(T name, char defaultValue) {
        Character v = this.getChar(name);
        return v != null ? v.charValue() : defaultValue;
    }

    @Override
    public Short getShort(T name) {
        T v = this.get(name);
        return v != null ? Short.valueOf(this.valueConverter.convertToShort(v)) : null;
    }

    @Override
    public short getShort(T name, short defaultValue) {
        Short v = this.getShort(name);
        return v != null ? v : defaultValue;
    }

    @Override
    public Integer getInt(T name) {
        T v = this.get(name);
        return v != null ? Integer.valueOf(this.valueConverter.convertToInt(v)) : null;
    }

    @Override
    public int getInt(T name, int defaultValue) {
        Integer v = this.getInt(name);
        return v != null ? v : defaultValue;
    }

    @Override
    public Long getLong(T name) {
        T v = this.get(name);
        return v != null ? Long.valueOf(this.valueConverter.convertToLong(v)) : null;
    }

    @Override
    public long getLong(T name, long defaultValue) {
        Long v = this.getLong(name);
        return v != null ? v : defaultValue;
    }

    @Override
    public Float getFloat(T name) {
        T v = this.get(name);
        return v != null ? Float.valueOf(this.valueConverter.convertToFloat(v)) : null;
    }

    @Override
    public float getFloat(T name, float defaultValue) {
        Float v = this.getFloat(name);
        return v != null ? v.floatValue() : defaultValue;
    }

    @Override
    public Double getDouble(T name) {
        T v = this.get(name);
        return v != null ? Double.valueOf(this.valueConverter.convertToDouble(v)) : null;
    }

    @Override
    public double getDouble(T name, double defaultValue) {
        Double v = this.getDouble(name);
        return v != null ? v : defaultValue;
    }

    @Override
    public Long getTimeMillis(T name) {
        T v = this.get(name);
        return v != null ? Long.valueOf(this.valueConverter.convertToTimeMillis(v)) : null;
    }

    @Override
    public long getTimeMillis(T name, long defaultValue) {
        Long v = this.getTimeMillis(name);
        return v != null ? v : defaultValue;
    }

    @Override
    public Boolean getBooleanAndRemove(T name) {
        T v = this.getAndRemove(name);
        return v != null ? Boolean.valueOf(this.valueConverter.convertToBoolean(v)) : null;
    }

    @Override
    public boolean getBooleanAndRemove(T name, boolean defaultValue) {
        Boolean v = this.getBooleanAndRemove(name);
        return v != null ? v : defaultValue;
    }

    @Override
    public Byte getByteAndRemove(T name) {
        T v = this.getAndRemove(name);
        return v != null ? Byte.valueOf(this.valueConverter.convertToByte(v)) : null;
    }

    @Override
    public byte getByteAndRemove(T name, byte defaultValue) {
        Byte v = this.getByteAndRemove(name);
        return v != null ? v : defaultValue;
    }

    @Override
    public Character getCharAndRemove(T name) {
        T v = this.getAndRemove(name);
        if (v == null) {
            return null;
        }
        try {
            return Character.valueOf(this.valueConverter.convertToChar(v));
        }
        catch (Throwable ignored) {
            return null;
        }
    }

    @Override
    public char getCharAndRemove(T name, char defaultValue) {
        Character v = this.getCharAndRemove(name);
        return v != null ? v.charValue() : defaultValue;
    }

    @Override
    public Short getShortAndRemove(T name) {
        T v = this.getAndRemove(name);
        return v != null ? Short.valueOf(this.valueConverter.convertToShort(v)) : null;
    }

    @Override
    public short getShortAndRemove(T name, short defaultValue) {
        Short v = this.getShortAndRemove(name);
        return v != null ? v : defaultValue;
    }

    @Override
    public Integer getIntAndRemove(T name) {
        T v = this.getAndRemove(name);
        return v != null ? Integer.valueOf(this.valueConverter.convertToInt(v)) : null;
    }

    @Override
    public int getIntAndRemove(T name, int defaultValue) {
        Integer v = this.getIntAndRemove(name);
        return v != null ? v : defaultValue;
    }

    @Override
    public Long getLongAndRemove(T name) {
        T v = this.getAndRemove(name);
        return v != null ? Long.valueOf(this.valueConverter.convertToLong(v)) : null;
    }

    @Override
    public long getLongAndRemove(T name, long defaultValue) {
        Long v = this.getLongAndRemove(name);
        return v != null ? v : defaultValue;
    }

    @Override
    public Float getFloatAndRemove(T name) {
        T v = this.getAndRemove(name);
        return v != null ? Float.valueOf(this.valueConverter.convertToFloat(v)) : null;
    }

    @Override
    public float getFloatAndRemove(T name, float defaultValue) {
        Float v = this.getFloatAndRemove(name);
        return v != null ? v.floatValue() : defaultValue;
    }

    @Override
    public Double getDoubleAndRemove(T name) {
        T v = this.getAndRemove(name);
        return v != null ? Double.valueOf(this.valueConverter.convertToDouble(v)) : null;
    }

    @Override
    public double getDoubleAndRemove(T name, double defaultValue) {
        Double v = this.getDoubleAndRemove(name);
        return v != null ? v : defaultValue;
    }

    @Override
    public Long getTimeMillisAndRemove(T name) {
        T v = this.getAndRemove(name);
        return v != null ? Long.valueOf(this.valueConverter.convertToTimeMillis(v)) : null;
    }

    @Override
    public long getTimeMillisAndRemove(T name, long defaultValue) {
        Long v = this.getTimeMillisAndRemove(name);
        return v != null ? v : defaultValue;
    }

    public boolean equals(Object o) {
        if (!(o instanceof Headers)) {
            return false;
        }
        return this.equals((Headers)o, HashingStrategy.JAVA_HASHER);
    }

    public int hashCode() {
        return this.hashCode(HashingStrategy.JAVA_HASHER);
    }

    public final boolean equals(Headers<T> h2, HashingStrategy<T> valueHashingStrategy) {
        if (h2.size() != this.size()) {
            return false;
        }
        if (this == h2) {
            return true;
        }
        for (T name : this.names()) {
            List<T> otherValues = h2.getAll(name);
            List<T> values = this.getAll(name);
            if (otherValues.size() != values.size()) {
                return false;
            }
            for (int i = 0; i < otherValues.size(); ++i) {
                if (valueHashingStrategy.equals(otherValues.get(i), values.get(i))) continue;
                return false;
            }
        }
        return true;
    }

    public final int hashCode(HashingStrategy<T> valueHashingStrategy) {
        int result = 1;
        for (T name : this.names()) {
            result = 31 * result + this.hashingStrategy.hashCode(name);
            List<T> values = this.getAll(name);
            for (int i = 0; i < values.size(); ++i) {
                result = 31 * result + valueHashingStrategy.hashCode(values.get(i));
            }
        }
        return result;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder(this.getClass().getSimpleName()).append('[');
        String separator = "";
        for (T name : this.names()) {
            List<T> values = this.getAll(name);
            for (int i = 0; i < values.size(); ++i) {
                builder.append(separator);
                builder.append(name).append(": ").append(values.get(i));
            }
            separator = ", ";
        }
        return builder.append(']').toString();
    }

    protected HeaderEntry<T> newHeaderEntry(int h, T name, T value, HeaderEntry<T> next) {
        return new HeaderEntry<T>(h, name, value, next, this.head);
    }

    protected ValueConverter<T> valueConverter() {
        return this.valueConverter;
    }

    private void add0(int h, int i, T name, T value) {
        this.entries[i] = this.newHeaderEntry(h, name, value, this.entries[i]);
        ++this.size;
    }

    private T remove0(int h, int i, T name) {
        HeaderEntry<T> e = this.entries[i];
        if (e == null) {
            return null;
        }
        T value = null;
        HeaderEntry next = e.next;
        while (next != null) {
            if (next.hash == h && this.hashingStrategy.equals(name, next.key)) {
                value = next.value;
                e.next = next.next;
                next.remove();
                --this.size;
            } else {
                e = next;
            }
            next = e.next;
        }
        e = this.entries[i];
        if (e.hash == h && this.hashingStrategy.equals(name, e.key)) {
            if (value == null) {
                value = e.value;
            }
            this.entries[i] = e.next;
            e.remove();
            --this.size;
        }
        return value;
    }

    protected static class HeaderEntry<T>
    implements Map.Entry<T, T> {
        protected final int hash;
        protected final T key;
        protected T value;
        protected HeaderEntry<T> next;
        protected HeaderEntry<T> before;
        protected HeaderEntry<T> after;

        protected HeaderEntry(int hash, T key) {
            this.hash = hash;
            this.key = key;
        }

        HeaderEntry(int hash, T key, T value, HeaderEntry<T> next, HeaderEntry<T> head) {
            this.hash = hash;
            this.key = key;
            this.value = value;
            this.next = next;
            this.after = head;
            this.before = head.before;
            this.pointNeighborsToThis();
        }

        HeaderEntry() {
            this.hash = -1;
            this.key = null;
        }

        protected final void pointNeighborsToThis() {
            this.before.after = this;
            this.after.before = this;
        }

        public final HeaderEntry<T> before() {
            return this.before;
        }

        public final HeaderEntry<T> after() {
            return this.after;
        }

        protected void remove() {
            this.before.after = this.after;
            this.after.before = this.before;
        }

        @Override
        public final T getKey() {
            return this.key;
        }

        @Override
        public final T getValue() {
            return this.value;
        }

        @Override
        public final T setValue(T value) {
            ObjectUtil.checkNotNull(value, (String)"value");
            T oldValue = this.value;
            this.value = value;
            return oldValue;
        }

        public final String toString() {
            return this.key.toString() + '=' + this.value.toString();
        }
    }

    private final class HeaderIterator
    implements Iterator<Map.Entry<T, T>> {
        private HeaderEntry<T> current;

        private HeaderIterator() {
            this.current = DefaultHeaders.this.head;
        }

        @Override
        public boolean hasNext() {
            return this.current.after != DefaultHeaders.this.head;
        }

        @Override
        public Map.Entry<T, T> next() {
            this.current = this.current.after;
            if (this.current == DefaultHeaders.this.head) {
                throw new NoSuchElementException();
            }
            return this.current;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("read-only iterator");
        }
    }

    public static final class HeaderDateFormat {
        private static final FastThreadLocal<HeaderDateFormat> dateFormatThreadLocal = new FastThreadLocal<HeaderDateFormat>(){

            protected HeaderDateFormat initialValue() {
                return new HeaderDateFormat();
            }
        };
        private final DateFormat dateFormat1 = new SimpleDateFormat("E, dd MMM yyyy HH:mm:ss z", Locale.ENGLISH);
        private final DateFormat dateFormat2 = new SimpleDateFormat("E, dd-MMM-yy HH:mm:ss z", Locale.ENGLISH);
        private final DateFormat dateFormat3 = new SimpleDateFormat("E MMM d HH:mm:ss yyyy", Locale.ENGLISH);

        static HeaderDateFormat get() {
            return (HeaderDateFormat)dateFormatThreadLocal.get();
        }

        private HeaderDateFormat() {
            TimeZone tz = TimeZone.getTimeZone("GMT");
            this.dateFormat1.setTimeZone(tz);
            this.dateFormat2.setTimeZone(tz);
            this.dateFormat3.setTimeZone(tz);
        }

        long parse(String text) throws ParseException {
            Date date = this.dateFormat1.parse(text);
            if (date == null) {
                date = this.dateFormat2.parse(text);
            }
            if (date == null) {
                date = this.dateFormat3.parse(text);
            }
            if (date == null) {
                throw new ParseException(text, 0);
            }
            return date.getTime();
        }
    }

    public static interface NameValidator<T> {
        public static final NameValidator NOT_NULL = new NameValidator(){

            public void validateName(Object name) {
                ObjectUtil.checkNotNull((Object)name, (String)"name");
            }
        };

        public void validateName(T var1);
    }
}

