/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.compression;

import com.aayushatharva.brotli4j.encoder.BrotliOutputStream;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.CompositeByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandler;
import io.netty.channel.embedded.EmbeddedChannel;
import io.netty.handler.codec.compression.Brotli;
import io.netty.handler.codec.compression.BrotliDecoder;
import io.netty.util.internal.PlatformDependent;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Random;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.condition.DisabledIf;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;

@DisabledIf(value="isNotSupported", disabledReason="Brotli is not supported on this platform")
public class BrotliDecoderTest {
    private static Random RANDOM;
    private static final byte[] BYTES_SMALL;
    private static final byte[] BYTES_LARGE;
    private static byte[] COMPRESSED_BYTES_SMALL;
    private static byte[] COMPRESSED_BYTES_LARGE;
    private static final ByteBuf WRAPPED_BYTES_SMALL;
    private static final ByteBuf WRAPPED_BYTES_LARGE;
    private EmbeddedChannel channel;

    @BeforeAll
    static void setUp() {
        try {
            Brotli.ensureAvailability();
            RANDOM = new Random();
            BrotliDecoderTest.fillArrayWithCompressibleData(BYTES_SMALL);
            BrotliDecoderTest.fillArrayWithCompressibleData(BYTES_LARGE);
            COMPRESSED_BYTES_SMALL = BrotliDecoderTest.compress(BYTES_SMALL);
            COMPRESSED_BYTES_LARGE = BrotliDecoderTest.compress(BYTES_LARGE);
        }
        catch (Throwable throwable) {
            throw new ExceptionInInitializerError(throwable);
        }
    }

    static boolean isNotSupported() {
        return PlatformDependent.isOsx() && "aarch_64".equals(PlatformDependent.normalizedArch());
    }

    private static void fillArrayWithCompressibleData(byte[] array) {
        for (int i = 0; i < array.length; ++i) {
            array[i] = i % 4 != 0 ? (byte)0 : (byte)RANDOM.nextInt();
        }
    }

    private static byte[] compress(byte[] data) throws IOException {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        BrotliOutputStream brotliOs = new BrotliOutputStream((OutputStream)os);
        brotliOs.write(data);
        brotliOs.close();
        return os.toByteArray();
    }

    @BeforeEach
    public void initChannel() {
        this.channel = new EmbeddedChannel(new ChannelHandler[]{new BrotliDecoder()});
    }

    @AfterEach
    public void destroyChannel() {
        if (this.channel != null) {
            this.channel.finishAndReleaseAll();
            this.channel = null;
        }
    }

    public static ByteBuf[] smallData() {
        ByteBuf heap = Unpooled.wrappedBuffer((byte[])COMPRESSED_BYTES_SMALL);
        ByteBuf direct = Unpooled.directBuffer((int)COMPRESSED_BYTES_SMALL.length);
        direct.writeBytes(COMPRESSED_BYTES_SMALL);
        return new ByteBuf[]{heap, direct};
    }

    public static ByteBuf[] largeData() {
        ByteBuf heap = Unpooled.wrappedBuffer((byte[])COMPRESSED_BYTES_LARGE);
        ByteBuf direct = Unpooled.directBuffer((int)COMPRESSED_BYTES_LARGE.length);
        direct.writeBytes(COMPRESSED_BYTES_LARGE);
        return new ByteBuf[]{heap, direct};
    }

    @ParameterizedTest
    @MethodSource(value={"smallData"})
    public void testDecompressionOfSmallChunkOfData(ByteBuf data) {
        this.testDecompression(WRAPPED_BYTES_SMALL.duplicate(), data);
    }

    @ParameterizedTest
    @MethodSource(value={"largeData"})
    public void testDecompressionOfLargeChunkOfData(ByteBuf data) {
        this.testDecompression(WRAPPED_BYTES_LARGE.duplicate(), data);
    }

    @ParameterizedTest
    @MethodSource(value={"largeData"})
    public void testDecompressionOfBatchedFlowOfData(ByteBuf data) {
        this.testDecompressionOfBatchedFlow(WRAPPED_BYTES_LARGE, data);
    }

    private void testDecompression(ByteBuf expected, ByteBuf data) {
        Assertions.assertTrue((boolean)this.channel.writeInbound(new Object[]{data}));
        ByteBuf decompressed = BrotliDecoderTest.readDecompressed(this.channel);
        Assertions.assertEquals((Object)expected, (Object)decompressed);
        decompressed.release();
    }

    private void testDecompressionOfBatchedFlow(ByteBuf expected, ByteBuf data) {
        ByteBuf compressedBuf;
        int compressedLength = data.readableBytes();
        int written = 0;
        int length = RANDOM.nextInt(100);
        while (written + length < compressedLength) {
            compressedBuf = data.retainedSlice(written, length);
            this.channel.writeInbound(new Object[]{compressedBuf});
            written += length;
            length = RANDOM.nextInt(100);
        }
        compressedBuf = data.slice(written, compressedLength - written);
        Assertions.assertTrue((boolean)this.channel.writeInbound(new Object[]{compressedBuf.retain()}));
        ByteBuf decompressedBuf = BrotliDecoderTest.readDecompressed(this.channel);
        Assertions.assertEquals((Object)expected, (Object)decompressedBuf);
        decompressedBuf.release();
        data.release();
    }

    private static ByteBuf readDecompressed(EmbeddedChannel channel) {
        ByteBuf msg;
        CompositeByteBuf decompressed = Unpooled.compositeBuffer();
        while ((msg = (ByteBuf)channel.readInbound()) != null) {
            decompressed.addComponent(true, msg);
        }
        return decompressed;
    }

    static {
        BYTES_SMALL = new byte[256];
        BYTES_LARGE = new byte[262144];
        WRAPPED_BYTES_SMALL = Unpooled.unreleasableBuffer((ByteBuf)Unpooled.wrappedBuffer((byte[])BYTES_SMALL)).asReadOnly();
        WRAPPED_BYTES_LARGE = Unpooled.unreleasableBuffer((ByteBuf)Unpooled.wrappedBuffer((byte[])BYTES_LARGE)).asReadOnly();
    }
}

