/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec;

import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelOutboundHandlerAdapter;
import io.netty.channel.ChannelPromise;
import io.netty.channel.embedded.EmbeddedChannel;
import io.netty.handler.codec.EncoderException;
import io.netty.handler.codec.MessageToMessageEncoder;
import java.util.List;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.function.Executable;

public class MessageToMessageEncoderTest {
    @Test
    public void testException() {
        final EmbeddedChannel channel = new EmbeddedChannel(new ChannelHandler[]{new MessageToMessageEncoder<Object>(){

            protected void encode(ChannelHandlerContext ctx, Object msg, List<Object> out) throws Exception {
                throw new Exception();
            }
        }});
        Assertions.assertThrows(EncoderException.class, (Executable)new Executable(){

            public void execute() {
                channel.writeOutbound(new Object[]{new Object()});
            }
        });
    }

    @Test
    public void testIntermediateWriteFailures() {
        MessageToMessageEncoder<Object> encoder = new MessageToMessageEncoder<Object>(){

            protected void encode(ChannelHandlerContext ctx, Object msg, List<Object> out) {
                out.add(new Object());
                out.add(msg);
            }
        };
        final Exception firstWriteException = new Exception();
        ChannelOutboundHandlerAdapter writeThrower = new ChannelOutboundHandlerAdapter(){
            private boolean firstWritten;

            public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) {
                if (this.firstWritten) {
                    ctx.write(msg, promise);
                } else {
                    this.firstWritten = true;
                    promise.setFailure((Throwable)firstWriteException);
                }
            }
        };
        EmbeddedChannel channel = new EmbeddedChannel(new ChannelHandler[]{writeThrower, encoder});
        Object msg = new Object();
        ChannelFuture write = channel.writeAndFlush(msg);
        Assertions.assertSame((Object)firstWriteException, (Object)write.cause());
        Assertions.assertSame((Object)msg, (Object)channel.readOutbound());
        Assertions.assertFalse((boolean)channel.finish());
    }
}

