/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.compression;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.handler.codec.compression.ByteBufChecksum;
import io.netty.handler.codec.compression.Lz4XXHash32;
import java.util.Random;
import java.util.zip.Adler32;
import java.util.zip.CRC32;
import java.util.zip.Checksum;
import net.jpountz.xxhash.XXHashFactory;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;

public class ByteBufChecksumTest {
    private static final byte[] BYTE_ARRAY = new byte[1024];

    @BeforeAll
    public static void setUp() {
        new Random().nextBytes(BYTE_ARRAY);
    }

    @Test
    public void testHeapByteBufUpdate() {
        ByteBufChecksumTest.testUpdate(Unpooled.wrappedBuffer((byte[])BYTE_ARRAY));
    }

    @Test
    public void testDirectByteBufUpdate() {
        ByteBuf buf = Unpooled.directBuffer((int)BYTE_ARRAY.length);
        buf.writeBytes(BYTE_ARRAY);
        ByteBufChecksumTest.testUpdate(buf);
    }

    private static void testUpdate(ByteBuf buf) {
        try {
            ByteBufChecksumTest.testUpdate(ByteBufChecksumTest.xxHash32(-1756908916), ByteBufChecksum.wrapChecksum((Checksum)ByteBufChecksumTest.xxHash32(-1756908916)), buf);
            ByteBufChecksumTest.testUpdate(ByteBufChecksumTest.xxHash32(-1756908916), (ByteBufChecksum)new Lz4XXHash32(-1756908916), buf);
            ByteBufChecksumTest.testUpdate(ByteBufChecksumTest.xxHash32(-1756908916), ByteBufChecksum.wrapChecksum((Checksum)new Lz4XXHash32(-1756908916)), buf);
            ByteBufChecksumTest.testUpdate(new CRC32(), ByteBufChecksum.wrapChecksum((Checksum)new CRC32()), buf);
            ByteBufChecksumTest.testUpdate(new Adler32(), ByteBufChecksum.wrapChecksum((Checksum)new Adler32()), buf);
        }
        finally {
            buf.release();
        }
    }

    private static void testUpdate(Checksum checksum, ByteBufChecksum wrapped, ByteBuf buf) {
        ByteBufChecksumTest.testUpdate(checksum, wrapped, buf, 0, BYTE_ARRAY.length);
        ByteBufChecksumTest.testUpdate(checksum, wrapped, buf, 0, BYTE_ARRAY.length - 1);
        ByteBufChecksumTest.testUpdate(checksum, wrapped, buf, 1, BYTE_ARRAY.length - 1);
        ByteBufChecksumTest.testUpdate(checksum, wrapped, buf, 1, BYTE_ARRAY.length - 2);
    }

    private static void testUpdate(Checksum checksum, ByteBufChecksum wrapped, ByteBuf buf, int off, int len) {
        checksum.reset();
        wrapped.reset();
        checksum.update(BYTE_ARRAY, off, len);
        wrapped.update(buf, off, len);
        Assertions.assertEquals((long)checksum.getValue(), (long)wrapped.getValue());
    }

    private static Checksum xxHash32(int seed) {
        return XXHashFactory.fastestInstance().newStreamingHash32(seed).asChecksum();
    }
}

