/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.handler.codec.ReplayingDecoderByteBuf;
import io.netty.util.CharsetUtil;
import io.netty.util.Signal;
import java.nio.charset.Charset;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ReplayingDecoderByteBufTest {
    @Test
    public void testGetUnsignedByte() {
        ByteBuf buf = Unpooled.copiedBuffer((CharSequence)"TestBuffer", (Charset)CharsetUtil.ISO_8859_1);
        ReplayingDecoderByteBuf buffer = new ReplayingDecoderByteBuf(buf);
        int i = 0;
        try {
            while (true) {
                buffer.getUnsignedByte(i);
                ++i;
            }
        }
        catch (Signal e) {
            boolean error = true;
            Assertions.assertTrue((boolean)error);
            Assertions.assertEquals((int)10, (int)i);
            buf.release();
            return;
        }
    }

    @Test
    public void testGetByte() {
        ByteBuf buf = Unpooled.copiedBuffer((CharSequence)"TestBuffer", (Charset)CharsetUtil.ISO_8859_1);
        ReplayingDecoderByteBuf buffer = new ReplayingDecoderByteBuf(buf);
        int i = 0;
        try {
            while (true) {
                buffer.getByte(i);
                ++i;
            }
        }
        catch (Signal e) {
            boolean error = true;
            Assertions.assertTrue((boolean)error);
            Assertions.assertEquals((int)10, (int)i);
            buf.release();
            return;
        }
    }

    @Test
    public void testGetBoolean() {
        ByteBuf buf = Unpooled.buffer((int)10);
        while (buf.isWritable()) {
            buf.writeBoolean(true);
        }
        ReplayingDecoderByteBuf buffer = new ReplayingDecoderByteBuf(buf);
        int i = 0;
        try {
            while (true) {
                buffer.getBoolean(i);
                ++i;
            }
        }
        catch (Signal e) {
            boolean error = true;
            Assertions.assertTrue((boolean)error);
            Assertions.assertEquals((int)10, (int)i);
            buf.release();
            return;
        }
    }

    @Test
    void testRetainedSlice() {
        ByteBuf buf = Unpooled.buffer((int)10);
        int i = 0;
        while (buf.isWritable()) {
            buf.writeByte(i++);
        }
        ReplayingDecoderByteBuf buffer = new ReplayingDecoderByteBuf(buf);
        ByteBuf slice = buffer.retainedSlice(0, 4);
        Assertions.assertEquals((int)2, (int)slice.refCnt());
        i = 0;
        while (slice.isReadable()) {
            Assertions.assertEquals((int)i++, (int)slice.readByte());
        }
        slice.release();
        buf.release();
        Assertions.assertEquals((int)0, (int)slice.refCnt());
        Assertions.assertEquals((int)0, (int)buf.refCnt());
        Assertions.assertEquals((int)0, (int)buffer.refCnt());
    }
}

