/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.marshalling;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandler;
import io.netty.channel.embedded.EmbeddedChannel;
import io.netty.handler.codec.marshalling.AbstractMarshallingTest;
import io.netty.handler.codec.marshalling.CompatibleMarshallingEncoder;
import io.netty.handler.codec.marshalling.DefaultMarshallerProvider;
import io.netty.handler.codec.marshalling.MarshallerProvider;
import java.nio.ByteBuffer;
import org.jboss.marshalling.MarshallerFactory;
import org.jboss.marshalling.Marshalling;
import org.jboss.marshalling.MarshallingConfiguration;
import org.jboss.marshalling.Unmarshaller;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public abstract class AbstractCompatibleMarshallingEncoderTest
extends AbstractMarshallingTest {
    @Test
    public void testMarshalling() throws Exception {
        String testObject = new String("test");
        MarshallerFactory marshallerFactory = this.createMarshallerFactory();
        MarshallingConfiguration configuration = this.createMarshallingConfig();
        EmbeddedChannel ch = new EmbeddedChannel(new ChannelHandler[]{this.createEncoder()});
        ch.writeOutbound(new Object[]{testObject});
        Assertions.assertTrue((boolean)ch.finish());
        ByteBuf buffer = (ByteBuf)ch.readOutbound();
        Unmarshaller unmarshaller = marshallerFactory.createUnmarshaller(configuration);
        unmarshaller.start(Marshalling.createByteInput((ByteBuffer)this.truncate(buffer).nioBuffer()));
        String read = (String)unmarshaller.readObject();
        Assertions.assertEquals((Object)testObject, (Object)read);
        Assertions.assertEquals((int)-1, (int)unmarshaller.read());
        Assertions.assertNull((Object)ch.readOutbound());
        unmarshaller.finish();
        unmarshaller.close();
        buffer.release();
    }

    protected ByteBuf truncate(ByteBuf buf) {
        return buf;
    }

    protected ChannelHandler createEncoder() {
        return new CompatibleMarshallingEncoder(this.createProvider());
    }

    protected MarshallerProvider createProvider() {
        return new DefaultMarshallerProvider(this.createMarshallerFactory(), this.createMarshallingConfig());
    }

    protected abstract MarshallerFactory createMarshallerFactory();

    protected abstract MarshallingConfiguration createMarshallingConfig();
}

