/*
 * Decompiled with CFR 0.152.
 */
package io.netty.util.internal;

import io.netty.logging.InternalLogger;
import io.netty.logging.InternalLoggerFactory;
import io.netty.util.internal.DetectionUtil;
import io.netty.util.internal.LegacyLinkedTransferQueue;
import io.netty.util.internal.LinkedTransferQueue;
import java.util.concurrent.BlockingQueue;

public final class QueueFactory {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(QueueFactory.class);
    private static final boolean USE_LTQ;

    public static <T> BlockingQueue<T> createQueue() {
        if (USE_LTQ) {
            return new LinkedTransferQueue();
        }
        return new LegacyLinkedTransferQueue();
    }

    private QueueFactory() {
    }

    static {
        boolean useLTQ = false;
        try {
            if (DetectionUtil.hasUnsafe()) {
                new LinkedTransferQueue();
                useLTQ = true;
            }
            logger.debug("No access to the Unsafe - using " + LegacyLinkedTransferQueue.class.getSimpleName() + " instead.");
        }
        catch (Throwable t) {
            logger.debug("Failed to initialize a " + LinkedTransferQueue.class.getSimpleName() + " - " + "using " + LegacyLinkedTransferQueue.class.getSimpleName() + " instead.", t);
        }
        USE_LTQ = useLTQ;
    }
}

