/*
 * Decompiled with CFR 0.152.
 */
package io.netty.util.internal;

import io.netty.util.internal.NoOpTypeParameterMatcher;
import io.netty.util.internal.TypeParameterMatcher;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.lang.reflect.Method;
import javassist.ClassPool;
import javassist.CtClass;

final class JavassistTypeParameterMatcherGenerator {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(JavassistTypeParameterMatcherGenerator.class);
    private static final ClassPool classPool = new ClassPool(true);

    static TypeParameterMatcher generate(Class<?> type) {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        if (classLoader == null) {
            classLoader = ClassLoader.getSystemClassLoader();
        }
        return JavassistTypeParameterMatcherGenerator.generate(type, classLoader);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static TypeParameterMatcher generate(Class<?> type, ClassLoader classLoader) {
        String className = "io.netty.util.internal.__matchers__." + type.getName() + "Matcher";
        try {
            return (TypeParameterMatcher)Class.forName(className, true, classLoader).newInstance();
        }
        catch (Exception e) {
            try {
                CtClass c = classPool.getAndRename(NoOpTypeParameterMatcher.class.getName(), className);
                c.setModifiers(c.getModifiers() | 0x10);
                c.getDeclaredMethod("match").setBody("{ return $1 instanceof " + type.getName() + "; }");
                byte[] byteCode = c.toBytecode();
                c.detach();
                Method method = ClassLoader.class.getDeclaredMethod("defineClass", String.class, byte[].class, Integer.TYPE, Integer.TYPE);
                method.setAccessible(true);
                Class generated = (Class)method.invoke((Object)classLoader, className, byteCode, 0, byteCode.length);
                logger.debug("Generated: {}", (Object)generated.getName());
                return (TypeParameterMatcher)generated.newInstance();
            }
            catch (Exception e2) {
                throw new RuntimeException(e2);
            }
        }
    }

    private JavassistTypeParameterMatcherGenerator() {
    }
}

