/*
 * Decompiled with CFR 0.152.
 */
package io.netty.util.collection;

import io.netty.util.collection.IntObjectMap;
import io.netty.util.internal.EmptyArrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.NoSuchElementException;

public final class PrimitiveCollections {
    private static final IntObjectMap<Object> EMPTY_INT_OBJECT_MAP = new EmptyIntObjectMap();

    private PrimitiveCollections() {
    }

    public static <V> IntObjectMap<V> emptyIntObjectMap() {
        return EMPTY_INT_OBJECT_MAP;
    }

    public static <V> IntObjectMap<V> unmodifiableIntObjectMap(IntObjectMap<V> map) {
        return new UnmodifiableIntObjectMap<V>(map);
    }

    private static final class UnmodifiableIntObjectMap<V>
    implements IntObjectMap<V>,
    Iterable<IntObjectMap.Entry<V>> {
        final IntObjectMap<V> map;

        UnmodifiableIntObjectMap(IntObjectMap<V> map) {
            this.map = map;
        }

        @Override
        public V get(int key) {
            return this.map.get(key);
        }

        @Override
        public V put(int key, V value) {
            throw new UnsupportedOperationException("put");
        }

        @Override
        public void putAll(IntObjectMap<V> sourceMap) {
            throw new UnsupportedOperationException("putAll");
        }

        @Override
        public V remove(int key) {
            throw new UnsupportedOperationException("remove");
        }

        @Override
        public int size() {
            return this.map.size();
        }

        @Override
        public boolean isEmpty() {
            return this.map.isEmpty();
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException("clear");
        }

        @Override
        public boolean containsKey(int key) {
            return this.map.containsKey(key);
        }

        @Override
        public boolean containsValue(V value) {
            return this.map.containsValue(value);
        }

        @Override
        public Iterable<IntObjectMap.Entry<V>> entries() {
            return this;
        }

        @Override
        public Iterator<IntObjectMap.Entry<V>> iterator() {
            return new IteratorImpl(this.map.entries().iterator());
        }

        @Override
        public int[] keys() {
            return this.map.keys();
        }

        @Override
        public V[] values(Class<V> clazz) {
            return this.map.values(clazz);
        }

        @Override
        public Collection<V> values() {
            return this.map.values();
        }

        private class EntryImpl
        implements IntObjectMap.Entry<V> {
            final IntObjectMap.Entry<V> entry;

            EntryImpl(IntObjectMap.Entry<V> entry) {
                this.entry = entry;
            }

            @Override
            public int key() {
                return this.entry.key();
            }

            @Override
            public V value() {
                return this.entry.value();
            }

            @Override
            public void setValue(V value) {
                throw new UnsupportedOperationException("setValue");
            }
        }

        private class IteratorImpl
        implements Iterator<IntObjectMap.Entry<V>> {
            final Iterator<IntObjectMap.Entry<V>> iter;

            IteratorImpl(Iterator<IntObjectMap.Entry<V>> iter) {
                this.iter = iter;
            }

            @Override
            public boolean hasNext() {
                return this.iter.hasNext();
            }

            @Override
            public IntObjectMap.Entry<V> next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                return new EntryImpl(this.iter.next());
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("remove");
            }
        }
    }

    private static final class EmptyIntObjectMap
    implements IntObjectMap<Object> {
        private EmptyIntObjectMap() {
        }

        @Override
        public Object get(int key) {
            return null;
        }

        @Override
        public Object put(int key, Object value) {
            throw new UnsupportedOperationException("put");
        }

        @Override
        public void putAll(IntObjectMap<Object> sourceMap) {
            throw new UnsupportedOperationException("putAll");
        }

        @Override
        public Object remove(int key) {
            return null;
        }

        @Override
        public int size() {
            return 0;
        }

        @Override
        public boolean isEmpty() {
            return true;
        }

        @Override
        public void clear() {
        }

        @Override
        public boolean containsKey(int key) {
            return false;
        }

        @Override
        public boolean containsValue(Object value) {
            return false;
        }

        @Override
        public Iterable<IntObjectMap.Entry<Object>> entries() {
            return Collections.emptySet();
        }

        @Override
        public int[] keys() {
            return EmptyArrays.EMPTY_INTS;
        }

        @Override
        public Object[] values(Class<Object> clazz) {
            return EmptyArrays.EMPTY_OBJECTS;
        }

        @Override
        public Collection<Object> values() {
            return Collections.emptyList();
        }
    }
}

