/*
 * Decompiled with CFR 0.152.
 */
package io.netty.util;

import io.netty.util.AsciiString;
import io.netty.util.CharsetUtil;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.util.Random;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class AsciiStringCharacterTest {
    private static final Random r = new Random();

    @Test
    public void testContentEqualsIgnoreCase() {
        byte[] bytes = new byte[]{32, 97};
        AsciiString asciiString = new AsciiString(bytes, 1, 1, false);
        Assertions.assertFalse((boolean)asciiString.contentEqualsIgnoreCase((CharSequence)"b"));
        Assertions.assertFalse((boolean)asciiString.contentEqualsIgnoreCase((CharSequence)AsciiString.of((CharSequence)"b")));
    }

    @Test
    public void testGetBytesStringBuilder() {
        StringBuilder b = new StringBuilder();
        for (int i = 0; i < 65536; ++i) {
            b.append("e\u00e9a\u00e0");
        }
        String bString = b.toString();
        Charset[] charsets = CharsetUtil.values();
        for (int i = 0; i < charsets.length; ++i) {
            Charset charset = charsets[i];
            byte[] expected = bString.getBytes(charset);
            byte[] actual = new AsciiString((CharSequence)b, charset).toByteArray();
            Assertions.assertArrayEquals((byte[])expected, (byte[])actual, (String)("failure for " + charset));
        }
    }

    @Test
    public void testGetBytesString() {
        StringBuilder b = new StringBuilder();
        for (int i = 0; i < 65536; ++i) {
            b.append("e\u00e9a\u00e0");
        }
        String bString = b.toString();
        Charset[] charsets = CharsetUtil.values();
        for (int i = 0; i < charsets.length; ++i) {
            Charset charset = charsets[i];
            byte[] expected = bString.getBytes(charset);
            byte[] actual = new AsciiString((CharSequence)bString, charset).toByteArray();
            Assertions.assertArrayEquals((byte[])expected, (byte[])actual, (String)("failure for " + charset));
        }
    }

    @Test
    public void testGetBytesAsciiString() {
        StringBuilder b = new StringBuilder();
        for (int i = 0; i < 65536; ++i) {
            b.append("e\u00e9a\u00e0");
        }
        String bString = b.toString();
        byte[] expected = bString.getBytes(CharsetUtil.ISO_8859_1);
        byte[] actual = new AsciiString((CharSequence)bString).toByteArray();
        Assertions.assertArrayEquals((byte[])expected, (byte[])actual);
    }

    @Test
    public void testComparisonWithString() {
        String string = "shouldn't fail";
        AsciiString ascii = new AsciiString(string.toCharArray());
        Assertions.assertEquals((Object)string, (Object)ascii.toString());
    }

    @Test
    public void subSequenceTest() {
        byte[] init = new byte[]{116, 104, 105, 115, 32, 105, 115, 32, 97, 32, 116, 101, 115, 116};
        AsciiString ascii = new AsciiString(init);
        int start = 2;
        int end = init.length;
        AsciiString sub1 = ascii.subSequence(2, end, false);
        AsciiString sub2 = ascii.subSequence(2, end, true);
        Assertions.assertEquals((int)sub1.hashCode(), (int)sub2.hashCode());
        Assertions.assertEquals((Object)sub1, (Object)sub2);
        for (int i = 2; i < end; ++i) {
            Assertions.assertEquals((byte)init[i], (byte)sub1.byteAt(i - 2));
        }
    }

    @Test
    public void testContains() {
        String b;
        String[] falseLhs = new String[]{null, "a", "aa", "aaa"};
        String[] falseRhs = new String[]{null, "b", "ba", "baa"};
        for (int i = 0; i < falseLhs.length; ++i) {
            for (int j = 0; j < falseRhs.length; ++j) {
                AsciiStringCharacterTest.assertContains(falseLhs[i], falseRhs[i], false, false);
            }
        }
        AsciiStringCharacterTest.assertContains("", "", true, true);
        AsciiStringCharacterTest.assertContains("AsfdsF", "", true, true);
        AsciiStringCharacterTest.assertContains("", "b", false, false);
        AsciiStringCharacterTest.assertContains("a", "a", true, true);
        AsciiStringCharacterTest.assertContains("a", "b", false, false);
        AsciiStringCharacterTest.assertContains("a", "A", false, true);
        String a = b = "xyz";
        AsciiStringCharacterTest.assertContains(a, b, true, true);
        a = "a" + b;
        AsciiStringCharacterTest.assertContains(a, b, true, true);
        a = b + "a";
        AsciiStringCharacterTest.assertContains(a, b, true, true);
        a = "a" + b + "a";
        AsciiStringCharacterTest.assertContains(a, b, true, true);
        b = "xYz";
        a = "xyz";
        AsciiStringCharacterTest.assertContains(a, b, false, true);
        b = "xYz";
        a = "xyzxxxXyZ" + b + "aaa";
        AsciiStringCharacterTest.assertContains(a, b, true, true);
        b = "foOo";
        a = "fooofoO";
        AsciiStringCharacterTest.assertContains(a, b, false, true);
        b = "Content-Equals: 10000";
        a = "content-equals: 1000";
        AsciiStringCharacterTest.assertContains(a, b, false, false);
        a = a + "0";
        AsciiStringCharacterTest.assertContains(a, b, false, true);
    }

    private static void assertContains(String a, String b, boolean caseSensitiveEquals, boolean caseInsenstaiveEquals) {
        Assertions.assertEquals((Object)caseSensitiveEquals, (Object)AsciiString.contains((CharSequence)a, (CharSequence)b));
        Assertions.assertEquals((Object)caseInsenstaiveEquals, (Object)AsciiString.containsIgnoreCase((CharSequence)a, (CharSequence)b));
    }

    @Test
    public void testCaseSensitivity() {
        int i;
        for (i = 0; i < 32; ++i) {
            AsciiStringCharacterTest.doCaseSensitivity(i);
        }
        int min = i;
        int max = 4000;
        int len = r.nextInt(4000 - min + 1) + min;
        AsciiStringCharacterTest.doCaseSensitivity(len);
    }

    private static void doCaseSensitivity(int len) {
        int upperA = 65;
        int upperZ = 90;
        int upperToLower = 32;
        byte[] lowerCaseBytes = new byte[len];
        StringBuilder upperCaseBuilder = new StringBuilder(len);
        for (int i = 0; i < len; ++i) {
            char upper = (char)(r.nextInt(26) + 65);
            upperCaseBuilder.append(upper);
            lowerCaseBytes[i] = (byte)(upper + 32);
        }
        String upperCaseString = upperCaseBuilder.toString();
        String lowerCaseString = new String(lowerCaseBytes);
        AsciiString lowerCaseAscii = new AsciiString(lowerCaseBytes, false);
        AsciiString upperCaseAscii = new AsciiString((CharSequence)upperCaseString);
        String errorString = "len: " + len;
        int upperCaseExpected = upperCaseAscii.hashCode();
        Assertions.assertEquals((int)upperCaseExpected, (int)AsciiString.hashCode((CharSequence)upperCaseBuilder), (String)errorString);
        Assertions.assertEquals((int)upperCaseExpected, (int)AsciiString.hashCode((CharSequence)upperCaseString), (String)errorString);
        Assertions.assertEquals((int)upperCaseExpected, (int)upperCaseAscii.hashCode(), (String)errorString);
        int lowerCaseExpected = lowerCaseAscii.hashCode();
        Assertions.assertEquals((int)lowerCaseExpected, (int)AsciiString.hashCode((CharSequence)lowerCaseAscii), (String)errorString);
        Assertions.assertEquals((int)lowerCaseExpected, (int)AsciiString.hashCode((CharSequence)lowerCaseString), (String)errorString);
        Assertions.assertEquals((int)lowerCaseExpected, (int)lowerCaseAscii.hashCode(), (String)errorString);
        int expectedCaseInsensitive = lowerCaseAscii.hashCode();
        Assertions.assertEquals((int)expectedCaseInsensitive, (int)AsciiString.hashCode((CharSequence)upperCaseBuilder), (String)errorString);
        Assertions.assertEquals((int)expectedCaseInsensitive, (int)AsciiString.hashCode((CharSequence)upperCaseString), (String)errorString);
        Assertions.assertEquals((int)expectedCaseInsensitive, (int)AsciiString.hashCode((CharSequence)lowerCaseString), (String)errorString);
        Assertions.assertEquals((int)expectedCaseInsensitive, (int)AsciiString.hashCode((CharSequence)lowerCaseAscii), (String)errorString);
        Assertions.assertEquals((int)expectedCaseInsensitive, (int)AsciiString.hashCode((CharSequence)upperCaseAscii), (String)errorString);
        Assertions.assertEquals((int)expectedCaseInsensitive, (int)lowerCaseAscii.hashCode(), (String)errorString);
        Assertions.assertEquals((int)expectedCaseInsensitive, (int)upperCaseAscii.hashCode(), (String)errorString);
        Assertions.assertEquals((int)lowerCaseAscii.hashCode(), (int)AsciiString.hashCode((CharSequence)upperCaseString), (String)errorString);
        Assertions.assertEquals((int)upperCaseAscii.hashCode(), (int)AsciiString.hashCode((CharSequence)lowerCaseString), (String)errorString);
    }

    @Test
    public void caseInsensitiveHasherCharBuffer() {
        String s1 = new String("TRANSFER-ENCODING");
        char[] array = new char[128];
        int offset = 100;
        for (int i = 0; i < s1.length(); ++i) {
            array[100 + i] = s1.charAt(i);
        }
        CharBuffer buffer = CharBuffer.wrap(array, 100, s1.length());
        Assertions.assertEquals((int)AsciiString.hashCode((CharSequence)s1), (int)AsciiString.hashCode((CharSequence)buffer));
    }

    @Test
    public void testBooleanUtilityMethods() {
        Assertions.assertTrue((boolean)new AsciiString(new byte[]{1}).parseBoolean());
        Assertions.assertFalse((boolean)AsciiString.EMPTY_STRING.parseBoolean());
        Assertions.assertFalse((boolean)new AsciiString(new byte[]{0}).parseBoolean());
        Assertions.assertTrue((boolean)new AsciiString(new byte[]{5}).parseBoolean());
        Assertions.assertTrue((boolean)new AsciiString(new byte[]{2, 0}).parseBoolean());
    }

    @Test
    public void testEqualsIgnoreCase() {
        MatcherAssert.assertThat((Object)AsciiString.contentEqualsIgnoreCase(null, null), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)AsciiString.contentEqualsIgnoreCase(null, (CharSequence)"foo"), (Matcher)CoreMatchers.is((Object)false));
        MatcherAssert.assertThat((Object)AsciiString.contentEqualsIgnoreCase((CharSequence)"bar", null), (Matcher)CoreMatchers.is((Object)false));
        MatcherAssert.assertThat((Object)AsciiString.contentEqualsIgnoreCase((CharSequence)"FoO", (CharSequence)"fOo"), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)AsciiString.contentEqualsIgnoreCase((CharSequence)"FoO", (CharSequence)"bar"), (Matcher)CoreMatchers.is((Object)false));
        MatcherAssert.assertThat((Object)AsciiString.contentEqualsIgnoreCase((CharSequence)"Foo", (CharSequence)"foobar"), (Matcher)CoreMatchers.is((Object)false));
        MatcherAssert.assertThat((Object)AsciiString.contentEqualsIgnoreCase((CharSequence)"foobar", (CharSequence)"Foo"), (Matcher)CoreMatchers.is((Object)false));
        MatcherAssert.assertThat((Object)AsciiString.contentEqualsIgnoreCase((CharSequence)new AsciiString((CharSequence)"FoO"), (CharSequence)"fOo"), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)AsciiString.contentEqualsIgnoreCase((CharSequence)new AsciiString((CharSequence)"FoO"), (CharSequence)new AsciiString((CharSequence)"fOo")), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)AsciiString.contentEqualsIgnoreCase((CharSequence)"FoO", (CharSequence)new AsciiString((CharSequence)"fOo")), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)AsciiString.contentEqualsIgnoreCase((CharSequence)new AsciiString((CharSequence)"FoO"), (CharSequence)"bAr"), (Matcher)CoreMatchers.is((Object)false));
        MatcherAssert.assertThat((Object)AsciiString.contentEqualsIgnoreCase((CharSequence)new AsciiString((CharSequence)"FoO"), (CharSequence)new AsciiString((CharSequence)"bAr")), (Matcher)CoreMatchers.is((Object)false));
        MatcherAssert.assertThat((Object)AsciiString.contentEqualsIgnoreCase((CharSequence)"FoO", (CharSequence)new AsciiString((CharSequence)"bAr")), (Matcher)CoreMatchers.is((Object)false));
    }

    @Test
    public void testIndexOfIgnoreCase() {
        Assertions.assertEquals((int)-1, (int)AsciiString.indexOfIgnoreCase(null, (CharSequence)"abc", (int)1));
        Assertions.assertEquals((int)-1, (int)AsciiString.indexOfIgnoreCase((CharSequence)"abc", null, (int)1));
        Assertions.assertEquals((int)0, (int)AsciiString.indexOfIgnoreCase((CharSequence)"", (CharSequence)"", (int)0));
        Assertions.assertEquals((int)0, (int)AsciiString.indexOfIgnoreCase((CharSequence)"aabaabaa", (CharSequence)"A", (int)0));
        Assertions.assertEquals((int)2, (int)AsciiString.indexOfIgnoreCase((CharSequence)"aabaabaa", (CharSequence)"B", (int)0));
        Assertions.assertEquals((int)1, (int)AsciiString.indexOfIgnoreCase((CharSequence)"aabaabaa", (CharSequence)"AB", (int)0));
        Assertions.assertEquals((int)5, (int)AsciiString.indexOfIgnoreCase((CharSequence)"aabaabaa", (CharSequence)"B", (int)3));
        Assertions.assertEquals((int)-1, (int)AsciiString.indexOfIgnoreCase((CharSequence)"aabaabaa", (CharSequence)"B", (int)9));
        Assertions.assertEquals((int)2, (int)AsciiString.indexOfIgnoreCase((CharSequence)"aabaabaa", (CharSequence)"B", (int)-1));
        Assertions.assertEquals((int)2, (int)AsciiString.indexOfIgnoreCase((CharSequence)"aabaabaa", (CharSequence)"", (int)2));
        Assertions.assertEquals((int)-1, (int)AsciiString.indexOfIgnoreCase((CharSequence)"abc", (CharSequence)"", (int)9));
        Assertions.assertEquals((int)0, (int)AsciiString.indexOfIgnoreCase((CharSequence)"\u00e3abaabaa", (CharSequence)"\u00c3", (int)0));
    }

    @Test
    public void testIndexOfIgnoreCaseAscii() {
        Assertions.assertEquals((int)-1, (int)AsciiString.indexOfIgnoreCaseAscii(null, (CharSequence)"abc", (int)1));
        Assertions.assertEquals((int)-1, (int)AsciiString.indexOfIgnoreCaseAscii((CharSequence)"abc", null, (int)1));
        Assertions.assertEquals((int)0, (int)AsciiString.indexOfIgnoreCaseAscii((CharSequence)"", (CharSequence)"", (int)0));
        Assertions.assertEquals((int)0, (int)AsciiString.indexOfIgnoreCaseAscii((CharSequence)"aabaabaa", (CharSequence)"A", (int)0));
        Assertions.assertEquals((int)2, (int)AsciiString.indexOfIgnoreCaseAscii((CharSequence)"aabaabaa", (CharSequence)"B", (int)0));
        Assertions.assertEquals((int)1, (int)AsciiString.indexOfIgnoreCaseAscii((CharSequence)"aabaabaa", (CharSequence)"AB", (int)0));
        Assertions.assertEquals((int)5, (int)AsciiString.indexOfIgnoreCaseAscii((CharSequence)"aabaabaa", (CharSequence)"B", (int)3));
        Assertions.assertEquals((int)-1, (int)AsciiString.indexOfIgnoreCaseAscii((CharSequence)"aabaabaa", (CharSequence)"B", (int)9));
        Assertions.assertEquals((int)2, (int)AsciiString.indexOfIgnoreCaseAscii((CharSequence)"aabaabaa", (CharSequence)"B", (int)-1));
        Assertions.assertEquals((int)2, (int)AsciiString.indexOfIgnoreCaseAscii((CharSequence)"aabaabaa", (CharSequence)"", (int)2));
        Assertions.assertEquals((int)-1, (int)AsciiString.indexOfIgnoreCaseAscii((CharSequence)"abc", (CharSequence)"", (int)9));
    }

    @Test
    public void testTrim() {
        Assertions.assertEquals((Object)"", (Object)AsciiString.EMPTY_STRING.trim().toString());
        Assertions.assertEquals((Object)"abc", (Object)new AsciiString((CharSequence)"  abc").trim().toString());
        Assertions.assertEquals((Object)"abc", (Object)new AsciiString((CharSequence)"abc  ").trim().toString());
        Assertions.assertEquals((Object)"abc", (Object)new AsciiString((CharSequence)"  abc  ").trim().toString());
    }

    @Test
    public void testIndexOfChar() {
        Assertions.assertEquals((int)-1, (int)AsciiString.indexOf(null, (char)'a', (int)0));
        Assertions.assertEquals((int)-1, (int)AsciiString.of((CharSequence)"").indexOf('a', 0));
        Assertions.assertEquals((int)-1, (int)AsciiString.of((CharSequence)"abc").indexOf('d', 0));
        Assertions.assertEquals((int)-1, (int)AsciiString.of((CharSequence)"aabaabaa").indexOf('A', 0));
        Assertions.assertEquals((int)0, (int)AsciiString.of((CharSequence)"aabaabaa").indexOf('a', 0));
        Assertions.assertEquals((int)1, (int)AsciiString.of((CharSequence)"aabaabaa").indexOf('a', 1));
        Assertions.assertEquals((int)3, (int)AsciiString.of((CharSequence)"aabaabaa").indexOf('a', 2));
        Assertions.assertEquals((int)3, (int)AsciiString.of((CharSequence)"aabdabaa").indexOf('d', 1));
        Assertions.assertEquals((int)1, (int)new AsciiString((CharSequence)"abcd", 1, 2).indexOf('c', 0));
        Assertions.assertEquals((int)2, (int)new AsciiString((CharSequence)"abcd", 1, 3).indexOf('d', 2));
        Assertions.assertEquals((int)0, (int)new AsciiString((CharSequence)"abcd", 1, 2).indexOf('b', 0));
        Assertions.assertEquals((int)-1, (int)new AsciiString((CharSequence)"abcd", 0, 2).indexOf('c', 0));
        Assertions.assertEquals((int)-1, (int)new AsciiString((CharSequence)"abcd", 1, 3).indexOf('a', 0));
    }

    @Test
    public void testIndexOfCharSequence() {
        Assertions.assertEquals((int)0, (int)new AsciiString((CharSequence)"abcd").indexOf((CharSequence)"abcd", 0));
        Assertions.assertEquals((int)0, (int)new AsciiString((CharSequence)"abcd").indexOf((CharSequence)"abc", 0));
        Assertions.assertEquals((int)1, (int)new AsciiString((CharSequence)"abcd").indexOf((CharSequence)"bcd", 0));
        Assertions.assertEquals((int)1, (int)new AsciiString((CharSequence)"abcd").indexOf((CharSequence)"bc", 0));
        Assertions.assertEquals((int)1, (int)new AsciiString((CharSequence)"abcdabcd").indexOf((CharSequence)"bcd", 0));
        Assertions.assertEquals((int)0, (int)new AsciiString((CharSequence)"abcd", 1, 2).indexOf((CharSequence)"bc", 0));
        Assertions.assertEquals((int)0, (int)new AsciiString((CharSequence)"abcd", 1, 3).indexOf((CharSequence)"bcd", 0));
        Assertions.assertEquals((int)1, (int)new AsciiString((CharSequence)"abcdabcd", 4, 4).indexOf((CharSequence)"bcd", 0));
        Assertions.assertEquals((int)3, (int)new AsciiString((CharSequence)"012345").indexOf((CharSequence)"345", 3));
        Assertions.assertEquals((int)3, (int)new AsciiString((CharSequence)"012345").indexOf((CharSequence)"345", 0));
        Assertions.assertEquals((int)0, (int)new AsciiString((CharSequence)"abcd").indexOf((CharSequence)"", 0));
        Assertions.assertEquals((int)1, (int)new AsciiString((CharSequence)"abcd").indexOf((CharSequence)"", 1));
        Assertions.assertEquals((int)3, (int)new AsciiString((CharSequence)"abcd", 1, 3).indexOf((CharSequence)"", 4));
        Assertions.assertEquals((int)-1, (int)new AsciiString((CharSequence)"abcd").indexOf((CharSequence)"abcde", 0));
        Assertions.assertEquals((int)-1, (int)new AsciiString((CharSequence)"abcdbc").indexOf((CharSequence)"bce", 0));
        Assertions.assertEquals((int)-1, (int)new AsciiString((CharSequence)"abcd", 1, 3).indexOf((CharSequence)"abc", 0));
        Assertions.assertEquals((int)-1, (int)new AsciiString((CharSequence)"abcd", 1, 2).indexOf((CharSequence)"bd", 0));
        Assertions.assertEquals((int)-1, (int)new AsciiString((CharSequence)"012345").indexOf((CharSequence)"345", 4));
        Assertions.assertEquals((int)-1, (int)new AsciiString((CharSequence)"012345").indexOf((CharSequence)"abc", 3));
        Assertions.assertEquals((int)-1, (int)new AsciiString((CharSequence)"012345").indexOf((CharSequence)"abc", 0));
        Assertions.assertEquals((int)-1, (int)new AsciiString((CharSequence)"012345").indexOf((CharSequence)"abcdefghi", 0));
        Assertions.assertEquals((int)-1, (int)new AsciiString((CharSequence)"012345").indexOf((CharSequence)"abcdefghi", 4));
    }

    @Test
    public void testStaticIndexOfChar() {
        Assertions.assertEquals((int)-1, (int)AsciiString.indexOf(null, (char)'a', (int)0));
        Assertions.assertEquals((int)-1, (int)AsciiString.indexOf((CharSequence)"", (char)'a', (int)0));
        Assertions.assertEquals((int)-1, (int)AsciiString.indexOf((CharSequence)"abc", (char)'d', (int)0));
        Assertions.assertEquals((int)-1, (int)AsciiString.indexOf((CharSequence)"aabaabaa", (char)'A', (int)0));
        Assertions.assertEquals((int)0, (int)AsciiString.indexOf((CharSequence)"aabaabaa", (char)'a', (int)0));
        Assertions.assertEquals((int)1, (int)AsciiString.indexOf((CharSequence)"aabaabaa", (char)'a', (int)1));
        Assertions.assertEquals((int)3, (int)AsciiString.indexOf((CharSequence)"aabaabaa", (char)'a', (int)2));
        Assertions.assertEquals((int)3, (int)AsciiString.indexOf((CharSequence)"aabdabaa", (char)'d', (int)1));
    }

    @Test
    public void testLastIndexOfCharSequence() {
        Assertions.assertEquals((int)0, (int)new AsciiString((CharSequence)"abcd").lastIndexOf((CharSequence)"abcd", 0));
        Assertions.assertEquals((int)0, (int)new AsciiString((CharSequence)"abcd").lastIndexOf((CharSequence)"abc", 4));
        Assertions.assertEquals((int)1, (int)new AsciiString((CharSequence)"abcd").lastIndexOf((CharSequence)"bcd", 4));
        Assertions.assertEquals((int)1, (int)new AsciiString((CharSequence)"abcd").lastIndexOf((CharSequence)"bc", 4));
        Assertions.assertEquals((int)5, (int)new AsciiString((CharSequence)"abcdabcd").lastIndexOf((CharSequence)"bcd", 10));
        Assertions.assertEquals((int)0, (int)new AsciiString((CharSequence)"abcd", 1, 2).lastIndexOf((CharSequence)"bc", 2));
        Assertions.assertEquals((int)0, (int)new AsciiString((CharSequence)"abcd", 1, 3).lastIndexOf((CharSequence)"bcd", 3));
        Assertions.assertEquals((int)1, (int)new AsciiString((CharSequence)"abcdabcd", 4, 4).lastIndexOf((CharSequence)"bcd", 4));
        Assertions.assertEquals((int)3, (int)new AsciiString((CharSequence)"012345").lastIndexOf((CharSequence)"345", 3));
        Assertions.assertEquals((int)3, (int)new AsciiString((CharSequence)"012345").lastIndexOf((CharSequence)"345", 6));
        Assertions.assertEquals((int)0, (int)new AsciiString((CharSequence)"abcd").lastIndexOf((CharSequence)"", 0));
        Assertions.assertEquals((int)1, (int)new AsciiString((CharSequence)"abcd").lastIndexOf((CharSequence)"", 1));
        Assertions.assertEquals((int)3, (int)new AsciiString((CharSequence)"abcd", 1, 3).lastIndexOf((CharSequence)"", 4));
        Assertions.assertEquals((int)-1, (int)new AsciiString((CharSequence)"abcd").lastIndexOf((CharSequence)"abcde", 0));
        Assertions.assertEquals((int)-1, (int)new AsciiString((CharSequence)"abcdbc").lastIndexOf((CharSequence)"bce", 0));
        Assertions.assertEquals((int)-1, (int)new AsciiString((CharSequence)"abcd", 1, 3).lastIndexOf((CharSequence)"abc", 0));
        Assertions.assertEquals((int)-1, (int)new AsciiString((CharSequence)"abcd", 1, 2).lastIndexOf((CharSequence)"bd", 0));
        Assertions.assertEquals((int)-1, (int)new AsciiString((CharSequence)"012345").lastIndexOf((CharSequence)"345", 2));
        Assertions.assertEquals((int)-1, (int)new AsciiString((CharSequence)"012345").lastIndexOf((CharSequence)"abc", 3));
        Assertions.assertEquals((int)-1, (int)new AsciiString((CharSequence)"012345").lastIndexOf((CharSequence)"abc", 0));
        Assertions.assertEquals((int)-1, (int)new AsciiString((CharSequence)"012345").lastIndexOf((CharSequence)"abcdefghi", 0));
        Assertions.assertEquals((int)-1, (int)new AsciiString((CharSequence)"012345").lastIndexOf((CharSequence)"abcdefghi", 4));
    }

    @Test
    public void testReplace() {
        AsciiString abcd = new AsciiString((CharSequence)"abcd");
        Assertions.assertEquals((Object)new AsciiString((CharSequence)"adcd"), (Object)abcd.replace('b', 'd'));
        Assertions.assertEquals((Object)new AsciiString((CharSequence)"dbcd"), (Object)abcd.replace('a', 'd'));
        Assertions.assertEquals((Object)new AsciiString((CharSequence)"abca"), (Object)abcd.replace('d', 'a'));
        Assertions.assertSame((Object)abcd, (Object)abcd.replace('x', 'a'));
        Assertions.assertEquals((Object)new AsciiString((CharSequence)"cc"), (Object)new AsciiString((CharSequence)"abcd", 1, 2).replace('b', 'c'));
        Assertions.assertEquals((Object)new AsciiString((CharSequence)"bb"), (Object)new AsciiString((CharSequence)"abcd", 1, 2).replace('c', 'b'));
        Assertions.assertEquals((Object)new AsciiString((CharSequence)"bddd"), (Object)new AsciiString((CharSequence)"abcdc", 1, 4).replace('c', 'd'));
        Assertions.assertEquals((Object)new AsciiString((CharSequence)"xbcxd"), (Object)new AsciiString((CharSequence)"abcada", 0, 5).replace('a', 'x'));
    }

    @Test
    public void testSubStringHashCode() {
        Assertions.assertEquals((int)AsciiString.hashCode((CharSequence)"123"), (int)AsciiString.hashCode((CharSequence)"a123".substring(1)));
    }

    @Test
    public void testIndexOf() {
        AsciiString foo = AsciiString.of((CharSequence)"This is a test");
        int i1 = foo.indexOf(' ', 0);
        Assertions.assertEquals((int)4, (int)i1);
        int i2 = foo.indexOf(' ', i1 + 1);
        Assertions.assertEquals((int)7, (int)i2);
        int i3 = foo.indexOf(' ', i2 + 1);
        Assertions.assertEquals((int)9, (int)i3);
        Assertions.assertTrue((i3 + 1 < foo.length() ? 1 : 0) != 0);
        int i4 = foo.indexOf(' ', i3 + 1);
        Assertions.assertEquals((int)i4, (int)-1);
    }
}

